﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Citrix.Common.GroupPolicy
Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$farm = Get-XAFarm 
Write-Host("Farm Name : ",$farm.FarmName)
Write-Host
Write-Host("#Connection limits - start")
$UserSessionLimit = Get-ItemProperty LocalFarmGpo:\Computer\Unfiltered\Settings\ServerSettings\ConnectionLimits\UserSessionLimit
if($UserSessionLimit.Value -eq 2147483647)
{
	Write-Host "MaxConnectionsPerUser : Unlimited"
}
else
{
	Write-Host("MaxConnectionsPerUser : ",$UserSessionLimit.Value)
}
$UserSessionLimitLogging = Get-ItemProperty LocalFarmGpo:\Computer\Unfiltered\Settings\ServerSettings\ConnectionLimits\UserSessionLimitLogging
if($UserSessionLimitLogging.State -eq "NotConfigured")
{
	Write-Host "LogOverLimitDenials : Not Enabled"
}
else
{
	Write-Host "LogOverLimitDenials : Enabled"
}

Write-Host "#Connection limits - end"
Write-Host

Write-Host "#ICA Keep-Alive - start"
$IcaKeepAlives = Get-ItemProperty LocalFarmGpo:\Computer\Unfiltered\Settings\ICA\KeepAlive\IcaKeepAlives
if($IcaKeepAlives.State -eq "NotConfigured")
{
	Write-Host "EnableICAKeepAlive : Not Enabled"
	Write-Host "ICAKeepAliveTimeout : 0 seconds"
}
else
{
	Write-Host "EnableICAKeepAlive : Enabled"
	$IcaKeepAliveTimeout = Get-ItemProperty LocalFarmGpo:\Computer\Unfiltered\Settings\ICA\KeepAlive\IcaKeepAliveTimeout
	Write-Host("ICAKeepAliveTimeout : ",$IcaKeepAliveTimeout.Value)
}
Write-Host  "#ICA Keep-Alive - end"
Write-Host

Write-Host "#ICA Settings - start"
Write-Host  "Alternate Caching method : false"

$DisplayMemoryLimit = Get-ItemProperty LocalFarmGpo:\Computer\Unfiltered\Settings\ICA\Graphics\DisplayMemoryLimit
Write-Host("ICAVideoBufferSize : ",$DisplayMemoryLimit.Value, "KB") 
$DisplayDegradePreference = Get-ItemProperty LocalFarmGpo:\Computer\Unfiltered\Settings\ICA\Graphics\DisplayDegradePreference
if($DisplayDegradePreference.State -eq "NotConfigured")
{
	Write-Host "DegradationBias:Degrade color depth first"
}
else
{
	Write-Host "DegradationBias:Degrade resolution first"
}
Write-Host "Redundant Graphics : false"
$DisplayDegradeUserNotification = Get-ItemProperty LocalFarmGpo:\Computer\Unfiltered\Settings\ICA\Graphics\DisplayDegradeUserNotification

if($DisplayDegradeUserNotification.State -eq "NotConfigured")
{
	Write-Host "Notify Degradation : false"
}
else
{
	Write-Host "Notify Degradation : true"
}

$AutoClientReconnectLogging = Get-ItemProperty LocalFarmGpo:\Computer\Unfiltered\Settings\ICA\AutoClientReconnect\AutoClientReconnectLogging
if($AutoClientReconnectLogging.State -eq "NotConfigured")
{
	Write-Host "Log automatic reconnection attempts : Not Enabled"
}
else
{
	Write-Host "Log automatic reconnection attempts : Enabled"
}
Write-Host  "#ICA Settings - end"
Write-Host 

Write-Host  "#MetaFrame Settings - start"
Write-Host "DCRespondToClientBroadcast : Not Enabled"
Write-Host  "RASRespondToClientBroadcast : Not Enabled"

$SessionTimeZone = Get-ItemProperty LocalFarmGpo:\User\Unfiltered\Settings\ICA\TimeZoneControl\SessionTimeZone
if($SessionTimeZone.State -eq "NotConfigured")
{
	Write-Host "UseClientLocalTime : Not Enabled"
}
else
{
	Write-Host "UseClientLocalTime : Enabled"
}

$LocalTimeEstimation = Get-ItemProperty LocalFarmGpo:\User\Unfiltered\Settings\ICA\TimeZoneControl\LocalTimeEstimation
if($LocalTimeEstimation.State -eq "NotConfigured")
{
	Write-Host "DisableClientLocalTimeEstimation : Not Enabled"
}
else
{
	Write-Host  "DisableClientLocalTimeEstimation : Enabled"
}

$DnsAddressResolution = Get-ItemProperty LocalFarmGpo:\Computer\Unfiltered\Settings\ServerSettings\DnsAddressResolution
if($DnsAddressResolution.State -eq "NotConfigured")
{
	Write-Host  "EnableDNSAddressResolution : Not Enabled"
}
else
{
	Write-Host  "EnableDNSAddressResolution : Enabled"
}

Write-Host  "NDSPreferredTree : -"


$HostToClientRedirection = Get-ItemProperty LocalFarmGpo:\User\Unfiltered\Settings\ICA\FileRedirection\HostToClientRedirection
if($HostToClientRedirection.State -eq "NotConfigured")
{
	Write-Host   "EnableContentRedirection : Not Enabled"
}
else
{
	Write-Host   "EnableContentRedirection : Enabled"
}
Write-Host "EnableRemoteConsoleConnections : Not Enabled"
Write-Host "#MetaFrame Settings - end"
Write-Host

Write-Host  "#SNMP Settings - start"
Write-Host  "SNMP Agent : Not Enabled"
Write-Host "Session Disconnect : Not Enabled"
Write-Host  "Session Logoff : Not Enabled"
Write-Host  "Session Logon : Not Enabled"
Write-Host "Session Threshold Exceeded : Not Enabled"
Write-Host  "Session limit per server : 0 " 
Write-Host "#SNMP Settings - end"
Write-Host

Write-Host "Share load information :  -"
Write-Host "PNEnumMode :  -"

Remove-PSSnapin Citrix.XenApp.Commands
Remove-PSSnapin Citrix.Common.GroupPolicy 

