$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Param(

[string] $strPortQryPath,  

[string] $Server

)
#Write-Output "$strPortQryPath  $Server"
#  WORKFLOW QUERIES THE PASSED ARRAY OF PORTS TO DETERMINE STATUS

Function CheckPort

{

    param ([string]$RPCServer,[array]$arrRPCPorts)

    ForEach($RPCPort in $arrRPCPorts)

    {

        $bolResult = Test-NetConnection -ComputerName $RPCServer -port $RPCPort -InformationLevel Quiet

        If ($bolResult)

        {

            Write-Output "$RPCPort on $RPCServer is reachable"

        }

        Else

        {

            Write-Output "$RPCPort on $RPCServer is unreachable"

        }

    }

}

#  INITIAL RPC PORT

$strRPCPort = "135"

 

#  TEST THE PATH TO SEE IF THE BINARY EXISTS

If (Test-Path "$strPortQryPath\lib\PortQry.exe")

{

    $strPortQryCmd = "$strPortQryPath\lib\PortQry.exe -nr -e $strRPCPort -n $Server"

}

Else

{

    Write-Output "Could not locate Portqry.exe at the path $strPortQryPath\lib. Download Portqry.exe from https://www.microsoft.com/en-us/download/details.aspx?id=17148 and put in eGurkhaInstallDir\lib folder."

    Exit

}

 

#  CREATE AN EMPTY ARRAY TO HOLD THE PORTS RETURNED FROM THE RPC PORTMAPPER

$arrPorts = @()

#  RUN THE PORTQRY COMMAND TO GET THE EPHEMERAL PORTS

$arrQuryResult = Invoke-Expression $strPortQryCmd
#Write-Output "output: $arrQuryResult on $strPortQryCmd"
# CREATE AN ARRAY OF THE PORTS
if($arrQuryResult -eq $null){
	Write-Output "output is null so exiting"
	Exit
}

ForEach ($strResult in $arrQuryResult)

{

    If ($strResult.Contains("ip_tcp"))

    {

        $arrSplt = $strResult.Split("[")

        $strPort = $arrSplt[1]

        $strPort = $strPort.Replace("]","")

        $arrPorts += $strPort

    }

}

#  DE-DUPLICATE THE PORTS

$arrPorts = $arrPorts | Sort-Object |Select-Object -Unique

#  EXECUTE THE WORKFLOW TO CHECK THE PORTS

CheckPort -RPCServer $Server -arrRPCPorts $arrPorts