$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ErrorActionPreference = "Stop"
If ( (Get-PSSnapin -Name Citrix.Broker.Admin.* -ErrorAction SilentlyContinue) -eq $null ) {
    Try {
        Add-PSSnapin Citrix.Broker.Admin.* | Out-Null
    } Catch {
        Write-Host "Unable to load Citrix Snapin. It is not possible to continue."
        Exit 1
    }
}

$VMs = Get-BrokerDesktop -RegistrationState Unregistered -PowerState On -MaxRecordCount 2147483647

If ($VMs) {
    Write-Host "Powered-on Unregistered VMs:"
    ForEach ($vm in $VMs) {
        Write-Host ($vm.MachineName,$vm.DesktopGroupName) -Separator "#^#"
    }
} Else {
    Write-Host "All the powered-on VMs are registered succcessfully!"
}
