$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-pssnapin citrix.broker.*
if($args.count -eq 0) {$days = 1} else {$days = $args[0]}
$day = (get-date).AddDays(-$days)
$actions = get-brokerhostingpoweraction -MaxRecordCount 1000 | where-object {$_.RequestTime -gt $day -and $_.State -eq 'Started'}
if($actions)
{
    foreach ($action in $actions)
    {
        
            $machine = get-brokermachine -DNSName $action.DNSName 
            switch($action.ActualPriority)
            {
                10 {$actionsource = "Restart User driven"}
                20 {$actionsource = "Launching Session"}
                30 {$actionsource = "Admin"}
                33 {$actionsource = "PVD"}
                40 {$actionsource = "Dirty worker"}
                50 {$actionsource = "Power Policy"}
                60 {$actionsource = "Pool Idle"}
            }
            if($action.Action -ne 'Completed')
            {
                write-host "$($actionsource) launched $($action.Action) action on $($action.MachineName) machine in the '$($machine.DesktopGroupName)' delivery group at $($action.RequestTime) with UID $($action.UID). The action started at $($action.ActionStartTime) and finished at $($action.ActionCompletionTime) with $($action.State)"
            }
        
    }
}
else
{
    Write-host "No power actions in the queue in the last $($days) days."
}

remove-pssnapin citrix.broker.*
