[int]$thePid = $args[0]
[string]$dumpFilePath = $env:temp


$MethodDefinition = @'
[DllImport("DbgHelp.dll", CharSet = CharSet.Unicode)]
public static extern bool MiniDumpWriteDump(
    IntPtr hProcess,
    uint processId,
    IntPtr hFile,
    uint dumpType,
    IntPtr expParam,
    IntPtr userStreamParam,
    IntPtr callbackParam
    );
'@

$dbghelp = Add-Type -MemberDefinition $MethodDefinition -Name 'dbghelp' -Namespace 'Win32' -PassThru

[uint32]$miniDumpWithFullMemory = 2 ## https://docs.microsoft.com/en-gb/windows/desktop/api/minidumpapiset/ne-minidumpapiset-_minidump_type
if( ! ( $process = Get-Process -Id $thePid ) )
{
    Write-Host "The action is unable to locate the process with PID $thePid"
    break
}

if( $process.Name -eq 'werfault' )
{
    if( $parentProcess = Get-CimInstance -ClassName win32_process -Filter "ProcessId = '$thePid'" | Select-Object -ExpandProperty ParentProcessId )
    {
        if( ! ( $process = Get-Process -Id $parentProcess ) )
        {
            Write-host "The action has failed to get the parent process with ID $parentProcess for werfault process and PID $thePid"
	    break
        }
        else
        {
            Write-Output -InputObject "Process $thePid is werfault.exe so dumping parent which is $($process.Name) (pid $($process.Id))"
        }
    }
    else
    {
        write-host "The action has failed to get parent process id for werfault pid $thePid"
	break
    }
}

if( ! ( $processDumpPath = Join-Path -Path $dumpFilePath -ChildPath "$($process.Name).$thePid.$(Get-Date -Format 'yyMMdd.HHmmss').dmp" -ErrorAction SilentlyContinue ) )
{
    write-host "The Path `"$dumpFilePath`" for dump file is invalid. So the action is exiting"
    break
}

$props = $null

try
{
    $props = Get-ItemProperty -Path $processDumpPath -ErrorAction SilentlyContinue
}
catch
{
    $props = $null
}

if( $props )
{
    Write-Error ("The acton cannot write dump as dump file `"{0}`" already exists - created {1}, size {2} MB" -f $processDumpPath , (Get-Date $props.CreationTime -Format G) , [math]::Round( $props.Length / 1MB ) )
    exit 1
}

if( ! ( $fileStream = New-Object IO.FileStream( $processDumpPath , [IO.FileMode]::Create) ))
{
    Write-Host "The action has failed to open dump file `"$processDumpPath`" for writing"
    break
}

try
{
    if( ! ( $result = $dbghelp::MiniDumpWriteDump( $process.Handle , $process.Id , $fileStream.SafeFileHandle.DangerousGetHandle() , $miniDumpWithFullMemory ,[IntPtr]::Zero,[IntPtr]::Zero,[IntPtr]::Zero) ) )
    {
        Write-Error "Error : cannot dump the process PID $thePid"
    }
    else
    {
        if( $props = Get-ItemProperty -Path $processDumpPath -ErrorAction SilentlyContinue )
        {
            Write-Output ("Dump file `"{0}`" created ok, size {1} MB" -f $processDumpPath , [math]::Round( $props.Length / 1MB ) )
        }
        else
        {
            Write-Error "MiniDumpWriteDump() appeared to succeed but dump file `"$processDumpPath`" does not exist"
        }
    }
}
catch
{
    Write-Error "Error : cannot dump the process PID $thePid - $($_.Exception.Message)"
}
finally
{
    $fileStream.Close()
}