# This Script will give all details of XenDesktop for Discovery
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Add-pssnapin "Citrix.Common.Commands"
Add-pssnapin "Citrix.Host.Admin.V1"
Add-pssnapin "Citrix.Broker.Admin.V1"

Write-Host "[Web_interface]"
$HKLM = 2147483650
$key = "Software\wow6432node\citrix\web interface"
$reg = [wmiclass]"\\.\root\default:StdRegprov"
$subkeys = $reg.EnumKey($HKLM, $key)
if($subkeys.snames -ne $null)
{
	Write-Host "Web Interface installed locally"
}


Write-Host "[License_server]"
$ips = @{}
$count = 0
$tips = ""
$Site = Get-BrokerSite
if ($Site -ne $null)
{
	$ips = @(([net.dns]::GetHostEntry($Site.LicenseServerName)).AddressList)
	$tips = ""
	$count = 0
	if($? -and $ips)
	{
		foreach($ip in $ips)
		{
			if($ip.AddressFamily -eq "InterNetwork")
			{
				if($count -eq 0)
				{
					$tips = $ip.IPAddressToString +":"+$Site.LicenseServerPort
				}
				else
				{
					$tips = $tips + "," + $ip.IPAddressToString+":"+$Site.LicenseServerPort
				}
				$count = $count + 1
			}	
		
		}	
		Write-Host $Site.LicenseServerName "=" $tips
	}	
}
$ips = @{}
$count = 0
$tips = ""

Write-Host "[Controllers]"
$Controllers = Get-BrokerController
if($Controllers -ne $null)
{
	foreach($Controller in $Controllers)
	{
		#Write-Host($Controller.DNSName)
		$ips = @(([net.dns]::GetHostEntry($Controller.DNSName)).AddressList)
		$tips = ""
		$count = 0
		if($? -and $ips)
		{
			foreach($ip in $ips)
			{
				if($ip.AddressFamily -eq "InterNetwork")
				{
					if($count -eq 0)
					{
						$tips = $ip.IPAddressToString
					}
					else
					{
						$tips = $tips + "," + $ip.IPAddressToString
					}
					$count = $count + 1
				}	
			
			}	
			Write-Host $Controller.DNSName "=" $tips
		}	
	}
}
$ips = @{}
$count = 0
$tips = ""


Write-Host "[Hypervisor_Details]"
$HyperConns = Get-BrokerHypervisorConnection
if($HyperConns -ne $null)
{
	foreach($HyperConn in $HyperConns)
	{
		$b = "XDHyp:\Connections\"
		$a = $b + $HyperConn.Name
		$HypervisorIP = "-"
		if ((Get-HypXenServerAddress -Literalpath $a).length -gt 0)
		{
			$HypervisorIP = Get-HypXenServerAddress -Literalpath $a
		}
		Write-Host ($HypervisorIP)
	}
}

Write-Host "[DataSource]"
$DataSource = Get-BrokerDBConnection
if ($DataSource -ne $null)
{
	Write-Host ($DataSource)
}


$ips = @{}
$count = 0
$tips = ""
Write-Host "[ActiveDirectory_server]"

$ips = @(([net.dns]::GetHostEntry($env:USERDNSDOMAIN)).AddressList)
if($? -and $ips)
{
	foreach($ip in $ips)
	{
		if($ip.AddressFamily -eq "InterNetwork")
		{
			if($count -eq 0)
			{
				$tips = $ip.IPAddressToString
			}
			else
			{
				$tips = $tips +","+ $ip.IPAddressToString
			}
			$count = $count + 1
		}	
		
	}
	Write-Host $env:USERDNSDOMAIN "=" $tips
}	

Remove-pssnapin "Citrix.Common.Commands"
Remove-pssnapin "Citrix.Host.Admin.V1"
Remove-pssnapin "Citrix.Broker.Admin.V1"


