﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue 

$OUT=Get-SPSite -Limit All | Get-SPWeb -Limit All | % { $_.Lists} | ? { $_ -isnot [Microsoft.SharePoint.SPDocumentLibrary] } | Sort-Object { $_.ItemCount } -Descending | Select-Object Title, Description, ItemCount, ParentWebUrl -First 10

foreach($output in $OUT) 
        {
            Write-Host "Title:-"$output.Title "~Description:-"$output.Description "~ItemCount:-"$output.ItemCount "~ParentWebUrl:-"$output.ParentWebUrl 
        }        