﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue
 
$TestInputs=$args 

$DirString=$TestInputs[0] 
$RsDomain=$TestInputs[1]
$RsUserName=$TestInputs[2]
$RsPassword=$TestInputs[3]
$TestFrequency=$TestInputs[4]


if ($DirString -eq $null) 
{
    'Error: Directory Input not provided'
}

if ($TestFrequency -eq $null) {
    'Error: TestFrequency not passed to powershell script'
    exit
}


$PATHS=""

if($DirString.contains('~'))
   {

   
        $paths=$DirString.Split('~')
    
        $Urlin=""

        foreach($Url in $paths)
        {
                    
            $Urlin+="$($Url),"
        }
     
        $lastIndex= $Urlin.LastIndexOf(',')
        $PATHS=$Urlin.Substring(0,$lastIndex)
    }else
    {
    $PATHS= [String]$TestInputs[0]
    }

    
 
$TokenizedInput=$PATHS.Split(',')


for ($i=0;$i -lt $TokenizedInput.count;$i++)
{
   
    $SharedPath=""
    $DomainNUserName=""
    
   
    if ($TokenizedInput[$i].ToString().StartsWith("\\"))
    {
        $SharedPath=$TokenizedInput[$i]
        $DomainNUserName=$RsDomain+$RsUserName

         net use z: $SharedPath  /user:$DomainNUserName $RsPassword /PERSISTENT:YES
      
    }

    
   #  net use z: $SharedPath  /user:$DomainNUserName $RsPassword /PERSISTENT:YES

    $isValidPath = Test-Path $TokenizedInput[$i]
    

    #write-host $TokenizedInput[$i]

        #if ($isValidPath -eq "True")         {

        

        $Output=Get-SPBackupHistory -Directory $TokenizedInput[$i] | select BackupMethod, RestoreMethod, IsBackupConfigurationOnly, FailureMessage, StartTime, EndTime, SelfId, RestoreId, ParentId, Name, TopComponent, TopComponentId, Directory, DirectoryName, RequestedBy, WarningCount, ErrorCount, IsFailure, T, S, Method| Where-Object {$_.starttime -gt (((get-date).ToUniversalTime()).AddMinutes($TestFrequency))}
               
        $keyIdentifier=$TokenizedInput[$i]

               
        foreach($p in $Output)
            {

                Write-Host $p.BackupMethod'~'$p.RestoreMethod'~'$p.IsBackupConfigurationOnly'~'$p.FailureMessage'~'$p.StartTime'~'$p.EndTime'~'$p.SelfId'~'$p.RestoreId'~'$p.ParentId'~'$p.Name'~'$p.TopComponent'~'$p.TopComponentId'~'$p.Directory'~'$p.DirectoryName'~'$p.RequestedBy'~'$p.WarningCount'~'$p.ErrorCount'~'$p.IsFailure'~'$p.T'~'$p.S'~'$p.Method'~'$TokenizedInput[$i]
            }
            
            
        if ($TokenizedInput[$i].ToString().StartsWith("\\"))
        {
            net use z: /delete /Y  
        }
       <# }
    else {
        'Error: Invalid Path ' + $TokenizedInput[$i] 
        }#>
}


Remove-PSSnapin Microsoft.SharePoint.PowerShell




<#

Add-PSSnapin Microsoft.SharePoint.PowerShell #-ErrorAction SilentlyContinue


# Below is to take the Backup to shared Folder Location

net use \\192.168.8.200\shared_folder\Temp  /user:mas\eguser egurkha /PERSISTENT:YES

Backup-SPFarm -Directory \\192.168.8.200\shared_folder\Temp -BackupMethod full -ConfigurationOnly
write-host "*************\\192.168.8.200\shared_folder\Temp Remote BackupNRestore DONE*********"



# Below is to take the Backup to Local Folder Location

Backup-SPFarm -Directory C:\ILAN\Temp -BackupMethod full -ConfigurationOnly
write-host "*************C:\ILAN\Temp  BackupNRestore DONE*********"



#>