﻿#Requires -Version 3.0
#This File is in Unicode format.  Do not edit in an ASCII editor.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#region help text

<#
.SYNOPSIS
	Creates an inventory of a Citrix PVS Host details.
.DESCRIPTION
	Creates an inventory of a Citrix PVS Host details using Microsoft PowerShell.
	
	The PVS Console must be installed and the snap-in registered on the computer running 
	the script.
	
	For Windows 8.x, Server 2012 and later, run:
	
	For 32-bit:
	%systemroot%\Microsoft.NET\Framework\v4.0.30319\installutil.exe "%ProgramFiles%\Citrix\Provisioning Services Console\Citrix.PVS.SnapIn.dll"
	
	For 64-bit:
	%systemroot%\Microsoft.NET\Framework64\v4.0.30319\installutil.exe "%ProgramFiles%\Citrix\Provisioning Services Console\Citrix.PVS.SnapIn.dll"
	
	
.INPUTS
	None.  You cannot pipe objects to this script.
.OUTPUTS
	No objects are output from this script.  
.NOTES
    Test	: PVSHostsPoolTest_cf
	
	Measures:
        1.Type
		2.Description
		3.Server (Host IP Address)
		4.Port
		5.Update Limit
		6.Update Timeout (Mins)
		7.Shutdown Timeout (Mins)
#>

#endregion

#region initialize variables
$SaveEAPreference = $ErrorActionPreference
$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False  

$global:CONST_SCRIPT_START = "***Start_Citrix_PVS_server_config_data_***";
$global:CONST_SCRIPT_END = "***End_Citrix_PVS_server_config_data_***";
$global:CONST_DELIMITER = "~#~";

Add-PSSnapin Citrix.PVS.SnapIn

Function getPvsVirtualHostingPool
{
    try
    {
        $pvsFarm =  Get-PvsFarm
        
        If($? -and $pvsFarm -ne $Null)
        {
            Write-Host $($CONST_SCRIPT_START)
			
			$rqrdFields = @('Type','Name','Description','Server','Port','PrepopulateEnabled','UserName','UpdateLimit','UpdateTimeout','ShutdownTimeout')
			
            $virtualHostNamesTemp = Get-PvsVirtualHostingPool -fields $rqrdFields
        
            If($? -and $virtualHostNamesTemp -ne $Null)
            {	   
                    ForEach($currentVirtualHost in $virtualHostNamesTemp)	                
	                {	
		                $type = $currentVirtualHost.Type;
		                $name = $currentVirtualHost.Name;
		                $description = $currentVirtualHost.Description;
		                $Server = $currentVirtualHost.Server;
		                $port = $currentVirtualHost.Port;
		                $prepopulateEnabled = $currentVirtualHost.PrepopulateEnabled;
		                $userName = $currentVirtualHost.UserName;
		                $updateLimit = $currentVirtualHost.UpdateLimit;
		                $updateTimeout = $currentVirtualHost.UpdateTimeout;
		                $shutdownTimeout = $currentVirtualHost.ShutdownTimeout;
		
		                Write-Host "Type: $($type) $($CONST_DELIMITER) Name: $($name) $($CONST_DELIMITER) Description: $($description) $($CONST_DELIMITER)  Server: $($Server) $($CONST_DELIMITER)  Port: $($port) $($CONST_DELIMITER) PrepopulateEnabled: $($prepopulateEnabled) $($CONST_DELIMITER) UserName: $($userName) $($CONST_DELIMITER) UpdateLimit: $($updateLimit)  $($CONST_DELIMITER) UpdateTimeout: $($updateTimeout) $($CONST_DELIMITER) ShutdownTimeout: $($shutdownTimeout)";
	                }
                
            }
        }
    }
    catch
    {
	    $global:isErrorOccured = $True
	    Write-Host " PVSHostsPoolTest_cf powershell script Exception ";
        Write-Host $_
    }

    If(-Not $isErrorOccured)
    {
	    Write-Host $CONST_SCRIPT_END
    }
}

getPvsVirtualHostingPool
Remove-PSSnapin Citrix.PVS.SnapIn
