﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
#$rptTimNUPN=$mperiodAndIsTeam[2].Trim()
$tmpEdTim=$mperiodAndIsTeam[2].Trim()
if($mperiodAndIsTeam[3]-ne $null -and $mperiodAndIsTeam[3] -ne ''){$tmpFrstUpn=$mperiodAndIsTeam[3].Trim()}else{$tmpFrstUpn=''}
if($mperiodAndIsTeam[4] -ne $null -and $mperiodAndIsTeam[4] -ne ''){$tmpSecUpn=$mperiodAndIsTeam[4].Trim()}else{$tmpSecUpn=''}
#$tmpFrstUpn=$mperiodAndIsTeam[3].Trim()
#$tmpSecUpn=$mperiodAndIsTeam[4].Trim()
$rptTimNUPN=$tmpEdTim+'#'+$tmpFrstUpn+'#'+$tmpSecUpn
$rptNam=$TestInputs[3].Trim()
$prxyCrds=$TestInputs[4].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[5]).ToString().trim()
$showPoorStreams=$TestInputs[6]
$showGoodStreams=$TestInputs[7]
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }
$dir=$egurkhaPath +'\agent\MTM\'+$rptNam
if(!(Test-Path -Path $dir )){
    $null=New-Item -ItemType directory -Path $dir
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$RecVBSSPath=$dir+'\vbssStrms'+ $timenow +".csv"
$measures='Measures.VBSS Stream Count','Measures.VBSS Poor Due To VideoPostFecplr Count','Measures.VBSS Poor Due To VideoLocalFrameLossPercentageAvg Count','Measures.VBSS Poor Due To VideoFrameRateAvg Count','Measures.VBSS Poor Stream Count','Measures.VBSS Good Stream Count','Measures.VBSS Unclassified Stream Count','Measures.VBSS Poor Percentage'
$Dimentions ='AllStreams.Start Time','AllStreams.End Time','AllStreams.Date','AllStreams.Hour','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Conference Id','AllStreams.Is Teams','AllStreams.Media Type','AllStreams.ClassifiedPoorCall','AllStreams.VBSS Poor Due To VideoFrameRateAvg','AllStreams.VBSS Poor Due To VideoLocalFrameLossPercentageAvg','AllStreams.VBSS Poor Due To VideoPostFecplr','AllStreams.First UPN','AllStreams.Second UPN'
#$VBBStrms=Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3 |Where-Object { $_.'Media Type' -eq 'VBSS' -and ($_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled)} | Sort-Object -Property 'End Time' -Descending
Try{
    Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3 |Where-Object { $_.'Media Type' -eq 'VBSS' -and ($_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled)} | Sort-Object -Property 'End Time' | Export-Csv  $RecVBSSPath -Encoding $encTyp #-Descending
}
Catch{
    $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "getting Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
    Write-Host $ExcepMsg
}
[System.GC]::GetTotalMemory($true) | out-null

$VBBStrms= import-csv $RecVBSSPath -Encoding $encTyp
if($RecVBSSPath -ne $null -and $RecVBSSPath -ne ''){
    if(Test-Path -Path $RecVBSSPath -PathType Leaf){
        Remove-Item $RecVBSSPath -Force
    }
}

$writPath=$dir+'\MTMVBBStrms'+ $timenow +".csv"
$iswrite=$false

$strmsVBCnt=0
$gdStmsVBCnt=0
$unclsfyStrmsVBCnt=0
$obj=$VBBStrms| select -Last 1
$rptEdTimNUPN=([String]$obj.'End Time').Trim()+'#'+([String]$obj.'First UPN').Trim()+'#'+([String]$obj.'Second UPN').Trim()
if($showGoodStreams -eq 'none'){
    if($rptTimNUPN -ne 'none'){
        $isChkTim=$true
        foreach($strms in $VBBStrms){
            if($iswrite){
                $stmStr=([String]$strms.'VBSS Stream Count').Trim()
                if($stmStr -ne $null -and $stmStr -ne '' -and $stmStr -ne 'NaN'){$strmsVBCnt+=[int]$stmStr}
                $stmGdStr=([String]$strms.'VBSS Good Stream Count').Trim()
                if($stmGdStr -ne $null -and $stmGdStr -ne '' -and $stmGdStr -ne 'NaN'){$gdStmsVBCnt+=[int]$stmGdStr}
                $stmUnClsStr=([String]$strms.'VBSS Unclassified Stream Count').Trim()
                if($stmUnClsStr -ne $null -and $stmUnClsStr -ne '' -and $stmUnClsStr -ne 'NaN'){$unclsfyStrmsVBCnt+=[int]$stmUnClsStr}   
                $stmPrStr=([String]$strms.'VBSS Poor Stream Count').Trim()
                if($stmPrStr -ne $null -and $stmPrStr -ne '' -and $stmPrStr -ne 'NaN' -and [int]$stmPrStr -gt 0){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append 
                }
            }
            if($isChkTim){
                $chktimNam=([String]$strms.'End Time').Trim()+'#'+([String]$strms.'First UPN').Trim()+'#'+([String]$strms.'Second UPN').Trim()
                if($rptTimNUPN -eq $chktimNam){
                    $iswrite=$true;$isChkTim=$false;
                }
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $VBBStrms){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $stmStr=([String]$strms.'VBSS Stream Count').Trim()
                    if($stmStr -ne $null -and $stmStr -ne '' -and $stmStr -ne 'NaN'){$strmsVBCnt+=[int]$stmStr}
                    $stmGdStr=([String]$strms.'VBSS Good Stream Count').Trim()
                    if($stmGdStr -ne $null -and $stmGdStr -ne '' -and $stmGdStr -ne 'NaN'){$gdStmsVBCnt+=[int]$stmGdStr}
                    $stmUnClsStr=([String]$strms.'VBSS Unclassified Stream Count').Trim()
                    if($stmUnClsStr -ne $null -and $stmUnClsStr -ne '' -and $stmUnClsStr -ne 'NaN'){$unclsfyStrmsVBCnt+=[int]$stmUnClsStr}   
                    $stmPrStr=([String]$strms.'VBSS Poor Stream Count').Trim()
                    if($stmPrStr -ne $null -and $stmPrStr -ne '' -and $stmPrStr -ne 'NaN' -and [int]$stmPrStr -gt 0){
                        $strms| Export-Csv $writPath -Encoding $encTyp -Append 
                    }
                }
            }
        }
    }

}else{
    if($rptTimNUPN -ne 'none'){
        $isChkTim=$true
        foreach($strms in $VBBStrms){
            if($iswrite){
                $strms| Export-Csv $writPath -Encoding $encTyp -Append
            }
            if($isChkTim){
                $chktimNam=([String]$strms.'End Time').Trim()+'#'+([String]$strms.'First UPN').Trim()+'#'+([String]$strms.'Second UPN').Trim()
                if($rptTimNUPN -eq $chktimNam){
                    $iswrite=$true;$isChkTim=$false;
                }
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $VBBStrms){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append  
                }
            }
        }
    }
}
$strcnt='StreamsCnt#'+$strmsVBCnt+'~'+$gdStmsVBCnt+'~'+$unclsfyStrmsVBCnt+'~'+$rptEdTimNUPN
Write-Host $strcnt
Write-Host 'LastReporting WritePath#'$writPath
[System.GC]::GetTotalMemory($true) | out-null