﻿# Hyper-V VM Replications
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"

$Date = Get-Date

$VMs = Get-VM
if($VMs -ne $null)
{
    $VMReplications = Get-VMReplication -VM $VMs
    if($VMReplications -ne $null)
    {
        foreach ($VMReplication in $VMReplications)
        {
            $Name = $VMReplication.Name
            $ReplicationState = $VMReplication.ReplicationState
            $ReplicationHealth = $VMReplication.ReplicationHealth
            $ReplicationMode = $VMReplication.ReplicationMode
            $PrimaryServerName = $VMReplication.PrimaryServerName
            $ReplicaServerName = $VMReplication.ReplicaServerName
            $CurrentReplicaServerName = $VMReplication.CurrentReplicaServerName
            $LastReplicationTime = @{Expression={"{0:N0}" -f (($Date)-($VMReplication.LastReplicationTime)).TotalMinutes};}

            Write-Host($Name,$ReplicationState,$ReplicationHealth,$ReplicationMode,$LastReplicationTime,
                      $PrimaryServerName,$ReplicaServerName,$CurrentReplicaServerName) -Separator ";"

        }
    }
}


