﻿<#
    /*****************************************************************************
    Author            :       Mounika Kuna
    Purpose           :       Provides Exchange Users Mailbox Details
    Created           :       18/07/2020    
    /*****************************************************************************
#>
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$strgLimit=$TestInputs[5]
$readingdate=[datetime]$TestInputs[6]
$rptNam=$TestInputs[7]
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

if($proxyUser.toString().toLower().Trim() -eq 'none') { $proxyUser=$proxyUser.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserver.toString().toLower().Trim().Contains('none')) { $proxyserver=$proxyserver.toString().toLower().Trim() }
if(!$proxyserver.Contains('none')){
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUser -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUser, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$rptPath=$egurkhaPath+'\agent\EXO\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}
$o365Domain=Eg-GetDomain -userName $username -Password $password -proxyUsr $proxyUser -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver

$appId=''
$appSecret=''
$tenantID=''
$authString=''
$resource=''
$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

#------Get App Reg Details ------------
$GraphDir=$egurkhaPath+'\agent\O365\MsGraph'
$unProtPath=$GraphDir+'\GraphDetails.dat'
$keyFileNam='\GraphDetailsKey.dat'
$kvalue=Get-Content -Path $GraphDir$keyFileNam
$null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.ini'
$spoGraphDtls=$GraphDir+"\GraphDetails.ini"
$getInputs=Get-Content -Path $spoGraphDtls
Remove-Item $spoGraphDtls
$flag=$false
foreach($input in $getInputs){
    if($input.StartsWith('[') -and $input.ToLower().Contains($o365Domain.ToLower())){
        $flag=$true
    }
    if($flag){
        if($input.Contains("client_id")){
            $appId=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("client_secret")){
            $appSecret=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("TenantName")){
            $tenantID=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("Authority")){
            $authString=$input.ToString().Substring($input.IndexOf('~')+1)
            $authString=$authString+$o365Domain
        }
        if($input.Contains("Resource")){
            $resource=$input.ToString().Substring($input.IndexOf('~')+1)
            $flag=$false
        }
    }         
}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$MailboxUsageDetailCSV=$rptPath+'\MailboxUsageDetail'+$timenow+'.csv'

Eg-InvokeGraphUrl -Url "https://graph.microsoft.com/v1.0/reports/getMailboxUsageDetail(period='D7')" -filePath $MailboxUsageDetailCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource

$TotalMailboxUsageDetail=Import-Csv $MailboxUsageDetailCSV -Encoding $encTyp

$diffence=(NEW-TIMESPAN –Start $readingdate –End (Get-Date) | Select-Object Days).Days

$notFirsttime = $false
while($diffence -ge 1)
{
    if($notFirsttime){ $readingdate=$readingdate.AddDays(1) }
    $actualdate=$readingdate
    $notFirsttime = $true
    $TotalMailboxUsage =$TotalMailboxUsageDetail | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
    if($TotalMailboxUsage)
    {
        Write-Host 'ReadDate for the Date#'$actualdate.tostring(“yyyy-MM-dd”)
        break
    }
    else
    {
        Write-Host 'thereIs No Data on#'$actualdate.tostring(“yyyy-MM-dd”)
    }
    $diffence=$diffence-1
}

foreach($User in $TotalMailboxUsage){
    $ItemCount=$User.ItemCount      
    $IssueWarningQuotaLimit=(([math]::Round(([long]$User.StorageUsed/1073741824),2))/([math]::Round(([long]$User.IssueWarningQuota/1073741824),2)))*100
    if($IssueWarningQuotaLimit -ge $strgLimit){ $ReachingIssueWarningQuotaLimit=1 }else{ $ReachingIssueWarningQuotaLimit=0 }
   
    $ProhibitSendQuotaLimit=(([math]::Round(([long]$User.StorageUsed/1073741824),2))/([math]::Round(([long]$User.ProhibitSendQuota/1073741824),2)))*100
    if($ProhibitSendQuotaLimit -ge $strgLimit){ $ReachingProhibitSendQuotaLimit=1 }else{ $ReachingProhibitSendQuotaLimit=0 }
     
    $ProhibitSendRecvQuotaLimit=(([math]::Round(([long]$User.StorageUsed/1073741824),2))/([math]::Round(([long]$User.'ProhibitSend/ReceiveQuota'/1073741824),2)))*100
    if($ProhibitSendRecvQuotaLimit -ge $strgLimit){ $ReachingProhibitSendRecvQuotaLimit=1 }else{ $ReachingProhibitSendRecvQuotaLimit=0 }

    $DeletedItemCount=$User.DeletedItemCount    
    $UserID=$User.UserPrincipalName

    $Output=$UserID+'~'+$ItemCount+'~'+[math]::Round(($User.StorageUsed/1073741824),2)+'~'+[math]::Round(($User.IssueWarningQuota/1073741824),2)+'~'+[math]::Round(($User.ProhibitSendQuota/1073741824),2)+'~'+[math]::Round(($User.'ProhibitSend/ReceiveQuota'/1073741824),2)+'~'+$ReachingIssueWarningQuotaLimit+'~'+$ReachingProhibitSendQuotaLimit+'~'+$ReachingProhibitSendRecvQuotaLimit+'~'+$DeletedItemCount+'~'+[math]::Round(($User.DeletedItemSize/1073741824),2)
    Write-Host 'info&Measures='$Output 
}
if([System.IO.File]::Exists($MailboxUsageDetailCSV) -eq 'True'){
    Remove-Item $MailboxUsageDetailCSV
}
