$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010
$SRVSettings = Get-ADServerSettings
if ($SRVSettings.ViewEntireForest -eq "False")
{
	Set-ADServerSettings -ViewEntireForest $true
}

Write-Host "Database Availability Group - DAG Summary Information"
Write-Host "--------------------------------------------------------"
$DAGS = Get-DatabaseAvailabilityGroup -Status 
Foreach($DAG in $DAGS)
{
	Write-Host "DAG Name: " $DAG.Name
	Write-Host "Servers: " $DAG.Servers
	Write-Host "PrimaryActiveManager: " $DAG.PrimaryActiveManager
	Write-Host "DatacenterActivationMode: " $DAG.DatacenterActivationMode
	Write-Host "DatabaseAvailabilityGroupIpAddresses: " $DAG.DatabaseAvailabilityGroupIpAddresses
	Write-Host "ReplicationPort: " $DAG.ReplicationPort
	Write-Host "WitnessServer: " $DAG.WitnessServer
	Write-Host "WitnessDirectory: " $DAG.WitnessDirectory
	Write-Host "AlternateWitnessServer: " $DAG.AlternateWitnessServer
	Write-Host "AlternateWitnessDirectory: " $DAG.AlternateWitnessDirectory
	Write-Host "NetworkCompression: " $DAG.NetworkCompression
	Write-Host "NetworkEncryption: " $DAG.NetworkEncryption
	Write-Host "NetworkNames: " $DAG.NetworkNames
}

Write-Host "Database Availability Group - Network Summary "
Write-Host "-------------------------------------------------"
$DAGNWKS = Get-DatabaseAvailabilityGroupNetwork
foreach($DAGNetwork in $DAGNWKS)
{
	Write-Host "Identity: " $DAGNetwork.Identity
	Write-Host "Subnets: " $DAGNetwork.Subnets
	Write-Host "MapiAccessEnabled: " $DAGNetwork.MapiAccessEnabled
	Write-Host "ReplicationEnabled: " $DAGNetwork.ReplicationEnabled
	Write-Host "IgnoreNetwork: " $DAGNetwork.IgnoreNetwork
	Write-Host "Interfaces: " $DAGNetwork.Interfaces
}

Write-Host "Database Availability Group - Server Information"
Write-Host "----------------------------------------------------"

$DAGMBX = Get-MailboxServer -identity $env:COMPUTERNAME -Status | where-object{$_.DatabaseAvailabilityGroup -ne $null}
if($DAGMBX)
{
	Write-Host "Server Name: " $DAGMBX.Name
	Write-Host "AutoDatabaseMountDial: " $DAGMBX.AutoDatabaseMountDial
	Write-Host "DatabaseAvailabilityGroup: " $DAGMBX.DatabaseAvailabilityGroup
	Write-Host "DatabaseCopyAutoActivationPolicy: " $DAGMBX.DatabaseCopyAutoActivationPolicy
	Write-Host "MaximumActiveDatabases: " $DAGMBX.MaximumActiveDatabases
}

Write-Host "Database Availability Group - Databases Backup Status"
Write-Host "---------------------------------------------------------"

$DbList = Get-MailboxDatabase -Server $env:COMPUTERNAME -Status | where {$_.Recovery -eq $False -AND $_.ReplicationType -eq "Remote"} | sort Server
foreach ($Db in $DbList)
{
	Write-Host "Server Name: " $Db.Server
	Write-Host "LastFullBackup: " $Db.LastFullBackup
	Write-Host "Database Name: " $Db.Identity
	Write-Host "LastIncrementalBackup: " $Db.LastIncrementalBackup
	Write-Host "LastDifferentialBackup: " $Db.LastDifferentialBackup
	Write-Host "LastCopyBackup: " $Db.LastCopyBackup
	Write-Host "SnapshotLastFullBackup: " $Db.SnapshotLastFullBackup
	Write-Host "SnapshotLastIncrementalBackup: " $Db.SnapshotLastIncrementalBackup
	Write-Host "SnapshotLastDifferentialBackup: " $Db.SnapshotLastDifferentialBackup
	Write-Host "SnapshotLastCopyBackup: " $Db.SnapshotLastCopyBackup
}

Write-Host "Database Availability Group - Mailbox Database Copy Status"
Write-Host "------------------------------------------------------------"

$MDCSCS = get-mailboxserver -identity $env:COMPUTERNAME | where-object{$_.DatabaseAvailabilityGroup -ne $null} | Get-MailboxDatabaseCopyStatus -ConnectionStatus | ?{$_.activecopy -eq "True"}
if($MDCSCS)
{
	Write-Host "Name: " $MDCSCS.Name
	Write-Host "Status: " $MDCSCS.Status
	Write-Host "ActiveDatabaseCopy: " $MDCSCS.ActiveDatabaseCopy
	Write-Host "ActivationSuspended: " $MDCSCS.ActivationSuspended
	Write-Host "OutgoingConnections: " $MDCSCS.OutgoingConnections
}

$MailboxDatabasesList = (Get-MailboxDatabase -Server $env:COMPUTERNAME -status | where-object{$_.ReplicationType -eq "Remote"} | sort Name | Get-MailboxDatabaseCopyStatus)
foreach($Database in $MailboxDatabasesList)
{
	Write-Host "Server Name: " $Database.MailboxServer
	Write-Host "Database Name: " $Database.DatabaseName
	Write-Host "ContentIndexState: " $Database.ContentIndexState
	Write-Host "CopyQueueLength: " $Database.CopyQueueLength
	Write-Host "ReplayQueueLength: " $Database.ReplayQueueLength
	Write-Host "Active Copy: " $Database.ActiveCopy.ToString()
	Write-Host "State: " $Database.Status.ToString()
	
}
Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010