﻿Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$hostname = $env:COMPUTERNAME
$printers = Get-XAPrinterDriver -ServerName  $hostname
if ($printers -ne $null)
{
	foreach($printer in $printers)
	{
		Write-Host "Driver Name : " $printer.DriverName
		Write-Host "Driver Id : " $printer.DriverId
		Write-Host "Machine Name : " $printer.MachineName 
	}
}
Write-Host "#EG_SCRIPT_DONE#"
Remove-PSSnapin Citrix.XenApp.Commands


