$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$installpath = (get-itemproperty "HKLM:\Software\Microsoft\APPV\Client").InstallPath
if($installpath -ne $null)
{
    $installpath = $installpath + "AppvClient\AppVClient.psd1"
}
else
{
    Write-Host "Error: APPV is not installed on this client machine"
    return
}
import-module $installpath
$Pkgs = Get-AppvClientPackage -All -Verbose
if($Pkgs -ne $null)
{
    foreach($Pkg in $Pkgs)
    {
        $Name = $Pkg.Name
        $Version = $pkg.Version
        $Path = $pkg.Path
        $IsPublishedToUser = $pkg.IsPublishedToUser
        $InUse = $pkg.InUse            
        $PkgSize = $pkg.PackageSize
        $PctLoaded = $pkg.PercentLoaded
        $IsLoading = $pkg.IsLoading
        $PkgID = $pkg.PackageId
        $VersionID = $pkg.VersionId
        $IsUserPending = $pkg.UserPending
        $IsGlobalPending = $pkg.GlobalPending
	Write-Host($Name,$PkgSize,$PctLoaded,$IsLoading,$InUse,$IsUserPending,$IsGlobalPending,$Version,$PkgID,$VersionID,$Path) -Separator ";"

    }
}
#Write-Host("Virtual process starts here")
$vprocesses = Get-appvvirtualprocess 
if($vprocesses -ne $null)
{
	
	foreach($vprocess in $vprocesses)
	{
		write-Host("Virtual process starts:",$vprocess.Id,$vprocess.ProcessName) -separator ";"
	}
}
#Write-Host("Virtual process ends here")

#Write-Host("Publishing Server starts here")
$publishingservers = Get-appvpublishingserver 
if($publishingservers -ne $null)
{
	
	foreach($publishingserver in $publishingservers)
	{
		write-Host("publishing server starts=",$publishingserver.URL) -separator ";"
	}
}
#Write-Host("Publishing Server ends here")

Remove-module $installpath

