#This File is in Unicode format.  Do not edit in an ASCII editor.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#region help text

<#
.SYNOPSIS
			
			To get the Group Information of Active Directory
.DESCRIPTION

			This Script is used to Collect the Group Information of Active Directory with Following
			Measure are:
				1.SAM account name,
				2.Group scope,
				3.Group type,
				4.GUID,
				5.SID,
				6.Created Time,
				7.Members

.INPUTS
			CONST_TEST_HDR , CONST_TEST_END and delimiter
.OUTPUTS
			Collect the Group Measures of  Active Directory in following format
			<GroupName><Delimiter><SamAccountName><Delimiter><GroupScope><Delimiter>
			<GroupCategory><Delimiter><ObjectGUID><Delimiter><SID><Delimiter>
			<WhenCreated><Delimiter><users>
			
#>

$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False

$global:CONST_TEST_HDR = $args[0]
$global:CONST_TEST_END = $args[1]
$global:delimiter = $args[2]


import-module ActiveDirectory
import-module GroupPolicy

Clear-Host

#To  get the Group Information of Active Directory

Function getADConfigGroupInfo
{

	$domain = Get-ADDomain -Current LocalComputer | select dnsroot
	$adGroups = get-adgroup -server $domain.dnsroot -filter 'GroupScope -eq "DomainLocal"' -property whencreated
	if($adGroups)
	{
		foreach($group in $adGroups)
		{
			$users = ""
			#try
			#{
				$members = Get-AdGroupMember -identity $group.Name | select-object "Name"
			#}
			#catch
			#{
			#	$members = $null
			#}
			#if ($members -eq $null -or $members.length -eq 0)
			#{
			#	$users = "-"
			#}
			#else
			#{
				foreach ($member in $members)
				{
					$users = $users + "," + $member.name
				}
					
				if ($users.startsWith(","))
				{
					$users = $users.substring(1)
				}
			#}

			if ($users -eq "" -or $users.length -eq 0)
			{
				$users = "-"
			}
			Write-Host ($group.Name,$group.SamAccountName,$group.GroupScope,$group.GroupCategory,$group.ObjectGUID,$group.SID,$group.WhenCreated,$users) -Separator $global:delimiter
		}
	}
}

#Main Region Starts
try
{

   	Write-Host $global:CONST_TEST_HDR
	Write-Host "-------------------------"
   
    getADConfigGroupInfo
}
catch [Exception]
{
	$global:isErrorOccured = $True
	Write-Verbose "Catch block executed and following Exception is occured : " $_.Exception.GetType().FullName, $_.Exception.Message
}

If($global:isErrorOccured -eq $False)
{
	Write-Host $global:CONST_TEST_END
}
#Main Region Ends

