﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$rptNMea=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$rptNMea[0].Trim()
$rptNam=$rptNMea[1].Trim()
$lastRptConfId=$TestInputs[3]
$prxyDtls=$TestInputs[4].ToString().Split('#')
$proxyUsr=$prxyDtls[0].Trim()
$proxyPass=Eg-O365Dcr -EncStr $prxyDtls[1]
$proxyserverip=$prxyDtls[2].Trim()
$debuglog=$TestInputs[5].Trim()
#>


##### LOG-Start ###########
$logDir=$egurkhaPath+'\agent\MTM\'+$rptNam+'\logs'
if(!(Test-Path -Path $logDir)){
    $null=New-Item -ItemType directory -Path $logDir
}
$LogFile = $logDir+"\MTMStreamBase.log"
$LogFile1 = $logDir+"\MTMStreamBase1.log"
$strmBasDebug=$false

Function Write-Log {
	Param ([string]$string)
		if($strmBasDebug){
		[string]$date = Get-Date -Format G
		( "[" + $date + "] -  [O365]  -  " + $string ) | Out-File -FilePath $LogFile -Append
		if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
			if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
				Remove-Item $LogFile1 
			} 
			Rename-Item $LogFile $LogFile1   
		}
	}
}
##### LOG - End ##########

##### MTMCallQlityReport Deletion - start ##########
if($debuglog -eq 'true'){
    $logDelDir=$egurkhaPath+'\agent\MTM\logs'
    $logDelFiles=Get-ChildItem -Path $logDelDir
    if($logDelFiles.Count -gt 0){
        foreach($logDelFile in $logDelFiles){
            $logDel=$logDelDir+'\'+$logDelFile
            Remove-Item -Path $logDel
        }
    }
}
##### MTMCallQlityReport Deletion - End ##########

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

if($lastRptConfId -ne 'none'){
    $confDatArr=($lastRptConfId -Split '~!~')
    $chklastRptConfId=($confDatArr[0]).ToString()
    $lstDat=[DateTime]($confDatArr[1]).ToString()
}
if($lstDat -ne $null -and $lstDat -ne ''){
    $currDat=(Get-Date)
    Write-Log("confId and curr date -->> $lstDat -- $currDat")
    if($lstDat.Date -eq $currDat.Date){
        $dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
    }
    else{
        $dat1=(Get-Date).AddMinutes(-($mPeriodInMin+1440)).ToUniversalTime()
    }
}else{
    $dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
}
#$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2
Write-Log("start and end date -->> $startDat -- $endDat")

if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }

$dir=$egurkhaPath +'\agent\MTM\'+$rptNam
if(!(Test-Path -Path $dir )){
    $null=New-Item -ItemType directory -Path $dir
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$allStmsPath=$dir+'\AllStrmsBase'+ $timenow +".csv"

$measures='Measures.Audio Stream Count','Measures.Audio Good Stream Count','Measures.Audio Poor Stream Count','Measures.Audio Unclassified Stream Count','Measures.Audio Poor Due To Jitter Count','Measures.Audio Poor Due To PacketLoss Count','Measures.Audio Poor Due To Degradation Count','Measures.Audio Poor Due To RoundTrip Count','Measures.Audio Poor Due To ConcealedRatio Count','Measures.Video Stream Count','Measures.Video Poor Due To VideoPostFecplr Count','Measures.Video Poor Due To VideoLocalFrameLossPercentageAvg Count','Measures.Video Poor Due To VideoFrameRateAvg Count','Measures.Video Poor Stream Count','Measures.Video Good Stream Count','Measures.Video Unclassified Stream Count','Measures.Avg Video Post FECPLR','Measures.Avg Video Local Frame Loss Percentage','Measures.Avg Video Recv Frame Rate Average','Measures.Avg Video Low Frame Rate Call Percent','Measures.Avg Video Packet Loss Rate','Measures.Avg Video Frame Rate','Measures.Avg Video Dynamic Capability Percent','Measures.VBSS Stream Count','Measures.VBSS Good Stream Count','Measures.VBSS Poor Stream Count','Measures.VBSS Unclassified Stream Count','Measures.VBSS Poor Due To VideoPostFecplr Count','Measures.VBSS Poor Due To VideoLocalFrameLossPercentageAvg Count','Measures.VBSS Poor Due To VideoFrameRateAvg Count','Measures.Total Stream Count','Measures.Total CDR Available Stream Count','Measures.Total Media Failed Stream Count','Measures.Total Call Setup Failed Stream Count','Measures.Total Call Dropped Stream Count','Measures.Total Media Succeeded Stream Count','Measures.Total Call Setup Succeeded Stream Count','Measures.Total Call Setup Failure Percentage','Measures.Total Call Dropped Failure Percentage','Measures.Total Answer Seizure Ratio','Measures.Total Short Call Percentage','Measures.Total Media Failure Percentage','Measures.Avg Call Duration','Measures.Media Failed Due To Firewall DPI Stream Count','Measures.Firewall DPI Media Failure Percentage','Measures.Media Failed Due To Firewall IP Blocked Stream Count','Measures.Firewall IP Blocked Media Failure Percentage','Measures.Media Failed Due To Other Stream Count','Measures.Other Media Failure Percentage','Measures.First Feedback Rating Avg','Measures.Second Feedback Rating Avg','Measures.First Feedback Rating Count','Measures.Second Feedback Rating Count','Measures.First Feedback Rating Poor Count','Measures.Second Feedback Rating Poor Count','Measures.First Feedback Rating Poor Percentage','Measures.Second Feedback Rating Poor Percentage','Measures.First Feedback Token Audio Issue Count','Measures.Second Feedback Token Audio Issue Count','Measures.First Feedback Token Video Issue Count','Measures.Second Feedback Token Video Issue Count','Measures.Avg Audio Degradation','Measures.Avg Jitter','Measures.Avg Jitter Max','Measures.Avg Packet Loss Rate','Measures.Avg Packet Loss Rate Max','Measures.Avg Send Listen MOS','Measures.Avg Overall Avg Network MOS','Measures.Avg Ratio Concealed Samples','Measures.Avg Ratio Stretched Samples','Measures.Avg Round Trip','Measures.Avg Round Trip Max'
$Dimentions='AllStreams.Is Teams','AllStreams.Poor','AllStreams.Unclassified','AllStreams.Date','AllStreams.Hour','AllStreams.Start Time','AllStreams.End Time','AllStreams.First UPN','AllStreams.Second UPN','AllStreams.Organizer UPN','AllStreams.Duration (Minutes)','AllStreams.Media Type','AllStreams.Poor Reason','AllStreams.Conference Id','AllStreams.First Inside Corp','AllStreams.Second Inside Corp','AllStreams.First Network Connection Detail','AllStreams.Second Network Connection Detail','AllStreams.First VPN','AllStreams.Second VPN','AllStreams.Transport','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.First Reflexive Local IP','AllStreams.Second Reflexive Local IP','AllStreams.First Feedback Rating','AllStreams.Second Feedback Rating','AllStreams.First Capture Dev Name','AllStreams.Second Capture Dev Name','AllStreams.First Render Dev Name','AllStreams.Second Render Dev Name','AllStreams.First User Agent','AllStreams.Second User Agent','AllStreams.First CPU Name','AllStreams.Second CPU Name','AllStreams.First OS','AllStreams.Second OS','AllStreams.First Virtualization Flag','AllStreams.Second Virtualization Flag','AllStreams.First Capture Dev','AllStreams.Second Capture Dev','AllStreams.First Capture Dev Driver','AllStreams.Second Capture Dev Driver','AllStreams.First Render Dev','AllStreams.Second Render Dev','AllStreams.First Render Dev Driver','AllStreams.Second Render Dev Driver','AllStreams.First MAC Address','AllStreams.Second MAC Address','AllStreams.First Client Endpoint Name','AllStreams.Second Client Endpoint Name','AllStreams.First ASN Country','AllStreams.Second ASN Country','AllStreams.First ASN City','AllStreams.Second ASN City','AllStreams.First ASN State','AllStreams.Second ASN State','AllStreams.Region','AllStreams.First Connectivity Ice','AllStreams.Second Connectivity Ice','AllStreams.First Link Speed','AllStreams.Second Link Speed','AllStreams.Bandwidth Est','AllStreams.Inside Corp Pair','AllStreams.First Tenant Id','AllStreams.Second Tenant Id','AllStreams.Is Federated','AllStreams.First Is Caller','AllStreams.Stream Direction','AllStreams.Audio and Video Call','AllStreams.First Domain','AllStreams.Second Domain','AllStreams.Conference Type','AllStreams.First Client App Version','AllStreams.Second Client App Version','AllStreams.Meeting Id','AllStreams.Error Report Sender','AllStreams.Is Media Error','AllStreams.Media Failure Type','AllStreams.Call Setup Failure Reason','AllStreams.Session Type','AllStreams.CDR Response Reason','AllStreams.First Video Duration Seconds','AllStreams.Second Video Duration Seconds','AllStreams.Audio Degradation Avg','AllStreams.Jitter','AllStreams.Packet Loss Rate','AllStreams.Send Listen MOS','AllStreams.Overall Avg Network MOS','AllStreams.Ratio Concealed Samples Avg','AllStreams.Ratio Stretched Samples Avg','AllStreams.Round Trip','AllStreams.Packet Utilization','AllStreams.Jitter Buffer Size Avg','AllStreams.Relative OneWay Gap Duration','AllStreams.Audio Post FECPLR','AllStreams.Network Jitter Avg','AllStreams.Video Post FECPLR','AllStreams.Video Local Frame Loss Percentage Avg','AllStreams.Recv Frame Rate Average','AllStreams.Low Frame Rate Call Percent','AllStreams.Video Packet Loss Rate','AllStreams.Video Frame Rate Avg','AllStreams.Dynamic Capability Percent','AllStreams.Spoiled Tile Percent Total','AllStreams.First Network Bandwidth Low Event Ratio','AllStreams.Second Network Bandwidth Low Event Ratio','AllStreams.Video Poor Due to Freeze','AllStreams.Video Poor Due To VideoPostFecplr','AllStreams.Video Poor Due To VideoLocalFrameLossPercentageAvg','AllStreams.Video Poor Due To VideoFrameRateAvg','AllStreams.VBSS Poor Due To VideoPostFecplr','AllStreams.VBSS Poor Due To VideoLocalFrameLossPercentageAvg','AllStreams.VBSS Poor Due To VideoFrameRateAvg','AllStreams.AppSharing Poor Due To SpoiledTilePercentTotal','AllStreams.AppSharing Poor Due To RelativeOneWayAverage','AllStreams.AppSharing Poor Due To RDPTileProcessingLatencyAverage','AllStreams.Audio Poor Due To Jitter','AllStreams.Audio Poor Due To RoundTrip','AllStreams.Audio Poor Due To PacketLoss','AllStreams.Audio Poor Due To Degradation','AllStreams.Audio Poor Due To ConcealedRatio','AllStreams.First Feedback Tokens','AllStreams.Second Feedback Tokens','AllStreams.First Feedback Has Audio Issue','AllStreams.Second Feedback Has Audio Issue','AllStreams.First Feedback Has Video Issue','AllStreams.Second Feedback Has Video Issue','AllStreams.First Feedback Has AppSharing Issue','AllStreams.Second Feedback Has AppSharing Issue','AllStreams.First Feedback Text','AllStreams.Second Feedback Text'
Try{
    Get-CQDData -Measures $measures -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat -OutPutType DataTable -username $username -password $password -CQDVer V3 -debugLog $debuglog | Export-Csv $allStmsPath -Encoding $encTyp #-Descending -debugLog $debuglog
}
Catch{
    $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "getting Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
    Write-Host $ExcepMsg
    Write-Log($ExcepMsg)
    [System.GC]::GetTotalMemory($true) | out-null
    Start-Sleep -Seconds 20

    Try{
        Write-Host 'Second try....'
        Write-Log('Second try....')
        Get-CQDData -Measures $measures -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat -OutPutType DataTable -username $username -password $password -CQDVer V3 -debugLog $debuglog | Export-Csv $allStmsPath -Encoding $encTyp #-Descending -debugLog $debuglog
    }Catch{
        $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "getting Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
        Write-Host 'After catching exception -->> '$ExcepMsg
        Write-Log ("After catching exception -->> $ExcepMsg")
    }
}
[System.GC]::GetTotalMemory($true) | out-null

if($allStmsPath -ne $null -and [System.IO.File]::Exists($allStmsPath) -eq 'True'){
	$allStrms= import-csv $allStmsPath -Encoding $encTyp
    $csvCnt='allStrms Count -- '+($allStrms.Count).ToString()
    Write-Log($csvCnt)
    if(Test-Path -Path $allStmsPath -PathType Leaf){
        Remove-Item $allStmsPath -Force
    }
}else{
    Write-Log($allStmsPath+" -- file is empty or null")
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$mdifyStmsPath=$dir+'\MdifyStrmsBase'+ $timenow +".csv"
foreach($strms in $allStrms){
    $strmsHash =[ordered] @{}
    $isOccur=$false;$isFirst=$true
    foreach( $property in $strms.psobject.properties.name)
    {
        if($property -eq 'First CPU Name'){$isOccur=$true}
        #if($property -eq 'Audio Poor Stream Count'){$isOccur=$false}
        if($property -eq 'Audio Stream Count'){$isOccur=$false}
        if($isOccur -and $isFirst){
            $isFirst=$false
            $sysDtls=$strms.'First CPU Name'+'~#~'+$strms.'Second CPU Name'+'~#~'+$strms.'First OS'+'~#~'+$strms.'Second OS'+'~#~'+$strms.'First Virtualization Flag'+'~#~'+$strms.'Second Virtualization Flag'+'~#~'+$strms.'First Capture Dev'+'~#~'+$strms.'Second Capture Dev'+'~#~'+$strms.'First Capture Dev Driver'+'~#~'+$strms.'Second Capture Dev Driver'+'~#~'+$strms.'First Render Dev'+'~#~'+$strms.'Second Render Dev'+'~#~'+$strms.'First Render Dev Driver'+'~#~'+$strms.'Second Render Dev Driver'+'~#~'+$strms.'First MAC Address'+'~#~'+$strms.'Second MAC Address'+'~#~'+$strms.'First Client Endpoint Name'+'~#~'+$strms.'Second Client Endpoint Name'
            $netWrkDtls=$strms.'First ASN Country'+'~#~'+$strms.'Second ASN Country'+'~#~'+$strms.'First ASN City'+'~#~'+$strms.'Second ASN City'+'~#~'+$strms.'First ASN State'+'~#~'+$strms.'Second ASN State'+'~#~'+$strms.'Region'+'~#~'+$strms.'First Connectivity Ice'+'~#~'+$strms.'Second Connectivity Ice'+'~#~'+$strms.'First Link Speed'+'~#~'+$strms.'Second Link Speed'+'~#~'+$strms.'Bandwidth Est'+'~#~'+$strms.'Inside Corp Pair'
            $callDtls=$strms.'First Tenant Id'+'~#~'+$strms.'Second Tenant Id'+'~#~'+$strms.'Is Federated'+'~#~'+$strms.'First Is Caller'+'~#~'+$strms.'Stream Direction'+'~#~'+$strms.'Audio and Video Call'+'~#~'+$strms.'First Domain'+'~#~'+$strms.'Second Domain'+'~#~'+$strms.'Conference Type'+'~#~'+$strms.'First Client App Version'+'~#~'+$strms.'Second Client App Version'+'~#~'+$strms.'Meeting Id'+'~#~'+$strms.'Error Report Sender'+'~#~'+$strms.'Is Media Error'+'~#~'+$strms.'Media Failure Type'+'~#~'+$strms.'Call Setup Failure Reason'+'~#~'+$strms.'Session Type'+'~#~'+$strms.'CDR Response Reason'+'~#~'+$strms.'First Video Duration Seconds'+'~#~'+$strms.'Second Video Duration Seconds'
            $metricsDtls=$strms.'Audio Degradation Avg'+'~#~'+$strms.'Jitter'+'~#~'+$strms.'Packet Loss Rate'+'~#~'+$strms.'Send Listen MOS'+'~#~'+$strms.'Overall Avg Network MOS'+'~#~'+$strms.'Ratio Concealed Samples Avg'+'~#~'+$strms.'Ratio Stretched Samples Avg'+'~#~'+$strms.'Round Trip'+'~#~'+$strms.'Packet Utilization'+'~#~'+$strms.'Jitter Buffer Size Avg'+'~#~'+$strms.'Relative OneWay Gap Duration'+'~#~'+$strms.'Audio Post FECPLR'+'~#~'+$strms.'Network Jitter Avg'+'~#~'+$strms.'Video Post FECPLR'+'~#~'+$strms.'Video Local Frame Loss Percentage Avg'+'~#~'+$strms.'Recv Frame Rate Average'+'~#~'+$strms.'Low Frame Rate Call Percent'+'~#~'+$strms.'Video Packet Loss Rate'+'~#~'+$strms.'Video Frame Rate Avg'+'~#~'+$strms.'Dynamic Capability Percent'+'~#~'+$strms.'Spoiled Tile Percent Total'+'~#~'+$strms.'First Network Bandwidth Low Event Ratio'+'~#~'+$strms.'Second Network Bandwidth Low Event Ratio'+'~#~'+$strms.'Video Poor Due to Freeze'+'~#~'+$strms.'Video Poor Due To VideoPostFecplr'+'~#~'+$strms.'Video Poor Due To VideoLocalFrameLossPercentageAvg'+'~#~'+$strms.'Video Poor Due To VideoFrameRateAvg'+'~#~'+$strms.'VBSS Poor Due To VideoPostFecplr'+'~#~'+$strms.'VBSS Poor Due To VideoLocalFrameLossPercentageAvg'+'~#~'+$strms.'VBSS Poor Due To VideoFrameRateAvg'+'~#~'+$strms.'AppSharing Poor Due To SpoiledTilePercentTotal'+'~#~'+$strms.'AppSharing Poor Due To RelativeOneWayAverage'+'~#~'+$strms.'AppSharing Poor Due To RDPTileProcessingLatencyAverage'+'~#~'+$strms.'Audio Poor Due To Jitter'+'~#~'+$strms.'Audio Poor Due To RoundTrip'+'~#~'+$strms.'Audio Poor Due To PacketLoss'+'~#~'+$strms.'Audio Poor Due To Degradation'+'~#~'+$strms.'Audio Poor Due To ConcealedRatio'
            $feedBackDtls=$strms.'First Feedback Tokens'+'~#~'+$strms.'Second Feedback Tokens'+'~#~'+$strms.'First Feedback Has Audio Issue'+'~#~'+$strms.'Second Feedback Has Audio Issue'+'~#~'+$strms.'First Feedback Has Video Issue'+'~#~'+$strms.'Second Feedback Has Video Issue'+'~#~'+$strms.'First Feedback Has AppSharing Issue'+'~#~'+$strms.'Second Feedback Has AppSharing Issue'+'~#~'+$strms.'First Feedback Text'+'~#~'+$strms.'Second Feedback Text'
            
            $strmsHash.Add('Video Frame Rate Avg',$strms.'Video Frame Rate Avg')
            $strmsHash.Add('First Transport Protocol',$strms.'First Transport Protocol')
            $strmsHash.Add('Second Transport Protocol',$strms.'Second Transport Protocol')
            $strmsHash.Add('Session Type',$strms.'Session Type')
            $strmsHash.Add('Stream Direction',$strms.'Stream Direction')
            $strmsHash.Add('Jitter',$strms.'Jitter')
            $strmsHash.Add('Packet Loss Rate',$strms.'Packet Loss Rate')
            $strmsHash.Add('Round Trip',$strms.'Round Trip')

            $strmsHash.Add('System Details',$sysDtls)
            $strmsHash.Add('Network Details',$netWrkDtls)
            $strmsHash.Add('Call Details',$callDtls)
            $strmsHash.Add('Metrics Details',$metricsDtls)
            $strmsHash.Add('Feedback Details',$feedBackDtls)

        }
        if(!$isOccur){
            $strmsHash.Add($property,$strms.$property)
        } 
    }
    [pscustomobject]$strmsHash | Export-Csv $mdifyStmsPath -Encoding $encTyp -Append 
}

if($mdifyStmsPath -ne $null -and [System.IO.File]::Exists($mdifyStmsPath) -eq 'True'){
	$allStrmsCSV= import-csv $mdifyStmsPath -Encoding $encTyp | Sort-Object -Property 'End Time'
    if(Test-Path -Path $mdifyStmsPath -PathType Leaf){
        Remove-Item $mdifyStmsPath -Force
    }
}
if($allStrmsCSV.Count -gt 0){
    $writPath=$dir+'\MTMStrmsBase'+ $timenow +".csv"
    $iswrite=$false
    $obj=$allStrmsCSV| select -Last 1
    #$rptEdTimNUPN=([String]$obj.'End Time').Trim()+'#'+([String]$obj.'First UPN').Trim()+'#'+([String]$obj.'Second UPN').Trim()
    $rptLastConfID=([String]$obj.'Conference Id').Trim()+"~!~"+([String]$obj.'Date').Trim()

    if($lastRptConfId -ne 'none'){
        $isChkTim=$true
        foreach($strms in $allStrmsCSV){
            $chkConfIdNam=([String]$strms.'Conference Id').Trim()
            if($iswrite){ 
                if($chklastRptConfId -ne $chkConfIdNam){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append
                }
            }
            if($isChkTim){
                if($chklastRptConfId -eq $chkConfIdNam){
                    Write-Log("initial - entering conf id -->> $chklastRptConfId")
                    $iswrite=$true;$isChkTim=$false;
                }
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $allStrmsCSV){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            Write-Log("compare time -->> $cmprTime")
            Write-Log("dat1 time -->> $dat1")
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append  
                }
            }
        }
    }

    $confIdStr='LastConferenceID#'+$rptLastConfID
    Write-Log("last - entering conf id -->> $rptLastConfID")
    Write-Host $confIdStr
    Write-Host 'LastReporting WritePath#'$writPath

    #<#
    $azureVal=Eg-GetAzureEnv -UserName $userName
    $azureEnvArr=$azureVal.Split(',')
    $credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
    $azureAD=Connect-AzureAD  -AzureEnvironmentName $azureEnvArr[0] -Credential $credential |select *
    $iniDomainDtls=Get-AzureADDomain | select *
    Write-Host 'TenantDomains#'$iniDomainDtls.Name
    Disconnect-AzureAD
    #>

}

[System.GC]::GetTotalMemory($true) | out-null





# SIG # Begin signature block
# MIIlTAYJKoZIhvcNAQcCoIIlPTCCJTkCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUgNDCnZrGbPUCCcLgGawaQR0K
# tVaggh5yMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbAMIIEqKADAgECAhAMTWlyS5T6PCpKPSkH
# gD1aMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwOTIxMDAwMDAwWhcNMzMxMTIx
# MjM1OTU5WjBGMQswCQYDVQQGEwJVUzERMA8GA1UEChMIRGlnaUNlcnQxJDAiBgNV
# BAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEB
# BQADggIPADCCAgoCggIBAM/spSY6xqnya7uNwQ2a26HoFIV0MxomrNAcVR4eNm28
# klUMYfSdCXc9FZYIL2tkpP0GgxbXkZI4HDEClvtysZc6Va8z7GGK6aYo25BjXL2J
# U+A6LYyHQq4mpOS7eHi5ehbhVsbAumRTuyoW51BIu4hpDIjG8b7gL307scpTjUCD
# HufLckkoHkyAHoVW54Xt8mG8qjoHffarbuVm3eJc9S/tjdRNlYRo44DLannR0hCR
# RinrPibytIzNTLlmyLuqUDgN5YyUXRlav/V7QG5vFqianJVHhoV5PgxeZowaCiS+
# nKrSnLb3T254xCg/oxwPUAY3ugjZNaa1Htp4WB056PhMkRCWfk3h3cKtpX74LRsf
# 7CtGGKMZ9jn39cFPcS6JAxGiS7uYv/pP5Hs27wZE5FX/NurlfDHn88JSxOYWe1p+
# pSVz28BqmSEtY+VZ9U0vkB8nt9KrFOU4ZodRCGv7U0M50GT6Vs/g9ArmFG1keLuY
# /ZTDcyHzL8IuINeBrNPxB9ThvdldS24xlCmL5kGkZZTAWOXlLimQprdhZPrZIGwY
# UWC6poEPCSVT8b876asHDmoHOWIZydaFfxPZjXnPYsXs4Xu5zGcTB5rBeO3GiMiw
# bjJ5xwtZg43G7vUsfHuOy2SJ8bHEuOdTXl9V0n0ZKVkDTvpd6kVzHIR+187i1Dp3
# AgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNV
# HSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgB
# hv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYE
# FGKK3tBh/I8xFO2XC809KpQU31KcMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9j
# cmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
# aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzAB
# hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9j
# YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEy
# NTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAFWqKhrzRvN4
# Vzcw/HXjT9aFI/H8+ZU5myXm93KKmMN31GT8Ffs2wklRLHiIY1UJRjkA/GnUypsp
# +6M/wMkAmxMdsJiJ3HjyzXyFzVOdr2LiYWajFCpFh0qYQitQ/Bu1nggwCfrkLdcJ
# iXn5CeaIzn0buGqim8FTYAnoo7id160fHLjsmEHw9g6A++T/350Qp+sAul9Kjxo6
# UrTqvwlJFTU2WZoPVNKyG39+XgmtdlSKdG3K0gVnK3br/5iyJpU4GYhEFOUKWaJr
# 5yI+RCHSPxzAm+18SLLYkgyRTzxmlK9dAlPrnuKe5NMfhgFknADC6Vp0dQ094XmI
# vxwBl8kZI4DXNlpflhaxYwzGRkA7zl011Fk+Q5oYrsPJy8P7mxNfarXH4PMFw1nf
# J2Ir3kHJU7n/NBBn9iYymHv+XEKUgZSCnawKi8ZLFUrTmJBFYDOA4CPe+AOk9kVH
# 5c64A0JH6EE2cXet/aLol3ROLtoeHYxayB6a1cLwxiKoT5u92ByaUcQvmvZfpyeX
# upYuhVfAYOd4Vn9q78KVmksRAsiCnMkaBXy6cbVOepls9Oie1FqYyJ+/jbsYXEP1
# 0Cro4mLueATbvdH7WwqocH7wl4R44wgDXUcsY6glOJcB0j862uXl9uab3H4szP8X
# TE0AotjWAQ64i+7m4HJViSwnGWH2dwGMMYIGRDCCBkACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFDLufmgBynLhsYBh
# gCnzeUB5EswEMA0GCSqGSIb3DQEBAQUABIICAG51TOUiLC4JxDaSqFBNhfbgpnqr
# /49kTIcnBJtmAYVEgWf0ThNTh8q7OqH9BE5eCnp/n9qYPeGRWXLPk7cvAtH2FbI0
# H8m8hq87p3YEyy2o5oJQGCR7ET3vVGXu16YRenOWfu9m81iglJs1Z4uriqGwPn0s
# Gbwzf/R3CiJigUX8w5koQoZLZN45qLT61PXCt8VSGgGVAHg0qdFRVhLbwMzq7Vs5
# r2QOYhisbVQPBURYXwf0M3H3Wo2gjZamuDM1KRC9k2W7f6yrmb0fHk/fnk3cs9/w
# oXEq+wOkGNce2XJrDs7IrD1zanR9lfglbPaqk6mEJrTU95zCnO8Yg7TzQaf0fA14
# cBL2nu3fDmOtIR9mOpK/KlZ31T5raguvRPgVigx/6vOyRz9t8GICLoqx8oPO2xOu
# r9UDzH2i7721G2aqZTNTJ+BIy9RxDo3jqZObZ8OzPzIU9KJPNe0OoImLXL7nFNgT
# 41Ayggo9DEV8bkmPHDrqQqqyXcfATiXn4Zfp3rdSon4B1aCx/eQhrXkCDob1AcK/
# ftOPMi+VyUax8vPgE8jDP4exIGYPYp4UnFHCPcmUiE8K+4SHQlLrGWM/m2PzLHlL
# WIO2R/pKF1Q8DRZ1S0RhapZGq8xXBAjcxaWhHDc5NquLzA9i11C2p4xzYTbOgbd4
# 36B64+7zt5hcubbIoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzEL
# MAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJE
# aWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBD
# QQIQDE1pckuU+jwqSj0pB4A9WjANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJ
# AzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMTIwOTEyNDEwNVowLwYJ
# KoZIhvcNAQkEMSIEIO6iE9E0kV7g5nPHjFxmdop13y5Gi1g/nWP3mVSmPGd1MA0G
# CSqGSIb3DQEBAQUABIICAB+DfhO3AQsk549eBTJfW2Roa0/46hxptXab1bnY9GIq
# 0yDVUuPAbrxRwp++5HKhsvvh0CbxcxWoNZlNeMEABmYKHGdWjLaGBSU7j+nqBaWz
# ddrwMwd3s3iMbLk9PLl7PmUzeG3KbjSNB2ViZrPa/buDqi7+vI8hiNsO5E7p9YDZ
# T0fTPvl20XUTlQq7hSuw++zfA1jp2aCplgvtl5CHe5KaprL23Wfo4CBlkVvWXXgD
# En6ckrLfzCyt9n0s7qWBxSNWwUZmSyeUAScassaAIROQ4iOWW5XWslC7xOrD/bmU
# +QK//Omrk7I14Qm4fiYwBHQrHqL/IQRoiJx3L4LuShvP3uftkAuBZd4yxJ3jocqQ
# SJrRWEN5BLsy4RFNl2kVylALvYqZIYjAybA18qqXPYK1/lPYyPsx0mDrGq0igt3b
# JKfnDITmCZTrQqW9qFUiRPxArPFuZM8Q7IWr7PQAAfGY3PTpOj2+l4xICkpGmazk
# SlguE7qe78Njjh6P5u20iok59yoPkSyvE307dMFCVC7kVxoag3iQimNxCJhk3xNb
# MU1BuNp65lwPkK9/y+uRZ+KpdbFOeIbYztO2ZHegJ+zN7/x4q2yFkkSS4yJnjePT
# xZriP8xDnQnddPdT+EcWZeZmB5E3ktDXVr6wO2DlD8IuNXpDXT2F7p7M5KuhMipA
# SIG # End signature block
