'use strict'

const logger = require('../logger');
const appUtils = require('../app-utils');
const ContainerId = require('./container-id');
const ContainerType = require('./container-type');

const appendMsg = 'Container-Discovery:';
const HOSTNAME_FILENAME = "/etc/hostname";
const NAMESPACE_FILENAME = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";

function ContainerDiscovery(agent) {
  this.podName = '';
  this.agent = agent;
  this.isPod = false;
  this.nameSpace = '';
  this.containerId = null;
  this.containerIP = null;
  this.isContainer = false;
  this.containerType = null;
}

module.exports = ContainerDiscovery;

ContainerDiscovery.prototype.start = async function () {
  logger.info(appendMsg, 'Starting..!');
  this.containerType = ContainerType.get();

  if (!this.containerType) {
    logger.info(appendMsg, 'This is NOT a containerized Applications', logger.doConsole);
    return;
  }

  this.isContainer = true;
  this.isPod = this.containerType.isK8Pod();
  logger.info(appendMsg, `This is a Containerized Applications and the type is ${this.containerType.toString()}`, logger.doConsole);
  this.containerId = await ContainerId.get(this.agent.config, this.containerType);
  this.containerIP = await _getContainerIp();
  logger.info(appendMsg, `isPod: ${this.isPod}, Container ID: ${this.containerId}, Container IP: ${this.containerIP}`, logger.doConsole);

  if (this.isPod) {
    this.podName = appUtils.readFile(HOSTNAME_FILENAME);
    this.nameSpace = appUtils.readFile(NAMESPACE_FILENAME);
    logger.info(appendMsg, `Pod Name: ${this.podName}, Name Space: ${this.nameSpace}`, logger.doConsole);
  }

  logger.info(appendMsg, 'Completed..!');
}

async function _getContainerIp() {
  let containerIp = await _getContainerIpFromCmd("hostname -i");
  if (containerIp) return containerIp;

  containerIp = await _getContainerIpFromCmd("awk 'END{print $1}' /etc/hosts");
  if (containerIp) return containerIp;
  return ``;
}

async function _getContainerIpFromCmd(cmd) {
  try {
    let containerIp = await appUtils.executeCmd(cmd, true);
    logger.info(appendMsg, `Container IP by using '${cmd}' is ${containerIp}`, logger.doConsole);
    if (containerIp && appUtils.isValidIPaddress(containerIp)) return containerIp;
  } catch (e) {
    logger.error(appendMsg, '_getContainerIp error', e);
  }
}