/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.jdbc.BsonTypeInfo;
import com.mongodb.jdbc.MongoColumnInfo;
import com.mongodb.jdbc.MongoJsonSchema;
import com.mongodb.jdbc.MongoResultSetMetaData;
import com.mongodb.jdbc.MongoSQLColumnInfo;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@AutoLoggable
public class MongoSQLResultSetMetaData
extends MongoResultSetMetaData
implements ResultSetMetaData,
LoggingAspect$ajcMightHaveAspect {
    private Map<String, DatasourceAndIndex> columnLabels;
    private List<NameSpace> columnIndices;
    private List<MongoSQLColumnInfo> columnInfo;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    String getDatasource(String columnLabel) {
        try {
            return this.columnLabels.get((Object)columnLabel).datasource;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    private void assertDatasourceSchema(MongoJsonSchema schema) throws SQLException {
        try {
            if (!schema.isObject() || schema.properties == null) {
                throw new SQLException("ResultSetMetaData json schema must be object with properties");
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    private void processDataSource(MongoJsonSchema schema, String datasource, boolean sortFieldsAlphabetically) throws SQLException {
        try {
            MongoJsonSchema datasourceSchema = schema.properties.get(datasource);
            this.assertDatasourceSchema(datasourceSchema);
            Object[] fields = datasourceSchema.properties.keySet().toArray(new String[0]);
            if (sortFieldsAlphabetically) {
                Arrays.sort(fields);
            }
            Object[] objectArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Object field = objectArray[n2];
                MongoJsonSchema columnSchema = datasourceSchema.properties.get(field);
                BsonTypeInfo columnBsonTypeInfo = columnSchema.getBsonTypeInfo();
                int nullability = datasourceSchema.getColumnNullability((String)field);
                this.columnIndices.add(new NameSpace(datasource, (String)field));
                this.columnInfo.add(new MongoSQLColumnInfo(datasource, (String)field, columnBsonTypeInfo, nullability));
                if (!this.columnLabels.containsKey(field)) {
                    this.columnLabels.put((String)field, new DatasourceAndIndex(datasource, this.columnIndices.size() - 1));
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    public MongoSQLResultSetMetaData(MongoJsonSchema schema, boolean sortFieldsAlphabetically, MongoLogger parentLogger, Integer statementId) throws SQLException {
        super(parentLogger, statementId);
        LoggingAspect.ajc$perObjectBind(this);
        this.assertDatasourceSchema(schema);
        this.columnLabels = new HashMap<String, DatasourceAndIndex>();
        this.columnIndices = new ArrayList<NameSpace>();
        this.columnInfo = new ArrayList<MongoSQLColumnInfo>();
        Object[] datasources = schema.properties.keySet().toArray(new String[0]);
        Arrays.sort(datasources);
        Object[] objectArray = datasources;
        int n = datasources.length;
        int n2 = 0;
        while (n2 < n) {
            Object datasource = objectArray[n2];
            this.processDataSource(schema, (String)datasource, sortFieldsAlphabetically);
            ++n2;
        }
    }

    @Override
    public int getColumnPositionFromLabel(String label) {
        String string = label;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, string));
            }
            return this.columnLabels.get((Object)label).index;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    @Override
    public boolean hasColumnWithLabel(String label) {
        String string = label;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_4, (Object)this, (Object)this, string));
            }
            return this.columnLabels.containsKey(label);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    @Override
    public MongoColumnInfo getColumnInfo(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_5, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            this.checkBounds(column);
            return this.columnInfo.get(column - 1);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_6, this, this));
            }
            return this.columnIndices.size();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    static {
        MongoSQLResultSetMetaData.ajc$preClinit();
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoSQLResultSetMetaData.java", MongoSQLResultSetMetaData.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getDatasource", "com.mongodb.jdbc.MongoSQLResultSetMetaData", "java.lang.String", "columnLabel", "", "java.lang.String"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "assertDatasourceSchema", "com.mongodb.jdbc.MongoSQLResultSetMetaData", "com.mongodb.jdbc.MongoJsonSchema", "schema", "java.sql.SQLException", "void"), 64);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processDataSource", "com.mongodb.jdbc.MongoSQLResultSetMetaData", "com.mongodb.jdbc.MongoJsonSchema:java.lang.String:boolean", "schema:datasource:sortFieldsAlphabetically", "java.sql.SQLException", "void"), 72);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnPositionFromLabel", "com.mongodb.jdbc.MongoSQLResultSetMetaData", "java.lang.String", "label", "", "int"), 118);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hasColumnWithLabel", "com.mongodb.jdbc.MongoSQLResultSetMetaData", "java.lang.String", "label", "", "boolean"), 122);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnInfo", "com.mongodb.jdbc.MongoSQLResultSetMetaData", "int", "column", "java.sql.SQLException", "com.mongodb.jdbc.MongoColumnInfo"), 127);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnCount", "com.mongodb.jdbc.MongoSQLResultSetMetaData", "", "", "java.sql.SQLException", "int"), 133);
    }

    private static class DatasourceAndIndex {
        String datasource;
        int index;

        DatasourceAndIndex(String datasource, int index) {
            this.datasource = datasource;
            this.index = index;
        }
    }

    private static class NameSpace {
        String datasource;
        String columnLabel;

        NameSpace(String datasource, String columnLabel) {
            this.datasource = datasource;
            this.columnLabel = columnLabel;
        }
    }
}

