/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class MultipartResponse {
    HttpServletResponse res;
    ServletOutputStream out;
    boolean endedLastResponse = true;

    public MultipartResponse(HttpServletResponse httpServletResponse) throws IOException {
        this.res = httpServletResponse;
        this.out = this.res.getOutputStream();
        this.res.setContentType("multipart/x-mixed-replace;boundary=End");
        this.out.println();
        this.out.println("--End");
    }

    public void startResponse(String string) throws IOException {
        if (!this.endedLastResponse) {
            this.endResponse();
        }
        this.out.println("Content-type: " + string);
        this.out.println();
        this.endedLastResponse = false;
    }

    public void endResponse() throws IOException {
        this.out.println();
        this.out.println("--End");
        this.out.flush();
        this.endedLastResponse = true;
    }

    public void finish() throws IOException {
        this.out.println("--End--");
        this.out.flush();
    }
}

