/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration {
    private static final String DOUBLE_PART = "([0-9]*(.[0-9]+)?)";
    private static final int DOUBLE_GROUP = 1;
    private static final String UNIT_PART = "(|milli(second)?|second(e)?|minute|hour|day)s?";
    private static final int UNIT_GROUP = 3;
    private static final Pattern DURATION_PATTERN = Pattern.compile("([0-9]*(.[0-9]+)?)\\s*(|milli(second)?|second(e)?|minute|hour|day)s?", 2);
    static final long SECONDS_COEFFICIENT = 1000L;
    static final long MINUTES_COEFFICIENT = 60000L;
    static final long HOURS_COEFFICIENT = 3600000L;
    static final long DAYS_COEFFICIENT = 86400000L;
    final long millis;

    public Duration(long l2) {
        this.millis = l2;
    }

    public static Duration buildByMilliseconds(double d9) {
        return new Duration((long)d9);
    }

    public static Duration buildBySeconds(double d9) {
        return new Duration((long)(1000.0 * d9));
    }

    public static Duration buildByMinutes(double d9) {
        return new Duration((long)(60000.0 * d9));
    }

    public static Duration buildByHours(double d9) {
        return new Duration((long)(3600000.0 * d9));
    }

    public static Duration buildByDays(double d9) {
        return new Duration((long)(8.64E7 * d9));
    }

    public static Duration buildUnbounded() {
        return new Duration(Long.MAX_VALUE);
    }

    public long getMilliseconds() {
        return this.millis;
    }

    public static Duration valueOf(String string) {
        block9: {
            double d9;
            String string2;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            Matcher matcher = DURATION_PATTERN.matcher(string);
                            if (!matcher.matches()) break block9;
                            String string3 = matcher.group(1);
                            string2 = matcher.group(3);
                            d9 = Double.valueOf(string3);
                            if (string2.equalsIgnoreCase("milli")) break block10;
                            if (!string2.equalsIgnoreCase("millisecond") && string2.length() != 0) break block11;
                        }
                        return Duration.buildByMilliseconds(d9);
                    }
                    if (string2.equalsIgnoreCase("second")) break block12;
                    if (!string2.equalsIgnoreCase("seconde")) break block13;
                }
                return Duration.buildBySeconds(d9);
            }
            if (string2.equalsIgnoreCase("minute")) {
                return Duration.buildByMinutes(d9);
            }
            if (string2.equalsIgnoreCase("hour")) {
                return Duration.buildByHours(d9);
            }
            if (string2.equalsIgnoreCase("day")) {
                return Duration.buildByDays(d9);
            }
            throw new IllegalStateException("Unexpected " + string2);
        }
        throw new IllegalArgumentException("String value [" + string + "] is not in the expected format.");
    }

    public String toString() {
        if (this.millis < 1000L) {
            return this.millis + " milliseconds";
        }
        if (this.millis < 60000L) {
            return this.millis / 1000L + " seconds";
        }
        if (this.millis < 3600000L) {
            return this.millis / 60000L + " minutes";
        }
        return this.millis / 3600000L + " hours";
    }
}

