/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.search.FieldName;

public class Schema {
    public final List<Field> fields = new ArrayList<Field>();

    public static Schema from(Field ... fields) {
        Schema schema = new Schema();
        for (Field field : fields) {
            schema.addField(field);
        }
        return schema;
    }

    public Schema addTextField(String name, double weight) {
        this.fields.add(new TextField(name, weight));
        return this;
    }

    public Schema addSortableTextField(String name, double weight) {
        this.fields.add(new TextField(name, weight, true));
        return this;
    }

    public Schema addGeoField(String name) {
        this.fields.add(new Field(name, FieldType.GEO, false));
        return this;
    }

    public Schema addNumericField(String name) {
        this.fields.add(new Field(name, FieldType.NUMERIC, false));
        return this;
    }

    public Schema addSortableNumericField(String name) {
        this.fields.add(new Field(name, FieldType.NUMERIC, true));
        return this;
    }

    public Schema addTagField(String name) {
        this.fields.add(new TagField(name));
        return this;
    }

    public Schema addTagField(String name, String separator) {
        this.fields.add(new TagField(name, separator));
        return this;
    }

    public Schema addSortableTagField(String name, String separator) {
        this.fields.add(new TagField(name, separator, true));
        return this;
    }

    public Schema addVectorField(String name, VectorField.VectorAlgo algorithm, Map<String, Object> attributes) {
        this.fields.add(new VectorField(name, algorithm, attributes));
        return this;
    }

    public Schema addFlatVectorField(String name, Map<String, Object> attributes) {
        this.fields.add(new VectorField(name, VectorField.VectorAlgo.FLAT, attributes));
        return this;
    }

    public Schema addHNSWVectorField(String name, Map<String, Object> attributes) {
        this.fields.add(new VectorField(name, VectorField.VectorAlgo.HNSW, attributes));
        return this;
    }

    public Schema addField(Field field) {
        this.fields.add(field);
        return this;
    }

    public String toString() {
        return "Schema{fields=" + this.fields + "}";
    }

    public static class VectorField
    extends Field {
        private final VectorAlgo algorithm;
        private final Map<String, Object> attributes;

        public VectorField(String name, VectorAlgo algorithm, Map<String, Object> attributes) {
            super(name, FieldType.VECTOR, false, false);
            this.algorithm = algorithm;
            this.attributes = attributes;
        }

        @Override
        public void addTypeArgs(CommandArguments args) {
            args.add((Object)this.algorithm);
            args.add(this.attributes.size() * 2);
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                args.add(entry.getKey());
                args.add(entry.getValue());
            }
        }

        @Override
        public String toString() {
            return "VectorField{name='" + this.name + "', type=" + (Object)((Object)this.type) + ", algorithm=" + (Object)((Object)this.algorithm) + ", attributes=" + this.attributes + "}";
        }

        public static enum VectorAlgo {
            FLAT,
            HNSW;

        }
    }

    public static class TagField
    extends Field {
        private final String separator;

        public TagField(String name) {
            this(name, null);
        }

        public TagField(String name, String separator) {
            this(name, separator, false);
        }

        public TagField(String name, boolean sortable) {
            this(name, (String)null, sortable);
        }

        public TagField(String name, String separator, boolean sortable) {
            super(name, FieldType.TAG, sortable);
            this.separator = separator;
        }

        public TagField(FieldName name, String separator, boolean sortable) {
            super(name, FieldType.TAG, sortable, false);
            this.separator = separator;
        }

        @Override
        public void addTypeArgs(CommandArguments args) {
            if (this.separator != null) {
                args.add("SEPARATOR");
                args.add(this.separator);
            }
        }

        @Override
        public String toString() {
            return "TagField{name='" + this.name + "', type=" + (Object)((Object)this.type) + ", sortable=" + this.sortable + ", noindex=" + this.noindex + ", separator='" + this.separator + "'}";
        }
    }

    public static class TextField
    extends Field {
        private final double weight;
        private final boolean nostem;
        private final String phonetic;

        public TextField(String name) {
            this(name, 1.0);
        }

        public TextField(FieldName name) {
            this(name, 1.0, false, false, false, null);
        }

        public TextField(String name, double weight) {
            this(name, weight, false);
        }

        public TextField(String name, double weight, boolean sortable) {
            this(name, weight, sortable, false);
        }

        public TextField(String name, double weight, boolean sortable, boolean nostem) {
            this(name, weight, sortable, nostem, false);
        }

        public TextField(String name, double weight, boolean sortable, boolean nostem, boolean noindex) {
            this(name, weight, sortable, nostem, noindex, null);
        }

        public TextField(String name, double weight, boolean sortable, boolean nostem, boolean noindex, String phonetic) {
            super(name, FieldType.TEXT, sortable, noindex);
            this.weight = weight;
            this.nostem = nostem;
            this.phonetic = phonetic;
        }

        public TextField(FieldName name, double weight, boolean sortable, boolean nostem, boolean noindex, String phonetic) {
            super(name, FieldType.TEXT, sortable, noindex);
            this.weight = weight;
            this.nostem = nostem;
            this.phonetic = phonetic;
        }

        @Override
        protected void addTypeArgs(CommandArguments args) {
            if (this.weight != 1.0) {
                args.add("WEIGHT");
                args.add(Double.toString(this.weight));
            }
            if (this.nostem) {
                args.add("NOSTEM");
            }
            if (this.phonetic != null) {
                args.add("PHONETIC");
                args.add(this.phonetic);
            }
        }

        @Override
        public String toString() {
            return "TextField{name='" + this.name + "', type=" + (Object)((Object)this.type) + ", sortable=" + this.sortable + ", noindex=" + this.noindex + ", weight=" + this.weight + ", nostem=" + this.nostem + ", phonetic='" + this.phonetic + "'}";
        }
    }

    public static class Field
    implements IParams {
        private final FieldName fieldName;
        public final String name;
        public final FieldType type;
        public final boolean sortable;
        public final boolean noindex;

        public Field(String name, FieldType type, boolean sortable) {
            this(name, type, sortable, false);
        }

        public Field(String name, FieldType type, boolean sortable, boolean noindex) {
            this(FieldName.of(name), type, sortable, noindex);
        }

        public Field(FieldName name, FieldType type) {
            this(name, type, false, false);
        }

        public Field(FieldName name, FieldType type, boolean sortable, boolean noIndex) {
            this.fieldName = name;
            this.name = this.fieldName.getName();
            this.type = type;
            this.sortable = sortable;
            this.noindex = noIndex;
        }

        @Override
        public final void addParams(CommandArguments args) {
            this.fieldName.addParams(args);
            args.add(this.type.name());
            this.addTypeArgs(args);
            if (this.sortable) {
                args.add("SORTABLE");
            }
            if (this.noindex) {
                args.add("NOINDEX");
            }
        }

        protected void addTypeArgs(CommandArguments args) {
        }

        public String toString() {
            return "Field{name='" + this.name + "', type=" + (Object)((Object)this.type) + ", sortable=" + this.sortable + ", noindex=" + this.noindex + "}";
        }
    }

    public static enum FieldType {
        TAG,
        TEXT,
        GEO,
        NUMERIC,
        VECTOR;

    }
}

