/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.ddm;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.DataStreamException;
import com.ibm.jtopenlite.HostServerConnection;
import com.ibm.jtopenlite.Message;
import com.ibm.jtopenlite.SignonConnection;
import com.ibm.jtopenlite.SystemInfo;
import com.ibm.jtopenlite.ddm.DDMCallbackEvent;
import com.ibm.jtopenlite.ddm.DDMDataBuffer;
import com.ibm.jtopenlite.ddm.DDMFile;
import com.ibm.jtopenlite.ddm.DDMFileMemberDescription;
import com.ibm.jtopenlite.ddm.DDMFileMemberDescriptionReader;
import com.ibm.jtopenlite.ddm.DDMReadCallback;
import com.ibm.jtopenlite.ddm.DDMRecordFormat;
import com.ibm.jtopenlite.ddm.DDMRecordFormatReader;
import com.ibm.jtopenlite.ddm.DDMWriteCallback;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDMConnection
extends HostServerConnection {
    private static final boolean DEBUG = false;
    public static final int DEFAULT_DDM_SERVER_PORT = 446;
    public static final int DEFAULT_SSL_DDM_SERVER_PORT = 446;
    private final byte[] messageBuf_ = new byte[1024];
    private final char[] charBuffer_ = new char[1024];
    private int dclNamCounter_ = 0;
    private int correlationID_ = 1;

    private int newCorrelationID() {
        if (this.correlationID_ == Short.MAX_VALUE) {
            this.correlationID_ = 0;
        }
        return ++this.correlationID_;
    }

    private DDMConnection(SystemInfo systemInfo, Socket socket, HostServerConnection.HostInputStream hostInputStream, HostServerConnection.HostOutputStream hostOutputStream, String string, String string2) {
        super(systemInfo, string, string2, socket, hostInputStream, hostOutputStream);
    }

    @Override
    protected void sendEndJobRequest() throws IOException {
    }

    public static DDMConnection getConnection(String string, String string2, String string3) throws IOException {
        return DDMConnection.getConnection(false, string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDMConnection getConnection(boolean bl, String string, String string2, String string3) throws IOException {
        SignonConnection signonConnection = SignonConnection.getConnection(bl, string, string2, string3);
        try {
            DDMConnection dDMConnection = DDMConnection.getConnection(bl, signonConnection.getInfo(), string2, string3);
            return dDMConnection;
        }
        finally {
            signonConnection.close();
        }
    }

    public static DDMConnection getConnection(SystemInfo systemInfo, String string, String string2) throws IOException {
        return DDMConnection.getConnection(false, systemInfo, string, string2);
    }

    public static DDMConnection getConnection(boolean bl, SystemInfo systemInfo, String string, String string2) throws IOException {
        return DDMConnection.getConnection(bl, systemInfo, string, string2, bl ? 446 : 446);
    }

    public static DDMConnection getConnection(SystemInfo systemInfo, String string, String string2, int n) throws IOException {
        return DDMConnection.getConnection(false, systemInfo, string, string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDMConnection getConnection(boolean bl, SystemInfo systemInfo, String string, String string2, int n) throws IOException {
        if (n < 0 || n > 65535) {
            throw new IOException("Bad DDM port: " + n);
        }
        DDMConnection dDMConnection = null;
        Socket socket = bl ? SSLSocketFactory.getDefault().createSocket(systemInfo.getSystem(), n) : new Socket(systemInfo.getSystem(), n);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        try {
            HostServerConnection.HostOutputStream hostOutputStream = new HostServerConnection.HostOutputStream(new BufferedOutputStream(outputStream, 1024));
            DDMConnection.sendEXCSATRequest(hostOutputStream);
            hostOutputStream.flush();
            HostServerConnection.HostInputStream hostInputStream = new HostServerConnection.HostInputStream(new BufferedInputStream(inputStream, 32768));
            int n2 = hostInputStream.readShort();
            if (n2 < 10) {
                throw DataStreamException.badLength("ddmExchangeServerAttributes", n2);
            }
            int n3 = hostInputStream.read();
            int n4 = hostInputStream.read();
            int n5 = hostInputStream.readShort();
            int n6 = hostInputStream.readShort();
            int n7 = hostInputStream.readShort();
            if (n7 != 5187) {
                throw DataStreamException.badReply("ddmExchangeServerAttributes", n7);
            }
            int n8 = 10;
            byte[] byArray = null;
            while (n2 - n8 > 4 && byArray == null) {
                int n9 = hostInputStream.readShort();
                int n10 = hostInputStream.readShort();
                n8 += 4;
                if (n10 == 4446) {
                    byArray = new byte[n9 - 4];
                    hostInputStream.readFully(byArray);
                    n8 += byArray.length;
                    continue;
                }
                hostInputStream.skipBytes(n9 - 4);
                n8 += n9 - 4;
            }
            hostInputStream.skipBytes(n2 - n8);
            hostInputStream.end();
            String string3 = byArray != null ? Conv.ebcdicByteArrayToString(byArray, 0, byArray.length) : null;
            long l = DDMConnection.sendACCSECRequest(hostOutputStream, systemInfo.getPasswordLevel() >= 2);
            byte[] byArray2 = Conv.longToByteArray(l);
            hostOutputStream.flush();
            n2 = hostInputStream.readShort();
            if (n2 < 28) {
                throw DataStreamException.badLength("ddmAccessMethodExchange", n2);
            }
            n3 = hostInputStream.read();
            n4 = hostInputStream.read();
            n5 = hostInputStream.readShort();
            hostInputStream.skipBytes(2);
            n7 = hostInputStream.readShort();
            if (n7 != 5292) {
                throw DataStreamException.badReply("ddmAccessMethodExchange", n7);
            }
            hostInputStream.skipBytes(10);
            byte[] byArray3 = new byte[8];
            hostInputStream.readFully(byArray3);
            hostInputStream.skipBytes(n2 - 28);
            hostInputStream.end();
            byte[] byArray4 = DDMConnection.getUserBytes(string, systemInfo.getPasswordLevel());
            byte[] byArray5 = DDMConnection.getPasswordBytes(string2, systemInfo.getPasswordLevel());
            string2 = null;
            byte[] byArray6 = DDMConnection.getEncryptedPassword(byArray4, byArray5, byArray2, byArray3, systemInfo.getPasswordLevel());
            byte[] byArray7 = systemInfo.getPasswordLevel() < 2 ? byArray4 : DDMConnection.getUserBytes(string, 0);
            DDMConnection.sendSECCHKRequest(hostOutputStream, byArray7, byArray6);
            hostOutputStream.flush();
            n2 = hostInputStream.readShort();
            if (n2 < 21) {
                throw DataStreamException.badLength("ddmSecurityCheck", n2);
            }
            n3 = hostInputStream.read();
            n4 = hostInputStream.read();
            n5 = hostInputStream.readShort();
            hostInputStream.skipBytes(2);
            n7 = hostInputStream.readShort();
            if (n7 != 4633) {
                throw DataStreamException.badReply("ddmSecurityCheckSECCHKRD", n7);
            }
            hostInputStream.skipBytes(8);
            n7 = hostInputStream.readShort();
            if (n7 != 4516) {
                throw DataStreamException.badReply("ddmSecurityCheckSECCHKCD", n7);
            }
            int n11 = hostInputStream.read();
            if (n11 != 0) {
                throw DataStreamException.badReturnCode("ddmSecurityCheck", n11);
            }
            hostInputStream.skipBytes(n2 - 21);
            hostInputStream.end();
            DDMConnection dDMConnection2 = dDMConnection = new DDMConnection(systemInfo, socket, hostInputStream, hostOutputStream, string, string3);
            return dDMConnection2;
        }
        finally {
            if (dDMConnection == null) {
                inputStream.close();
                outputStream.close();
                socket.close();
            }
        }
    }

    static byte[] getUserBytes(String string, int n) throws IOException {
        if (n < 2) {
            if (string.length() > 10) {
                throw new IOException("User too long");
            }
            byte[] byArray = Conv.blankPadEBCDIC10(string.toUpperCase());
            return byArray;
        }
        byte[] byArray = new byte[20];
        Conv.stringToBlankPadUnicodeByteArray(string.toUpperCase(), byArray, 0, 20);
        return byArray;
    }

    static byte[] getPasswordBytes(String string, int n) throws IOException {
        if (n < 2) {
            if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
                string = "Q" + string;
            }
            if (string.length() > 10) {
                throw new IOException("Password too long");
            }
            byte[] byArray = Conv.blankPadEBCDIC10(string.toUpperCase());
            return byArray;
        }
        return Conv.stringToUnicodeByteArray(string);
    }

    public Message[] close(DDMFile dDMFile) throws IOException {
        List<Message> list = this.closeReturnMessageList(dDMFile);
        Message[] messageArray = new Message[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            messageArray[i] = list.get(i);
        }
        return messageArray;
    }

    public List<Message> closeReturnMessageList(DDMFile dDMFile) throws IOException {
        byte[] byArray = dDMFile.getDCLNAM();
        this.sendS38CloseRequest(this.out_, byArray);
        this.out_.flush();
        int n = this.in_.readShort();
        if (n < 10) {
            throw DataStreamException.badLength("ddmS38Close", n);
        }
        int n2 = this.in_.read();
        int n3 = this.in_.read();
        int n4 = this.in_.readShort();
        int n5 = 8;
        ArrayList<Message> arrayList = new ArrayList<Message>();
        int[] nArray = new int[1];
        while (n5 + 4 < n) {
            int n6 = this.in_.readShort();
            int n7 = this.in_.readShort();
            n5 += 4;
            if (n7 == 53761) {
                Message message = this.getMessage(this.in_, n6, nArray);
                n5 += nArray[0];
                if (message == null) continue;
                arrayList.add(message);
                continue;
            }
            this.in_.skipBytes(n6 - 4);
            n5 += n6 - 4;
        }
        this.in_.skipBytes(n - n5);
        this.in_.end();
        return arrayList;
    }

    private Message getMessage(HostServerConnection.HostInputStream hostInputStream, int n, int[] nArray) throws IOException {
        int n2;
        int n3;
        int n4 = -1;
        String string = null;
        String string2 = null;
        byte[] byArray = null;
        char[] cArray = null;
        block5: for (n2 = 0; n2 < n - 4; n2 += n3) {
            n3 = hostInputStream.readShort();
            int n5 = hostInputStream.readShort();
            switch (n5) {
                case 4425: {
                    n4 = hostInputStream.readShort();
                    hostInputStream.skipBytes(n3 - 6);
                    continue block5;
                }
                case 53522: {
                    boolean bl = n3 > 1028;
                    int n6 = n3 - 4;
                    byArray = bl ? new byte[n6] : this.messageBuf_;
                    cArray = bl ? new char[n6] : this.charBuffer_;
                    hostInputStream.readFully(byArray, 0, n6);
                    string = Conv.ebcdicByteArrayToString(byArray, 0, n6, cArray);
                    continue block5;
                }
                case 53526: {
                    boolean bl = n3 > 1030;
                    int n7 = n3 - 6;
                    byArray = bl ? new byte[n7] : this.messageBuf_;
                    cArray = bl ? new char[n7] : this.charBuffer_;
                    hostInputStream.skipBytes(2);
                    hostInputStream.readFully(byArray, 0, n7);
                    string2 = Conv.ebcdicByteArrayToString(byArray, 0, n7, cArray);
                    continue block5;
                }
                default: {
                    hostInputStream.skipBytes(n3 - 4);
                }
            }
        }
        nArray[0] = n2;
        return string == null ? null : new Message(string, string2, n4);
    }

    public DDMFile open(String string, String string2, String string3, String string4) throws IOException {
        return this.open(string, string2, string3, string4, 0, false, 100, 1);
    }

    public DDMFile open(String string, String string2, String string3, String string4, int n, boolean bl, int n2, int n3) throws IOException {
        Object object;
        boolean bl2;
        boolean bl3 = n == 2 || n == 1;
        boolean bl4 = bl2 = n == 2 || n == 0 || !bl3;
        if (bl3 && bl2 || n2 <= 0) {
            n2 = 1;
        }
        byte[] byArray = this.generateDCLNAM();
        this.sendS38OpenRequest(this.out_, string2, string, string3, bl2, bl3, bl, string4, byArray, n2 &= Short.MAX_VALUE);
        this.out_.flush();
        int n4 = this.in_.readShort();
        if (n4 < 10) {
            throw DataStreamException.badLength("ddmS38Open", n4);
        }
        int n5 = this.in_.read();
        int n6 = this.in_.read();
        boolean bl5 = (n6 & 0x40) != 0;
        int n7 = this.in_.readShort();
        int n8 = this.in_.readShort();
        int n9 = this.in_.readShort();
        int n10 = 10;
        while (n9 != 54276 && n10 + 4 <= n4) {
            if (n9 == 53761) {
                int[] nArray = new int[1];
                object = this.getMessage(this.in_, n8, nArray);
                n10 += nArray[0];
                if (object != null) {
                    throw DataStreamException.errorMessage("ddmS38Open", (Message)object);
                }
            } else {
                this.in_.skipBytes(n8 - 4);
                n10 += n8 - 4;
            }
            n8 = this.in_.readShort();
            n9 = this.in_.readShort();
            n10 += 4;
        }
        if (n9 != 54276) {
            throw DataStreamException.badReply("ddmS38Open", n9);
        }
        int n11 = this.in_.readByte();
        object = new byte[10];
        char[] cArray = new char[10];
        this.in_.readFully((byte[])object);
        String string5 = Conv.ebcdicByteArrayToString(object, 0, ((byte[])object).length, cArray);
        this.in_.readFully((byte[])object);
        String string6 = Conv.ebcdicByteArrayToString(object, 0, ((byte[])object).length, cArray);
        this.in_.readFully((byte[])object);
        String string7 = Conv.ebcdicByteArrayToString(object, 0, ((byte[])object).length, cArray);
        int n12 = this.in_.readShort();
        this.in_.skipBytes(10);
        int n13 = this.in_.readInt();
        this.in_.readFully((byte[])object, 0, 2);
        String string8 = Conv.ebcdicByteArrayToString(object, 0, 2, cArray);
        boolean bl6 = this.in_.readByte() == 196;
        boolean bl7 = this.in_.readByte() == 232;
        this.in_.skipBytes(10);
        int n14 = this.in_.readShort();
        int n15 = this.in_.readShort();
        int n16 = this.in_.readByte();
        this.in_.skipBytes(6);
        int n17 = this.in_.readShort();
        int n18 = this.in_.readInt();
        int n19 = this.in_.readShort();
        int n20 = this.in_.readShort();
        int n21 = this.in_.readShort();
        this.in_.skipBytes(4);
        int n22 = this.in_.readShort();
        int n23 = this.in_.readShort();
        this.in_.skipBytes(n4 - (n10 += 92));
        while (bl5) {
            n4 = this.in_.readShort();
            if (n4 < 10) {
                throw DataStreamException.badLength("ddmS38Open", n4);
            }
            n5 = this.in_.read();
            n6 = this.in_.read();
            bl5 = (n6 & 0x40) != 0;
            n7 = this.in_.readShort();
            n10 = 6;
            this.in_.skipBytes(n4 - 6);
        }
        this.in_.end();
        byte[] byArray2 = Conv.blankPadEBCDIC10(string4);
        return new DDMFile(string6, string5, string7, byArray2, byArray, n, n12, n15, n2, n20, n3);
    }

    public List<DDMFileMemberDescription> getFileMemberDescriptions(String string, String string2) throws IOException {
        DDMFile dDMFile = new DDMFile(string, string2, null, null, null, 0, 0, 0, 0, 0, 1);
        return this.getFileMemberDescriptions(dDMFile);
    }

    public List<DDMFileMemberDescription> getFileMemberDescriptions(DDMFile dDMFile) throws IOException {
        List<Message> list = this.executeReturnMessageList("DSPFD FILE(" + dDMFile.getLibrary().trim() + "/" + dDMFile.getFile().trim() + ") TYPE(*MBR) OUTPUT(*OUTFILE) OUTFILE(QTEMP/TB2FD)");
        if (list.size() == 0) {
            throw new IOException("DSPFFD failed to return success message");
        }
        boolean bl = false;
        for (int i = 0; !bl && i < list.size(); ++i) {
            if (list.get(i).getID().equals("CPF9861") || list.get(i).getID().equals("CPF9862") || list.get(i).getID().equals("CPF3030")) continue;
            bl = true;
        }
        if (bl) {
            DataStreamException dataStreamException = DataStreamException.errorMessage("DSPFD", list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                dataStreamException.addMessage(list.get(i));
            }
            throw dataStreamException;
        }
        DDMFile dDMFile2 = this.open("QTEMP", "TB2FD", "TB2FD", "QWHFDMBR", 0, false, 100, 1);
        DDMFileMemberDescriptionReader dDMFileMemberDescriptionReader = new DDMFileMemberDescriptionReader(this.getInfo().getServerCCSID());
        while (!dDMFileMemberDescriptionReader.eof()) {
            this.readNext(dDMFile2, dDMFileMemberDescriptionReader);
        }
        this.close(dDMFile2);
        return dDMFileMemberDescriptionReader.getMemberDescriptions();
    }

    public DDMRecordFormat getRecordFormat(String string, String string2) throws IOException {
        DDMFile dDMFile = new DDMFile(string, string2, null, null, null, 0, 0, 0, 0, 0, 1);
        return this.getRecordFormat(dDMFile);
    }

    public DDMRecordFormat getRecordFormat(DDMFile dDMFile) throws IOException {
        List<Message> list = this.executeReturnMessageList("DSPFFD FILE(" + dDMFile.getLibrary().trim() + "/" + dDMFile.getFile().trim() + ") OUTPUT(*OUTFILE) OUTFILE(QTEMP/TB2FFD)");
        if (list.size() == 0) {
            throw new IOException("DSPFFD failed to return success message");
        }
        boolean bl = false;
        for (int i = 0; !bl && i < list.size(); ++i) {
            if (list.get(i).getID().equals("CPF9861") || list.get(i).getID().equals("CPF9862") || list.get(i).getID().equals("CPF3030")) continue;
            bl = true;
        }
        if (bl) {
            DataStreamException dataStreamException = DataStreamException.errorMessage("DSPFFD", list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                dataStreamException.addMessage(list.get(i));
            }
            throw dataStreamException;
        }
        DDMFile dDMFile2 = this.open("QTEMP", "TB2FFD", "TB2FFD", "QWHDRFFD", 0, false, 100, 1);
        DDMRecordFormatReader dDMRecordFormatReader = new DDMRecordFormatReader(this.getInfo().getServerCCSID());
        while (!dDMRecordFormatReader.eof()) {
            this.readNext(dDMFile2, dDMRecordFormatReader);
        }
        this.close(dDMFile2);
        DDMRecordFormat dDMRecordFormat = new DDMRecordFormat(dDMRecordFormatReader.getLibrary(), dDMRecordFormatReader.getFile(), dDMRecordFormatReader.getName(), dDMRecordFormatReader.getType(), dDMRecordFormatReader.getText(), dDMRecordFormatReader.getFields(), dDMRecordFormatReader.getLength());
        list = this.executeReturnMessageList("DLTF FILE(" + dDMFile2.getLibrary().trim() + "/" + dDMFile2.getFile().trim() + ")");
        bl = false;
        for (int i = 0; !bl && i < list.size(); ++i) {
            if (list.get(i).getID().equals("CPC2191")) continue;
            bl = true;
        }
        if (bl) {
            DataStreamException dataStreamException = DataStreamException.errorMessage("DLTF", list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                dataStreamException.addMessage(list.get(i));
            }
            throw dataStreamException;
        }
        return dDMRecordFormat;
    }

    public void read(DDMFile dDMFile, DDMReadCallback dDMReadCallback, int n) throws IOException {
        this.sendS38GetDRequest(this.out_, dDMFile.getDCLNAM(), dDMFile.getReadWriteType() == 2, dDMFile.getRecordFormatName(), n, false);
        this.out_.flush();
        this.handleReply(dDMFile, "ddmS38GetD", dDMReadCallback);
    }

    public void readKeyEqual(DDMFile dDMFile, DDMReadCallback dDMReadCallback, byte[] byArray, int n) throws IOException {
        this.readTypeKey(dDMFile, dDMReadCallback, byArray, n, 11, false);
    }

    public void readKeyGreater(DDMFile dDMFile, DDMReadCallback dDMReadCallback, byte[] byArray, int n) throws IOException {
        this.readTypeKey(dDMFile, dDMReadCallback, byArray, n, 13, false);
    }

    public void readKeyGreaterOrEqual(DDMFile dDMFile, DDMReadCallback dDMReadCallback, byte[] byArray, int n) throws IOException {
        this.readTypeKey(dDMFile, dDMReadCallback, byArray, n, 12, false);
    }

    public void readKeyLess(DDMFile dDMFile, DDMReadCallback dDMReadCallback, byte[] byArray, int n) throws IOException {
        this.readTypeKey(dDMFile, dDMReadCallback, byArray, n, 9, false);
    }

    public void readKeyLessOrEqual(DDMFile dDMFile, DDMReadCallback dDMReadCallback, byte[] byArray, int n) throws IOException {
        this.readTypeKey(dDMFile, dDMReadCallback, byArray, n, 10, false);
    }

    public void positionToKeyEqual(DDMFile dDMFile, DDMReadCallback dDMReadCallback, byte[] byArray, int n) throws IOException {
        this.readTypeKey(dDMFile, dDMReadCallback, byArray, n, 11, true);
    }

    public void positionToKeyGreater(DDMFile dDMFile, DDMReadCallback dDMReadCallback, byte[] byArray, int n) throws IOException {
        this.readTypeKey(dDMFile, dDMReadCallback, byArray, n, 13, true);
    }

    public void positionToKeyGreaterOrEqual(DDMFile dDMFile, DDMReadCallback dDMReadCallback, byte[] byArray, int n) throws IOException {
        this.readTypeKey(dDMFile, dDMReadCallback, byArray, n, 12, true);
    }

    public void positionToKeyLess(DDMFile dDMFile, DDMReadCallback dDMReadCallback, byte[] byArray, int n) throws IOException {
        this.readTypeKey(dDMFile, dDMReadCallback, byArray, n, 9, true);
    }

    public void positionToKeyLessOrEqual(DDMFile dDMFile, DDMReadCallback dDMReadCallback, byte[] byArray, int n) throws IOException {
        this.readTypeKey(dDMFile, dDMReadCallback, byArray, n, 10, true);
    }

    private void readTypeKey(DDMFile dDMFile, DDMReadCallback dDMReadCallback, byte[] byArray, int n, int n2, boolean bl) throws IOException {
        this.sendS38GetKRequest(this.out_, dDMFile.getDCLNAM(), dDMFile.getReadWriteType() == 2, dDMFile.getRecordFormatName(), n2, byArray, n, bl);
        this.out_.flush();
        this.handleReply(dDMFile, "ddmS38GetK", dDMReadCallback);
    }

    public void readNext(DDMFile dDMFile, DDMReadCallback dDMReadCallback) throws IOException {
        this.readType(dDMFile, dDMReadCallback, 3, false);
    }

    public void readPrevious(DDMFile dDMFile, DDMReadCallback dDMReadCallback) throws IOException {
        this.readType(dDMFile, dDMReadCallback, 4, false);
    }

    public void readFirst(DDMFile dDMFile, DDMReadCallback dDMReadCallback) throws IOException {
        this.readType(dDMFile, dDMReadCallback, 1, false);
    }

    public void readLast(DDMFile dDMFile, DDMReadCallback dDMReadCallback) throws IOException {
        this.readType(dDMFile, dDMReadCallback, 2, false);
    }

    public void readCurrent(DDMFile dDMFile, DDMReadCallback dDMReadCallback) throws IOException {
        this.readType(dDMFile, dDMReadCallback, 33, false);
    }

    public void positionToNext(DDMFile dDMFile, DDMReadCallback dDMReadCallback) throws IOException {
        this.readType(dDMFile, dDMReadCallback, 3, true);
    }

    public void positionToPrevious(DDMFile dDMFile, DDMReadCallback dDMReadCallback) throws IOException {
        this.readType(dDMFile, dDMReadCallback, 4, true);
    }

    public void positionToFirst(DDMFile dDMFile) throws IOException {
        this.readType(dDMFile, null, 1, true);
    }

    public void positionToLast(DDMFile dDMFile) throws IOException {
        this.readType(dDMFile, null, 2, true);
    }

    public void positionAfterLast(DDMFile dDMFile) throws IOException {
        this.position(dDMFile, 2);
    }

    public void positionBeforeFirst(DDMFile dDMFile) throws IOException {
        this.position(dDMFile, 1);
    }

    public void position(DDMFile dDMFile, DDMReadCallback dDMReadCallback, int n) throws IOException {
        this.sendS38GetDRequest(this.out_, dDMFile.getDCLNAM(), dDMFile.getReadWriteType() == 2, dDMFile.getRecordFormatName(), n, true);
        this.out_.flush();
        this.handleReply(dDMFile, "ddmS38GetD", dDMReadCallback);
    }

    public void write(DDMFile dDMFile, byte[] byArray, int n, boolean[] blArray, DDMReadCallback dDMReadCallback) throws IOException {
        int n2 = this.newCorrelationID();
        this.sendS38PUTMRequest(this.out_, dDMFile.getDCLNAM(), n2);
        dDMFile.getEventBuffer().setEventType(0);
        this.sendS38BUFRequest(this.out_, n2, dDMFile.getRecordIncrement(), byArray, n, dDMFile.getRecordLength(), blArray);
        this.out_.flush();
        this.handleReply(dDMFile, "ddmS38PUTM", dDMReadCallback);
    }

    public void write(DDMFile dDMFile, DDMWriteCallback dDMWriteCallback) throws IOException {
        DDMCallbackEvent dDMCallbackEvent = dDMFile.getEventBuffer();
        dDMCallbackEvent.setEventType(0);
        int n = dDMFile.getBatchSize();
        int n2 = dDMWriteCallback.getNumberOfRecords(dDMCallbackEvent);
        int n3 = n2 > n ? n : n2;
        int n4 = this.newCorrelationID();
        for (int i = 0; i < n2; i += n3) {
            if (i + n3 >= n2) {
                n3 = n2 - i;
            }
            this.sendS38PUTMRequest(this.out_, dDMFile.getDCLNAM(), n4);
            this.sendS38BUFRequest(dDMFile, this.out_, n4, dDMFile.getRecordIncrement(), dDMWriteCallback, dDMFile.getRecordLength(), i, n3);
            this.out_.flush();
            this.handleReply(dDMFile, "ddmS38PUTM", null);
        }
    }

    public void updateCurrent(DDMFile dDMFile, byte[] byArray, int n, boolean[] blArray) throws IOException {
        int n2 = this.sendS38UPDATRequest(this.out_, dDMFile.getDCLNAM());
        dDMFile.getEventBuffer().setEventType(1);
        this.sendS38BUFRequest(this.out_, n2, dDMFile.getRecordIncrement(), byArray, n, dDMFile.getRecordLength(), blArray);
        this.out_.flush();
        this.handleReply(dDMFile, "ddmS38UPDAT", null);
    }

    public void updateCurrent(DDMFile dDMFile, DDMWriteCallback dDMWriteCallback) throws IOException {
        int n = this.sendS38UPDATRequest(this.out_, dDMFile.getDCLNAM());
        dDMFile.getEventBuffer().setEventType(1);
        this.sendS38BUFRequest(dDMFile, this.out_, n, dDMFile.getRecordIncrement(), dDMWriteCallback, dDMFile.getRecordLength(), 0, 1);
        this.out_.flush();
        this.handleReply(dDMFile, "ddmS38UPDAT", null);
    }

    public Message[] execute(String string) throws IOException {
        List<Message> list = this.executeReturnMessageList(string);
        Message[] messageArray = new Message[list.size()];
        for (int i = 0; i < messageArray.length; ++i) {
            messageArray[i] = list.get(i);
        }
        return messageArray;
    }

    public List<Message> executeReturnMessageList(String string) throws IOException {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        this.sendS38CMDRequest(this.out_, string);
        this.out_.flush();
        this.handleReply(null, "ddmS38CMD", null, arrayList);
        return arrayList;
    }

    public void deleteCurrent(DDMFile dDMFile) throws IOException {
        this.sendS38DELRequest(this.out_, dDMFile.getDCLNAM());
        this.out_.flush();
        this.handleReply(dDMFile, "ddmS38DEL", null);
    }

    private void position(DDMFile dDMFile, int n) throws IOException {
        this.sendS38FEODRequest(this.out_, dDMFile.getDCLNAM(), n);
        this.out_.flush();
        this.handleReply(dDMFile, "ddmS38FEOD", null);
    }

    private void readType(DDMFile dDMFile, DDMReadCallback dDMReadCallback, int n, boolean bl) throws IOException {
        this.sendS38GetRequest(this.out_, dDMFile.getDCLNAM(), dDMFile.getReadWriteType() == 2, n, bl);
        this.out_.flush();
        this.handleReply(dDMFile, "ddmS38Get", dDMReadCallback);
    }

    private void handleReply(DDMFile dDMFile, String string, DDMReadCallback dDMReadCallback) throws IOException {
        this.handleReply(dDMFile, string, dDMReadCallback, null);
    }

    private void handleReply(DDMFile dDMFile, String string, DDMReadCallback dDMReadCallback, List<Message> list) throws IOException {
        boolean bl;
        int n = this.in_.readShort();
        boolean bl2 = bl = n > Short.MAX_VALUE;
        if (bl) {
            n &= Short.MAX_VALUE;
        }
        if (n < 10) {
            throw DataStreamException.badLength(string, n);
        }
        int n2 = this.in_.read();
        int n3 = this.in_.read();
        boolean bl3 = (n3 & 0x40) != 0;
        int n4 = this.in_.readShort();
        int n5 = 6;
        DataStreamException dataStreamException = null;
        while (n5 < n) {
            int n6;
            int n7;
            String string2;
            int n8;
            int n9 = this.in_.readShort();
            int n10 = this.in_.readShort();
            n5 += 4;
            if (n10 == 54274) {
                boolean bl4 = !bl3;
                this.in_.skipBytes(n - n5);
                n5 += n - n5;
                while (bl3) {
                    int n11 = this.in_.readShort();
                    if (n11 < 10) {
                        throw DataStreamException.badLength(string, n11);
                    }
                    n2 = this.in_.read();
                    n3 = this.in_.read();
                    bl3 = (n3 & 0x40) != 0;
                    n4 = this.in_.readShort();
                    n9 = this.in_.readShort();
                    n10 = this.in_.readShort();
                    n8 = 10;
                    n5 += 10;
                    if (n10 == 53761) {
                        int[] nArray = new int[1];
                        Message message = this.getMessage(this.in_, n9, nArray);
                        n5 += nArray[0];
                        n8 += nArray[0];
                        if (message != null) {
                            if (list != null) {
                                list.add(message);
                            }
                            if ((string2 = message.getID()) != null) {
                                if (string2.equals("CPF5001") || string2.equals("CPF5025")) {
                                    if (dDMReadCallback != null) {
                                        dDMFile.getEventBuffer().setEventType(2);
                                        dDMReadCallback.endOfFile(dDMFile.getEventBuffer());
                                    }
                                    bl4 = true;
                                } else if (string2.equals("CPF5006")) {
                                    if (dDMReadCallback != null) {
                                        dDMFile.getEventBuffer().setEventType(2);
                                        dDMReadCallback.recordNotFound(dDMFile.getEventBuffer());
                                    }
                                    bl4 = true;
                                } else if (list == null) {
                                    if (dataStreamException == null) {
                                        dataStreamException = DataStreamException.errorMessage(string + "_chained", message);
                                        dataStreamException.fillInStackTrace();
                                    } else {
                                        dataStreamException.addMessage(message);
                                    }
                                    bl4 = true;
                                }
                            } else if (list == null) {
                                if (dataStreamException == null) {
                                    dataStreamException = DataStreamException.errorMessage(string + "_chained", message);
                                    dataStreamException.fillInStackTrace();
                                } else {
                                    dataStreamException.addMessage(message);
                                }
                                bl4 = true;
                            }
                        }
                    } else {
                        this.in_.skipBytes(n9 - 4);
                        n5 += n9 - 4;
                        n8 += n9 - 4;
                    }
                    this.in_.skipBytes(n11 - n8);
                    n5 += n11 - n8;
                }
                if (bl4) continue;
                throw DataStreamException.badReply(string, n10);
            }
            if (n10 == 54277) {
                boolean bl5 = n9 > Short.MAX_VALUE;
                int n12 = bl5 ? this.in_.readInt() + 18 : n9 + 10;
                n5 += bl5 ? 4 : 0;
                if (dDMReadCallback == null) {
                    n8 = n12 - n5 - 4;
                    if (n8 > 0) {
                        this.in_.skipBytes(n8);
                        n5 += n8;
                    }
                } else {
                    n8 = dDMFile.getRecordLength();
                    n7 = dDMFile.getRecordIncrement();
                    while (n5 + n7 <= n12) {
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        byte[] byArray = dDMFile.getRecordDataBuffer();
                        boolean bl6 = false;
                        if (bl && n5 + n7 > n) {
                            n16 = n - n5;
                            n15 = n16 > byArray.length ? byArray.length : n16;
                            this.in_.readFully(byArray, 0, n15);
                            n5 += n15;
                            int n17 = byArray.length - n15;
                            if (n17 > 0) {
                                int n18 = this.in_.readShort();
                                if (n18 <= Short.MAX_VALUE) {
                                    bl = false;
                                }
                                n14 = (n18 & Short.MAX_VALUE) - 2;
                                n += n14;
                                this.in_.readFully(byArray, n15, n17);
                                n5 += n17;
                            } else {
                                byte by;
                                int n19;
                                byte[] byArray2 = dDMFile.getPacketBuffer();
                                this.in_.readFully(byArray2);
                                n5 += byArray2.length;
                                n14 = (byArray2[n16 -= byArray.length] & 0xFF) << 8 | byArray2[n16 + 1] & 0xFF;
                                if (n14 <= Short.MAX_VALUE) {
                                    bl = false;
                                }
                                n13 = n14 & Short.MAX_VALUE;
                                n += n13;
                                int n20 = 0;
                                int n21 = -1;
                                if (n16 < 3) {
                                    n21 = Conv.byteArrayToInt(byArray2, 4);
                                    n20 = 8;
                                } else if (n16 > 5) {
                                    n21 = Conv.byteArrayToInt(byArray2, 2);
                                    n20 = 6;
                                } else {
                                    int n22 = 2;
                                    byte by2 = byArray2[n22++];
                                    if (n16 == n22) {
                                        n22 += 2;
                                    }
                                    n19 = byArray2[n22++];
                                    if (n16 == n22) {
                                        n22 += 2;
                                    }
                                    by = byArray2[n22++];
                                    if (n16 == n22) {
                                        n22 += 2;
                                    }
                                    byte by3 = byArray2[n22++];
                                    n21 = (by2 & 0xFF) << 24 | (n19 & 0xFF) << 16 | (by & 0xFF) << 8 | by3 & 0xFF;
                                    n20 = n22;
                                }
                                n20 += 5;
                                byte[] byArray3 = dDMFile.getNullFieldMap();
                                boolean[] blArray = dDMFile.getNullFieldValues();
                                for (n19 = 0; n19 < blArray.length; ++n19) {
                                    if (n20 == n16 || n20 == n16 + 1) {
                                        --n19;
                                    } else {
                                        by = byArray2[n20];
                                        if (by == -15) {
                                            blArray[n19] = true;
                                            byArray3[n19] = by;
                                        } else if (by == -16) {
                                            blArray[n19] = false;
                                            byArray3[n19] = by;
                                        } else {
                                            throw new IOException("Bad null field map value: " + Integer.toHexString(by));
                                        }
                                    }
                                    ++n20;
                                }
                                DDMCallbackEvent dDMCallbackEvent = dDMFile.getEventBuffer();
                                dDMCallbackEvent.setEventType(2);
                                DDMDataBuffer dDMDataBuffer = dDMFile.getDataBuffer(dDMFile.getCurrentBufferIndex());
                                dDMDataBuffer.setRecordNumber(n21);
                                dDMReadCallback.newRecord(dDMCallbackEvent, dDMDataBuffer);
                                dDMFile.nextBuffer();
                                bl6 = true;
                            }
                        } else {
                            this.in_.readFully(byArray);
                            n5 += byArray.length;
                        }
                        if (bl6) continue;
                        this.in_.skipBytes(2);
                        n16 = this.in_.readInt();
                        n5 += 6;
                        n15 = 5;
                        this.in_.skipBytes(n15);
                        n5 += n15;
                        byte[] byArray4 = dDMFile.getNullFieldMap();
                        this.in_.readFully(byArray4);
                        n5 += byArray4.length;
                        boolean[] blArray = dDMFile.getNullFieldValues();
                        for (n14 = 0; n14 < byArray4.length; ++n14) {
                            n13 = byArray4[n14];
                            if (n13 == -15) {
                                blArray[n14] = true;
                                continue;
                            }
                            if (n13 == -16) {
                                blArray[n14] = false;
                                continue;
                            }
                            throw new IOException("Bad null field map value: " + Integer.toHexString(n13));
                        }
                        DDMCallbackEvent dDMCallbackEvent = dDMFile.getEventBuffer();
                        dDMCallbackEvent.setEventType(2);
                        DDMDataBuffer dDMDataBuffer = dDMFile.getDataBuffer(dDMFile.getCurrentBufferIndex());
                        dDMDataBuffer.setRecordNumber(n16);
                        dDMReadCallback.newRecord(dDMCallbackEvent, dDMDataBuffer);
                        dDMFile.nextBuffer();
                    }
                    int n23 = n12 - n5 - 4;
                    if (n23 > 0) {
                        this.in_.skipBytes(n23);
                        n5 += n23;
                    }
                    if (n9 < 32768 && n9 < dDMFile.getRecordIncrement() * dDMFile.getBatchSize()) {
                        dDMFile.getEventBuffer().setEventType(2);
                        dDMReadCallback.endOfFile(dDMFile.getEventBuffer());
                    }
                }
                n8 = n - n5;
                if (n8 > 0) {
                    this.in_.skipBytes(n8);
                    n5 += n8;
                }
                while (bl3) {
                    n7 = this.in_.readShort();
                    if (n7 < 10) {
                        throw DataStreamException.badLength(string + "_chained", n7);
                    }
                    n2 = this.in_.read();
                    n3 = this.in_.read();
                    bl3 = (n3 & 0x40) != 0;
                    n4 = this.in_.readShort();
                    n9 = this.in_.readShort();
                    n10 = this.in_.readShort();
                    n6 = 10;
                    n5 += 10;
                    if (n10 == 53761) {
                        int[] nArray = new int[1];
                        Message message = this.getMessage(this.in_, n9, nArray);
                        n6 += nArray[0];
                        n5 += nArray[0];
                        if (message != null) {
                            String string3;
                            if (list != null) {
                                list.add(message);
                            }
                            if ((string3 = message.getID()) != null) {
                                if (string3.equals("CPF5001") || string3.equals("CPF5025")) {
                                    if (dDMReadCallback != null) {
                                        dDMFile.getEventBuffer().setEventType(2);
                                        dDMReadCallback.endOfFile(dDMFile.getEventBuffer());
                                    }
                                } else if (string3.equals("CPF5006")) {
                                    if (dDMReadCallback != null) {
                                        dDMFile.getEventBuffer().setEventType(2);
                                        dDMReadCallback.recordNotFound(dDMFile.getEventBuffer());
                                    }
                                } else if (list == null) {
                                    throw DataStreamException.errorMessage(string + "_chained", message);
                                }
                            } else if (list == null) {
                                throw DataStreamException.errorMessage(string + "_chained", message);
                            }
                        }
                    } else if (n10 == 54274) {
                        this.in_.skipBytes(n7 - n6);
                        n5 += n7 - n6;
                        n6 = n7;
                    } else {
                        throw DataStreamException.badReply(string + "_chained", n10);
                    }
                    this.in_.skipBytes(n7 - n6);
                    n5 += n7 - n6;
                }
                continue;
            }
            if (n10 == 53761) {
                int[] nArray = new int[1];
                Message message = this.getMessage(this.in_, n9, nArray);
                n5 += nArray[0];
                if (message != null) {
                    if (list != null) {
                        list.add(message);
                    } else {
                        throw DataStreamException.errorMessage(string, message);
                    }
                }
                if ((n8 = n - n5) > 0) {
                    this.in_.skipBytes(n8);
                    n5 += n8;
                }
                while (bl3) {
                    n7 = this.in_.readShort();
                    if (n7 < 10) {
                        throw DataStreamException.badLength(string + "_chained", n7);
                    }
                    n2 = this.in_.read();
                    n3 = this.in_.read();
                    bl3 = (n3 & 0x40) != 0;
                    n4 = this.in_.readShort();
                    n9 = this.in_.readShort();
                    n10 = this.in_.readShort();
                    n6 = 10;
                    n5 += 10;
                    if (n10 == 53761) {
                        nArray = new int[1];
                        message = this.getMessage(this.in_, n9, nArray);
                        n6 += nArray[0];
                        n5 += nArray[0];
                        if (message != null) {
                            if (list != null) {
                                list.add(message);
                            }
                            if ((string2 = message.getID()) != null) {
                                if (string2.equals("CPF5001") || string2.equals("CPF5025")) {
                                    if (dDMReadCallback != null) {
                                        dDMFile.getEventBuffer().setEventType(2);
                                        dDMReadCallback.endOfFile(dDMFile.getEventBuffer());
                                    }
                                } else if (string2.equals("CPF5006")) {
                                    if (dDMReadCallback != null) {
                                        dDMFile.getEventBuffer().setEventType(2);
                                        dDMReadCallback.recordNotFound(dDMFile.getEventBuffer());
                                    }
                                } else if (list == null) {
                                    throw DataStreamException.errorMessage(string + "_chained", message);
                                }
                            } else if (list == null) {
                                throw DataStreamException.errorMessage(string + "_chained", message);
                            }
                        }
                    } else if (n10 == 54274) {
                        this.in_.skipBytes(n7 - n6);
                        n5 += n7 - n6;
                        n6 = n7;
                    } else {
                        throw DataStreamException.badReply(string + "_chained", n10);
                    }
                    this.in_.skipBytes(n7 - n6);
                    n5 += n7 - n6;
                }
                continue;
            }
            throw DataStreamException.badReply(string, n10);
        }
        this.in_.end();
        if (dataStreamException != null) {
            throw dataStreamException;
        }
    }

    private byte[] generateDCLNAM() {
        byte[] byArray = new byte[8];
        int n = this.dclNamCounter_++;
        int n2 = n % 10;
        byArray[7] = (byte)(n2 + 240);
        n2 = (n /= 10) % 10;
        byArray[6] = (byte)(n2 + 240);
        n = n == 0 ? 0 : n / 10;
        n2 = n == 0 ? 0 : n % 10;
        byArray[5] = (byte)(n2 + 240);
        n = n == 0 ? 0 : n / 10;
        n2 = n == 0 ? 0 : n % 10;
        byArray[4] = (byte)(n2 + 240);
        n = n == 0 ? 0 : n / 10;
        n2 = n == 0 ? 0 : n % 10;
        byArray[3] = (byte)(n2 + 240);
        n = n == 0 ? 0 : n / 10;
        n2 = n == 0 ? 0 : n % 10;
        byArray[2] = (byte)(n2 + 240);
        n = n == 0 ? 0 : n / 10;
        n2 = n == 0 ? 0 : n % 10;
        byArray[1] = (byte)(n2 + 240);
        n = n == 0 ? 0 : n / 10;
        n2 = n == 0 ? 0 : n % 10;
        byArray[0] = (byte)(n2 + 240);
        return byArray;
    }

    private void sendS38CMDRequest(HostServerConnection.HostOutputStream hostOutputStream, String string) throws IOException {
        byte[] byArray = Conv.stringToEBCDICByteArray37(string);
        hostOutputStream.writeShort(14 + byArray.length);
        hostOutputStream.write(208);
        hostOutputStream.write(1);
        hostOutputStream.writeShort(this.newCorrelationID());
        hostOutputStream.writeShort(8 + byArray.length);
        hostOutputStream.writeShort(53254);
        hostOutputStream.writeShort(4 + byArray.length);
        hostOutputStream.writeShort(53507);
        hostOutputStream.write(byArray);
    }

    private void sendS38DELRequest(HostServerConnection.HostOutputStream hostOutputStream, byte[] byArray) throws IOException {
        hostOutputStream.writeInt(1495041);
        hostOutputStream.writeShort(this.newCorrelationID());
        hostOutputStream.writeInt(1101831);
        hostOutputStream.writeInt(790838);
        hostOutputStream.write(byArray, 0, 8);
    }

    private int sendS38UPDATRequest(HostServerConnection.HostOutputStream hostOutputStream, byte[] byArray) throws IOException {
        hostOutputStream.writeInt(2019409);
        int n = this.newCorrelationID();
        hostOutputStream.writeShort(n);
        hostOutputStream.writeInt(1626137);
        hostOutputStream.writeInt(790838);
        hostOutputStream.write(byArray, 0, 8);
        hostOutputStream.writeInt(577817);
        hostOutputStream.writeInt(553844999);
        return n;
    }

    private void sendS38PUTMRequest(HostServerConnection.HostOutputStream hostOutputStream, byte[] byArray, int n) throws IOException {
        hostOutputStream.writeInt(1495121);
        hostOutputStream.writeShort(n);
        hostOutputStream.writeInt(1101843);
        hostOutputStream.writeInt(790838);
        hostOutputStream.write(byArray, 0, 8);
    }

    private void sendS38BUFRequest(HostServerConnection.HostOutputStream hostOutputStream, int n, int n2, byte[] byArray, int n3, int n4, boolean[] blArray) throws IOException {
        hostOutputStream.writeShort(n2 + 10);
        hostOutputStream.writeShort(53251);
        hostOutputStream.writeShort(n);
        hostOutputStream.writeShort(n2 + 4);
        hostOutputStream.writeShort(54277);
        hostOutputStream.write(byArray, n3, n4);
        int n5 = n2 - n4;
        boolean bl = blArray != null;
        for (int i = 0; i < n5; ++i) {
            int n6 = bl && i < blArray.length ? (blArray[i] ? 241 : 240) : 240;
            hostOutputStream.write(n6);
        }
    }

    private void sendS38BUFRequest(DDMFile dDMFile, HostServerConnection.HostOutputStream hostOutputStream, int n, int n2, DDMWriteCallback dDMWriteCallback, int n3, int n4, int n5) throws IOException {
        int n6 = n5 * n2;
        hostOutputStream.writeShort(n6 + 10);
        hostOutputStream.write(53251);
        hostOutputStream.writeShort(n);
        hostOutputStream.writeShort(n6 + 4);
        hostOutputStream.writeShort(54277);
        int n7 = n4 + n5;
        DDMCallbackEvent dDMCallbackEvent = dDMFile.getEventBuffer();
        for (int i = n4; i < n7; ++i) {
            byte[] byArray = dDMWriteCallback.getRecordData(dDMCallbackEvent, i);
            int n8 = dDMWriteCallback.getRecordDataOffset(dDMCallbackEvent, i);
            hostOutputStream.write(byArray, n8, n3);
            int n9 = n2 - n3;
            boolean[] blArray = dDMWriteCallback.getNullFieldValues(dDMCallbackEvent, i);
            boolean bl = blArray != null;
            for (int j = 0; j < n9; ++j) {
                int n10 = bl && j < blArray.length ? (blArray[j] ? 241 : 240) : 240;
                hostOutputStream.write(n10);
            }
        }
    }

    private void sendS38GetRequest(HostServerConnection.HostOutputStream hostOutputStream, byte[] byArray, boolean bl, int n, boolean bl2) throws IOException {
        hostOutputStream.writeInt(2019329);
        hostOutputStream.writeShort(this.newCorrelationID());
        hostOutputStream.writeInt(1626124);
        hostOutputStream.writeInt(790838);
        hostOutputStream.write(byArray, 0, 8);
        hostOutputStream.writeInt(577817);
        hostOutputStream.write(n);
        hostOutputStream.write(bl ? 3 : 0);
        hostOutputStream.write(bl2 ? 1 : 0);
        hostOutputStream.write(1);
    }

    private void sendS38GetKRequest(HostServerConnection.HostOutputStream hostOutputStream, byte[] byArray, boolean bl, byte[] byArray2, int n, byte[] byArray3, int n2, boolean bl2) throws IOException {
        hostOutputStream.writeShort(63 + byArray3.length);
        hostOutputStream.writeShort(53249);
        hostOutputStream.writeShort(this.newCorrelationID());
        hostOutputStream.writeShort(57 + byArray3.length);
        hostOutputStream.writeInt(-804388852);
        hostOutputStream.writeShort(4406);
        hostOutputStream.write(byArray, 0, 8);
        hostOutputStream.writeInt(577817);
        hostOutputStream.write(n);
        hostOutputStream.write(bl ? 3 : 0);
        hostOutputStream.writeShort(bl2 ? 259 : 3);
        hostOutputStream.writeShort(33 + byArray3.length);
        hostOutputStream.writeInt(-788201216);
        hostOutputStream.write(10);
        hostOutputStream.write(byArray2);
        hostOutputStream.writeInt(0xF000200);
        hostOutputStream.writeInt(524292);
        hostOutputStream.writeInt(n2);
        hostOutputStream.write(7);
        hostOutputStream.writeShort(byArray3.length);
        hostOutputStream.write(byArray3);
        hostOutputStream.write(255);
    }

    private void sendS38GetDRequest(HostServerConnection.HostOutputStream hostOutputStream, byte[] byArray, boolean bl, byte[] byArray2, int n, boolean bl2) throws IOException {
        hostOutputStream.writeInt(3985409);
        hostOutputStream.writeShort(this.newCorrelationID());
        hostOutputStream.writeInt(3592205);
        hostOutputStream.writeInt(790838);
        hostOutputStream.write(byArray, 0, 8);
        hostOutputStream.writeInt(577817);
        hostOutputStream.write(8);
        hostOutputStream.write(bl ? 3 : 0);
        hostOutputStream.write(bl2 ? 1 : 0);
        hostOutputStream.writeInt(33562321);
        hostOutputStream.writeInt(83951628);
        hostOutputStream.write(byArray2);
        hostOutputStream.writeInt(0xF000200);
        hostOutputStream.writeInt(131076);
        hostOutputStream.writeInt(n);
        hostOutputStream.write(255);
    }

    private void sendS38FEODRequest(HostServerConnection.HostOutputStream hostOutputStream, byte[] byArray, int n) throws IOException {
        hostOutputStream.writeInt(2019409);
        int n2 = this.newCorrelationID();
        hostOutputStream.writeShort(n2);
        hostOutputStream.writeInt(1626123);
        hostOutputStream.writeInt(790838);
        hostOutputStream.write(byArray, 0, 8);
        hostOutputStream.writeInt(577817);
        hostOutputStream.write(n);
        hostOutputStream.writeInt(0x2010100);
        hostOutputStream.write(11);
        hostOutputStream.writeShort(53251);
        hostOutputStream.writeShort(n2);
        hostOutputStream.writeInt(381957);
        hostOutputStream.write(0);
    }

    private void sendS38CloseRequest(HostServerConnection.HostOutputStream hostOutputStream, byte[] byArray) throws IOException {
        hostOutputStream.writeInt(1822721);
        hostOutputStream.writeShort(this.newCorrelationID());
        hostOutputStream.writeShort(21);
        hostOutputStream.writeShort(53252);
        hostOutputStream.writeShort(12);
        hostOutputStream.writeShort(4406);
        hostOutputStream.write(byArray, 0, 8);
        hostOutputStream.writeShort(5);
        hostOutputStream.writeShort(53537);
        hostOutputStream.write(2);
    }

    private void sendS38OpenRequest(HostServerConnection.HostOutputStream hostOutputStream, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, String string4, byte[] byArray, int n) throws IOException {
        if (!bl && !bl2) {
            bl = true;
        }
        int n2 = 106 + (bl3 || bl ? 3 : 0);
        int n3 = 26 + n2;
        if (n < 1 || bl && bl2) {
            n = 1;
        }
        n &= Short.MAX_VALUE;
        hostOutputStream.writeShort(n3);
        hostOutputStream.write(208);
        hostOutputStream.write(1);
        hostOutputStream.writeShort(this.newCorrelationID());
        hostOutputStream.writeShort(20 + n2);
        hostOutputStream.writeShort(53265);
        hostOutputStream.writeShort(12);
        hostOutputStream.writeShort(4406);
        hostOutputStream.write(byArray);
        hostOutputStream.writeShort(4 + n2);
        hostOutputStream.writeShort(53535);
        int n4 = 18 + byArray.length;
        DDMConnection.writePadEBCDIC10(string, hostOutputStream);
        hostOutputStream.writeShort(72);
        DDMConnection.writePadEBCDIC10(string2, hostOutputStream);
        hostOutputStream.writeShort(73);
        DDMConnection.writePadEBCDIC10(string3, hostOutputStream);
        n4 += 34;
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        n4 += 12;
        int n5 = 4098;
        n5 = bl && !bl2 ? (n5 |= 0x20) : (bl && bl2 ? (n5 |= 0x3C) : (n5 |= 0x10));
        hostOutputStream.writeShort(n5);
        hostOutputStream.writeInt(-252579600);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0x20000000);
        hostOutputStream.writeInt(0x2000000);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeShort(6);
        hostOutputStream.write(0);
        n4 += 37;
        if (bl3 || bl) {
            hostOutputStream.writeShort(60);
            hostOutputStream.write(!bl3 || !bl ? 128 : 0);
            n4 += 3;
        }
        hostOutputStream.writeShort(58);
        hostOutputStream.write(bl && bl2 ? 64 : 192);
        hostOutputStream.writeShort(n);
        hostOutputStream.writeShort(9);
        hostOutputStream.writeShort(1);
        hostOutputStream.writeShort(1);
        DDMConnection.writePadEBCDIC10(string4, hostOutputStream);
        hostOutputStream.writeShort(Short.MAX_VALUE);
        n4 += 23;
    }

    private static void sendSECCHKRequest(HostServerConnection.HostOutputStream hostOutputStream, byte[] byArray, byte[] byArray2) throws IOException {
        hostOutputStream.writeShort(34 + byArray2.length);
        hostOutputStream.write(208);
        hostOutputStream.write(1);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(28 + byArray2.length);
        hostOutputStream.writeShort(4206);
        hostOutputStream.writeShort(6);
        hostOutputStream.writeShort(4514);
        hostOutputStream.writeShort(byArray2.length == 20 ? 8 : 6);
        hostOutputStream.writeShort(14);
        hostOutputStream.writeShort(4512);
        hostOutputStream.write(byArray, 0, 10);
        hostOutputStream.writeShort(4 + byArray2.length);
        hostOutputStream.writeShort(4513);
        hostOutputStream.write(byArray2);
    }

    private static long sendACCSECRequest(HostServerConnection.HostOutputStream hostOutputStream, boolean bl) throws IOException {
        hostOutputStream.writeShort(28);
        hostOutputStream.write(208);
        hostOutputStream.write(1);
        hostOutputStream.writeShort(1);
        hostOutputStream.writeShort(22);
        hostOutputStream.writeShort(4205);
        hostOutputStream.writeShort(6);
        hostOutputStream.writeShort(4514);
        hostOutputStream.writeShort(bl ? 8 : 6);
        hostOutputStream.writeShort(12);
        hostOutputStream.writeShort(4572);
        long l = System.currentTimeMillis();
        hostOutputStream.writeLong(l);
        return l;
    }

    private static void sendEXCSATRequest(HostServerConnection.HostOutputStream hostOutputStream) throws IOException {
        hostOutputStream.writeShort(126);
        hostOutputStream.write(208);
        hostOutputStream.write(1);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(120);
        hostOutputStream.writeShort(4161);
        hostOutputStream.writeShort(9);
        hostOutputStream.writeShort(4446);
        hostOutputStream.writeInt(-473770265);
        hostOutputStream.write(242);
        hostOutputStream.writeShort(11);
        hostOutputStream.writeShort(4423);
        hostOutputStream.writeShort(7);
        hostOutputStream.writeShort(9);
        hostOutputStream.writeShort(55489);
        hostOutputStream.write(226);
        hostOutputStream.writeShort(96);
        hostOutputStream.writeShort(5124);
        hostOutputStream.writeShort(5123);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5155);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5125);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5126);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5127);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5236);
        hostOutputStream.writeShort(5);
        hostOutputStream.writeShort(5208);
        hostOutputStream.writeShort(1);
        hostOutputStream.writeShort(5207);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5132);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5145);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5150);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5154);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(9231);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5170);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5171);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5184);
        hostOutputStream.writeShort(1);
        hostOutputStream.writeShort(5179);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(9223);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5219);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5221);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5180);
        hostOutputStream.writeShort(3);
        hostOutputStream.writeShort(5247);
        hostOutputStream.writeShort(4);
        hostOutputStream.writeShort(5280);
        hostOutputStream.writeShort(4);
    }
}

