/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import com.ibm.jtopenlite.ByteArrayKey;
import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.database.DatabaseRequestAttributes;
import com.ibm.jtopenlite.database.jdbc.JDBCBlob;
import com.ibm.jtopenlite.database.jdbc.JDBCBlobLocator;
import com.ibm.jtopenlite.database.jdbc.JDBCClob;
import com.ibm.jtopenlite.database.jdbc.JDBCConnection;
import com.ibm.jtopenlite.database.jdbc.JDBCError;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;

final class Column {
    private static final char[] NUMS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String name_;
    private String udtName_;
    private int type_;
    private int length_;
    private int declaredLength_ = 0;
    private int scale_;
    private int precision_;
    private int ccsid_;
    private boolean isForBitData_;
    private int lobMaxSize_;
    private int offset_;
    private int index_;
    private boolean parameter_;
    private char[] buffer_;
    private int dateFormat_;
    private int timeFormat_;
    private int dateSeparator_;
    private int timeSeparator_;
    private String table_;
    private String label_;
    private String schema_;
    private boolean autoIncrement_;
    private boolean definitelyWritable_;
    private boolean readOnly_ = true;
    private boolean searchable_ = true;
    private boolean writable_;
    private boolean useDateCache_ = false;
    private HashMap dateCache_;
    private boolean useTimeCache_ = false;
    private HashMap timeCache_;
    private boolean useStringCache_ = false;
    private boolean cacheLastOnly_ = false;
    private HashMap cache_ = null;
    private boolean null_ = false;
    private String stringValue_;
    private int intValue_;
    private long longValue_;
    private short shortValue_;
    private float floatValue_;
    private double doubleValue_;
    private byte byteValue_;
    private boolean booleanValue_;
    private java.util.Date dateValue_;
    private byte[] byteArrayValue_;
    private BigDecimal bigDecimalValue_;
    private Object objectValue_;
    private URL urlValue_;
    private InputStream inputStreamValue_;
    private int inputStreamLength_;
    private Reader readerValue_;
    private int valueType_ = 0;
    private static final int TYPE_STRING = 1;
    private static final int TYPE_INT = 2;
    private static final int TYPE_LONG = 3;
    private static final int TYPE_SHORT = 4;
    private static final int TYPE_FLOAT = 5;
    private static final int TYPE_DOUBLE = 6;
    private static final int TYPE_BYTE = 7;
    private static final int TYPE_BOOLEAN = 8;
    private static final int TYPE_DATE = 9;
    private static final int TYPE_TIME = 10;
    private static final int TYPE_TIMESTAMP = 11;
    private static final int TYPE_BYTE_ARRAY = 12;
    private static final int TYPE_BIG_DECIMAL = 13;
    private static final int TYPE_OBJECT = 14;
    private static final int TYPE_URL = 15;
    private static final int TYPE_ASCII_STREAM = 16;
    private static final int TYPE_BINARY_STREAM = 17;
    private static final int TYPE_UNICODE_STREAM = 18;
    private static final int TYPE_CHARACTER_STREAM = 19;
    private Calendar calendar_;
    private final ByteArrayKey key_ = new ByteArrayKey();
    static TimeZone gmtTimeZone = null;

    Column(Calendar calendar, int n, boolean bl) {
        this.calendar_ = calendar;
        this.index_ = n;
        this.parameter_ = bl;
    }

    void clearValue() {
        this.null_ = false;
        this.stringValue_ = null;
        this.intValue_ = 0;
        this.longValue_ = 0L;
        this.shortValue_ = 0;
        this.floatValue_ = 0.0f;
        this.doubleValue_ = 0.0;
        this.byteValue_ = 0;
        this.booleanValue_ = false;
        this.dateValue_ = null;
        this.byteArrayValue_ = null;
        this.bigDecimalValue_ = null;
        this.objectValue_ = null;
        this.urlValue_ = null;
        this.inputStreamValue_ = null;
        this.inputStreamLength_ = 0;
        this.readerValue_ = null;
        this.valueType_ = 0;
    }

    void setValue(String string) {
        this.stringValue_ = string;
        this.null_ = string == null;
        this.valueType_ = 1;
    }

    void setValue(int n) {
        this.intValue_ = n;
        this.null_ = false;
        this.valueType_ = 2;
    }

    void setValue(long l) {
        this.longValue_ = l;
        this.null_ = false;
        this.valueType_ = 3;
    }

    void setValue(short s) {
        this.shortValue_ = s;
        this.null_ = false;
        this.valueType_ = 4;
    }

    void setValue(float f) {
        this.floatValue_ = f;
        this.null_ = false;
        this.valueType_ = 5;
    }

    void setValue(double d) {
        this.doubleValue_ = d;
        this.null_ = false;
        this.valueType_ = 6;
    }

    void setValue(byte by) {
        this.byteValue_ = by;
        this.null_ = false;
        this.valueType_ = 7;
    }

    void setValue(boolean bl) {
        this.booleanValue_ = bl;
        this.null_ = false;
        this.valueType_ = 8;
    }

    void setValue(Date date) {
        this.dateValue_ = date;
        this.null_ = date == null;
        this.valueType_ = 9;
    }

    void setValue(Date date, Calendar calendar) {
        this.dateValue_ = date;
        this.null_ = date == null;
        this.valueType_ = 9;
        this.calendar_ = calendar;
    }

    void setValue(Time time) {
        this.dateValue_ = time;
        this.null_ = time == null;
        this.valueType_ = 10;
    }

    void setValue(Time time, Calendar calendar) {
        this.dateValue_ = time;
        this.null_ = time == null;
        this.valueType_ = 10;
        this.calendar_ = calendar;
    }

    void setValue(Timestamp timestamp) {
        this.dateValue_ = timestamp;
        this.null_ = timestamp == null;
        this.valueType_ = 11;
    }

    void setValue(Timestamp timestamp, Calendar calendar) {
        this.dateValue_ = timestamp;
        this.null_ = timestamp == null;
        this.valueType_ = 11;
        this.calendar_ = calendar;
    }

    void setValue(byte[] byArray) {
        this.byteArrayValue_ = byArray;
        this.null_ = byArray == null;
        this.valueType_ = 12;
    }

    void setValue(BigDecimal bigDecimal) {
        this.bigDecimalValue_ = bigDecimal;
        this.null_ = bigDecimal == null;
        this.valueType_ = 13;
    }

    void setValue(Object object) {
        if (object instanceof String) {
            this.setValue((String)object);
        } else if (object instanceof Date) {
            this.setValue((Date)object);
        } else if (object instanceof Time) {
            this.setValue((Time)object);
        } else if (object instanceof Timestamp) {
            this.setValue((Timestamp)object);
        } else if (object instanceof byte[]) {
            this.setValue((byte[])object);
        } else if (object instanceof BigDecimal) {
            this.setValue((BigDecimal)object);
        } else if (object instanceof URL) {
            this.setValue((URL)object);
        } else {
            this.objectValue_ = object;
            this.null_ = object == null;
            this.valueType_ = 14;
        }
    }

    void setValue(URL uRL) {
        this.urlValue_ = uRL;
        this.null_ = uRL == null;
        this.valueType_ = 15;
    }

    void setAsciiStreamValue(InputStream inputStream, int n) {
        this.inputStreamValue_ = inputStream;
        this.inputStreamLength_ = n;
        this.null_ = inputStream == null;
        this.valueType_ = 16;
    }

    void setBinaryStreamValue(InputStream inputStream, int n) {
        this.inputStreamValue_ = inputStream;
        this.inputStreamLength_ = n;
        this.null_ = inputStream == null;
        this.valueType_ = 17;
    }

    void setUnicodeStreamValue(InputStream inputStream, int n) {
        this.inputStreamValue_ = inputStream;
        this.inputStreamLength_ = n;
        this.null_ = inputStream == null;
        this.valueType_ = 18;
    }

    void setCharacterStreamValue(Reader reader, int n) {
        this.readerValue_ = reader;
        this.inputStreamLength_ = n;
        this.null_ = reader == null;
        this.valueType_ = 19;
    }

    private String getNonexponentValueString() throws SQLException {
        String string;
        switch (this.valueType_) {
            case 5: {
                string = String.valueOf(this.floatValue_);
                if (string.indexOf("E") <= 0) break;
                string = new BigDecimal(this.floatValue_).toPlainString();
                break;
            }
            case 6: {
                string = String.valueOf(this.doubleValue_);
                if (string.indexOf("E") <= 0) break;
                string = new BigDecimal(this.doubleValue_).toPlainString();
                break;
            }
            case 13: {
                string = this.bigDecimalValue_.toPlainString();
                break;
            }
            case 8: {
                string = this.booleanValue_ ? "1" : "0";
                break;
            }
            default: {
                return this.getValueString();
            }
        }
        return string;
    }

    private String getValueString() throws SQLException {
        String string;
        try {
            switch (this.valueType_) {
                case 1: {
                    string = this.stringValue_;
                    break;
                }
                case 2: {
                    string = String.valueOf(this.intValue_);
                    break;
                }
                case 4: {
                    string = String.valueOf(this.shortValue_);
                    break;
                }
                case 3: {
                    string = String.valueOf(this.longValue_);
                    break;
                }
                case 5: {
                    string = String.valueOf(this.floatValue_);
                    break;
                }
                case 6: {
                    string = String.valueOf(this.doubleValue_);
                    break;
                }
                case 7: {
                    string = String.valueOf(this.byteValue_);
                    break;
                }
                case 8: {
                    string = String.valueOf(this.booleanValue_);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    string = this.dateValue_.toString();
                    break;
                }
                case 12: {
                    string = Conv.bytesToHexString(this.byteArrayValue_, 0, this.byteArrayValue_.length);
                    break;
                }
                case 13: {
                    string = this.bigDecimalValue_.toString();
                    break;
                }
                case 14: {
                    string = this.objectValue_.toString();
                    break;
                }
                case 15: {
                    string = this.urlValue_.toString();
                    break;
                }
                case 16: 
                case 17: {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    for (int i = 0; n >= 0 && i < this.inputStreamLength_; ++i) {
                        n = this.inputStreamValue_.read();
                        if (n < 0) continue;
                        stringBuffer.append((char)n);
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 18: {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    for (int i = 0; n >= 0 && i < this.inputStreamLength_; ++i) {
                        n = this.inputStreamValue_.read();
                        if (n < 0) continue;
                        byte by = (byte)n;
                        n = this.inputStreamValue_.read();
                        if (n < 0) continue;
                        byte by2 = (byte)n;
                        char c = (char)(by << 8 | by2 & 0xFF);
                        stringBuffer.append(c);
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 19: {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    for (int i = 0; n >= 0 && i < this.inputStreamLength_; ++i) {
                        n = this.readerValue_.read();
                        if (n < 0) continue;
                        stringBuffer.append((char)n);
                    }
                    string = stringBuffer.toString();
                    break;
                }
                default: {
                    throw JDBCError.getSQLException("HY000", "Unrecognized valueType " + this.valueType_);
                }
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = JDBCError.getSQLException("07006", "Error reading from parameter stream: " + iOException.toString());
            sQLException.initCause(iOException);
            throw sQLException;
        }
        return string;
    }

    private String getValueTimeAsString() throws SQLException {
        String string = "UNSET";
        try {
            switch (this.valueType_) {
                case 0: {
                    if (this.parameter_) {
                        throw JDBCError.getSQLException("07001");
                    }
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 15: {
                    throw JDBCError.getSQLException("07006");
                }
                case 10: {
                    Time time = new Time(this.dateValue_.getTime());
                    string = time.toString();
                    break;
                }
                case 14: {
                    string = this.objectValue_.toString();
                    Time time = Time.valueOf(string);
                    string = time.toString();
                    break;
                }
                case 16: 
                case 17: {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    for (int i = 0; n >= 0 && i < this.inputStreamLength_; ++i) {
                        n = this.inputStreamValue_.read();
                        if (n < 0) continue;
                        stringBuffer.append((char)n);
                    }
                    string = stringBuffer.toString();
                    Time time = Time.valueOf(string);
                    string = time.toString();
                    break;
                }
                case 18: {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    for (int i = 0; n >= 0 && i < this.inputStreamLength_; ++i) {
                        n = this.inputStreamValue_.read();
                        if (n < 0) continue;
                        byte by = (byte)n;
                        n = this.inputStreamValue_.read();
                        if (n < 0) continue;
                        byte by2 = (byte)n;
                        char c = (char)(by << 8 | by2 & 0xFF);
                        stringBuffer.append(c);
                    }
                    string = stringBuffer.toString();
                    Time time = Time.valueOf(string);
                    string = time.toString();
                    break;
                }
                case 19: {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    for (int i = 0; n >= 0 && i < this.inputStreamLength_; ++i) {
                        n = this.readerValue_.read();
                        if (n < 0) continue;
                        stringBuffer.append((char)n);
                    }
                    string = stringBuffer.toString();
                    Time time = Time.valueOf(string);
                    string = time.toString();
                    break;
                }
                case 1: {
                    string = this.stringValue_;
                    Time time = Time.valueOf(string);
                    string = time.toString();
                }
                default: {
                    throw JDBCError.getSQLException("HY000", "Unrecognized valueType " + this.valueType_);
                }
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = JDBCError.getSQLException("07006", "Error reading from parameter stream: " + iOException.toString());
            sQLException.initCause(iOException);
            throw sQLException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(illegalArgumentException);
            throw sQLException;
        }
        return string;
    }

    private String getValueTimestampAsString() throws SQLException {
        String string = "NOT SET";
        try {
            switch (this.valueType_) {
                case 0: {
                    if (this.parameter_) {
                        throw JDBCError.getSQLException("07001");
                    }
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: {
                    throw JDBCError.getSQLException("07006", "Conversion of type " + this.valueType_ + " to timestamp not supported.");
                }
                case 9: {
                    string = this.dateValue_.toString() + " 00:00:00";
                    Comparable<StringBuffer> comparable = Timestamp.valueOf(string);
                    string = ((Timestamp)comparable).toString();
                    break;
                }
                case 11: {
                    string = this.dateValue_.toString();
                    break;
                }
                case 14: {
                    string = this.objectValue_.toString();
                    Comparable<StringBuffer> comparable = Timestamp.valueOf(string);
                    string = ((Timestamp)comparable).toString();
                    break;
                }
                case 16: 
                case 17: {
                    int n;
                    Comparable<StringBuffer> comparable = new StringBuffer();
                    int n2 = 0;
                    for (n = 0; n2 >= 0 && n < this.inputStreamLength_; ++n) {
                        n2 = this.inputStreamValue_.read();
                        if (n2 < 0) continue;
                        ((StringBuffer)comparable).append((char)n2);
                    }
                    string = ((StringBuffer)comparable).toString();
                    Timestamp timestamp = Timestamp.valueOf(string);
                    string = timestamp.toString();
                    break;
                }
                case 18: {
                    int n;
                    Comparable<StringBuffer> comparable = new StringBuffer();
                    int n2 = 0;
                    for (n = 0; n2 >= 0 && n < this.inputStreamLength_; ++n) {
                        n2 = this.inputStreamValue_.read();
                        if (n2 < 0) continue;
                        byte by = (byte)n2;
                        n2 = this.inputStreamValue_.read();
                        if (n2 < 0) continue;
                        byte by2 = (byte)n2;
                        char c = (char)(by << 8 | by2 & 0xFF);
                        ((StringBuffer)comparable).append(c);
                    }
                    string = ((StringBuffer)comparable).toString();
                    Timestamp timestamp = Timestamp.valueOf(string);
                    string = timestamp.toString();
                    break;
                }
                case 19: {
                    int n;
                    Comparable<StringBuffer> comparable = new StringBuffer();
                    int n2 = 0;
                    for (n = 0; n2 >= 0 && n < this.inputStreamLength_; ++n) {
                        n2 = this.readerValue_.read();
                        if (n2 < 0) continue;
                        ((StringBuffer)comparable).append((char)n2);
                    }
                    string = ((StringBuffer)comparable).toString();
                    Timestamp timestamp = Timestamp.valueOf(string);
                    string = timestamp.toString();
                    break;
                }
                case 1: {
                    string = this.isoTimestamp(this.stringValue_);
                    Timestamp timestamp = Timestamp.valueOf(string);
                    string = timestamp.toString();
                }
                default: {
                    throw JDBCError.getSQLException("HY000", "Unrecognized valueType " + this.valueType_);
                }
            }
            while (string.length() < 26) {
                string = string + "0";
            }
            string = string.substring(0, 10) + "-" + string.substring(11, 13) + "." + string.substring(14, 16) + "." + string.substring(17);
        }
        catch (IOException iOException) {
            SQLException sQLException = JDBCError.getSQLException("07006", "Error reading from parameter stream: " + iOException.toString());
            sQLException.initCause(iOException);
            throw sQLException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(illegalArgumentException);
            throw sQLException;
        }
        return string;
    }

    private String isoTimestamp(String string) throws SQLException {
        if (string.length() < 18) {
            JDBCError.throwSQLException("07006");
        }
        if (string.charAt(10) == '-' || string.charAt(13) == '.' || string.charAt(16) == '.') {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            if (n >= 11) {
                cArray[10] = 32;
            }
            if (n >= 14) {
                cArray[13] = 58;
            }
            if (n >= 17) {
                cArray[16] = 58;
            }
            return new String(cArray);
        }
        return string;
    }

    private float getValueFloat() throws SQLException {
        String string = null;
        try {
            float f = this.floatValue_;
            switch (this.valueType_) {
                case 0: {
                    if (this.parameter_) {
                        throw JDBCError.getSQLException("07001");
                    }
                }
                case 2: {
                    f = this.intValue_;
                    break;
                }
                case 4: {
                    f = this.shortValue_;
                    break;
                }
                case 3: {
                    f = this.longValue_;
                    break;
                }
                case 1: {
                    string = this.stringValue_;
                    f = Float.parseFloat(string);
                    break;
                }
                case 5: {
                    f = this.floatValue_;
                    break;
                }
                case 6: {
                    f = (float)this.doubleValue_;
                    break;
                }
                case 7: {
                    f = this.byteValue_;
                    break;
                }
                case 8: {
                    f = this.booleanValue_ ? 1.0f : 0.0f;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    throw JDBCError.getSQLException("07006", "Conversion of date/time/timestamp to float not supported.");
                }
                case 12: {
                    throw JDBCError.getSQLException("07006", "Conversion of byte array to float not supported.");
                }
                case 13: {
                    f = this.bigDecimalValue_.floatValue();
                    break;
                }
                case 14: {
                    string = this.objectValue_.toString();
                    f = Float.parseFloat(string);
                    break;
                }
                case 15: {
                    throw JDBCError.getSQLException("07006", "Conversion of URL to float not supported.");
                }
                case 16: {
                    throw JDBCError.getSQLException("07006", "Conversion of ASCII stream to float not supported.");
                }
                case 17: {
                    throw JDBCError.getSQLException("07006", "Conversion of binary stream to float not supported.");
                }
                case 18: {
                    throw JDBCError.getSQLException("07006", "Conversion of Unicode stream to float not supported.");
                }
                case 19: {
                    throw JDBCError.getSQLException("07006", "Conversion of character stream to float not supported.");
                }
                default: {
                    throw JDBCError.getSQLException("HY000", "Unrecognized valueType " + this.valueType_);
                }
            }
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(numberFormatException);
            throw sQLException;
        }
    }

    private double getValueDouble() throws SQLException {
        String string = null;
        try {
            double d = this.doubleValue_;
            switch (this.valueType_) {
                case 0: {
                    if (this.parameter_) {
                        throw JDBCError.getSQLException("07001");
                    }
                }
                case 2: {
                    d = this.intValue_;
                    break;
                }
                case 4: {
                    d = this.shortValue_;
                    break;
                }
                case 3: {
                    d = this.longValue_;
                    break;
                }
                case 1: {
                    string = this.stringValue_;
                    d = Double.parseDouble(this.stringValue_);
                    break;
                }
                case 5: {
                    d = this.floatValue_;
                    break;
                }
                case 6: {
                    d = this.doubleValue_;
                    break;
                }
                case 7: {
                    d = this.byteValue_;
                    break;
                }
                case 8: {
                    d = this.booleanValue_ ? 1.0 : 0.0;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    throw JDBCError.getSQLException("07006", "Conversion of date/time/timestamp to double not supported.");
                }
                case 12: {
                    throw JDBCError.getSQLException("07006", "Conversion of byte array to double not supported.");
                }
                case 13: {
                    d = this.bigDecimalValue_.doubleValue();
                    break;
                }
                case 14: {
                    string = this.objectValue_.toString();
                    d = Double.parseDouble(string);
                    break;
                }
                case 15: {
                    throw JDBCError.getSQLException("07006", "Conversion of URL to double not supported.");
                }
                case 16: {
                    throw JDBCError.getSQLException("07006", "Conversion of ASCII stream to double not supported.");
                }
                case 17: {
                    throw JDBCError.getSQLException("07006", "Conversion of binary stream to double not supported.");
                }
                case 18: {
                    throw JDBCError.getSQLException("07006", "Conversion of Unicode stream to double not supported.");
                }
                case 19: {
                    throw JDBCError.getSQLException("07006", "Conversion of character stream to double not supported.");
                }
                default: {
                    throw JDBCError.getSQLException("HY000", "Unrecognized valueType " + this.valueType_);
                }
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(numberFormatException);
            throw sQLException;
        }
    }

    private long getValueLong() throws SQLException {
        String string = null;
        try {
            long l;
            switch (this.valueType_) {
                case 0: {
                    if (this.parameter_) {
                        throw JDBCError.getSQLException("07001");
                    }
                }
                case 3: {
                    l = this.longValue_;
                    break;
                }
                case 2: {
                    l = this.intValue_;
                    break;
                }
                case 4: {
                    l = this.shortValue_;
                    break;
                }
                case 1: 
                case 14: {
                    string = this.valueType_ == 14 ? this.objectValue_.toString() : this.stringValue_;
                    double d = Double.parseDouble(string);
                    if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
                        throw JDBCError.getSQLException("07006");
                    }
                    if (d < 9.007199254740992E15 && d > -9.007199254740992E15) {
                        l = (long)d;
                        break;
                    }
                    try {
                        l = Long.parseLong(string);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        int n = string.indexOf(".");
                        if (n > 0) {
                            string = string.substring(0, n);
                            l = Long.parseLong(string);
                            break;
                        }
                        throw numberFormatException;
                    }
                }
                case 5: {
                    if (this.floatValue_ > 9.223372E18f || this.floatValue_ < -9.223372E18f) {
                        throw JDBCError.getSQLException("07006");
                    }
                    l = (long)this.floatValue_;
                    break;
                }
                case 6: {
                    if (this.doubleValue_ > 9.223372036854776E18 || this.doubleValue_ < -9.223372036854776E18) {
                        throw JDBCError.getSQLException("07006");
                    }
                    l = (long)this.doubleValue_;
                    break;
                }
                case 7: {
                    l = this.byteValue_;
                    break;
                }
                case 8: {
                    l = this.booleanValue_ ? 1L : 0L;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    throw JDBCError.getSQLException("07006");
                }
                case 12: {
                    throw JDBCError.getSQLException("07006", "Conversion of byte array to long not supported.");
                }
                case 13: {
                    double d = this.bigDecimalValue_.doubleValue();
                    if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
                        throw JDBCError.getSQLException("07006");
                    }
                    l = this.bigDecimalValue_.longValue();
                    break;
                }
                case 15: {
                    throw JDBCError.getSQLException("07006", "Conversion of URL to long not supported.");
                }
                case 16: {
                    throw JDBCError.getSQLException("07006", "Conversion of ASCII stream to long not supported.");
                }
                case 17: {
                    throw JDBCError.getSQLException("07006", "Conversion of binary stream to long not supported.");
                }
                case 18: {
                    throw JDBCError.getSQLException("07006", "Conversion of Unicode stream to long not supported.");
                }
                case 19: {
                    throw JDBCError.getSQLException("07006", "Conversion of character stream to long not supported.");
                }
                default: {
                    throw JDBCError.getSQLException("HY000", "Unrecognized valueType " + this.valueType_);
                }
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(numberFormatException);
            throw sQLException;
        }
    }

    private int getValueInt() throws SQLException {
        String string = null;
        try {
            int n;
            switch (this.valueType_) {
                case 0: {
                    if (this.parameter_) {
                        throw JDBCError.getSQLException("07001");
                    }
                }
                case 2: {
                    n = this.intValue_;
                    break;
                }
                case 3: {
                    if (this.longValue_ > Integer.MAX_VALUE || this.longValue_ < Integer.MIN_VALUE) {
                        throw JDBCError.getSQLException("07006");
                    }
                    n = (int)this.longValue_;
                    break;
                }
                case 4: {
                    n = this.shortValue_;
                    break;
                }
                case 1: {
                    double d = Double.parseDouble(this.stringValue_);
                    if (d > 2.147483647E9 || d < -2.147483648E9) {
                        throw JDBCError.getSQLException("07006");
                    }
                    n = (int)d;
                    break;
                }
                case 5: {
                    if (this.floatValue_ > 2.1474836E9f || this.floatValue_ < -2.1474836E9f) {
                        throw JDBCError.getSQLException("07006");
                    }
                    n = (int)this.floatValue_;
                    break;
                }
                case 6: {
                    if (this.doubleValue_ > 2.147483647E9 || this.doubleValue_ < -2.147483648E9) {
                        throw JDBCError.getSQLException("07006");
                    }
                    n = (int)this.doubleValue_;
                    break;
                }
                case 7: {
                    n = this.byteValue_;
                    break;
                }
                case 8: {
                    n = this.booleanValue_ ? 1 : 0;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    throw JDBCError.getSQLException("07006");
                }
                case 12: {
                    throw JDBCError.getSQLException("07006", "Conversion from byte array to integer not supported");
                }
                case 13: {
                    double d = this.bigDecimalValue_.doubleValue();
                    if (d > 2.147483647E9 || d < -2.147483648E9) {
                        throw JDBCError.getSQLException("07006");
                    }
                    n = (int)d;
                    break;
                }
                case 14: {
                    double d = Double.parseDouble(this.objectValue_.toString());
                    if (d > 2.147483647E9 || d < -2.147483648E9) {
                        throw JDBCError.getSQLException("07006");
                    }
                    n = (int)d;
                    break;
                }
                case 15: {
                    throw JDBCError.getSQLException("07006", "Conversion of URL to int not supported.");
                }
                case 16: {
                    throw JDBCError.getSQLException("07006", "Conversion of ASCII stream to int not supported.");
                }
                case 17: {
                    throw JDBCError.getSQLException("07006", "Conversion of binary stream to int not supported.");
                }
                case 18: {
                    throw JDBCError.getSQLException("07006", "Conversion of Unicode stream to int not supported.");
                }
                case 19: {
                    throw JDBCError.getSQLException("07006", "Conversion of character stream to int not supported.");
                }
                default: {
                    throw JDBCError.getSQLException("HY000", "Unrecognized valueType " + this.valueType_);
                }
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(numberFormatException);
            throw sQLException;
        }
    }

    private short getValueShort() throws SQLException {
        String string = null;
        try {
            short s;
            switch (this.valueType_) {
                case 0: {
                    if (this.parameter_) {
                        throw JDBCError.getSQLException("07001");
                    }
                }
                case 4: {
                    s = this.shortValue_;
                    break;
                }
                case 3: {
                    if (this.longValue_ > 32767L || this.longValue_ < -32768L) {
                        throw JDBCError.getSQLException("07006");
                    }
                    s = (short)this.longValue_;
                    break;
                }
                case 2: {
                    if (this.intValue_ > Short.MAX_VALUE || this.intValue_ < Short.MIN_VALUE) {
                        throw JDBCError.getSQLException("07006");
                    }
                    s = (short)this.intValue_;
                    break;
                }
                case 1: {
                    double d = Double.valueOf(this.stringValue_);
                    if (d > 32767.0 || d < -32768.0) {
                        throw JDBCError.getSQLException("07006");
                    }
                    s = (short)d;
                    break;
                }
                case 5: {
                    if (this.floatValue_ > 32767.0f || this.floatValue_ < -32768.0f) {
                        throw JDBCError.getSQLException("07006");
                    }
                    s = (short)this.floatValue_;
                    break;
                }
                case 6: {
                    if (this.doubleValue_ > 32767.0 || this.doubleValue_ < -32768.0) {
                        throw JDBCError.getSQLException("07006");
                    }
                    s = (short)this.doubleValue_;
                    break;
                }
                case 7: {
                    s = this.byteValue_;
                    break;
                }
                case 8: {
                    s = (short)(this.booleanValue_ ? 1 : 0);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    throw JDBCError.getSQLException("07006");
                }
                case 12: {
                    throw JDBCError.getSQLException("07006", "Conversion of byte array to short not supported.");
                }
                case 13: {
                    double d = this.bigDecimalValue_.doubleValue();
                    if (d > 32767.0 || d < -32768.0) {
                        throw JDBCError.getSQLException("07006");
                    }
                    s = (short)d;
                    break;
                }
                case 14: {
                    double d = Double.valueOf(this.objectValue_.toString());
                    if (d > 32767.0 || d < -32768.0) {
                        throw JDBCError.getSQLException("07006");
                    }
                    s = (short)d;
                    break;
                }
                case 15: {
                    throw JDBCError.getSQLException("07006", "Conversion of URL to short not supported.");
                }
                case 16: {
                    throw JDBCError.getSQLException("07006", "Conversion of ASCII stream to short not supported.");
                }
                case 17: {
                    throw JDBCError.getSQLException("07006", "Conversion of binary stream to short not supported.");
                }
                case 18: {
                    throw JDBCError.getSQLException("07006", "Conversion of Unicode stream to short not supported.");
                }
                case 19: {
                    throw JDBCError.getSQLException("07006", "Conversion of character stream to short not supported.");
                }
                default: {
                    throw JDBCError.getSQLException("HY000", "Unrecognized valueType " + this.valueType_);
                }
            }
            return s;
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(numberFormatException);
            throw sQLException;
        }
    }

    private byte[] getValueByteArray() throws SQLException {
        byte[] byArray = this.byteArrayValue_;
        switch (this.valueType_) {
            case 0: {
                if (this.parameter_) {
                    throw JDBCError.getSQLException("07001");
                }
            }
            case 12: {
                byArray = this.byteArrayValue_;
                break;
            }
            case 1: {
                throw JDBCError.getSQLException("07006", "Conversion of string to byte array not supported.");
            }
            case 3: {
                throw JDBCError.getSQLException("07006", "Conversion of long to byte array not supported.");
            }
            case 2: {
                throw JDBCError.getSQLException("07006", "Conversion of int to byte array not supported.");
            }
            case 4: {
                throw JDBCError.getSQLException("07006", "Conversion of short to byte array not supported.");
            }
            case 5: {
                throw JDBCError.getSQLException("07006", "Conversion of float to byte array not supported.");
            }
            case 6: {
                throw JDBCError.getSQLException("07006", "Conversion of doubleto byte array not supported.");
            }
            case 7: {
                throw JDBCError.getSQLException("07006", "Conversion of byte to byte array not supported.");
            }
            case 8: {
                throw JDBCError.getSQLException("07006", "Conversion of boolean to byte array not supported.");
            }
            case 9: {
                throw JDBCError.getSQLException("07006", "Conversion of date to byte array not supported.");
            }
            case 10: {
                throw JDBCError.getSQLException("07006", "Conversion of time to byte array not supported.");
            }
            case 11: {
                throw JDBCError.getSQLException("07006", "Conversion of timestamp to byte array not supported.");
            }
            case 13: {
                throw JDBCError.getSQLException("07006", "Conversion of BIGDECIMAL  to byte array not supported.");
            }
            case 14: {
                throw JDBCError.getSQLException("07006", "Conversion of OBJECT to byte array not supported.");
            }
            case 15: {
                throw JDBCError.getSQLException("07006", "Conversion of URL to byte array not supported.");
            }
            case 16: {
                throw JDBCError.getSQLException("07006", "Conversion of ASCII stream to byte array not supported.");
            }
            case 17: {
                throw JDBCError.getSQLException("07006", "Conversion of binary stream to byte array not supported.");
            }
            case 18: {
                throw JDBCError.getSQLException("07006", "Conversion of Unicode stream to byte array not supported.");
            }
            case 19: {
                throw JDBCError.getSQLException("07006", "Conversion of character stream to byte array not supported.");
            }
            default: {
                throw JDBCError.getSQLException("HY000", "Unrecognized valueType " + this.valueType_);
            }
        }
        return byArray;
    }

    boolean isNull() {
        return this.null_;
    }

    void setNull(boolean bl) {
        this.null_ = bl;
    }

    int getOffset() {
        return this.offset_;
    }

    void setOffset(int n) {
        this.offset_ = n;
    }

    String getName() {
        return this.name_;
    }

    void setName(String string) {
        this.name_ = string;
    }

    String getUdtName() {
        return this.udtName_;
    }

    public void setUdtName(String string) {
        this.udtName_ = string;
    }

    String getTable() {
        return this.table_;
    }

    void setTable(String string) {
        this.table_ = string;
    }

    String getSchema() {
        return this.schema_;
    }

    void setSchema(String string) {
        this.schema_ = string;
    }

    String getLabel() {
        return this.label_;
    }

    void setLabel(String string) {
        this.label_ = string;
    }

    boolean isAutoIncrement() {
        return this.autoIncrement_;
    }

    void setAutoIncrement(boolean bl) {
        this.autoIncrement_ = bl;
    }

    boolean isDefinitelyWritable() {
        return this.definitelyWritable_;
    }

    void setDefinitelyWritable(boolean bl) {
        this.definitelyWritable_ = bl;
    }

    boolean isReadOnly() {
        return this.readOnly_;
    }

    void setReadOnly(boolean bl) {
        this.readOnly_ = bl;
    }

    boolean isSearchable() {
        return this.searchable_;
    }

    void setSearchable(boolean bl) {
        this.searchable_ = bl;
    }

    boolean isWritable() {
        return this.writable_;
    }

    void setWritable(boolean bl) {
        this.writable_ = bl;
    }

    int getType() {
        return this.type_;
    }

    void setType(int n) {
        this.type_ = n;
    }

    int getSQLType() throws SQLException {
        switch (this.type_ & 0xFFFE) {
            case 384: {
                return 91;
            }
            case 388: {
                return 92;
            }
            case 392: {
                return 93;
            }
            case 396: {
                return 70;
            }
            case 404: {
                return 2004;
            }
            case 408: 
            case 412: {
                return 2005;
            }
            case 448: {
                return 12;
            }
            case 452: {
                return 1;
            }
            case 456: {
                return 12;
            }
            case 464: {
                return 12;
            }
            case 468: {
                return 1;
            }
            case 472: {
                return 12;
            }
            case 480: {
                if (this.length_ == 4) {
                    return 7;
                }
                return 8;
            }
            case 484: {
                return 3;
            }
            case 488: {
                return 2;
            }
            case 492: {
                return -5;
            }
            case 496: {
                return 4;
            }
            case 500: {
                return 5;
            }
            case 904: {
                return -3;
            }
            case 908: {
                return -3;
            }
            case 912: {
                return -2;
            }
            case 960: {
                return 2004;
            }
            case 964: 
            case 968: {
                return 2005;
            }
            case 988: 
            case 2452: {
                return 2005;
            }
            case 996: {
                return 1111;
            }
        }
        throw JDBCError.getSQLException("HY000", "Unknown database column type: " + this.type_);
    }

    String getSQLTypeName() throws SQLException {
        switch (this.type_ & 0xFFFE) {
            case 384: {
                return "DATE";
            }
            case 388: {
                return "TIME";
            }
            case 392: {
                return "TIMESTAMP";
            }
            case 396: {
                return "DATALINK";
            }
            case 404: {
                return "BLOB";
            }
            case 408: {
                return "CLOB";
            }
            case 412: {
                return "DBCLOB";
            }
            case 448: {
                if (this.isForBitData_) {
                    return "VARCHAR () FOR BIT DATA";
                }
                return "VARCHAR";
            }
            case 452: {
                if (this.isForBitData_) {
                    return "CHAR () FOR BIT DATA";
                }
                return "CHAR";
            }
            case 456: {
                return "VARCHAR";
            }
            case 464: {
                return "VARGRAPHIC";
            }
            case 468: {
                return "GRAPHIC";
            }
            case 472: {
                return "VARGRAPHIC";
            }
            case 480: {
                if (this.length_ == 4) {
                    return "REAL";
                }
                return "DOUBLE";
            }
            case 484: {
                return "DECIMAL";
            }
            case 488: {
                return "NUMERIC";
            }
            case 492: {
                return "BIGINT";
            }
            case 496: {
                return "INTEGER";
            }
            case 500: {
                return "SMALLINT";
            }
            case 904: {
                return "ROWID";
            }
            case 908: {
                if (this.isForBitData_) {
                    return "VARCHAR () FOR BIT DATA";
                }
                return "VARBINARY";
            }
            case 912: {
                if (this.isForBitData_) {
                    return "CHAR () FOR BIT DATA";
                }
                return "BINARY";
            }
            case 960: {
                return "BLOB LOCATOR";
            }
            case 964: {
                return "CLOB LOCATOR";
            }
            case 968: {
                return "DBCLOB";
            }
            case 988: {
                return "SQLXML";
            }
            case 2452: {
                return "XML";
            }
            case 996: {
                return "DECFLOAT";
            }
        }
        throw JDBCError.getSQLException("HY000", "Unknown database column type: " + this.type_);
    }

    int getLength() {
        return this.length_;
    }

    int getDeclaredLength() throws SQLException {
        if (this.declaredLength_ == 0) {
            switch (this.type_ & 0xFFFE) {
                case 396: 
                case 448: 
                case 456: 
                case 904: 
                case 908: {
                    this.declaredLength_ = this.length_ - 2;
                    break;
                }
                case 464: 
                case 472: {
                    this.declaredLength_ = (this.length_ - 2) / 2;
                    break;
                }
                case 404: 
                case 408: {
                    this.declaredLength_ = this.length_ - 4;
                    break;
                }
                case 412: {
                    this.declaredLength_ = (this.length_ - 4) / 2;
                    break;
                }
                case 468: {
                    this.declaredLength_ = this.length_ / 2;
                    break;
                }
                case 484: 
                case 488: {
                    this.declaredLength_ = this.precision_;
                    break;
                }
                case 960: 
                case 964: 
                case 968: 
                case 2452: {
                    this.declaredLength_ = this.lobMaxSize_;
                    break;
                }
                case 996: {
                    if (this.length_ == 8) {
                        this.declaredLength_ = 16;
                        break;
                    }
                    if (this.length_ == 16) {
                        this.declaredLength_ = 34;
                        break;
                    }
                    throw JDBCError.getSQLException("HY000", "Unknown DECFLOAT length= " + this.length_);
                }
                case 392: {
                    this.declaredLength_ = 26;
                    break;
                }
                case 388: {
                    this.declaredLength_ = 8;
                    break;
                }
                case 384: {
                    this.declaredLength_ = 10;
                    break;
                }
                default: {
                    this.declaredLength_ = this.length_;
                }
            }
        }
        return this.declaredLength_;
    }

    void setLength(int n) {
        this.length_ = n;
    }

    int getScale() {
        return this.scale_;
    }

    void setScale(int n) {
        this.scale_ = n;
    }

    int getPrecision() {
        return this.precision_;
    }

    void setPrecision(int n) {
        this.precision_ = n;
    }

    public void setLobMaxSize(int n) {
        this.lobMaxSize_ = n;
    }

    public int getLobMaxSize() {
        return this.lobMaxSize_;
    }

    int getCCSID() {
        return this.ccsid_;
    }

    void setCCSID(int n) {
        this.ccsid_ = n;
        if (this.ccsid_ == 65535) {
            switch (this.type_) {
                case 452: {
                    this.type_ = 912;
                    this.isForBitData_ = true;
                    break;
                }
                case 453: {
                    this.type_ = 913;
                    this.isForBitData_ = true;
                    break;
                }
                case 448: {
                    this.type_ = 908;
                    this.isForBitData_ = true;
                    break;
                }
                case 449: {
                    this.type_ = 909;
                    this.isForBitData_ = true;
                    break;
                }
                case 456: {
                    this.type_ = 908;
                    this.isForBitData_ = true;
                    break;
                }
                case 457: {
                    this.type_ = 909;
                    this.isForBitData_ = true;
                }
            }
        }
    }

    void setDateFormat(int n) {
        this.dateFormat_ = n;
    }

    void setTimeFormat(int n) {
        this.timeFormat_ = n;
    }

    void setDateSeparator(int n) {
        this.dateSeparator_ = n;
    }

    void setTimeSeparator(int n) {
        this.timeSeparator_ = n;
    }

    void setUseDateCache(boolean bl) {
        this.useDateCache_ = bl;
        this.dateCache_ = bl ? new HashMap() : null;
    }

    void setUseTimeCache(boolean bl) {
        this.useTimeCache_ = bl;
        this.timeCache_ = bl ? new HashMap() : null;
    }

    void setUseStringCache(boolean bl) {
        this.useStringCache_ = bl;
        this.cache_ = bl ? new HashMap() : null;
    }

    void setCacheLastOnly(boolean bl) {
        this.cacheLastOnly_ = bl;
    }

    private String lookupString(byte[] byArray, int n, int n2) {
        this.key_.setHashData(byArray, n, n2);
        return (String)this.cache_.get(this.key_);
    }

    private Date lookupDate(byte[] byArray, int n, int n2) {
        this.key_.setHashData(byArray, n, n2);
        return (Date)this.dateCache_.get(this.key_);
    }

    private Time lookupTime(byte[] byArray, int n, int n2) {
        this.key_.setHashData(byArray, n, n2);
        return (Time)this.timeCache_.get(this.key_);
    }

    private void cache(byte[] byArray, int n, int n2, String string) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        if (this.cacheLastOnly_) {
            this.cache_.clear();
        }
        this.cache_.put(new ByteArrayKey(byArray2), string);
    }

    private void cache(byte[] byArray, int n, int n2, Date date) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.dateCache_.clear();
        this.dateCache_.put(new ByteArrayKey(byArray2), date);
    }

    private void cache(byte[] byArray, int n, int n2, Time time) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.timeCache_.clear();
        this.timeCache_.put(new ByteArrayKey(byArray2), time);
    }

    private int convertString(String string, byte[] byArray, int n) throws SQLException {
        int n2;
        int n3 = 0;
        boolean bl = false;
        int n4 = string.length();
        if (n4 > (n2 = this.getDeclaredLength())) {
            bl = true;
            n4 = n2;
        }
        switch (this.ccsid_) {
            case 1200: 
            case 13488: {
                n3 = Conv.stringToUnicodeByteArray(string, n4, byArray, n);
                break;
            }
            case 65535: {
                n3 = Conv.stringToEBCDICByteArray37(string, n4, byArray, n);
                break;
            }
            case 1208: {
                n3 = Conv.stringToUtf8ByteArray(string, n4, byArray, n);
                break;
            }
            default: {
                try {
                    n3 = Conv.stringToEBCDICByteArray(string, n4, byArray, n, this.ccsid_);
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    SQLException sQLException = JDBCError.getSQLException("22524");
                    sQLException.initCause(unsupportedEncodingException);
                    throw sQLException;
                }
            }
        }
        if (bl) {
            throw new DataTruncation(this.index_, this.parameter_, false, string.length(), n4);
        }
        return n3;
    }

    void convertToBytes(byte[] byArray, int n) throws SQLException {
        int n2;
        int n3;
        boolean bl;
        block35: {
            bl = false;
            n3 = 0;
            n2 = 0;
            try {
                if (this.valueType_ == 0 && this.parameter_) {
                    throw JDBCError.getSQLException("07001");
                }
                if (this.null_) break block35;
                int n4 = 0;
                String string = this.stringValue_;
                float f = this.floatValue_;
                double d = this.doubleValue_;
                long l = this.longValue_;
                int n5 = this.intValue_;
                short s = this.shortValue_;
                byte[] byArray2 = this.byteArrayValue_;
                switch (this.type_ & 0xFFFE) {
                    case 384: {
                        switch (this.dateFormat_) {
                            default: 
                        }
                        string = this.getValueString();
                        this.convertString(string, byArray, n);
                        break;
                    }
                    case 388: {
                        string = this.getValueTimeAsString();
                        this.convertString(string, byArray, n);
                        break;
                    }
                    case 392: {
                        string = this.getValueTimestampAsString();
                        this.convertString(string, byArray, n);
                        break;
                    }
                    case 396: {
                        string = this.getValueString();
                        n4 = this.convertString(string, byArray, n + 2);
                        Conv.shortToByteArray(n4, byArray, n);
                        break;
                    }
                    case 404: 
                    case 408: 
                    case 412: {
                        throw JDBCError.getSQLException("HY000", "Lob  not implemented yet");
                    }
                    case 448: 
                    case 456: {
                        string = this.getValueString();
                        n4 = this.convertString(string, byArray, n + 2);
                        Conv.shortToByteArray(n4, byArray, n);
                        break;
                    }
                    case 452: {
                        string = this.getValueString();
                        while (string.length() < this.length_) {
                            string = string + " ";
                        }
                        this.convertString(string, byArray, n);
                        break;
                    }
                    case 464: 
                    case 472: {
                        string = this.getValueString();
                        n4 = Conv.stringToUnicodeByteArray(string, byArray, n + 2);
                        Conv.shortToByteArray(n4 / 2, byArray, n);
                        break;
                    }
                    case 468: {
                        string = this.getValueString();
                        Conv.stringToUnicodeByteArray(string, byArray, n, this.length_);
                        break;
                    }
                    case 480: {
                        if (this.length_ == 4) {
                            f = this.getValueFloat();
                            Conv.floatToByteArray(f, byArray, n);
                            break;
                        }
                        if (this.length_ == 8) {
                            d = this.getValueDouble();
                            Conv.doubleToByteArray(d, byArray, n);
                            break;
                        }
                        throw JDBCError.getSQLException("HY000", "Unknown database type: " + this.type_ + " length= " + this.length_);
                    }
                    case 484: {
                        string = this.getNonexponentValueString();
                        string = this.formatDecimal(string, this.precision_, this.scale_);
                        Conv.stringToPackedDecimal(string, this.precision_, byArray, n);
                        break;
                    }
                    case 488: {
                        string = this.getNonexponentValueString();
                        string = this.formatDecimal(string, this.precision_, this.scale_);
                        Conv.stringToZonedDecimal(string, this.precision_, byArray, n);
                        break;
                    }
                    case 492: {
                        l = this.getValueLong();
                        Conv.longToByteArray(l, byArray, n);
                        break;
                    }
                    case 496: {
                        n5 = this.getValueInt();
                        Conv.intToByteArray(n5, byArray, n);
                        break;
                    }
                    case 500: {
                        s = this.getValueShort();
                        Conv.shortToByteArray(s, byArray, n);
                        break;
                    }
                    case 904: 
                    case 908: {
                        byArray2 = this.getValueByteArray();
                        n3 = byArray2.length;
                        if (n3 + 2 > this.length_) {
                            bl = true;
                            n2 = n3;
                            n3 = this.length_ - 2;
                        }
                        for (int i = 0; i < n3; ++i) {
                            byArray[n + 2 + i] = byArray2[i];
                        }
                        Conv.shortToByteArray(byArray2.length, byArray, n);
                        break;
                    }
                    case 912: {
                        byArray2 = this.getValueByteArray();
                        n3 = byArray2.length;
                        if (n3 > this.length_) {
                            n2 = n3;
                            bl = true;
                            n3 = this.length_;
                        }
                        for (int i = 0; i < n3; ++i) {
                            byArray[n + i] = byArray2[i];
                        }
                        break;
                    }
                    case 960: 
                    case 964: 
                    case 968: 
                    case 2452: {
                        throw JDBCError.getSQLException("HY000", "LOB locator not implemented yet");
                    }
                    case 988: {
                        throw JDBCError.getSQLException("HY000", "XML not implemented yet");
                    }
                    case 996: {
                        throw JDBCError.getSQLException("HY000", "DECFLOAT not implemented yet");
                    }
                    default: {
                        throw JDBCError.getSQLException("HY000", "Unknown database type: " + this.type_);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                SQLException sQLException = JDBCError.getSQLException("07006");
                sQLException.initCause(numberFormatException);
                throw sQLException;
            }
        }
        if (bl) {
            throw new DataTruncation(this.index_, this.parameter_, false, n2, n3);
        }
    }

    byte convertToByte(byte[] byArray, int n) throws SQLException {
        String string = null;
        try {
            int n2 = n + this.offset_;
            switch (this.type_ & 0xFFFE) {
                case 492: {
                    long l = this.convertToLong(byArray, n);
                    if (l > 127L || l < -128L) {
                        throw JDBCError.getSQLException("07006");
                    }
                    return (byte)l;
                }
                case 496: {
                    int n3 = this.convertToInt(byArray, n);
                    if (n3 > 127 || n3 < -128) {
                        throw JDBCError.getSQLException("07006");
                    }
                    return (byte)n3;
                }
                case 500: {
                    short s = this.convertToShort(byArray, n);
                    if (s > 127 || s < -128) {
                        throw JDBCError.getSQLException("07006");
                    }
                    return (byte)s;
                }
                case 480: {
                    if (this.length_ == 4) {
                        float f = Conv.byteArrayToFloat(byArray, n2);
                        if (f > 127.0f || f < -128.0f) {
                            throw JDBCError.getSQLException("07006");
                        }
                        return (byte)f;
                    }
                    if (this.length_ == 8) {
                        double d = Conv.byteArrayToDouble(byArray, n2);
                        if (d > 127.0 || d < -128.0) {
                            throw JDBCError.getSQLException("07006");
                        }
                        return (byte)d;
                    }
                }
                case 908: {
                    short s = Conv.byteArrayToShort(byArray, n2);
                    if (s == 1) {
                        return byArray[n2 + 2];
                    }
                    throw JDBCError.getSQLException("07006");
                }
                case 912: {
                    if (this.length_ == 1) {
                        return byArray[n2];
                    }
                    throw JDBCError.getSQLException("07006");
                }
            }
            string = this.convertToString(byArray, n);
            Double d = new Double(string);
            double d2 = d;
            if (d2 > 127.0 || d2 < -128.0) {
                throw JDBCError.getSQLException("07006");
            }
            return d.byteValue();
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(numberFormatException);
            throw sQLException;
        }
    }

    double convertToDouble(byte[] byArray, int n) throws SQLException {
        String string = null;
        try {
            int n2 = n + this.offset_;
            switch (this.type_ & 0xFFFE) {
                case 484: {
                    return Conv.packedDecimalToDouble(byArray, n2, this.precision_, this.scale_);
                }
                case 488: {
                    return Conv.zonedDecimalToDouble(byArray, n2, this.precision_, this.scale_);
                }
                case 492: {
                    return Conv.byteArrayToLong(byArray, n2);
                }
                case 496: {
                    return Conv.byteArrayToInt(byArray, n2);
                }
                case 500: {
                    return Conv.byteArrayToShort(byArray, n2);
                }
                case 480: {
                    if (this.length_ == 4) {
                        return Conv.byteArrayToFloat(byArray, n2);
                    }
                    if (this.length_ == 8) {
                        return Conv.byteArrayToDouble(byArray, n2);
                    }
                }
                case 908: 
                case 912: {
                    throw JDBCError.getSQLException("07006");
                }
            }
            string = this.convertToString(byArray, n);
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(numberFormatException);
            throw sQLException;
        }
    }

    float convertToFloat(byte[] byArray, int n) throws SQLException {
        String string = null;
        try {
            int n2 = n + this.offset_;
            switch (this.type_ & 0xFFFE) {
                case 484: {
                    return (float)Conv.packedDecimalToDouble(byArray, n2, this.precision_, this.scale_);
                }
                case 488: {
                    return (float)Conv.zonedDecimalToDouble(byArray, n2, this.precision_, this.scale_);
                }
                case 492: {
                    return Conv.byteArrayToLong(byArray, n2);
                }
                case 496: {
                    return Conv.byteArrayToInt(byArray, n2);
                }
                case 500: {
                    return Conv.byteArrayToShort(byArray, n2);
                }
                case 908: 
                case 912: {
                    throw JDBCError.getSQLException("07006");
                }
                case 480: {
                    if (this.length_ == 4) {
                        return Conv.byteArrayToFloat(byArray, n2);
                    }
                    if (this.length_ != 8) break;
                    double d = Conv.byteArrayToDouble(byArray, n2);
                    if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY || Double.isNaN(d)) {
                        return (float)d;
                    }
                    if (d > 3.4028234663852886E38 || d < -3.4028234663852886E38) {
                        throw JDBCError.getSQLException("07006", string);
                    }
                    return (float)d;
                }
            }
            string = this.convertToString(byArray, n).trim();
            Double d = new Double(string);
            double d2 = d;
            if (d2 == Double.NEGATIVE_INFINITY || d2 == Double.POSITIVE_INFINITY || Double.isNaN(d2)) {
                return (float)d2;
            }
            if (d2 > 3.4028234663852886E38 || d2 < -3.4028234663852886E38) {
                throw JDBCError.getSQLException("07006", string);
            }
            return d.floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(numberFormatException);
            throw sQLException;
        }
    }

    short convertToShort(byte[] byArray, int n) throws SQLException {
        String string = null;
        try {
            int n2 = n + this.offset_;
            switch (this.type_ & 0xFFFE) {
                case 480: {
                    if (this.length_ == 4) {
                        float f = Conv.byteArrayToFloat(byArray, n2);
                        if (f > 32767.0f || f < -32768.0f) {
                            throw JDBCError.getSQLException("07006");
                        }
                        return (short)f;
                    }
                    if (this.length_ == 8) {
                        double d = Conv.byteArrayToDouble(byArray, n2);
                        if (d > 32767.0 || d < -32768.0) {
                            throw JDBCError.getSQLException("07006");
                        }
                        return (short)d;
                    }
                }
                case 484: {
                    double d = Conv.packedDecimalToDouble(byArray, n2, this.precision_, this.scale_);
                    if (d > 32767.0 || d < -32768.0) {
                        throw JDBCError.getSQLException("07006");
                    }
                    return (short)d;
                }
                case 488: {
                    double d = Conv.zonedDecimalToDouble(byArray, n2, this.precision_, this.scale_);
                    if (d > 32767.0 || d < -32768.0) {
                        throw JDBCError.getSQLException("07006");
                    }
                    return (short)d;
                }
                case 492: {
                    long l = Conv.byteArrayToLong(byArray, n2);
                    if (l > 32767L || l < -32768L) {
                        throw JDBCError.getSQLException("07006");
                    }
                    return (short)l;
                }
                case 496: {
                    int n3 = Conv.byteArrayToInt(byArray, n2);
                    if (n3 > Short.MAX_VALUE || n3 < Short.MIN_VALUE) {
                        throw JDBCError.getSQLException("07006");
                    }
                    return (short)n3;
                }
                case 500: {
                    return Conv.byteArrayToShort(byArray, n2);
                }
                case 908: {
                    short s = Conv.byteArrayToShort(byArray, n2);
                    if (s > 2) {
                        throw JDBCError.getSQLException("07006");
                    }
                    switch (s) {
                        case 0: {
                            return 0;
                        }
                        case 1: {
                            return (short)(byArray[n2 + 2] & 0xFF);
                        }
                        case 2: {
                            return Conv.byteArrayToShort(byArray, n2 + 2);
                        }
                    }
                    throw JDBCError.getSQLException("07006");
                }
                case 912: {
                    int n4 = this.length_;
                    if (n4 > 2) {
                        throw JDBCError.getSQLException("07006");
                    }
                    switch (n4) {
                        case 0: {
                            return 0;
                        }
                        case 1: {
                            return (short)(byArray[n2] & 0xFF);
                        }
                        case 2: {
                            return Conv.byteArrayToShort(byArray, n2);
                        }
                    }
                    throw JDBCError.getSQLException("07006");
                }
            }
            string = this.convertToString(byArray, n);
            Double d = new Double(string.trim());
            double d2 = d;
            if (d2 > 32767.0 || d2 < -32768.0) {
                SQLException sQLException = JDBCError.getSQLException("07006", string);
                throw sQLException;
            }
            return d.shortValue();
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(numberFormatException);
            throw sQLException;
        }
    }

    int convertToInt(byte[] byArray, int n) throws SQLException {
        String string = null;
        try {
            int n2 = n + this.offset_;
            switch (this.type_ & 0xFFFE) {
                case 484: {
                    double d = Conv.packedDecimalToDouble(byArray, n2, this.precision_, this.scale_);
                    if (d > 2.147483647E9 || d < -2.147483648E9) {
                        throw JDBCError.getSQLException("07006");
                    }
                    return (int)d;
                }
                case 488: {
                    double d = Conv.zonedDecimalToDouble(byArray, n2, this.precision_, this.scale_);
                    if (d > 2.147483647E9 || d < -2.147483648E9) {
                        throw JDBCError.getSQLException("07006");
                    }
                    return (int)d;
                }
                case 492: {
                    long l = Conv.byteArrayToLong(byArray, n2);
                    if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                        throw JDBCError.getSQLException("07006");
                    }
                    return (int)l;
                }
                case 496: {
                    return Conv.byteArrayToInt(byArray, n2);
                }
                case 500: {
                    return Conv.byteArrayToShort(byArray, n2);
                }
                case 908: {
                    short s = Conv.byteArrayToShort(byArray, n2);
                    switch (s) {
                        case 0: {
                            return 0;
                        }
                        case 1: {
                            return byArray[n2 + 2] & 0xFF;
                        }
                        case 2: {
                            return Conv.byteArrayToShort(byArray, n2 + 2);
                        }
                        case 3: {
                            return (byArray[n2 + 2] << 16 | Conv.byteArrayToShort(byArray, n2 + 3)) & 0xFFFFFF;
                        }
                        case 4: {
                            return Conv.byteArrayToInt(byArray, n2 + 2);
                        }
                    }
                    throw JDBCError.getSQLException("07006");
                }
                case 912: {
                    int n3 = this.length_;
                    switch (n3) {
                        case 0: {
                            return 0;
                        }
                        case 1: {
                            return byArray[n2] & 0xFF;
                        }
                        case 2: {
                            return Conv.byteArrayToShort(byArray, n2);
                        }
                        case 3: {
                            return (byArray[n2] << 16 | Conv.byteArrayToShort(byArray, n2 + 1)) & 0xFFFFFF;
                        }
                        case 4: {
                            return Conv.byteArrayToInt(byArray, n2 + 2);
                        }
                    }
                    throw JDBCError.getSQLException("07006");
                }
            }
            string = this.convertToString(byArray, n);
            Double d = new Double(string.trim());
            double d2 = d;
            if (d2 > 2.147483647E9 || d2 < -2.147483648E9) {
                SQLException sQLException = JDBCError.getSQLException("07006", string);
                throw sQLException;
            }
            return d.intValue();
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(numberFormatException);
            throw sQLException;
        }
    }

    long convertToLong(byte[] byArray, int n) throws SQLException {
        String string = "";
        try {
            int n2 = n + this.offset_;
            switch (this.type_ & 0xFFFE) {
                case 384: {
                    throw JDBCError.getSQLException("07006");
                }
                case 388: {
                    throw JDBCError.getSQLException("07006");
                }
                case 392: {
                    throw JDBCError.getSQLException("07006");
                }
                case 484: {
                    return (long)Conv.packedDecimalToDouble(byArray, n2, this.precision_, this.scale_);
                }
                case 488: {
                    return (long)Conv.zonedDecimalToDouble(byArray, n2, this.precision_, this.scale_);
                }
                case 492: {
                    return Conv.byteArrayToLong(byArray, n2);
                }
                case 496: {
                    return Conv.byteArrayToInt(byArray, n2);
                }
                case 500: {
                    return Conv.byteArrayToShort(byArray, n2);
                }
                case 908: {
                    short s = Conv.byteArrayToShort(byArray, n2);
                    if (s > 8) {
                        throw JDBCError.getSQLException("07006");
                    }
                    switch (s) {
                        case 0: {
                            return 0L;
                        }
                        case 1: {
                            return byArray[n2 + 2] & 0xFF;
                        }
                        case 2: {
                            return Conv.byteArrayToShort(byArray, n2 + 2);
                        }
                        case 3: {
                            return (byArray[n2 + 2] << 16 | Conv.byteArrayToShort(byArray, n2 + 3)) & 0xFFFFFF;
                        }
                        case 4: {
                            return Conv.byteArrayToInt(byArray, n2 + 2);
                        }
                        case 5: {
                            return (((long)byArray[n2 + 2] & 0xFFFFFFFFFFFFFFFFL) << 32 | (long)Conv.byteArrayToInt(byArray, n2 + 3)) & 0xFFFFFFFFFFL;
                        }
                        case 6: {
                            return (((long)byArray[n2 + 2] & 0xFFFFFFFFFFFFFFFFL) << 40) + (((long)byArray[n2 + 3] & 0xFFFFFFFFFFFFFFFFL) << 32) + (long)Conv.byteArrayToInt(byArray, n2 + 4) & 0xFFFFFFFFFFFFL;
                        }
                        case 7: {
                            return (((long)byArray[n2 + 2] & 0xFFFFFFFFFFFFFFFFL) << 48) + (((long)byArray[n2 + 3] & 0xFFFFFFFFFFFFFFFFL) << 40) + (((long)byArray[n2 + 4] & 0xFFFFFFFFFFFFFFFFL) << 32) + (long)Conv.byteArrayToInt(byArray, n2 + 5) & 0xFFFFFFFFFFFFFFL;
                        }
                        case 8: {
                            return Conv.byteArrayToLong(byArray, n2 + 2);
                        }
                    }
                    return 0L;
                }
                case 912: {
                    int n3 = this.length_;
                    if (n3 > 8) {
                        throw JDBCError.getSQLException("07006");
                    }
                    switch (n3) {
                        case 0: {
                            return 0L;
                        }
                        case 1: {
                            return byArray[n2] & 0xFF;
                        }
                        case 2: {
                            return Conv.byteArrayToShort(byArray, n2);
                        }
                        case 3: {
                            return (byArray[n2] << 16 | Conv.byteArrayToShort(byArray, n2 + 1)) & 0xFFFFFF;
                        }
                        case 4: {
                            return Conv.byteArrayToInt(byArray, n2 + 2);
                        }
                        case 5: {
                            return (((long)byArray[n2] & 0xFFFFFFFFFFFFFFFFL) << 32 | (long)Conv.byteArrayToInt(byArray, n2 + 1)) & 0xFFFFFFFFFFL;
                        }
                        case 6: {
                            return (((long)byArray[n2] & 0xFFFFFFFFFFFFFFFFL) << 40) + (((long)byArray[n2 + 1] & 0xFFFFFFFFFFFFFFFFL) << 32) + (long)Conv.byteArrayToInt(byArray, n2 + 2) & 0xFFFFFFFFFFFFL;
                        }
                        case 7: {
                            return (((long)byArray[n2] & 0xFFFFFFFFFFFFFFFFL) << 48) + (((long)byArray[n2 + 1] & 0xFFFFFFFFFFFFFFFFL) << 40) + (((long)byArray[n2 + 2] & 0xFFFFFFFFFFFFFFFFL) << 32) + (long)Conv.byteArrayToInt(byArray, n2 + 3) & 0xFFFFFFFFFFFFFFL;
                        }
                        case 8: {
                            return Conv.byteArrayToLong(byArray, n2 + 2);
                        }
                    }
                    return 0L;
                }
            }
            string = this.convertToString(byArray, n);
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double d = new Double(string.trim());
                double d2 = d;
                if (d2 > 9.223372036854776E18 || d2 < -9.223372036854776E18) {
                    SQLException sQLException = JDBCError.getSQLException("07006", string);
                    sQLException.initCause(numberFormatException);
                    throw sQLException;
                }
                return d.longValue();
            }
            catch (NumberFormatException numberFormatException2) {
                SQLException sQLException = JDBCError.getSQLException("07006", string);
                sQLException.initCause(numberFormatException2);
                throw sQLException;
            }
        }
    }

    Date convertToDate(byte[] byArray, int n, Calendar calendar) throws SQLException {
        String string = null;
        try {
            int n2;
            if (this.buffer_ == null) {
                n2 = this.length_ + 2;
                if (this.precision_ + 2 > n2) {
                    n2 = this.precision_ + 2;
                }
                this.buffer_ = new char[n2];
            }
            n2 = n + this.offset_;
            switch (this.type_ & 0xFFFE) {
                case 384: 
                case 392: {
                    Date date;
                    if (this.useDateCache_ && (date = this.lookupDate(byArray, n2, this.length_)) != null) {
                        return date;
                    }
                    int n3 = (byArray[n2] & 0xF) * 1000 + (byArray[n2 + 1] & 0xF) * 100 + (byArray[n2 + 2] & 0xF) * 10 + (byArray[n2 + 3] & 0xF);
                    int n4 = (byArray[n2 + 5] & 0xF) * 10 + (byArray[n2 + 6] & 0xF);
                    int n5 = (byArray[n2 + 8] & 0xF) * 10 + (byArray[n2 + 9] & 0xF);
                    calendar.clear();
                    calendar.set(1, n3);
                    calendar.set(2, n4 - 1);
                    calendar.set(5, n5);
                    Date date2 = new Date(calendar.getTimeInMillis());
                    if (this.useDateCache_) {
                        this.cache(byArray, n2, this.length_, date2);
                    }
                    return date2;
                }
                case 388: 
                case 492: 
                case 496: 
                case 500: 
                case 908: 
                case 912: {
                    throw JDBCError.getSQLException("07006");
                }
            }
            string = this.convertToString(byArray, n).trim();
            return Date.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(illegalArgumentException);
            throw sQLException;
        }
    }

    Time convertToTime(byte[] byArray, int n, Calendar calendar) throws SQLException {
        String string = null;
        try {
            int n2;
            if (this.buffer_ == null) {
                n2 = this.length_ + 2;
                if (this.precision_ + 2 > n2) {
                    n2 = this.precision_ + 2;
                }
                this.buffer_ = new char[n2];
            }
            n2 = n + this.offset_;
            switch (this.type_ & 0xFFFE) {
                case 388: {
                    Time time;
                    switch (this.timeFormat_) {
                        default: 
                    }
                    if (this.useTimeCache_ && (time = this.lookupTime(byArray, n2, this.length_)) != null) {
                        return time;
                    }
                    int n3 = (byArray[n2] & 0xF) * 10 + (byArray[n2 + 1] & 0xF);
                    int n4 = (byArray[n2 + 3] & 0xF) * 10 + (byArray[n2 + 4] & 0xF);
                    int n5 = (byArray[n2 + 6] & 0xF) * 10 + (byArray[n2 + 7] & 0xF);
                    calendar.clear();
                    calendar.set(11, n3);
                    calendar.set(12, n4);
                    calendar.set(13, n5);
                    long l = calendar.getTimeInMillis();
                    Time time2 = new Time(l);
                    if (this.useTimeCache_) {
                        this.cache(byArray, n2, this.length_, time2);
                    }
                    return time2;
                }
                case 392: {
                    Time time;
                    if (this.useTimeCache_ && (time = this.lookupTime(byArray, n2, this.length_)) != null) {
                        return time;
                    }
                    int n6 = (byArray[n2 + 11] & 0xF) * 10 + (byArray[n2 + 12] & 0xF);
                    int n7 = (byArray[n2 + 14] & 0xF) * 10 + (byArray[n2 + 15] & 0xF);
                    int n8 = (byArray[n2 + 17] & 0xF) * 10 + (byArray[n2 + 18] & 0xF);
                    calendar.clear();
                    calendar.set(11, n6);
                    calendar.set(12, n7);
                    calendar.set(13, n8);
                    long l = calendar.getTimeInMillis();
                    Time time3 = new Time(l);
                    if (this.useTimeCache_) {
                        this.cache(byArray, n2, this.length_, time3);
                    }
                    return time3;
                }
                case 384: 
                case 492: 
                case 496: 
                case 500: 
                case 908: 
                case 912: {
                    JDBCError.throwSQLException("07006");
                    return null;
                }
            }
            string = this.convertToString(byArray, n).trim();
            return Time.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(illegalArgumentException);
            throw sQLException;
        }
    }

    Timestamp convertToTimestamp(byte[] byArray, int n, Calendar calendar) throws SQLException {
        String string = null;
        try {
            int n2;
            if (this.buffer_ == null) {
                n2 = this.length_ + 2;
                if (this.precision_ + 2 > n2) {
                    n2 = this.precision_ + 2;
                }
                this.buffer_ = new char[n2];
            }
            n2 = n + this.offset_;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            switch (this.type_ & 0xFFFE) {
                case 384: {
                    n3 = (byArray[n2] & 0xF) * 1000 + (byArray[n2 + 1] & 0xF) * 100 + (byArray[n2 + 2] & 0xF) * 10 + (byArray[n2 + 3] & 0xF);
                    n4 = (byArray[n2 + 5] & 0xF) * 10 + (byArray[n2 + 6] & 0xF);
                    n5 = (byArray[n2 + 8] & 0xF) * 10 + (byArray[n2 + 9] & 0xF);
                    calendar.clear();
                    calendar.set(1, n3);
                    calendar.set(2, n4 - 1);
                    calendar.set(5, n5);
                    return new Timestamp(calendar.getTimeInMillis());
                }
                case 392: {
                    n3 = (byArray[n2] & 0xF) * 1000 + (byArray[n2 + 1] & 0xF) * 100 + (byArray[n2 + 2] & 0xF) * 10 + (byArray[n2 + 3] & 0xF);
                    n4 = (byArray[n2 + 5] & 0xF) * 10 + (byArray[n2 + 6] & 0xF);
                    n5 = (byArray[n2 + 8] & 0xF) * 10 + (byArray[n2 + 9] & 0xF);
                    calendar.clear();
                    calendar.set(1, n3);
                    calendar.set(2, n4 - 1);
                    calendar.set(5, n5);
                    n6 = (byArray[n2 + 11] & 0xF) * 10 + (byArray[n2 + 12] & 0xF);
                    n7 = (byArray[n2 + 14] & 0xF) * 10 + (byArray[n2 + 15] & 0xF);
                    n8 = (byArray[n2 + 17] & 0xF) * 10 + (byArray[n2 + 18] & 0xF);
                    calendar.set(11, n6);
                    calendar.set(12, n7);
                    calendar.set(13, n8);
                    Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                    int n9 = (byArray[n2 + 20] & 0xF) * 100000 + (byArray[n2 + 21] & 0xF) * 10000 + (byArray[n2 + 22] & 0xF) * 1000 + (byArray[n2 + 23] & 0xF) * 100 + (byArray[n2 + 24] & 0xF) * 10 + (byArray[n2 + 25] & 0xF);
                    int n10 = n9 * 1000;
                    timestamp.setNanos(n10);
                    return timestamp;
                }
                case 388: 
                case 492: 
                case 496: 
                case 500: 
                case 908: 
                case 912: {
                    JDBCError.throwSQLException("07006");
                    return null;
                }
            }
            string = this.convertToString(byArray, n).trim();
            return Timestamp.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SQLException sQLException = JDBCError.getSQLException("07006", string);
            sQLException.initCause(illegalArgumentException);
            throw sQLException;
        }
    }

    byte[] convertToOutputBytes(byte[] byArray, int n) throws SQLException {
        int n2 = n + this.offset_;
        int n3 = this.length_;
        switch (this.type_ & 0xFFFE) {
            case 384: {
                break;
            }
            case 388: {
                break;
            }
            case 392: {
                n3 = 26;
                break;
            }
            case 408: {
                n3 = Conv.byteArrayToInt(byArray, n2);
                n2 += 4;
                break;
            }
            case 396: 
            case 448: 
            case 456: {
                n3 = Conv.byteArrayToShort(byArray, n2);
                n2 += 2;
                break;
            }
            case 452: {
                break;
            }
            case 464: 
            case 472: {
                n3 = Conv.byteArrayToShort(byArray, n2) * 2;
                n2 += 2;
                break;
            }
            case 468: {
                break;
            }
            case 480: 
            case 484: 
            case 488: 
            case 492: 
            case 496: 
            case 500: {
                break;
            }
            case 908: {
                n3 = Conv.byteArrayToShort(byArray, n2);
                n2 += 2;
                break;
            }
            case 912: {
                break;
            }
            case 964: 
            case 968: {
                int n4 = Conv.byteArrayToInt(byArray, n2);
                throw JDBCError.getSQLException("HY000", "Unhandled database type: " + this.type_);
            }
            default: {
                throw JDBCError.getSQLException("HY000", "Unknown database type: " + this.type_);
            }
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    String convertToString(byte[] byArray, int n) throws SQLException {
        int n2;
        if (this.buffer_ == null) {
            n2 = this.length_ + 2;
            if (this.precision_ + 2 > n2) {
                n2 = this.precision_ + 2;
            }
            this.buffer_ = new char[n2];
        }
        n2 = n + this.offset_;
        try {
            switch (this.type_ & 0xFFFE) {
                case 384: {
                    switch (this.dateFormat_) {
                        default: 
                    }
                    if (this.useStringCache_) {
                        String string = this.lookupString(byArray, n2, this.length_);
                        if (string != null) {
                            return string;
                        }
                        string = Conv.ebcdicByteArrayToString(byArray, n2, this.length_, this.buffer_);
                        this.cache(byArray, n2, this.length_, string);
                        return string;
                    }
                    return Conv.ebcdicByteArrayToString(byArray, n2, this.length_, this.buffer_);
                }
                case 388: {
                    switch (this.timeFormat_) {
                        default: 
                    }
                    if (this.useStringCache_) {
                        String string = this.lookupString(byArray, n2, this.length_);
                        if (string != null) {
                            return string;
                        }
                        string = Conv.ebcdicByteArrayToString(byArray, n2, this.length_, this.buffer_);
                        this.cache(byArray, n2, this.length_, string);
                        return string;
                    }
                    return Conv.ebcdicByteArrayToString(byArray, n2, this.length_, this.buffer_);
                }
                case 392: {
                    String string;
                    if (this.useStringCache_ && (string = this.lookupString(byArray, n2, this.length_)) != null) {
                        return string;
                    }
                    this.buffer_[0] = NUMS[byArray[n2] & 0xF];
                    this.buffer_[1] = NUMS[byArray[n2 + 1] & 0xF];
                    this.buffer_[2] = NUMS[byArray[n2 + 2] & 0xF];
                    this.buffer_[3] = NUMS[byArray[n2 + 3] & 0xF];
                    this.buffer_[4] = 45;
                    this.buffer_[5] = NUMS[byArray[n2 + 5] & 0xF];
                    this.buffer_[6] = NUMS[byArray[n2 + 6] & 0xF];
                    this.buffer_[7] = 45;
                    this.buffer_[8] = NUMS[byArray[n2 + 8] & 0xF];
                    this.buffer_[9] = NUMS[byArray[n2 + 9] & 0xF];
                    this.buffer_[10] = 32;
                    this.buffer_[11] = NUMS[byArray[n2 + 11] & 0xF];
                    this.buffer_[12] = NUMS[byArray[n2 + 12] & 0xF];
                    this.buffer_[13] = 58;
                    this.buffer_[14] = NUMS[byArray[n2 + 14] & 0xF];
                    this.buffer_[15] = NUMS[byArray[n2 + 15] & 0xF];
                    this.buffer_[16] = 58;
                    this.buffer_[17] = NUMS[byArray[n2 + 17] & 0xF];
                    this.buffer_[18] = NUMS[byArray[n2 + 18] & 0xF];
                    this.buffer_[19] = 46;
                    this.buffer_[20] = NUMS[byArray[n2 + 20] & 0xF];
                    this.buffer_[21] = NUMS[byArray[n2 + 21] & 0xF];
                    this.buffer_[22] = NUMS[byArray[n2 + 22] & 0xF];
                    this.buffer_[23] = NUMS[byArray[n2 + 23] & 0xF];
                    this.buffer_[24] = NUMS[byArray[n2 + 24] & 0xF];
                    this.buffer_[25] = NUMS[byArray[n2 + 25] & 0xF];
                    string = new String(this.buffer_, 0, 26);
                    if (this.useStringCache_) {
                        this.cache(byArray, n2, this.length_, string);
                    }
                    return string;
                }
                case 408: {
                    int n3 = Conv.byteArrayToInt(byArray, n2);
                    switch (this.ccsid_) {
                        case 1200: 
                        case 13488: {
                            return Conv.unicodeByteArrayToString(byArray, n2 + 4, n3, this.buffer_);
                        }
                    }
                    return Conv.ebcdicByteArrayToString(byArray, n2 + 4, n3, this.buffer_, this.ccsid_);
                }
                case 396: 
                case 448: 
                case 456: {
                    short s = Conv.byteArrayToShort(byArray, n2);
                    switch (this.ccsid_) {
                        case 1200: 
                        case 13488: {
                            if (this.useStringCache_) {
                                String string = this.lookupString(byArray, n2 + 2, s);
                                if (string != null) {
                                    return string;
                                }
                                string = Conv.unicodeByteArrayToString(byArray, n2 + 2, s, this.buffer_);
                                this.cache(byArray, n2 + 2, (int)s, string);
                                return string;
                            }
                            return Conv.unicodeByteArrayToString(byArray, n2 + 2, s, this.buffer_);
                        }
                    }
                    if (this.useStringCache_) {
                        String string = this.lookupString(byArray, n2 + 2, s);
                        if (string != null) {
                            return string;
                        }
                        string = Conv.ebcdicByteArrayToString(byArray, n2 + 2, s, this.buffer_, this.ccsid_);
                        this.cache(byArray, n2 + 2, (int)s, string);
                        return string;
                    }
                    return Conv.ebcdicByteArrayToString(byArray, n2 + 2, s, this.buffer_, this.ccsid_);
                }
                case 452: {
                    switch (this.ccsid_) {
                        case 1200: 
                        case 13488: {
                            if (this.useStringCache_) {
                                String string = this.lookupString(byArray, n2, this.length_);
                                if (string != null) {
                                    return string;
                                }
                                string = Conv.unicodeByteArrayToString(byArray, n2, this.length_, this.buffer_);
                                this.cache(byArray, n2, this.length_, string);
                                return string;
                            }
                            return Conv.unicodeByteArrayToString(byArray, n2, this.length_, this.buffer_);
                        }
                    }
                    if (this.useStringCache_) {
                        String string = this.lookupString(byArray, n2, this.length_);
                        if (string != null) {
                            return string;
                        }
                        string = Conv.ebcdicByteArrayToString(byArray, n2, this.length_, this.buffer_);
                        this.cache(byArray, n2, this.length_, string);
                        return string;
                    }
                    return Conv.ebcdicByteArrayToString(byArray, n2, this.length_, this.buffer_, this.ccsid_);
                }
                case 464: 
                case 472: {
                    if (this.ccsid_ == 13488 || this.ccsid_ == 1200) {
                        short s = Conv.byteArrayToShort(byArray, n2);
                        if (this.useStringCache_) {
                            String string = this.lookupString(byArray, n2 + 2, s * 2);
                            if (string != null) {
                                return string;
                            }
                            string = Conv.unicodeByteArrayToString(byArray, n2 + 2, s * 2, this.buffer_);
                            this.cache(byArray, n2 + 2, s * 2, string);
                            return string;
                        }
                        return Conv.unicodeByteArrayToString(byArray, n2 + 2, s * 2, this.buffer_);
                    }
                    JDBCError.throwSQLException("22524");
                }
                case 468: {
                    if (this.ccsid_ == 13488 || this.ccsid_ == 1200) {
                        return Conv.unicodeByteArrayToString(byArray, n2, this.length_, this.buffer_);
                    }
                    JDBCError.throwSQLException("22524");
                }
                case 480: {
                    if (this.length_ == 4) {
                        return "" + Conv.byteArrayToFloat(byArray, n2);
                    }
                    if (this.length_ == 8) {
                        return "" + Conv.byteArrayToDouble(byArray, n2);
                    }
                    throw JDBCError.getSQLException("HY000", "Unknown database type: " + this.type_ + " length= " + this.length_);
                }
                case 484: {
                    return Conv.packedDecimalToString(byArray, n2, this.precision_, this.scale_, this.buffer_);
                }
                case 488: {
                    return Conv.zonedDecimalToString(byArray, n2, this.precision_, this.scale_, this.buffer_);
                }
                case 492: {
                    if (this.useStringCache_) {
                        String string = this.lookupString(byArray, n2, 8);
                        if (string != null) {
                            return string;
                        }
                        string = String.valueOf(Conv.byteArrayToLong(byArray, n2));
                        this.cache(byArray, n2, 8, string);
                        return string;
                    }
                    return String.valueOf(Conv.byteArrayToLong(byArray, n2));
                }
                case 496: {
                    if (this.useStringCache_) {
                        String string = this.lookupString(byArray, n2, 4);
                        if (string != null) {
                            return string;
                        }
                        string = String.valueOf(Conv.byteArrayToInt(byArray, n2));
                        this.cache(byArray, n2, 4, string);
                        return string;
                    }
                    return String.valueOf(Conv.byteArrayToInt(byArray, n2));
                }
                case 500: {
                    if (this.useStringCache_) {
                        String string = this.lookupString(byArray, n2, 2);
                        if (string != null) {
                            return string;
                        }
                        string = String.valueOf(Conv.byteArrayToShort(byArray, n2));
                        this.cache(byArray, n2, 2, string);
                        return string;
                    }
                    return String.valueOf(Conv.byteArrayToShort(byArray, n2));
                }
                case 908: {
                    short s = Conv.byteArrayToShort(byArray, n2);
                    if (this.useStringCache_) {
                        String string = this.lookupString(byArray, n2 + 2, s);
                        if (string != null) {
                            return string;
                        }
                        string = Conv.bytesToHexString(byArray, n2 + 2, s);
                        this.cache(byArray, n2 + 2, (int)s, string);
                        return string;
                    }
                    return Conv.bytesToHexString(byArray, n2 + 2, s);
                }
                case 912: {
                    if (this.useStringCache_) {
                        String string = this.lookupString(byArray, n2, this.length_);
                        if (string != null) {
                            return string;
                        }
                        string = Conv.bytesToHexString(byArray, n2, this.length_);
                        this.cache(byArray, n2, this.length_, string);
                        return string;
                    }
                    return Conv.bytesToHexString(byArray, n2, this.length_);
                }
                case 412: {
                    if (this.ccsid_ == 13488 || this.ccsid_ == 1200) {
                        int n4 = Conv.byteArrayToInt(byArray, n2);
                        if (this.useStringCache_) {
                            String string = this.lookupString(byArray, n2 + 4, n4 * 2);
                            if (string != null) {
                                return string;
                            }
                            string = Conv.unicodeByteArrayToString(byArray, n2 + 4, n4 * 2, this.buffer_);
                            this.cache(byArray, n2 + 2, n4 * 2, string);
                            return string;
                        }
                        return Conv.unicodeByteArrayToString(byArray, n2 + 4, n4 * 2, this.buffer_);
                    }
                    JDBCError.throwSQLException("22524");
                    return null;
                }
                case 960: 
                case 964: 
                case 968: 
                case 2452: {
                    int n5 = Conv.byteArrayToInt(byArray, n2);
                    throw JDBCError.getSQLException("HY000", "Unsupported database type: " + this.type_ + " length= " + this.length_);
                }
                case 996: {
                    if (this.length_ == 8) {
                        return Conv.decfloat16ByteArrayToString(byArray, n2);
                    }
                    if (this.length_ == 16) {
                        return Conv.decfloat34ByteArrayToString(byArray, n2);
                    }
                    throw JDBCError.getSQLException("HY000", "Unknown DECFLOAT length= " + this.length_);
                }
            }
            throw JDBCError.getSQLException("HY000", "Unknown database type: " + this.type_ + " length= " + this.length_);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = JDBCError.getSQLException("07006", "Data conversion error");
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
    }

    boolean convertToBoolean(byte[] byArray, int n) throws SQLException {
        int n2 = n + this.offset_;
        switch (this.type_ & 0xFFFE) {
            case 448: 
            case 452: 
            case 456: 
            case 464: 
            case 468: 
            case 472: {
                String string = this.convertToString(byArray, n);
                string = string.trim();
                return !string.equals("0") && !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("n");
            }
            case 484: {
                return Conv.packedDecimalToDouble(byArray, n2, this.precision_, this.scale_) != 0.0;
            }
            case 488: {
                return Conv.zonedDecimalToDouble(byArray, n2, this.precision_, this.scale_) != 0.0;
            }
            case 492: {
                return this.convertToLong(byArray, n) != 0L;
            }
            case 496: {
                return this.convertToInt(byArray, n) != 0;
            }
            case 500: {
                return this.convertToShort(byArray, n) != 0;
            }
            case 480: {
                return this.convertToDouble(byArray, n) != 0.0;
            }
            case 908: {
                short s = Conv.byteArrayToShort(byArray, n2);
                for (int i = n2 + 2; i < n2 + 2 + s; ++i) {
                    if (byArray[i] == 0) continue;
                    return true;
                }
                return false;
            }
            case 912: {
                for (int i = n2; i < n2 + this.length_; ++i) {
                    if (byArray[i] == 0) continue;
                    return true;
                }
                return false;
            }
            case 996: {
                String string;
                if (this.length_ == 8) {
                    string = Conv.decfloat16ByteArrayToString(byArray, n2);
                } else if (this.length_ == 16) {
                    string = Conv.decfloat34ByteArrayToString(byArray, n2);
                } else {
                    throw JDBCError.getSQLException("HY000", "Unknown DECFLOAT length= " + this.length_);
                }
                Double d = Double.parseDouble(string);
                return d != 0.0;
            }
            case 384: 
            case 388: 
            case 392: 
            case 408: 
            case 960: 
            case 964: 
            case 968: 
            case 2452: {
                JDBCError.throwSQLException("07006");
                return false;
            }
        }
        throw JDBCError.getSQLException("HY000", "Unknown database type: " + this.type_);
    }

    Object convertToObject(byte[] byArray, int n) throws SQLException {
        try {
            switch (this.type_ & 0xFFFE) {
                case 384: {
                    return this.convertToDate(byArray, n, this.calendar_);
                }
                case 388: {
                    return this.convertToTime(byArray, n, this.calendar_);
                }
                case 392: {
                    return this.convertToTimestamp(byArray, n, this.calendar_);
                }
                case 448: 
                case 452: 
                case 456: 
                case 464: 
                case 468: 
                case 472: {
                    return this.convertToString(byArray, n);
                }
                case 484: {
                    return new BigDecimal(this.convertToString(byArray, n));
                }
                case 488: {
                    return new BigDecimal(this.convertToString(byArray, n));
                }
                case 492: {
                    return new Long(this.convertToLong(byArray, n));
                }
                case 496: {
                    return new Integer(this.convertToInt(byArray, n));
                }
                case 500: {
                    return new Integer(this.convertToShort(byArray, n));
                }
                case 908: {
                    int n2 = n + this.offset_;
                    short s = Conv.byteArrayToShort(byArray, n2);
                    byte[] byArray2 = new byte[s];
                    System.arraycopy(byArray, n2 + 2, byArray2, 0, s);
                    return byArray2;
                }
                case 912: {
                    byte[] byArray3 = new byte[this.length_];
                    System.arraycopy(byArray, n + this.offset_, byArray3, 0, this.length_);
                    return byArray3;
                }
                case 480: {
                    int n3 = n + this.offset_;
                    if (this.length_ == 4) {
                        float f = Conv.byteArrayToFloat(byArray, n3);
                        return new Float(f);
                    }
                    if (this.length_ == 8) {
                        double d = Conv.byteArrayToDouble(byArray, n3);
                        return new Double(d);
                    }
                    break;
                }
                case 960: 
                case 964: 
                case 968: 
                case 2452: {
                    throw JDBCError.getSQLException("HY000", "Type " + this.type_ + " not fully supported");
                }
                case 996: {
                    if (this.length_ == 8) {
                        return new BigDecimal(Conv.decfloat16ByteArrayToString(byArray, n));
                    }
                    if (this.length_ == 16) {
                        return new BigDecimal(Conv.decfloat34ByteArrayToString(byArray, n));
                    }
                    throw JDBCError.getSQLException("HY000", "Unknown DECFLOAT length= " + this.length_);
                }
                case 396: {
                    String string = this.convertToString(byArray, n);
                    try {
                        return new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        SQLException sQLException = JDBCError.getSQLException("07006");
                        sQLException.initCause(malformedURLException);
                        throw sQLException;
                    }
                }
                default: {
                    throw JDBCError.getSQLException("HY000", "Unknown database type: " + this.type_);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = JDBCError.getSQLException("07006");
            sQLException.initCause(numberFormatException);
            throw sQLException;
        }
        return null;
    }

    Blob convertToBlob(byte[] byArray, int n, JDBCConnection jDBCConnection) throws SQLException {
        int n2 = n + this.offset_;
        switch (this.type_ & 0xFFFE) {
            case 408: {
                int n3 = Conv.byteArrayToInt(byArray, n2);
                return new JDBCBlob(byArray, n2 + 4, n3);
            }
            case 960: 
            case 964: 
            case 968: 
            case 2452: {
                int n4 = Conv.byteArrayToInt(byArray, n2);
                DatabaseRequestAttributes databaseRequestAttributes = new DatabaseRequestAttributes();
                databaseRequestAttributes.setLOBLocatorHandle(n4);
                JDBCBlobLocator jDBCBlobLocator = new JDBCBlobLocator(jDBCConnection.getDatabaseConnection(), databaseRequestAttributes);
                return jDBCBlobLocator;
            }
        }
        return new JDBCBlob(byArray, n2, this.length_);
    }

    String formatDecimal(String string, int n, int n2) throws SQLException {
        if (n2 == 0) {
            int n3 = string.indexOf(46);
            if (n3 > 0) {
                string = string.substring(0, n3);
            }
            int n4 = string.length();
            if (string.charAt(0) == '-') {
                --n4;
            }
            if (n4 > n) {
                throw new DataTruncation(this.index_, this.parameter_, false, string.length(), n);
            }
        } else {
            int n5 = string.indexOf(46);
            if (n5 > 0) {
                int n6 = string.length() - n5 - 1;
                if (n6 < n2) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    while (n6 < n2) {
                        stringBuffer.append('0');
                        ++n6;
                    }
                    string = stringBuffer.toString();
                } else if (n6 > n2) {
                    string = string.substring(0, n5 + 1 + n2);
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append('.');
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append('0');
                }
                string = stringBuffer.toString();
            }
            int n7 = string.length();
            if (string.charAt(0) == '-') {
                --n7;
            }
            if (n7 > n + 1) {
                throw new DataTruncation(this.index_, this.parameter_, false, string.length() - 1, n);
            }
        }
        return string;
    }

    public int isNullable() {
        if ((this.type_ & 1) != 0) {
            return 1;
        }
        return 0;
    }

    public static Calendar getGregorianInstance() {
        Calendar calendar = Calendar.getInstance();
        boolean bl = calendar instanceof GregorianCalendar;
        boolean bl2 = false;
        try {
            bl2 = Column.isBuddhistCalendar(calendar);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bl && !bl2) {
            return calendar;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return gregorianCalendar;
    }

    private static boolean isBuddhistCalendar(Calendar calendar) {
        try {
            Class<?> clazz = Class.forName("sun.util.BuddhistCalendar");
            return clazz.isInstance(calendar);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Calendar getGMTInstance() {
        if (gmtTimeZone == null) {
            gmtTimeZone = TimeZone.getTimeZone("GMT");
        }
        return Calendar.getInstance(gmtTimeZone);
    }

    Clob convertToClob(byte[] byArray, int n, JDBCConnection jDBCConnection) throws SQLException {
        int n2 = n + this.offset_;
        switch (this.type_) {
            case 404: 
            case 405: 
            case 408: 
            case 409: {
                int n3 = Conv.byteArrayToInt(byArray, n2);
                return new JDBCClob(byArray, n2 + 4, n3, this.ccsid_);
            }
            case 960: 
            case 961: 
            case 964: 
            case 965: {
                int n4 = Conv.byteArrayToInt(byArray, n2);
                DatabaseRequestAttributes databaseRequestAttributes = new DatabaseRequestAttributes();
                databaseRequestAttributes.setLOBLocatorHandle(n4);
                return null;
            }
        }
        return new JDBCClob(byArray, n2, this.length_, this.ccsid_);
    }
}

