/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.components;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.command.CommandConnection;
import com.ibm.jtopenlite.command.program.openlist.OpenListHandler;
import com.ibm.jtopenlite.command.program.workmgmt.OpenListOfJobs;
import com.ibm.jtopenlite.command.program.workmgmt.OpenListOfJobsFormatOLJB0300;
import com.ibm.jtopenlite.command.program.workmgmt.OpenListOfJobsFormatOLJB0300Listener;
import com.ibm.jtopenlite.command.program.workmgmt.OpenListOfJobsKeyField;
import com.ibm.jtopenlite.command.program.workmgmt.OpenListOfJobsSelectionListener;
import com.ibm.jtopenlite.command.program.workmgmt.OpenListOfJobsSortListener;
import com.ibm.jtopenlite.components.ActiveJobsListener;
import com.ibm.jtopenlite.components.JobInfo;
import java.io.IOException;

class ListActiveJobsImpl
implements OpenListOfJobsFormatOLJB0300Listener,
OpenListOfJobsSelectionListener,
OpenListOfJobsSortListener,
ActiveJobsListener {
    private final OpenListOfJobsFormatOLJB0300 jobFormat_ = new OpenListOfJobsFormatOLJB0300();
    private final int[] fieldsToReturn_ = new int[]{1906, 314, 602, 601, 305, 2008, 1802, 312, 1306};
    private final OpenListOfJobs jobList_ = new OpenListOfJobs(this.jobFormat_, 120, 1, this.fieldsToReturn_);
    private final OpenListHandler handler_ = new OpenListHandler(this.jobList_, this.jobFormat_, this);
    private ActiveJobsListener ajListener_;
    private int counter_ = -1;
    private JobInfo[] jobs_;

    ListActiveJobsImpl() {
        this.jobList_.setSelectionListener(this, 3);
        this.jobList_.setSortListener(this);
    }

    public void setActiveJobsListener(ActiveJobsListener activeJobsListener) {
        this.ajListener_ = activeJobsListener;
    }

    public long getElapsedTime() {
        return this.jobList_.getElapsedTime();
    }

    public void totalRecords(int n) {
        this.jobs_ = new JobInfo[n];
    }

    public boolean stopProcessing() {
        return false;
    }

    public void totalRecordsInList(int n) {
        this.ajListener_.totalRecords(n);
    }

    public void openComplete() {
        OpenListOfJobsKeyField[] openListOfJobsKeyFieldArray = this.jobList_.getKeyFields();
        this.jobFormat_.setKeyFields(openListOfJobsKeyFieldArray);
    }

    public synchronized JobInfo[] getJobs(CommandConnection commandConnection, boolean bl) throws IOException {
        this.jobs_ = null;
        this.counter_ = -1;
        this.jobList_.setResetStatusStatistics(bl);
        this.handler_.process(commandConnection, 600);
        return this.jobs_;
    }

    private void sort() {
        int n;
        int n2;
        for (n2 = 1; n2 < this.jobs_.length - 1; ++n2) {
            JobInfo jobInfo = this.jobs_[n2];
            if (!jobInfo.getJobType().equals("SBS")) continue;
            n = n2;
            JobInfo jobInfo2 = this.jobs_[n - 1];
            while (jobInfo2.getSubsystem().equals(jobInfo.getJobName())) {
                this.jobs_[n - 1] = jobInfo;
                this.jobs_[n] = jobInfo2;
                jobInfo = this.jobs_[--n];
                jobInfo2 = this.jobs_[n - 1];
            }
        }
        n2 = -1;
        for (int i = 0; n2 == -1 && i < this.jobs_.length; ++i) {
            if (this.jobs_[i].getJobType().equals("SYS")) continue;
            n2 = i;
        }
        while (n2 > 0) {
            JobInfo jobInfo = this.jobs_[0];
            for (n = 1; n < this.jobs_.length; ++n) {
                this.jobs_[n - 1] = this.jobs_[n];
            }
            this.jobs_[this.jobs_.length - 1] = jobInfo;
            --n2;
        }
    }

    public int getNumberOfSortKeys() {
        return 2;
    }

    public int getSortKeyFieldStartingPosition(int n) {
        if (n == 0) {
            return 41;
        }
        return 1;
    }

    public int getSortKeyFieldLength(int n) {
        if (n == 0) {
            return 20;
        }
        return 26;
    }

    public int getSortKeyFieldDataType(int n) {
        return 6;
    }

    public boolean isAscending(int n) {
        return true;
    }

    public static String getWRKACTJOBType(String string, String string2) {
        char c = string.charAt(0);
        char c2 = string2.charAt(0);
        switch (c) {
            case 'A': {
                return "ASJ";
            }
            case 'B': {
                switch (c2) {
                    case ' ': {
                        return "BCH";
                    }
                    case 'D': {
                        return "BCI";
                    }
                    case 'E': {
                        return "EVK";
                    }
                    case 'F': {
                        return "M36";
                    }
                    case 'T': {
                        return "MRT";
                    }
                    case 'J': {
                        return "PJ ";
                    }
                    case 'U': {
                        return "   ";
                    }
                }
                return null;
            }
            case 'I': {
                return "INT";
            }
            case 'W': {
                switch (c2) {
                    case 'P': {
                        return "PDJ";
                    }
                    case ' ': {
                        return "WTR";
                    }
                }
                return null;
            }
            case 'R': {
                return "RDR";
            }
            case 'S': 
            case 'X': {
                return "SYS";
            }
            case 'M': {
                return "SBS";
            }
        }
        return null;
    }

    public static String getFunctionPrefix(String string) {
        char c = string.charAt(0);
        switch (c) {
            case '\u0000': 
            case ' ': {
                return "    ";
            }
            case 'C': {
                return "CMD-";
            }
            case 'D': {
                return "DLY-";
            }
            case 'G': {
                return "GRP-";
            }
            case 'I': {
                return "IDX-";
            }
            case 'J': {
                return "JVM-";
            }
            case 'L': {
                return "LOG-";
            }
            case 'M': {
                return "MRT-";
            }
            case 'N': {
                return "MNU-";
            }
            case 'O': {
                return "I/O-";
            }
            case 'P': {
                return "PGM-";
            }
            case 'R': {
                return "PRC-";
            }
            case '*': {
                return "*  -";
            }
        }
        return null;
    }

    public void newJobInfo(JobInfo jobInfo, int n) {
        this.jobs_[n] = jobInfo;
    }

    public void subsystem(String string, int n) {
        this.jobs_[n].setSubsystem(string);
    }

    public void functionPrefix(String string, int n) {
        this.jobs_[n].setFunctionPrefix(string);
    }

    public void functionName(String string, int n) {
        this.jobs_[n].setFunctionName(string);
    }

    public void currentUser(String string, int n) {
        this.jobs_[n].setCurrentUser(string);
    }

    public void totalCPUUsed(long l, int n) {
        this.jobs_[n].setTotalCPUUsed(l);
    }

    public void memoryPool(String string, int n) {
        this.jobs_[n].setMemoryPool(string);
    }

    public void cpuPercent(int n, int n2) {
        this.jobs_[n2].setCPUPercent(n);
    }

    public void threadCount(int n, int n2) {
        this.jobs_[n2].setThreadCount(n);
    }

    public void runPriority(int n, int n2) {
        this.jobs_[n2].setRunPriority(n);
    }

    public void newJobEntry(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = ListActiveJobsImpl.getWRKACTJOBType(string5, string6);
        this.ajListener_.newJobInfo(new JobInfo(string, string2, string3, string7, string4), ++this.counter_);
    }

    public synchronized void newKeyData(int n, String string, byte[] byArray, int n2) {
        switch (n) {
            case 1906: {
                this.ajListener_.subsystem(string.substring(0, 10), this.counter_);
                break;
            }
            case 602: {
                this.ajListener_.functionPrefix(ListActiveJobsImpl.getFunctionPrefix(string), this.counter_);
                break;
            }
            case 601: {
                this.ajListener_.functionName(string.charAt(0) == '\u0000' ? "          " : string, this.counter_);
                break;
            }
            case 305: {
                this.ajListener_.currentUser(string, this.counter_);
                break;
            }
            case 312: {
                this.ajListener_.totalCPUUsed(Conv.byteArrayToLong(byArray, n2), this.counter_);
                break;
            }
            case 1306: {
                this.ajListener_.memoryPool(string, this.counter_);
            }
        }
    }

    public void newKeyData(int n, int n2) {
        switch (n) {
            case 314: {
                this.ajListener_.cpuPercent(n2, this.counter_);
                break;
            }
            case 2008: {
                this.ajListener_.threadCount(n2, this.counter_);
                break;
            }
            case 1802: {
                this.ajListener_.runPriority(n2, this.counter_);
            }
        }
    }

    public String getJobName() {
        return "*ALL";
    }

    public String getUserName() {
        return "*ALL";
    }

    public String getJobNumber() {
        return "*ALL";
    }

    public String getJobType() {
        return "*";
    }

    public int getPrimaryJobStatusCount() {
        return 0;
    }

    public String getPrimaryJobStatus(int n) {
        return null;
    }

    public int getActiveJobStatusCount() {
        return 0;
    }

    public String getActiveJobStatus(int n) {
        return null;
    }

    public int getJobsOnJobQueueStatusCount() {
        return 0;
    }

    public String getJobsOnJobQueueStatus(int n) {
        return null;
    }

    public int getJobQueueNameCount() {
        return 0;
    }

    public String getJobQueueName(int n) {
        return null;
    }

    public int getCurrentUserProfileCount() {
        return 0;
    }

    public String getCurrentUserProfile(int n) {
        return null;
    }

    public int getServerTypeCount() {
        return 0;
    }

    public String getServerType(int n) {
        return null;
    }

    public int getActiveSubsystemCount() {
        return 0;
    }

    public String getActiveSubsystem(int n) {
        return null;
    }

    public int getMemoryPoolCount() {
        return 0;
    }

    public int getMemoryPool(int n) {
        return 0;
    }

    public int getJobTypeEnhancedCount() {
        return 0;
    }

    public int getJobTypeEnhanced(int n) {
        return 0;
    }

    public int getQualifiedJobNameCount() {
        return 0;
    }

    public String getQualifiedJobName(int n) {
        return null;
    }
}

