/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.constants;

public enum OperatingSystemType {
    RHEL_6_64_BIT("Red Hat Enterprise Linux 6 (64-bit)", 26),
    RHEL_6_32_BIT("Red Hat Enterprise Linux 6 (32-bit)", 25),
    RHEL_5_64_BIT("Red Hat Enterprise Linux 5 (64-bit)", 28),
    RHEL_5_32_BIT("Red Hat Enterprise Linux 5 (32-bit)", 27),
    RHEL_4_64_BIT("Red Hat Enterprise Linux 4 (64-bit)", 30),
    RHEL_4_32_BIT("Red Hat Enterprise Linux 4 (32-bit)", 29),
    RHEL_3_64_BIT("Red Hat Enterprise Linux 3 (64-bit)", 32),
    RHEL_3_32_BIT("Red Hat Enterprise Linux 3 (32-bit)", 31),
    RHEL_2_1("Red Hat Enterprise Linux 2.1", 33),
    SUSE_11_64_BIT("SUSE Linux Enterprise 11 (64-bit)", 35),
    SUSE_11_32_BIT("SUSE Linux Enterprise 11 (32-bit)", 34),
    SUSE_10_64_BIT("SUSE Linux Enterprise 10 (64-bit)", 37),
    SUSE_10_32_BIT("SUSE Linux Enterprise 10 (32-bit)", 36),
    SUSE_8_9_64_BIT("SUSE Linux Enterprise 8/9 (64-bit)", 39),
    SUSE_8_9_32_BIT("SUSE Linux Enterprise 8/9 (32-bit)", 38),
    CENTOS_4_5_6_64_BIT("CentOS 4/5/6 (64-bit)", 70),
    CENTOS_4_5_6_32_BIT("CentOS 4/5/6 (32-bit)", 69),
    DEBIAN_6_64_BIT("Debian GNU/Linux 6 (64-bit)", 74),
    DEBIAN_6_32_BIT("Debian GNU/Linux 6 (32-bit)", 73),
    DEBIAN_5_64_BIT("Debian GNU/Linux 5 (64-bit)", 44),
    DEBIAN_5_32_BIT("Debian GNU/Linux 5 (32-bit)", 43),
    DEBIAN_4_64_BIT("Debian GNU/Linux 4 (64-bit)", 46),
    DEBIAN_4_32_BIT("Debian GNU/Linux 4 (32-bit)", 45),
    ASIANUX_4_64_BIT("Asianux 4 (64-bit)", 76),
    ASIANUX_4_32_BIT("Asianux 4 (32-bit)", 75),
    ASIANUX_3_64_BIT("Asianux 3 (64-bit)", 42),
    ASIANUX_3_32_BIT("Asianux 3 (32-bit)", 41),
    NOVELL_OPEN_ENTERPRISE_SERVER("Novell Open Enterprise Server", 40),
    ORACLE_LINUX_4_5_6_64_BIT("Oracle Linux 4/5/6 (64-bit)", 72),
    ORACLE_LINUX_4_5_6_32_BIT("Oracle Linux 4/5/6 (32-bit)", 71),
    UBUNTU_64_BIT("Ubuntu Linux (64-bit)", 48),
    UBUNTU_32_BIT("Ubuntu Linux (32-bit)", 47),
    OTHER_2_6_X_LINUX_64_BIT("Other 2.6.x Linux (64-bit)", 50),
    OTHER_2_6_X_LINUX_32_BIT("Other 2.6.x Linux (32-bit)", 49),
    OTHER_2_4_X_LINUX_64_BIT("Other 2.4.x Linux (64-bit)", 52),
    OTHER_2_4_X_LINUX_32_BIT("Other 2.4.x Linux (32-bit)", 51),
    OTHER_LINUX_64_BIT("Other Linux (64-bit)", 54),
    OTHER_LINUX_32_BIT("Other Linux (32-bit)", 53),
    WINDOWS_SERVER_8_64_BIT("Microsoft Windows Server 8 (64-bit)", 85),
    WINDOWS_SERVER_2008_R2_64_BIT("Microsoft Windows Server 2008 R2 (64-bit)", 3),
    WINDOWS_SERVER_2008_64_BIT("Microsoft Windows Server 2008 (64-bit)", 5),
    WINDOWS_SERVER_2008_32_BIT("Microsoft Windows Server 2008 (32-bit)", 4),
    WINDOWS_SERVER_2003_64_BIT("Microsoft Windows Server 2003 (64-bit)", 7),
    WINDOWS_SERVER_2003_32_BIT("Microsoft Windows Server 2003 (32-bit)", 6),
    WINDOWS_SERVER_2003_DATACENTER_64_BIT("Microsoft Windows Server 2003 Datacenter (64-bit)", 9),
    WINDOWS_SERVER_2003_DATACENTER_32_BIT("Microsoft Windows Server 2003 Datacenter (32-bit)", 8),
    WINDOWS_SERVER_2003_STANDARD_64_BIT("Microsoft Windows Server 2003 Standard (64-bit)", 11),
    WINDOWS_SERVER_2003_STANDARD_32_BIT("Microsoft Windows Server 2003 Standard (32-bit)", 10),
    WINDOWS_SERVER_2003_WEB_32_BIT("Microsoft Windows Server 2003 Web Edition (32-bit)", 12),
    WINDOWS_SMALL_BUSINESS_SERVER_2003("Microsoft Windows Small Business Server 2003", 13),
    WINDOWS_8_64_BIT("Microsoft Windows 8 (64-bit)", 86),
    WINDOWS_8_32_BIT("Microsoft Windows 8 (32-bit)", 87),
    WINDOWS_7_64_BIT("Microsoft Windows 7 (64-bit)", 2),
    WINDOWS_7_32_BIT("Microsoft Windows 7 (32-bit)", 1),
    WINDOWS_VISTA_64_BIT("Microsoft Windows Vista (64-bit)", 15),
    WINDOWS_VISTA_32_BIT("Microsoft Windows Vista (32-bit)", 14),
    WINDOWS_XP_PROFESSIONAL_64_BIT("Microsoft Windows XP Professional (64-bit)", 17),
    WINDOWS_XP_PROFESSIONAL_32_BIT("Microsoft Windows XP Professional (32-bit)", 16),
    WINDOWS_2000("Microsoft Windows 2000", 18),
    WINDOWS_2000_SERVER("Microsoft Windows 2000 Server", 19),
    WINDOWS_2000_PROFESSIONAL("Microsoft Windows 2000 Professional", 20),
    WINDOWS_NT("Microsoft Windows NT", 23),
    WINDOWS_98("Microsoft Windows 98", 21),
    WINDOWS_95("Microsoft Windows 95", 22),
    WINDOWS_3_1("Microsoft Windows 3.1", 24),
    MICROSOFT_MS_DOS("Microsoft MS-DOS", 66),
    APPLE_MAC_OS_X_10_7_64_BIT("Apple Mac OS X 10.7 (64-bit)", 88),
    APPLE_MAC_OS_X_10_7_32_BIT("Apple Mac OS X 10.7 (32-bit)", 89),
    APPLE_MAC_OS_X_10_6_64_BIT("Apple Mac OS X 10.6 (64-bit)", 83),
    APPLE_MAC_OS_X_10_6_32_BIT("Apple Mac OS X 10.6 (32-bit)", 84),
    APPLE_MAC_OS_X_10_5_64_BIT("Apple Mac OS X 10.5 (64-bit)", 81),
    APPLE_MAC_OS_X_10_5_32_BIT("Apple Mac OS X 10.5 (32-bit)", 82),
    FREEBSD_64_BIT("FreeBSD (64-bit)", 62),
    FREEBSD_32_BIT("FreeBSD (32-bit)", 61),
    IBM_OS_2("IBM OS/2", 63),
    NETWARE_6_X("Novell NetWare 6.x", 55),
    NETWARE_5_1("Novell NetWare 5.1", 56),
    ORACLE_SOLARIS_11_64_BIT("Oracle Solaris 11 (64-bit)", 77),
    ORACLE_SOLARIS_10_64_BIT("Oracle Solaris 10 (64-bit)", 58),
    ORACLE_SOLARIS_10_32_BIT("Oracle Solaris 10 (32-bit)", 57),
    SUN_MICROSYSTEMS_SOLARIS_9("Sun Microsystems Solaris 9 (experimental)", 59),
    SUN_MICROSYSTEMS_SOLARIS_8("Sun Microsystems Solaris 8 (experimental)", 60),
    SCO_OPENSERVER_6("SCO OpenServer 6", 78),
    SCO_OPENSERVER_5("SCO OpenServer 5", 64),
    SCO_UNIXWARE_7("SCO UnixWare 7", 65),
    SERENITY_SYSTEMS_ECOMSTATION_2("Serenity Systems eComStation 2", 80),
    SERENITY_SYSTEMS_ECOMSTATION_1("Serenity Systems eComStation 1", 79),
    OTHER_64_BIT("Other (64-bit)", 68),
    OTHER_32_BIT("Other (32-bit)", 67);

    private String osName;
    private Integer value;

    private OperatingSystemType(String osName, Integer osId) {
        this.osName = osName;
        this.value = osId;
    }

    public String getName() {
        return this.osName;
    }

    public Integer value() {
        return this.value;
    }

    public static OperatingSystemType fromName(String name) {
        for (OperatingSystemType os : OperatingSystemType.values()) {
            if (!os.getName().equals(name)) continue;
            return os;
        }
        throw new IllegalArgumentException(name.toString());
    }

    public static OperatingSystemType fromValue(Integer value) {
        for (OperatingSystemType os : OperatingSystemType.values()) {
            if (!os.value().equals(value)) continue;
            return os;
        }
        throw new IllegalArgumentException(value.toString());
    }
}

