/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions.service;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.extension.ServiceResourceType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminServiceResource
extends VcloudEntity<ServiceResourceType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType adminResourceClassRef;

    AdminServiceResource(VcloudClient client, ServiceResourceType serviceResParams) {
        super(client, serviceResParams);
        this.sortAdminServiceResourceLinkRefs();
    }

    private void sortAdminServiceResourceLinkRefs() {
        if (this.getResource() != null) {
            for (LinkType link : ((ServiceResourceType)this.getResource()).getLink()) {
                if (!link.getRel().equals("up") || !link.getType().equals("application/vnd.vmware.admin.resourceClass+xml")) continue;
                this.adminResourceClassRef = link;
            }
        }
    }

    public static AdminServiceResource getAdminServiceResourceByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new AdminServiceResource(client, (ServiceResourceType)AdminServiceResource.getResourceByReference(client, reference));
    }

    public static AdminServiceResource getAdminServiceResourceById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new AdminServiceResource(client, (ServiceResourceType)AdminServiceResource.getEntityById(client, vCloudId, "application/vnd.vmware.admin.serviceResource+xml"));
    }

    public void delete() throws VCloudException {
        SdkUtil.delete(this.getVcloudClient(), this.getReference().getHref(), 204);
    }

    public ReferenceType getAdminResourceClassReference() throws VCloudException {
        if (this.adminResourceClassRef != null) {
            return this.adminResourceClassRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

