/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions.service;

import com.vmware.vcloud.api.rest.schema.EntityType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.extension.AdminFileDescriptorType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudResource;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminFileDescriptor
extends VcloudResource<AdminFileDescriptorType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType apiDefinitionRef;

    AdminFileDescriptor(VcloudClient client, AdminFileDescriptorType fileDescResource) {
        super(client, fileDescResource);
        this.sortAdminFileDescriptorRefs();
    }

    private void sortAdminFileDescriptorRefs() {
        if (this.getResource() != null) {
            for (LinkType link : ((AdminFileDescriptorType)this.getResource()).getLink()) {
                if (!link.getRel().equals("up") || !link.getType().equals("application/vnd.vmware.admin.apiDefinition+xml")) continue;
                this.apiDefinitionRef = link;
            }
        }
    }

    public static AdminFileDescriptor getAdminFileDescriptorByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new AdminFileDescriptor(client, (AdminFileDescriptorType)AdminFileDescriptor.getResourceByReference(client, reference));
    }

    public static AdminFileDescriptor getAdminFileDescriptorById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + client.getVcloudApiURL() + "/entity" + "/" + vCloudId);
        EntityType entityType = (EntityType)SdkUtil.get(client, client.getVcloudApiURL() + "/entity" + "/" + vCloudId, 200);
        for (LinkType link : entityType.getLink()) {
            if (!link.getType().equals("application/vnd.vmware.admin.fileDescriptor+xml")) continue;
            return new AdminFileDescriptor(client, (AdminFileDescriptorType)SdkUtil.get(client, link.getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public void delete() throws VCloudException {
        SdkUtil.delete(this.getVcloudClient(), this.getReference().getHref(), 204);
    }

    public ReferenceType getApiDefinitionReference() throws VCloudException {
        if (this.apiDefinitionRef != null) {
            return this.apiDefinitionRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

