/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions.service;

import com.vmware.vcloud.api.rest.schema.EntityType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.extension.ApiFilterType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudResource;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminApiFilter
extends VcloudResource<ApiFilterType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType serviceRef;

    AdminApiFilter(VcloudClient client, ApiFilterType apiFilterResource) {
        super(client, apiFilterResource);
        this.sortApiFilterRefs();
    }

    private void sortApiFilterRefs() {
        if (this.getResource() != null) {
            for (LinkType link : ((ApiFilterType)this.getResource()).getLink()) {
                if (!link.getRel().equals("up") || !link.getType().equals("application/vnd.vmware.admin.service+xml")) continue;
                this.serviceRef = link;
            }
        }
    }

    public static AdminApiFilter getApiFilterByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new AdminApiFilter(client, (ApiFilterType)AdminApiFilter.getResourceByReference(client, reference));
    }

    public static AdminApiFilter getApiFilterById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + client.getVcloudApiURL() + "/entity" + "/" + vCloudId);
        EntityType entityType = (EntityType)SdkUtil.get(client, client.getVcloudApiURL() + "/entity" + "/" + vCloudId, 200);
        for (LinkType link : entityType.getLink()) {
            if (!link.getType().equals("application/vnd.vmware.admin.apiFilter+xml")) continue;
            return new AdminApiFilter(client, (ApiFilterType)SdkUtil.get(client, link.getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public void delete() throws VCloudException {
        SdkUtil.delete(this.getVcloudClient(), this.getReference().getHref(), 204);
    }

    public ReferenceType getServiceReference() throws VCloudException {
        if (this.serviceRef != null) {
            return this.serviceRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

