/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.CertificateUpdateParamsType;
import com.vmware.vcloud.api.rest.schema.CertificateUploadSocketType;
import com.vmware.vcloud.api.rest.schema.KeystoreUpdateParamsType;
import com.vmware.vcloud.api.rest.schema.KeystoreUploadSocketType;
import com.vmware.vcloud.api.rest.schema.SspiKeytabUpdateParamsType;
import com.vmware.vcloud.api.rest.schema.SspiKeytabUploadSocketType;
import com.vmware.vcloud.api.rest.schema.TaskOperationListType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.TrustStoreUpdateParamsType;
import com.vmware.vcloud.api.rest.schema.TrustStoreUploadSocketType;
import com.vmware.vcloud.api.rest.schema.extension.AmqpSettingsTestType;
import com.vmware.vcloud.api.rest.schema.extension.AmqpSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.BlockingTaskSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.BrandingSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.CatalogSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.EmailSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.GeneralSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.KerberosSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.LdapGroupAttributesType;
import com.vmware.vcloud.api.rest.schema.extension.LdapSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.LdapUserAttributesType;
import com.vmware.vcloud.api.rest.schema.extension.LicenseMetricsInfoType;
import com.vmware.vcloud.api.rest.schema.extension.LicenseType;
import com.vmware.vcloud.api.rest.schema.extension.LookupServiceParamsType;
import com.vmware.vcloud.api.rest.schema.extension.LookupServiceSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.NotificationsSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.SmtpSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.SystemPasswordPolicySettingsType;
import com.vmware.vcloud.api.rest.schema.extension.SystemSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.VcTrustStoreUpdateParamsType;
import com.vmware.vcloud.api.rest.schema.extension.VcTrustStoreUploadSocketType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.constants.BlockingTaskOperationType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcloudAdminExtensionSettings {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private SystemSettingsType vcloudSystemSettings;
    private VcloudClient client;
    private List<BlockingTaskOperationType> enabledBlockingTaskOperations;

    VcloudAdminExtensionSettings(VcloudClient vcloudClient) throws VCloudException {
        this.client = vcloudClient;
        this.vcloudSystemSettings = (SystemSettingsType)SdkUtil.get(this.client, this.client.getVcloudApiURL() + "/admin/extension" + "/settings", 200);
        this.sort_v1_5();
    }

    private void sort_v1_5() {
        this.enabledBlockingTaskOperations = new ArrayList<BlockingTaskOperationType>();
        if (this.getSystemSettings().getBlockingTaskSettings() != null && this.getSystemSettings().getBlockingTaskSettings().getBlockingTaskOperations() != null) {
            try {
                this.enabledBlockingTaskOperations = BlockingTaskOperationType.fromValues(this.getSystemSettings().getBlockingTaskSettings().getBlockingTaskOperations().getOperation());
            }
            catch (IllegalArgumentException e) {
                logger.info(e.getLocalizedMessage());
            }
        }
    }

    public SystemSettingsType getResource() {
        return this.vcloudSystemSettings;
    }

    public SystemSettingsType getSystemSettings() {
        return this.vcloudSystemSettings;
    }

    public SystemSettingsType updateSystemSettings(SystemSettingsType systemSettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createSystemSettings(systemSettingsType));
        return (SystemSettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.systemSettings+xml", 200);
    }

    public GeneralSettingsType getGeneralSettings() {
        return this.getSystemSettings().getGeneralSettings();
    }

    public static GeneralSettingsType getGeneralSettings(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/general";
        return (GeneralSettingsType)SdkUtil.get(client, adminSettingsUpdateUrl, 200);
    }

    public KerberosSettingsType getKerberosSettings() {
        return this.getSystemSettings().getKerberosSettings();
    }

    public static KerberosSettingsType getKerberosSettings(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/kerberosSettings";
        return (KerberosSettingsType)SdkUtil.get(client, adminSettingsUpdateUrl, 200);
    }

    public GeneralSettingsType updateGeneralSettings(GeneralSettingsType generalSettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/general";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createGeneralSettings(generalSettingsType));
        return (GeneralSettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.generalSettings+xml", 200);
    }

    public KerberosSettingsType updateKerberosSettings(KerberosSettingsType kerberosSettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/kerberosSettings";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createKerberosSettings(kerberosSettingsType));
        return (KerberosSettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.kerberosSettings+xml", 200);
    }

    public BrandingSettingsType getBrandingSettings() throws VCloudException {
        return this.getResource().getBrandingSettings();
    }

    public static BrandingSettingsType getBrandingSettings(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/branding";
        return (BrandingSettingsType)SdkUtil.get(client, adminSettingsUpdateUrl, 200);
    }

    public BrandingSettingsType updateBrandingSettings(BrandingSettingsType brandingSettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/branding";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createBrandingSettings(brandingSettingsType));
        return (BrandingSettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.brandingSettings+xml", 200);
    }

    public EmailSettingsType getEmailSettings() throws VCloudException {
        return this.getResource().getEmailSettings();
    }

    public static EmailSettingsType getEmailSettings(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/email";
        return (EmailSettingsType)SdkUtil.get(client, adminSettingsUpdateUrl, 200);
    }

    public EmailSettingsType updateEmailSettings(EmailSettingsType emailSettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/email";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createEmailSettings(emailSettingsType));
        return (EmailSettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.emailSettings+xml", 200);
    }

    public LicenseType getLicenseSettings() throws VCloudException {
        return this.getResource().getLicense();
    }

    public static LicenseType getLicenseSettings(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/license";
        return (LicenseType)SdkUtil.get(client, adminSettingsUpdateUrl, 200);
    }

    public LicenseType updateLicenseSettings(LicenseType licenseType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/license";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createLicense(licenseType));
        return (LicenseType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.licenseSettings+xml", 200);
    }

    public LicenseMetricsInfoType getLicenseMetricsInfo() throws VCloudException {
        return this.getResource().getLicense().getLicenseMetricsInfo();
    }

    public SmtpSettingsType getEmailSmtpSettings() throws VCloudException {
        return this.getEmailSettings().getSmtpSettings();
    }

    public Boolean isNotificationsEnabled() {
        return this.getSystemSettings().getNotificationsSettings().isEnableNotifications();
    }

    public static Boolean isNotificationsEnabled(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/notifications";
        return ((NotificationsSettingsType)SdkUtil.get(client, adminSettingsUpdateUrl, 200)).isEnableNotifications();
    }

    public void setEnableNotifications(Boolean enableNotificationsSetting) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/notifications";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        NotificationsSettingsType notificationsSettingsType = new NotificationsSettingsType();
        notificationsSettingsType.setEnableNotifications(enableNotificationsSetting.booleanValue());
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createNotificationsSettings(notificationsSettingsType));
        SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.notificationsSettings+xml", 200);
    }

    public AmqpSettingsType getAmqpSettings() {
        return this.getSystemSettings().getAmqpSettings();
    }

    public static AmqpSettingsType getAmqpSettings(VcloudClient client) throws VCloudException {
        String adminSettingsUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/amqp";
        return (AmqpSettingsType)SdkUtil.get(client, adminSettingsUrl, 200);
    }

    public AmqpSettingsType updateAmqpSettings(AmqpSettingsType amqpSettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/amqp";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createAmqpSettings(amqpSettingsType));
        return (AmqpSettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.amqpSettings+xml", 200);
    }

    public LdapSettingsType getLdapSettings() {
        return this.getSystemSettings().getLdapSettings();
    }

    public static LdapSettingsType getLdapSettings(VcloudClient client) throws VCloudException {
        String adminLdapSettingsUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/ldapSettings";
        return (LdapSettingsType)SdkUtil.get(client, adminLdapSettingsUrl, 200);
    }

    public LdapSettingsType updateLdapSettings(LdapSettingsType ldapSettingsType) throws VCloudException {
        String adminLdapSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/ldapSettings";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminLdapSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createLdapSettings(ldapSettingsType));
        return (LdapSettingsType)SdkUtil.put(this.client, adminLdapSettingsUpdateUrl, adminLdapSettingsUpdateXml, "application/vnd.vmware.admin.ldapSettings+xml", 200);
    }

    public LdapUserAttributesType getLdapUserSettings() {
        return this.getSystemSettings().getLdapSettings().getUserAttributes();
    }

    public LdapGroupAttributesType getLdapGroupSettings() {
        return this.getSystemSettings().getLdapSettings().getGroupAttributes();
    }

    public Boolean testAmqpConnection() throws VCloudException {
        String testAmqpConnectionUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/amqp" + "/action/test";
        String testAmqpSettingsXML = JAXBUtil.marshal(new ObjectFactory().createAmqpSettings(this.getAmqpSettings()));
        return ((AmqpSettingsTestType)SdkUtil.post(this.client, testAmqpConnectionUrl, testAmqpSettingsXML, "application/vnd.vmware.admin.amqpSettings+xml", 200)).isValid();
    }

    public static Boolean testAmqpConnection(VcloudClient client, AmqpSettingsType amqpSettings) throws VCloudException {
        String testAmqpConnectionUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/amqp" + "/action/test";
        String testAmqpSettingsXML = JAXBUtil.marshal(new ObjectFactory().createAmqpSettings(amqpSettings));
        return ((AmqpSettingsTestType)SdkUtil.post(client, testAmqpConnectionUrl, testAmqpSettingsXML, "application/vnd.vmware.admin.amqpSettings+xml", 200)).isValid();
    }

    public SystemPasswordPolicySettingsType getPasswordPolicySettings() {
        return this.getSystemSettings().getPasswordPolicySettings();
    }

    public static SystemPasswordPolicySettingsType getPasswordPolicySettings(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/passwordPolicy";
        return (SystemPasswordPolicySettingsType)SdkUtil.get(client, adminSettingsUpdateUrl, 200);
    }

    public SystemPasswordPolicySettingsType updatePasswordPolicySettings(SystemPasswordPolicySettingsType passwordPolicySettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/passwordPolicy";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createSystemPasswordPolicySettings(passwordPolicySettingsType));
        return (SystemPasswordPolicySettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.systemPasswordPolicySettings+xml", 200);
    }

    public BlockingTaskSettingsType getBlockingTaskSettings() {
        return this.getSystemSettings().getBlockingTaskSettings();
    }

    public static BlockingTaskSettingsType getBlockingTaskSettings(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/blockingTask";
        return (BlockingTaskSettingsType)SdkUtil.get(client, adminSettingsUpdateUrl, 200);
    }

    public BlockingTaskSettingsType updateBlockingTaskSettings(BlockingTaskSettingsType blockingTaskSettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/blockingTask";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createBlockingTaskSettings(blockingTaskSettingsType));
        return (BlockingTaskSettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.extensionSettings+xml", 200);
    }

    public List<BlockingTaskOperationType> getEnabledBlockingTaskOperations() {
        return this.enabledBlockingTaskOperations;
    }

    public static List<BlockingTaskOperationType> getEnabledBlockingTaskOperations(VcloudClient client) throws VCloudException {
        String adminEnabledOperationsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/blockingTask" + "/operations";
        TaskOperationListType taskOperationListType = (TaskOperationListType)SdkUtil.get(client, adminEnabledOperationsUpdateUrl, 200);
        return BlockingTaskOperationType.fromValues(taskOperationListType.getOperation());
    }

    public List<BlockingTaskOperationType> updateEnabledBlockingTaskOperations(List<BlockingTaskOperationType> enabledBlockingTaskOperations) throws VCloudException {
        String adminEnabledOperationsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/blockingTask" + "/operations";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        TaskOperationListType taskOperationListType = new TaskOperationListType();
        taskOperationListType.getOperation().addAll(BlockingTaskOperationType.toValues(enabledBlockingTaskOperations));
        String adminEnabledOperationsListUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createBlockingTaskOperations(taskOperationListType));
        taskOperationListType = (TaskOperationListType)SdkUtil.put(this.client, adminEnabledOperationsUpdateUrl, adminEnabledOperationsListUpdateXml, "application/vnd.vmware.admin.taskOperationList+xml", 200);
        return BlockingTaskOperationType.fromValues(taskOperationListType.getOperation());
    }

    public LookupServiceSettingsType getLookupService() throws VCloudException {
        return this.getResource().getLookupServiceSettings();
    }

    public static LookupServiceSettingsType getLookupService(VcloudClient client) throws VCloudException {
        String adminSettingsLookupServiceUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/lookupService";
        return (LookupServiceSettingsType)SdkUtil.get(client, adminSettingsLookupServiceUrl, 200);
    }

    public Task updateLookupService(LookupServiceParamsType lookupServiceParams) throws VCloudException {
        String adminSettingsLookupServiceUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/lookupService";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createLookupServiceParams(lookupServiceParams));
        return new Task(this.client, (TaskType)SdkUtil.put(this.client, adminSettingsLookupServiceUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.lookupServiceParams+xml", 202));
    }

    public void resetAmqpCertificate() throws VCloudException {
        String resetAmqpCertificateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/amqp" + "/action/resetAmqpCertificate";
        SdkUtil.post(this.client, resetAmqpCertificateUrl, null, null, 204);
    }

    public void resetAmqpTruststore() throws VCloudException {
        String resetAmqpTruststoreUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/amqp" + "/action/resetAmqpTruststore";
        SdkUtil.post(this.client, resetAmqpTruststoreUrl, null, null, 204);
    }

    public CertificateUploadSocketType updateAmqpCertificate(CertificateUpdateParamsType certificateUpdateParamsType) throws VCloudException {
        String updateAmqpCertificateUri = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/amqp" + "/action/updateAmqpCertificate";
        com.vmware.vcloud.api.rest.schema.ObjectFactory objectFactory_v5_1 = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory_v5_1.createCertificateUpdateParams(certificateUpdateParamsType));
        return (CertificateUploadSocketType)SdkUtil.post(this.client, updateAmqpCertificateUri, requestBodyXml, "application/vnd.vmware.admin.certificateUpdateParams+xml", 200);
    }

    public TrustStoreUploadSocketType updateAmqpTruststore(TrustStoreUpdateParamsType trustStoreUpdateParamsType) throws VCloudException {
        String updateAmqpTruststoreUri = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/amqp" + "/action/updateAmqpTruststore";
        com.vmware.vcloud.api.rest.schema.ObjectFactory objectFactory_v5_1 = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory_v5_1.createTrustStoreUpdateParams(trustStoreUpdateParamsType));
        return (TrustStoreUploadSocketType)SdkUtil.post(this.client, updateAmqpTruststoreUri, requestBodyXml, "application/vnd.vmware.admin.trustStoreUpdateParams+xml", 200);
    }

    public void resetVcTrustsore() throws VCloudException {
        String resetVcTrustsoreUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/general" + "/action/resetVcTrustsore";
        SdkUtil.post(this.client, resetVcTrustsoreUrl, null, null, 204);
    }

    public VcTrustStoreUploadSocketType updateVcTrustsore(VcTrustStoreUpdateParamsType vcTrustStoreUpdateParamsType) throws VCloudException {
        String updateVcTrustsoreUri = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/general" + "/action/updateVcTrustsore";
        ObjectFactory objectFactory_v5_1 = new ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory_v5_1.createVcTrustStoreUpdateParams(vcTrustStoreUpdateParamsType));
        return (VcTrustStoreUploadSocketType)SdkUtil.post(this.client, updateVcTrustsoreUri, requestBodyXml, "application/vnd.vmware.admin.vcTrustStoreUpdateParams+xml", 200);
    }

    public void resetLdapCertificate() throws VCloudException {
        String resetLdapCertificateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/ldapSettings" + "/action/resetLdapCertificate";
        SdkUtil.post(this.client, resetLdapCertificateUrl, null, null, 204);
    }

    public void resetLdapKeyStore() throws VCloudException {
        String resetLdapKeyStoreUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/ldapSettings" + "/action/resetLdapKeyStore";
        SdkUtil.post(this.client, resetLdapKeyStoreUrl, null, null, 204);
    }

    public void resetLdapSspiKeytab() throws VCloudException {
        String resetLdapSspiKeytabUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/ldapSettings" + "/action/resetLdapSspiKeytab";
        SdkUtil.post(this.client, resetLdapSspiKeytabUrl, null, null, 204);
    }

    public CertificateUploadSocketType updateLdapCertificate(CertificateUpdateParamsType certificateUpdateParamsType) throws VCloudException {
        String updateLdapCertificateUri = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/ldapSettings" + "/action/updateLdapCertificate";
        com.vmware.vcloud.api.rest.schema.ObjectFactory objectFactory_v5_1 = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory_v5_1.createCertificateUpdateParams(certificateUpdateParamsType));
        return (CertificateUploadSocketType)SdkUtil.post(this.client, updateLdapCertificateUri, requestBodyXml, "application/vnd.vmware.admin.certificateUpdateParams+xml", 200);
    }

    public KeystoreUploadSocketType updateLdapKeyStore(KeystoreUpdateParamsType keystoreUpdateParamsType) throws VCloudException {
        String updateLdapKeyStoreUri = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/ldapSettings" + "/action/updateLdapKeyStore";
        com.vmware.vcloud.api.rest.schema.ObjectFactory objectFactory_v5_1 = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory_v5_1.createKeystoreUpdateParams(keystoreUpdateParamsType));
        return (KeystoreUploadSocketType)SdkUtil.post(this.client, updateLdapKeyStoreUri, requestBodyXml, "application/vnd.vmware.admin.keystoreUpdateParams+xml", 200);
    }

    public SspiKeytabUploadSocketType updateLdapSspiKeytab(SspiKeytabUpdateParamsType sspiKeytabUpdateParamsType) throws VCloudException {
        String updateLdapSspiKeytabUri = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/ldapSettings" + "/action/updateLdapSspiKeytab";
        com.vmware.vcloud.api.rest.schema.ObjectFactory objectFactory_v5_1 = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory_v5_1.createSspiKeytabUpdateParams(sspiKeytabUpdateParamsType));
        return (SspiKeytabUploadSocketType)SdkUtil.post(this.client, updateLdapSspiKeytabUri, requestBodyXml, "application/vnd.vmware.admin.sspiKeytabUpdateParams+xml", 200);
    }

    public CatalogSettingsType getCatalogSettings() throws VCloudException {
        String adminCatalogSettingsUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/catalog";
        return (CatalogSettingsType)SdkUtil.get(this.client, adminCatalogSettingsUrl, 200);
    }

    public static CatalogSettingsType getCatalogSettings(VcloudClient client) throws VCloudException {
        String adminCatalogSettingsUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/catalog";
        return (CatalogSettingsType)SdkUtil.get(client, adminCatalogSettingsUrl, 200);
    }

    public CatalogSettingsType updateCatalogSettings(CatalogSettingsType catalogSettingsParams) throws VCloudException {
        String updateCatalogSettingsUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/catalog";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String updateCatalogSettingsXml = JAXBUtil.marshal(objectFactory_v1_5.createCatalogSettings(catalogSettingsParams));
        return (CatalogSettingsType)SdkUtil.put(this.client, updateCatalogSettingsUrl, updateCatalogSettingsXml, "application/vnd.vmware.admin.catalogSettings+xml", 200);
    }
}

