/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.ControlAccessParamsType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.VMWVdcTemplateType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMWVdcTemplate
extends VcloudEntity<VMWVdcTemplateType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");

    VMWVdcTemplate(VcloudClient client, VMWVdcTemplateType vmwVdcTemplateType) {
        super(client, vmwVdcTemplateType);
    }

    public static VMWVdcTemplate getVMWVdcTemplateByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new VMWVdcTemplate(client, (VMWVdcTemplateType)VMWVdcTemplate.getResourceByReference(client, reference));
    }

    public static VMWVdcTemplate getVMWVdcTemplateById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new VMWVdcTemplate(client, (VMWVdcTemplateType)VMWVdcTemplate.getEntityById(client, vCloudId, "application/vnd.vmware.admin.vmwVdcTemplate+xml"));
    }

    public VMWVdcTemplate updateVMWVdcTemplate(VMWVdcTemplateType vmwVdcTemplateType) throws VCloudException {
        ObjectFactory ofFactory = new ObjectFactory();
        String vmwVdcTemplateUpdateUrl = this.getReference().getHref();
        String vmwVdcTemplateUpdateRequest = JAXBUtil.marshal(ofFactory.createVMWVdcTemplate(vmwVdcTemplateType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + vmwVdcTemplateUpdateUrl);
        return new VMWVdcTemplate(this.getVcloudClient(), (VMWVdcTemplateType)SdkUtil.put(this.getVcloudClient(), vmwVdcTemplateUpdateUrl, vmwVdcTemplateUpdateRequest, "application/vnd.vmware.admin.vmwVdcTemplate+xml", 200));
    }

    public void delete() throws VCloudException {
        String vmwVdcTemplateUrl = this.getReference().getHref();
        VMWVdcTemplate.deleteVMWVdcTemplate(this.getVcloudClient(), vmwVdcTemplateUrl);
    }

    public static void delete(VcloudClient client, ReferenceType vmwVdcTemplateRef) throws VCloudException {
        VMWVdcTemplate.deleteVMWVdcTemplate(client, vmwVdcTemplateRef.getHref());
    }

    private static void deleteVMWVdcTemplate(VcloudClient client, String vmwVdcTemplateUrl) throws VCloudException {
        SdkUtil.delete(client, vmwVdcTemplateUrl, 204);
    }

    public ControlAccessParamsType getControlAccess() throws VCloudException {
        String url = this.getReference().getHref() + "/controlAccess";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        return (ControlAccessParamsType)SdkUtil.get(this.getVcloudClient(), url, 200);
    }

    public ControlAccessParamsType updateControlAccess(ControlAccessParamsType controlAccessParams) throws VCloudException {
        String url = this.getReference().getHref() + "/action/controlAccess";
        com.vmware.vcloud.api.rest.schema.ObjectFactory of = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String requestString = JAXBUtil.marshal(of.createControlAccessParams(controlAccessParams));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + url);
        return (ControlAccessParamsType)SdkUtil.put(this.getVcloudClient(), url, requestString, "application/vnd.vmware.vcloud.controlAccess+xml", 200);
    }
}

