/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.AvailableNetworksType;
import com.vmware.vcloud.api.rest.schema.CaptureVAppParamsType;
import com.vmware.vcloud.api.rest.schema.CatalogItemType;
import com.vmware.vcloud.api.rest.schema.CatalogType;
import com.vmware.vcloud.api.rest.schema.CloneMediaParamsType;
import com.vmware.vcloud.api.rest.schema.CloneVAppParamsType;
import com.vmware.vcloud.api.rest.schema.CloneVAppTemplateParamsType;
import com.vmware.vcloud.api.rest.schema.ComposeVAppParamsType;
import com.vmware.vcloud.api.rest.schema.DiskCreateParamsType;
import com.vmware.vcloud.api.rest.schema.DiskType;
import com.vmware.vcloud.api.rest.schema.InstantiateOvfParamsType;
import com.vmware.vcloud.api.rest.schema.InstantiateVAppTemplateParamsType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.MediaType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.OrgVdcNetworkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.ResourceEntitiesType;
import com.vmware.vcloud.api.rest.schema.ResourceReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.UploadVAppTemplateParamsType;
import com.vmware.vcloud.api.rest.schema.VAppTemplateType;
import com.vmware.vcloud.api.rest.schema.VAppType;
import com.vmware.vcloud.api.rest.schema.VCloudExtensionType;
import com.vmware.vcloud.api.rest.schema.VdcType;
import com.vmware.vcloud.api.rest.schema.VmAffinityRuleType;
import com.vmware.vcloud.api.rest.schema.VmAffinityRulesType;
import com.vmware.vcloud.api.rest.schema.extension.VimObjectRefType;
import com.vmware.vcloud.sdk.Catalog;
import com.vmware.vcloud.sdk.CatalogItem;
import com.vmware.vcloud.sdk.Disk;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.Media;
import com.vmware.vcloud.sdk.OrgVdcNetwork;
import com.vmware.vcloud.sdk.ReferenceResult;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.Vapp;
import com.vmware.vcloud.sdk.VappTemplate;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.ImageType;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.VappStatus;
import com.vmware.vcloud.sdk.constants.VappTemplateStatus;
import com.vmware.vcloud.sdk.constants.VimObjectTypeEnum;
import com.vmware.vcloud.sdk.constants.query.FormatType;
import com.vmware.vcloud.sdk.exception.DuplicateNameException;
import com.vmware.vcloud.sdk.exception.MissingPropertyException;
import com.vmware.vcloud.sdk.exception.ResourceNotAddedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vdc
extends VcloudEntity<VdcType> {
    private static Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private Collection<ReferenceType> vappTemplateRefs;
    private Collection<ReferenceType> mediaRefs;
    private Collection<ReferenceType> storageProfileRefs;
    private Collection<ReferenceType> diskRefs;
    private HashMap<String, ReferenceType> vappRefsByName;
    private HashMap<String, ReferenceType> availableNetworkRefsByName;
    private ReferenceType orgReference;

    Vdc(VcloudClient client, VdcType vdcType_v1_5) {
        super(client, vdcType_v1_5);
        this.sortEntityRefs_v1_5();
    }

    public static Vdc getVdcByReference(VcloudClient client, ReferenceType vdcRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + vdcRef.getHref());
        return new Vdc(client, (VdcType)Vdc.getResourceByReference(client, vdcRef));
    }

    public static Vdc getVdcById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new Vdc(client, (VdcType)Vdc.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.vdc+xml"));
    }

    public VimObjectRefType getResourcePoolVimRef() throws VCloudException {
        for (VCloudExtensionType vcloudExtension : ((VdcType)this.getResource()).getVCloudExtension()) {
            for (Object jaxbObject : vcloudExtension.getAny()) {
                if (!(((JAXBElement)jaxbObject).getValue() instanceof VimObjectRefType) || !((VimObjectRefType)((JAXBElement)jaxbObject).getValue()).getVimObjectType().equals(VimObjectTypeEnum.RESOURCE_POOL.value())) continue;
                return (VimObjectRefType)((JAXBElement)jaxbObject).getValue();
            }
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }

    public ReferenceType getOrgReference() throws VCloudException {
        if (this.orgReference != null) {
            return this.orgReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    private void sortEntityRefs_v1_5() {
        this.vappTemplateRefs = new ArrayList<ReferenceType>();
        this.mediaRefs = new ArrayList<ReferenceType>();
        this.vappRefsByName = new HashMap();
        this.availableNetworkRefsByName = new HashMap();
        this.storageProfileRefs = new ArrayList<ReferenceType>();
        this.diskRefs = new ArrayList<ReferenceType>();
        if (((VdcType)this.getResource()).getResourceEntities() != null) {
            ResourceEntitiesType resEntities = ((VdcType)this.getResource()).getResourceEntities();
            List entities = resEntities.getResourceEntity();
            for (ResourceReferenceType entity : entities) {
                if (entity.getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml")) {
                    this.vappTemplateRefs.add((ReferenceType)entity);
                    continue;
                }
                if (entity.getType().equals("application/vnd.vmware.vcloud.media+xml")) {
                    this.mediaRefs.add((ReferenceType)entity);
                    continue;
                }
                if (entity.getType().equals("application/vnd.vmware.vcloud.vApp+xml")) {
                    this.vappRefsByName.put(entity.getName(), (ReferenceType)entity);
                    continue;
                }
                if (entity.getType().equals("application/vnd.vmware.vcloud.disk+xml")) {
                    this.diskRefs.add((ReferenceType)entity);
                    continue;
                }
                logger.warn(SdkUtil.getI18nString(SdkMessage.UNKNOWN_REF_TYPE_MSG) + " - ", (Object)entity.getType());
            }
        }
        if (((VdcType)this.getResource()).getAvailableNetworks() != null) {
            AvailableNetworksType availableNetworksType = ((VdcType)this.getResource()).getAvailableNetworks();
            for (ReferenceType networkRef : availableNetworksType.getNetwork()) {
                this.availableNetworkRefsByName.put(networkRef.getName(), networkRef);
            }
        }
        for (LinkType vdcLink : ((VdcType)this.getResource()).getLink()) {
            if (!vdcLink.getRel().equals("up") || !vdcLink.getType().equals("application/vnd.vmware.vcloud.org+xml")) continue;
            this.orgReference = vdcLink;
        }
        if (((VdcType)this.getResource()).getVdcStorageProfiles() != null) {
            for (ReferenceType ref : ((VdcType)this.getResource()).getVdcStorageProfiles().getVdcStorageProfile()) {
                this.storageProfileRefs.add(ref);
            }
        }
    }

    public HashMap<String, ReferenceType> getAvailableNetworkRefsByName() {
        return this.availableNetworkRefsByName;
    }

    public ReferenceType getAvailableNetworkRefByName(String name) {
        return this.availableNetworkRefsByName.get(name);
    }

    public Collection<ReferenceType> getAvailableNetworkRefs() {
        return this.availableNetworkRefsByName.values();
    }

    public Collection<ReferenceType> getVappTemplateRefs() {
        return this.vappTemplateRefs;
    }

    public Collection<ReferenceType> getMediaRefs() {
        return this.mediaRefs;
    }

    public Collection<ReferenceType> getDiskRefs() {
        return this.diskRefs;
    }

    public HashMap<String, ReferenceType> getVappRefsByName() {
        return this.vappRefsByName;
    }

    public Collection<ReferenceType> getVappTemplateRefsByName(String vAppTemplateName) {
        ArrayList<ReferenceType> vappTemplateRefs = new ArrayList<ReferenceType>();
        for (ReferenceType vappTemplateRef : this.getVappTemplateRefs()) {
            if (!vappTemplateRef.getName().equalsIgnoreCase(vAppTemplateName)) continue;
            vappTemplateRefs.add(vappTemplateRef);
        }
        return vappTemplateRefs;
    }

    public Collection<ReferenceType> getMediaRefsByName(String mediaName) {
        ArrayList<ReferenceType> mediaRefs = new ArrayList<ReferenceType>();
        for (ReferenceType mediaRef : this.getMediaRefs()) {
            if (!mediaRef.getName().equalsIgnoreCase(mediaName)) continue;
            mediaRefs.add(mediaRef);
        }
        return mediaRefs;
    }

    public ReferenceType getVappRefByName(String name) {
        return this.vappRefsByName.get(name);
    }

    public Collection<ReferenceType> getVappRefs() {
        return this.vappRefsByName.values();
    }

    public VappTemplate createVappTemplate(UploadVAppTemplateParamsType vappTemplParams) throws VCloudException {
        String url = this.getReference().getHref() + "/action/uploadVAppTemplate";
        JAXBElement params = new ObjectFactory().createUploadVAppTemplateParams(vappTemplParams);
        String reqPayload = JAXBUtil.marshal(params);
        return Vdc.executeVappTemplUpload(this.getVcloudClient(), url, reqPayload, "application/vnd.vmware.vcloud.uploadVAppTemplateParams+xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VappTemplate uploadVappTemplate(String vAppTemplateName, String vAppTemplateDesc, String localOvfFileLocation, Boolean manifestRequired, ReferenceType vdcStorageRef, ReferenceType catalogRef) throws VCloudException, DuplicateNameException, ResourceNotAddedException, TimeoutException {
        Catalog catalog = this.checkCatalogForDuplicates(catalogRef, vAppTemplateName);
        UploadVAppTemplateParamsType vappTemplParams = new UploadVAppTemplateParamsType();
        vappTemplParams.setDescription(vAppTemplateDesc);
        vappTemplParams.setName(vAppTemplateName);
        vappTemplParams.setManifestRequired(manifestRequired);
        vappTemplParams.setVdcStorageProfile(vdcStorageRef);
        VappTemplate vappTemplate = this.createVappTemplate(vappTemplParams);
        File ovfFile = new File(localOvfFileLocation);
        String ovfFileName = ovfFile.getName();
        try {
            FileInputStream ovfFileInputStream = new FileInputStream(ovfFile);
            try {
                vappTemplate.uploadOVFFile(ovfFileInputStream, ovfFile.length());
                vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), vappTemplate.getReference());
                while (!((VAppTemplateType)vappTemplate.getResource()).isOvfDescriptorUploaded().booleanValue()) {
                    vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), vappTemplate.getReference());
                }
            }
            finally {
                ovfFileInputStream.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new VCloudRuntimeException(e);
        }
        catch (IOException e) {
            throw new VCloudRuntimeException(e);
        }
        Set<String> vmdkFileNames = vappTemplate.getUploadFileNames();
        for (String vmdkFileName : vmdkFileNames) {
            String vmdkFileLocation = localOvfFileLocation.replace(ovfFileName, vmdkFileName);
            File vmdkFile = new File(vmdkFileLocation);
            try {
                FileInputStream vmdkFileInputStream = new FileInputStream(vmdkFile);
                try {
                    vappTemplate.uploadFile(vmdkFileName, vmdkFileInputStream, vmdkFile.length());
                }
                finally {
                    vmdkFileInputStream.close();
                }
            }
            catch (FileNotFoundException e) {
                throw new VCloudRuntimeException(e);
            }
            catch (IOException e) {
                throw new VCloudRuntimeException(e);
            }
        }
        vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), vappTemplate.getReference());
        while (((VAppTemplateType)vappTemplate.getResource()).getStatus().intValue() == VappTemplateStatus.UNRESOLVED.value()) {
            vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), vappTemplate.getReference());
        }
        this.addResourceToCatalog(vappTemplate.getReference(), catalog);
        vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), vappTemplate.getReference());
        return vappTemplate;
    }

    private Catalog checkCatalogForDuplicates(ReferenceType catalogRef, String resourceName) throws DuplicateNameException, VCloudException {
        Catalog catalog = Catalog.getCatalogByReference(this.getVcloudClient(), catalogRef);
        if (catalog.getCatalogItemRefsByName().containsKey(resourceName)) {
            throw new DuplicateNameException(MessageFormat.format(SdkUtil.getI18nString(SdkMessage.DUPLICATE_NAME), resourceName, ((CatalogType)catalog.getResource()).getName(), ((CatalogType)catalog.getResource()).getHref()));
        }
        return catalog;
    }

    private void addResourceToCatalog(ReferenceType resourceRef, Catalog catalog) throws ResourceNotAddedException, VCloudException, TimeoutException {
        CatalogItem catalogItem;
        CatalogItemType catalogItemType = new CatalogItemType();
        catalogItemType.setName(resourceRef.getName());
        catalogItemType.setEntity(resourceRef);
        try {
            catalogItem = catalog.addCatalogItem(catalogItemType);
        }
        catch (VCloudException e) {
            throw new ResourceNotAddedException(e, resourceRef);
        }
        if (catalogItem.getTasks().size() > 0) {
            catalogItem.getTasks().get(0).waitForTask(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Media uploadMedia(String mediaName, String mediaDescription, ImageType mediaType, String localMediaFile, ReferenceType vdcStorageProfileRef, ReferenceType catalogRef) throws VCloudException, DuplicateNameException, ResourceNotAddedException, TimeoutException {
        Catalog catalog = this.checkCatalogForDuplicates(catalogRef, mediaName);
        File mediaFile = new File(localMediaFile);
        MediaType mediaParams = new MediaType();
        mediaParams.setName(mediaName);
        mediaParams.setDescription(mediaDescription);
        mediaParams.setImageType(mediaType.value());
        mediaParams.setSize(mediaFile.length());
        mediaParams.setVdcStorageProfile(vdcStorageProfileRef);
        Media media = this.createMedia(mediaParams);
        String uploadMediaFileName = media.getUploadFileNames().iterator().next();
        try {
            FileInputStream mediaInputStream = new FileInputStream(mediaFile);
            try {
                media.uploadFile(uploadMediaFileName, mediaInputStream, mediaFile.length());
            }
            finally {
                mediaInputStream.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new VCloudRuntimeException(e);
        }
        catch (IOException e) {
            throw new VCloudRuntimeException(e);
        }
        while (((MediaType)media.getResource()).getStatus() == 0) {
            media = Media.getMediaByReference(this.getVcloudClient(), media.getReference());
        }
        this.addResourceToCatalog(media.getReference(), catalog);
        media = Media.getMediaByReference(this.getVcloudClient(), media.getReference());
        return media;
    }

    public Media createMedia(MediaType mediaParams) throws VCloudException {
        String url = this.getReference().getHref() + "/media/";
        JAXBElement params = new ObjectFactory().createMedia(mediaParams);
        String reqPayload = JAXBUtil.marshal(params);
        return new Media(this.getVcloudClient(), (MediaType)SdkUtil.post(this.getVcloudClient(), url, reqPayload, "application/vnd.vmware.vcloud.media+xml", 201));
    }

    private static VappTemplate executeVappTemplUpload(VcloudClient client, String vdcActionUrl, String reqPayload, String contentType) throws VCloudException {
        return new VappTemplate(client, (VAppTemplateType)SdkUtil.post(client, vdcActionUrl, reqPayload, contentType, 201));
    }

    public Vapp composeVapp(ComposeVAppParamsType composeVappParamsType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement composeVappParams = of.createComposeVAppParams(composeVappParamsType);
        String requestBodyXml = JAXBUtil.marshal(composeVappParams);
        String postURL = this.getReference().getHref() + "/action/composeVApp";
        return new Vapp(this.getVcloudClient(), (VAppType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.composeVAppParams+xml", 201));
    }

    public VappTemplate captureVapp(CaptureVAppParamsType captureVappParamsType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement captureVappParams = of.createCaptureVAppParams(captureVappParamsType);
        String requestBodyXml = JAXBUtil.marshal(captureVappParams);
        String postURL = this.getReference().getHref() + "/action/captureVApp";
        return new VappTemplate(this.getVcloudClient(), (VAppTemplateType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.captureVAppParams+xml", 201));
    }

    public VappTemplate captureVapp(CaptureVAppParamsType captureVappParamsType, ReferenceType catalogRef) throws VCloudException, DuplicateNameException, ResourceNotAddedException, TimeoutException, MissingPropertyException {
        if (captureVappParamsType.getName() == null) {
            throw new MissingPropertyException(MessageFormat.format(SdkUtil.getI18nString(SdkMessage.MISSING_PROPERTY), "name", CaptureVAppParamsType.class.getSimpleName()));
        }
        Catalog catalog = this.checkCatalogForDuplicates(catalogRef, captureVappParamsType.getName());
        VappTemplate vappTemplate = this.captureVapp(captureVappParamsType);
        this.addResourceToCatalog(vappTemplate.getReference(), catalog);
        vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), vappTemplate.getReference());
        return vappTemplate;
    }

    public Vapp instantiateVappTemplate(InstantiateVAppTemplateParamsType instVappTemplParamsType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement instVappParams = of.createInstantiateVAppTemplateParams(instVappTemplParamsType);
        String requestBodyXml = JAXBUtil.marshal(instVappParams);
        String postURL = this.getReference().getHref() + "/action/instantiateVAppTemplate";
        return new Vapp(this.getVcloudClient(), (VAppType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml", 201));
    }

    public Vapp cloneVapp(CloneVAppParamsType cloneVappParamsType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement cloneVappParams = of.createCloneVAppParams(cloneVappParamsType);
        String requestBodyXml = JAXBUtil.marshal(cloneVappParams);
        String postURL = this.getReference().getHref() + "/action/cloneVApp";
        return new Vapp(this.getVcloudClient(), (VAppType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.cloneVAppParams+xml", 201));
    }

    public VappTemplate cloneVappTemplate(CloneVAppTemplateParamsType cloneVappTemplateParamsType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement cloneVappParams = of.createCloneVAppTemplateParams(cloneVappTemplateParamsType);
        String requestBodyXml = JAXBUtil.marshal(cloneVappParams);
        String postURL = this.getReference().getHref() + "/action/cloneVAppTemplate";
        return new VappTemplate(this.getVcloudClient(), (VAppTemplateType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.cloneVAppTemplateParams+xml", 201));
    }

    public Media cloneMedia(CloneMediaParamsType cloneMediaParamsType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement cloneMediaParams = of.createCloneMediaParams(cloneMediaParamsType);
        String requestBodyXml = JAXBUtil.marshal(cloneMediaParams);
        String postURL = this.getReference().getHref() + "/action/cloneMedia";
        return new Media(this.getVcloudClient(), (MediaType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.cloneMediaParams+xml", 201));
    }

    public VappTemplate cloneVappTemplate(CloneVAppTemplateParamsType cloneVappTemplateParamsType, ReferenceType catalogRef) throws VCloudException, DuplicateNameException, MissingPropertyException, ResourceNotAddedException, TimeoutException {
        if (cloneVappTemplateParamsType.getName() == null) {
            throw new MissingPropertyException(MessageFormat.format(SdkUtil.getI18nString(SdkMessage.MISSING_PROPERTY), "name", CloneVAppTemplateParamsType.class.getSimpleName()));
        }
        Catalog catalog = this.checkCatalogForDuplicates(catalogRef, cloneVappTemplateParamsType.getName());
        VappTemplate vappTemplate = this.cloneVappTemplate(cloneVappTemplateParamsType);
        this.addResourceToCatalog(vappTemplate.getReference(), catalog);
        vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), vappTemplate.getReference());
        return vappTemplate;
    }

    public Media cloneMedia(CloneMediaParamsType cloneMediaParamsType, ReferenceType catalogRef) throws VCloudException, DuplicateNameException, MissingPropertyException, ResourceNotAddedException, TimeoutException {
        if (cloneMediaParamsType.getName() == null) {
            throw new MissingPropertyException(MessageFormat.format(SdkUtil.getI18nString(SdkMessage.MISSING_PROPERTY), "name", CloneMediaParamsType.class.getSimpleName()));
        }
        Catalog catalog = this.checkCatalogForDuplicates(catalogRef, cloneMediaParamsType.getName());
        Media media = this.cloneMedia(cloneMediaParamsType);
        this.addResourceToCatalog(media.getReference(), catalog);
        media = Media.getMediaByReference(this.getVcloudClient(), media.getReference());
        return media;
    }

    public Collection<ReferenceType> getVdcStorageProfileRefs() {
        return this.storageProfileRefs;
    }

    public Disk createDisk(DiskCreateParamsType diskCreateParams) throws VCloudException {
        JAXBElement diskMediaParams = new ObjectFactory().createDiskCreateParams(diskCreateParams);
        String requestBodyXml = JAXBUtil.marshal(diskMediaParams);
        String postURL = this.getReference().getHref() + "/disk";
        return new Disk(this.getVcloudClient(), (DiskType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.diskCreateParams+xml", 201));
    }

    public Vapp instantiateOvf(InstantiateOvfParamsType instantiateOvfParams) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement instOvfParams = of.createInstantiateOvfParams(instantiateOvfParams);
        String requestBodyXml = JAXBUtil.marshal(instOvfParams);
        String postURL = this.getReference().getHref() + "/action/instantiateOvf";
        return new Vapp(this.getVcloudClient(), (VAppType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.instantiateOvfParams+xml", 201));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vapp uploadVapp(InstantiateOvfParamsType InstantiateOvfParamsType2, String localOvfFileLocation) throws VCloudException {
        Vapp vapp = this.instantiateOvf(InstantiateOvfParamsType2);
        File ovfFile = new File(localOvfFileLocation);
        String ovfFileName = ovfFile.getName();
        try {
            FileInputStream ovfFileInputStream = new FileInputStream(ovfFile);
            try {
                vapp.uploadOVFFile(ovfFileInputStream, ovfFile.length());
                vapp = Vapp.getVappByReference(this.getVcloudClient(), vapp.getReference());
                while (!((VAppType)vapp.getResource()).isOvfDescriptorUploaded().booleanValue()) {
                    vapp = Vapp.getVappByReference(this.getVcloudClient(), vapp.getReference());
                }
            }
            finally {
                ovfFileInputStream.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new VCloudRuntimeException(e);
        }
        catch (IOException e) {
            throw new VCloudRuntimeException(e);
        }
        Set<String> vmdkFileNames = vapp.getUploadFileNames();
        for (String vmdkFileName : vmdkFileNames) {
            String vmdkFileLocation = localOvfFileLocation.replace(ovfFileName, vmdkFileName);
            File vmdkFile = new File(vmdkFileLocation);
            try {
                FileInputStream vmdkFileInputStream = new FileInputStream(vmdkFile);
                try {
                    vapp.uploadFile(vmdkFileName, vmdkFileInputStream, vmdkFile.length());
                }
                finally {
                    vmdkFileInputStream.close();
                }
            }
            catch (FileNotFoundException e) {
                throw new VCloudRuntimeException(e);
            }
            catch (IOException e) {
                throw new VCloudRuntimeException(e);
            }
        }
        vapp = Vapp.getVappByReference(this.getVcloudClient(), vapp.getReference());
        while (((VAppType)vapp.getResource()).getStatus().intValue() == VappStatus.UNRESOLVED.value()) {
            vapp = Vapp.getVappByReference(this.getVcloudClient(), vapp.getReference());
        }
        vapp = Vapp.getVappByReference(this.getVcloudClient(), vapp.getReference());
        return vapp;
    }

    public OrgVdcNetwork createOrgVdcNetwork(OrgVdcNetworkType orgVdcNetworkParams) throws VCloudException, MissingPropertyException {
        String requestXml = JAXBUtil.marshal(new ObjectFactory().createOrgVdcNetwork(orgVdcNetworkParams));
        for (LinkType link : ((VdcType)this.getResource()).getLink()) {
            if (!link.getRel().equals("orgVdcNetworks")) continue;
            return new OrgVdcNetwork(this.getVcloudClient(), (OrgVdcNetworkType)SdkUtil.post(this.getVcloudClient(), link.getHref(), requestXml, "application/vnd.vmware.vcloud.orgVdcNetwork+xml", 201));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.LINK_NOT_FOUND_MSG));
    }

    public ReferenceResult getEdgeGatewayRefs() throws VCloudException {
        for (LinkType link : ((VdcType)this.getResource()).getLink()) {
            if (!link.getRel().equals("edgeGateways")) continue;
            String query = link.getHref() + "?" + this.getVcloudClient().getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
            return (ReferenceResult)this.getVcloudClient().getQueryService().executeQuery(query);
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.LINK_NOT_FOUND_MSG));
    }

    public Task updateVdc(VdcType vdcParams) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String vdcUpdateUrl = this.getReference().getHref();
        String vdcRequestXmlString = JAXBUtil.marshal(of.createVdc(vdcParams));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + vdcUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), vdcUpdateUrl, vdcRequestXmlString, "application/vnd.vmware.vcloud.vdc+xml", 202));
    }

    public Task delete() throws VCloudException {
        String vdcUrl = this.getReference().getHref();
        return Vdc.deleteVdc(this.getVcloudClient(), vdcUrl);
    }

    public static Task delete(VcloudClient client, ReferenceType vdcRef) throws VCloudException {
        return Vdc.deleteVdc(client, vdcRef.getHref());
    }

    private static Task deleteVdc(VcloudClient client, String vdcUrl) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, vdcUrl, 202));
    }

    public List<VmAffinityRuleType> getVmAffinityRules() throws VCloudException {
        String url = this.getReference().getHref() + "/vmAffinityRules";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VmAffinityRulesType VmAffinityRules = (VmAffinityRulesType)SdkUtil.get(this.getVcloudClient(), url, 200);
        return VmAffinityRules.getVmAffinityRule();
    }

    public TaskType createVmAffinityRule(VmAffinityRuleType vmAffinityRuleType) throws VCloudException {
        ObjectFactory objectFactory = new ObjectFactory();
        String requestString = JAXBUtil.marshal(objectFactory.createVmAffinityRule(vmAffinityRuleType));
        String postURL = this.getReference().getHref() + "/vmAffinityRules";
        return (TaskType)SdkUtil.post(this.getVcloudClient(), postURL, requestString, "application/vnd.vmware.vcloud.vmaffinityrule+xml", 202);
    }
}

