/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.MetadataEntryType;
import com.vmware.vcloud.api.rest.schema.MetadataType;
import com.vmware.vcloud.api.rest.schema.MetadataValueType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudResource;
import com.vmware.vcloud.sdk.constants.MetadataDomain;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metadata
extends VcloudResource<MetadataType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private HashMap<String, String> metadataEntries;
    private List<MetadataEntryType> typedMetadataEntries;

    public Metadata(VcloudClient client, MetadataType metadataType) {
        super(client, metadataType);
        this.sortMetadataEntries();
        this.sortTypedMetadataEntries();
    }

    private void sortMetadataEntries() {
        this.metadataEntries = new HashMap();
        for (MetadataEntryType metadataEntry : ((MetadataType)this.getResource()).getMetadataEntry()) {
            if (metadataEntry.getValue() == null || metadataEntry.getDomain() != null) continue;
            this.metadataEntries.put(metadataEntry.getKey(), metadataEntry.getValue());
        }
    }

    private void sortTypedMetadataEntries() {
        this.typedMetadataEntries = new ArrayList<MetadataEntryType>();
        for (MetadataEntryType metadataEntry : ((MetadataType)this.getResource()).getMetadataEntry()) {
            if (metadataEntry.getValue() != null) continue;
            this.typedMetadataEntries.add(metadataEntry);
        }
    }

    public String getMetadataEntry(String key) throws VCloudException {
        if (this.metadataEntries.containsKey(key)) {
            return this.metadataEntries.get(key);
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
    }

    public MetadataEntryType getTypedMetadataEntry(String key) throws VCloudException {
        for (MetadataEntryType typedMetadata : this.typedMetadataEntries) {
            if (!typedMetadata.getKey().equals(key) || typedMetadata.getDomain() != null) continue;
            return typedMetadata;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
    }

    public MetadataEntryType getTypedMetadataEntry(String key, MetadataDomain domain) throws VCloudException {
        if (domain != null && key != null) {
            for (MetadataEntryType typedMetadata : this.typedMetadataEntries) {
                if (!typedMetadata.getKey().equals(key) || !typedMetadata.getDomain().getValue().equals(domain.value())) continue;
                return typedMetadata;
            }
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
    }

    public HashMap<String, String> getMetadataEntries() {
        return this.metadataEntries;
    }

    public List<MetadataEntryType> getTypedMetadataEntries() {
        return this.typedMetadataEntries;
    }

    public Task updateMetadataEntries(HashMap<String, String> metadataEntries) throws VCloudException {
        MetadataType metadataType = new MetadataType();
        List updateMetadataEntires = metadataType.getMetadataEntry();
        for (String key : metadataEntries.keySet()) {
            MetadataEntryType metadataEntryType = new MetadataEntryType();
            metadataEntryType.setKey(key);
            metadataEntryType.setValue(metadataEntries.get(key));
            updateMetadataEntires.add(metadataEntryType);
        }
        String updateXML = JAXBUtil.marshal(new ObjectFactory().createMetadata(metadataType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + this.getReference().getHref());
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref(), updateXML, "application/vnd.vmware.vcloud.metadata+xml", 202));
    }

    public Task updateTypedMetadataEntries(List<MetadataEntryType> metadataEntries) throws VCloudException {
        MetadataType metadataType = new MetadataType();
        metadataType.getMetadataEntry().addAll(metadataEntries);
        String updateXML = JAXBUtil.marshal(new ObjectFactory().createMetadata(metadataType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + this.getReference().getHref());
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref(), updateXML, "application/vnd.vmware.vcloud.metadata+xml", 202));
    }

    public Task updateMetadataEntry(String key, String value) throws VCloudException {
        String url = Metadata.encodeUrl(this.getReference().getHref(), key);
        MetadataValueType metadataValue = new MetadataValueType();
        metadataValue.setValue(value);
        String updateXML = JAXBUtil.marshal(new ObjectFactory().createMetadataValue(metadataValue));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + url);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), url, updateXML, "application/vnd.vmware.vcloud.metadata.value+xml", 202));
    }

    public Task updateTypedMetadataEntry(MetadataEntryType typedMetadataEntry) throws VCloudException {
        ArrayList<MetadataEntryType> metadatas = new ArrayList<MetadataEntryType>();
        metadatas.add(typedMetadataEntry);
        return this.updateTypedMetadataEntries(metadatas);
    }

    public Task deleteMetadataEntry(String key) throws VCloudException {
        String url = Metadata.encodeUrl(this.getReference().getHref(), key);
        logger.info(SdkUtil.getI18nString(SdkMessage.DELETE_URL_MSG) + " - " + url);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.delete(this.getVcloudClient(), url, 202));
    }

    public Task deleteTypedMetadataEntry(String key) throws VCloudException {
        MetadataEntryType metadataEntry = this.getTypedMetadataEntry(key);
        logger.info(SdkUtil.getI18nString(SdkMessage.DELETE_URL_MSG) + " - " + metadataEntry.getHref());
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.delete(this.getVcloudClient(), metadataEntry.getHref(), 202));
    }

    public Task deleteTypedMetadataEntry(String key, MetadataDomain domain) throws VCloudException {
        MetadataEntryType metadataEntry = this.getTypedMetadataEntry(key, domain);
        logger.info(SdkUtil.getI18nString(SdkMessage.DELETE_URL_MSG) + " - " + metadataEntry.getHref());
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.delete(this.getVcloudClient(), metadataEntry.getHref(), 202));
    }

    public static String getMetadataEntry(VcloudClient client, ReferenceType entityRef, String key) throws VCloudException {
        String url = Metadata.encodeUrl(entityRef.getHref() + "/metadata", key);
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        return ((MetadataValueType)SdkUtil.get(client, url, 200)).getValue();
    }

    public static HashMap<String, String> getMetadataEntries(VcloudClient client, ReferenceType entityRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + entityRef.getHref() + "/metadata");
        MetadataType metadataType = (MetadataType)SdkUtil.get(client, entityRef.getHref() + "/metadata", 200);
        HashMap<String, String> metadataEntries = new HashMap<String, String>();
        for (MetadataEntryType metadataEntry : metadataType.getMetadataEntry()) {
            metadataEntries.put(metadataEntry.getKey(), metadataEntry.getValue());
        }
        return metadataEntries;
    }

    public static Task updateMetadataEntry(VcloudClient client, ReferenceType entityRef, String key, String value) throws VCloudException {
        String url = Metadata.encodeUrl(entityRef.getHref() + "/metadata", key);
        MetadataValueType metadataValue = new MetadataValueType();
        metadataValue.setValue(value);
        String updateXML = JAXBUtil.marshal(new ObjectFactory().createMetadataValue(metadataValue));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + url);
        return new Task(client, (TaskType)SdkUtil.put(client, url, updateXML, "application/vnd.vmware.vcloud.metadata.value+xml", 202));
    }

    public static Task deleteMetadataEntry(VcloudClient client, ReferenceType entityRef, String key) throws VCloudException {
        String url = Metadata.encodeUrl(entityRef.getHref() + "/metadata", key);
        logger.info(SdkUtil.getI18nString(SdkMessage.DELETE_URL_MSG) + " - " + url);
        return new Task(client, (TaskType)SdkUtil.delete(client, url, 202));
    }

    private static String encodeUrl(String url, String key) {
        try {
            URI uri = new URI(url);
            URI encodedUrl = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath() + "/" + key, uri.getQuery(), uri.getFragment());
            return encodedUrl.toURL().toString();
        }
        catch (URISyntaxException e) {
            throw new VCloudRuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new VCloudRuntimeException(e);
        }
    }
}

