/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ApiDefinitionType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.QueryResultFileDescriptorRecordType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.sdk.RecordResult;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.query.FormatType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiDefinition
extends VcloudEntity<ApiDefinitionType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType serviceRef;

    ApiDefinition(VcloudClient client, ApiDefinitionType apiDefinitionParams) {
        super(client, apiDefinitionParams);
        this.sortApiDefinitionRefs();
    }

    private void sortApiDefinitionRefs() {
        if (this.getResource() != null) {
            for (LinkType link : ((ApiDefinitionType)this.getResource()).getLink()) {
                if (!link.getRel().equals("up") || !link.getType().equals("application/vnd.vmware.vcloud.service+xml")) continue;
                this.serviceRef = link;
            }
        }
    }

    public static ApiDefinition getApiDefinitionByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new ApiDefinition(client, (ApiDefinitionType)ApiDefinition.getResourceByReference(client, reference));
    }

    public static ApiDefinition getApiDefinitionById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new ApiDefinition(client, (ApiDefinitionType)ApiDefinition.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.apidefinition+xml"));
    }

    public RecordResult<QueryResultFileDescriptorRecordType> getFileDescriptorRecords() throws VCloudException {
        String query = this.getReference().getHref() + "/files" + "?" + this.getVcloudClient().getQueryService().buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.getVcloudClient().getQueryService().executeQuery(query);
    }

    public ReferenceType getServiceReference() throws VCloudException {
        if (this.serviceRef != null) {
            return this.serviceRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

