'use strict'

const fs = require('fs');
const Path = require('path');

let outPath = '';
let allDependencies = _getDependencies(Path.normalize(`${__dirname}/..`));
allDependencies = JSON.stringify(allDependencies, null, 2);

if (process.argv && process.argv.length) {
  process.argv.forEach(argv => {
    if (argv.indexOf("--out") > -1) {
      outPath = argv.split("=")[1];
    }
  });
}

if (outPath) {
  try {
    fs.writeFileSync(outPath, allDependencies);
    console.log(`The dependencies is written in the ${outPath}`);
    process.exit();
  } catch (e) {
    console.error(e);
  }
}

console.log(allDependencies);

function _getDependencies(path) {
  if (!path) return null;
  path = `${path}/node_modules`;
  if (!fs.existsSync(path)) return null;
  const folders = fs.readdirSync(path, { withFileTypes: true });
  if (!folders || !folders.length) return null;
  const dependencies = {};

  folders.forEach(folder => {
    if (!folder.isDirectory()) return;
    let packagesJSON = null;
    try {
      packagesJSON = require(`${path}/${folder.name}/package.json`);
    } catch (e) { }
    if (!packagesJSON) return;
    dependencies[`${packagesJSON.name}@${packagesJSON.version}`] = _getDependencies(`${path}/${folder.name}`)
  });
  return dependencies;
}