/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm.sampling;

import com.eg.jtm.sampling.Sample;
import com.eg.jtm.sampling.SamplingFilter;
import com.eg.jtm.sampling.SamplingMethodInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StackTraceAnalyzer {
    private ArrayList<Sample> sampleList;
    private String baseMethod;
    private long totalTime = 0L;
    private int callOrder = 0;
    int initialStackOrder = 0;
    private LinkedHashMap<String, SamplingMethodInfo> methodInfoMainMap = new LinkedHashMap();
    private HashMap<String, Integer> uniqueMethodNameCountMap = new HashMap();
    public static final String loggerDispStr = "[StackTraceAnalyzer]";

    public StackTraceAnalyzer(ArrayList<Sample> arrayList, String string) {
        this.sampleList = arrayList;
        this.baseMethod = string;
    }

    public void analyze(SamplingFilter samplingFilter) {
        if (this.sampleList != null && this.sampleList.size() > 0) {
            this.sample(samplingFilter);
        }
    }

    private void sample(SamplingFilter samplingFilter) {
        Sample sample = null;
        for (int i = 0; i < this.sampleList.size(); ++i) {
            Sample sample2 = this.sampleList.get(i);
            Sample sample3 = i < this.sampleList.size() - 1 ? this.sampleList.get(i + 1) : null;
            long l = this.getIntervalPeriod(sample, sample2);
            this.totalTime += l;
            StackTraceElement[] stackTraceElementArray = sample2.getStackTraceElement();
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            StackTraceElement[] stackTraceElementArray2 = null;
            int n = -1;
            if (sample3 != null) {
                stackTraceElementArray2 = sample3.getStackTraceElement();
                n = stackTraceElementArray2.length - 1;
            }
            samplingFilter.doneBaseMethodVisited();
            SamplingMethodInfo samplingMethodInfo = null;
            for (int j = stackTraceElementArray.length - 1; j >= 0; --j) {
                Serializable serializable;
                StackTraceElement stackTraceElement = stackTraceElementArray[j];
                String string = stackTraceElement.getClassName() + "#" + stackTraceElement.getMethodName();
                if (!bl) {
                    if (sample3 == null || n == -1) {
                        bl = true;
                    } else if (n > -1) {
                        serializable = stackTraceElementArray2[n];
                        bl = this.doesNextSampleContainsSameMethod(stackTraceElement, (StackTraceElement)serializable);
                    }
                }
                serializable = this.getUniqueMethodNameCount(stackTraceElement.toString(), bl);
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append(string).append(serializable).append(stringBuilder.toString());
                stringBuilder.append(stackTraceElement.getLineNumber());
                if (samplingFilter.filter(this.baseMethod, stackTraceElement) || j == 0) {
                    samplingMethodInfo = this.getMethodInfo(stringBuilder2.toString(), samplingMethodInfo);
                    this.updateMethodInfoData(l, samplingMethodInfo, j, string);
                }
                --n;
            }
            sample = sample2;
        }
    }

    private int getUniqueMethodNameCount(String string, boolean bl) {
        if (this.uniqueMethodNameCountMap.get(string) == null) {
            this.uniqueMethodNameCountMap.put(string, 1);
            return this.uniqueMethodNameCountMap.get(string);
        }
        int n = this.uniqueMethodNameCountMap.get(string);
        if (bl) {
            this.uniqueMethodNameCountMap.put(string, n + 1);
        }
        return n;
    }

    private static Object processInputFile(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("FileNotFoundException while reading the sample file");
            return null;
        }
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(fileInputStream);
        }
        catch (IOException iOException) {
            System.err.println("IOException while reading the sample file. File may not be a valid serialized object file or a corrupted file");
            return null;
        }
        Object object = null;
        try {
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class of a sample object cannot be found");
        }
        catch (IOException iOException) {
            System.err.println("IOException while reading the sample object");
        }
        return object;
    }

    private boolean doesNextSampleContainsSameMethod(StackTraceElement stackTraceElement, StackTraceElement stackTraceElement2) {
        boolean bl = !this.getFMNString(stackTraceElement).equals(this.getFMNString(stackTraceElement2));
        return bl;
    }

    private void updateMethodInfoData(long l, SamplingMethodInfo samplingMethodInfo, int n, String string) {
        long l2;
        if (n == 0) {
            l2 = samplingMethodInfo.getSelftime() + l;
            samplingMethodInfo.setSelftime(l2);
        } else {
            l2 = samplingMethodInfo.getParenttime() + l;
            samplingMethodInfo.setParenttime(l2);
        }
        l2 = samplingMethodInfo.getStarttime();
        if (l2 == -1L) {
            samplingMethodInfo.setStarttime(this.totalTime);
        }
        samplingMethodInfo.setMethodName(string);
    }

    private long getIntervalPeriod(Sample sample, Sample sample2) {
        return sample != null ? sample2.getSampleStartTime() - sample.getSampleStartTime() : 0L;
    }

    public LinkedList<ArrayList> getCallTreeData() {
        LinkedList<ArrayList> linkedList = new LinkedList<ArrayList>();
        Set<Map.Entry<String, SamplingMethodInfo>> set = this.methodInfoMainMap.entrySet();
        ArrayList<Map.Entry<String, SamplingMethodInfo>> arrayList = new ArrayList<Map.Entry<String, SamplingMethodInfo>>(set);
        for (Map.Entry<String, SamplingMethodInfo> entry : arrayList) {
            linkedList.add(entry.getValue().getSingleRowDetails(this.totalTime));
        }
        for (Map.Entry<String, SamplingMethodInfo> entry : set) {
            SamplingMethodInfo samplingMethodInfo = entry.getValue();
            this.traverse(samplingMethodInfo, linkedList);
        }
        return linkedList;
    }

    private SamplingMethodInfo getMethodInfo(String string, SamplingMethodInfo samplingMethodInfo) {
        SamplingMethodInfo samplingMethodInfo2 = this.methodInfoMainMap.get(string);
        LinkedHashMap<String, SamplingMethodInfo> linkedHashMap = this.methodInfoMainMap;
        if (samplingMethodInfo != null) {
            linkedHashMap = samplingMethodInfo.childMethods;
        }
        if ((samplingMethodInfo2 = linkedHashMap.get(string)) == null) {
            samplingMethodInfo2 = new SamplingMethodInfo();
            if (samplingMethodInfo == null) {
                samplingMethodInfo2.setStackOrder(String.valueOf(this.initialStackOrder++));
            } else {
                samplingMethodInfo2.setStackOrder(samplingMethodInfo.getStackOrder() + "." + samplingMethodInfo.childMethods.size());
            }
            samplingMethodInfo2.setCallOrder(++this.callOrder);
            linkedHashMap.put(string, samplingMethodInfo2);
        }
        return samplingMethodInfo2;
    }

    private String getFMNString(StackTraceElement stackTraceElement) {
        return stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
    }

    public LinkedList<ArrayList> traverse(SamplingMethodInfo samplingMethodInfo, LinkedList<ArrayList> linkedList) {
        if (samplingMethodInfo.childMethods.size() > 0) {
            LinkedHashMap<String, SamplingMethodInfo> linkedHashMap = samplingMethodInfo.childMethods;
            Set<Map.Entry<String, SamplingMethodInfo>> set = linkedHashMap.entrySet();
            ArrayList<Map.Entry<String, SamplingMethodInfo>> arrayList = new ArrayList<Map.Entry<String, SamplingMethodInfo>>(set);
            Collections.reverse(arrayList);
            for (Map.Entry<String, SamplingMethodInfo> entry : arrayList) {
                linkedList.add(entry.getValue().getSingleRowDetails(this.totalTime));
            }
            for (Map.Entry<String, SamplingMethodInfo> entry : arrayList) {
                this.traverse(entry.getValue(), linkedList);
            }
        }
        return linkedList;
    }
}

