/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BaseDatabaseInfo;
import com.eg.jtm.OracleKeyValue;
import com.eg.jtm.OracleNetConnectionDescriptorParser;
import com.eg.jtm.StringMaker;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabaseInfo
extends BaseDatabaseInfo {
    private static final String URL_PREFIX = "jdbc:oracle:";
    private static final String DATADIRECT_URL_PREFIX = "jdbc:datadirect:oracle://";
    private boolean isUrlRAC = false;
    private static final String DEFAULT_PORT = "1521";
    private List<HashMap<String, String>> hostList = null;

    public OracleDatabaseInfo(String string, String string2, Logger logger) {
        super(string, string2, logger);
    }

    @Override
    public Hashtable<String, String> getDBInfo() {
        this.parseUrl();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = this.isParsingFailure();
        String string = this.getDataBaseType();
        if (bl) {
            hashtable.put("SERVERTYPE", string);
            hashtable.put("SERVERNAME", this.jdbcUrl);
            hashtable.put("DATABASENAME", "-");
            hashtable.put("PORTNUMBER", "-");
        } else {
            String string2 = this.getDataBaseName();
            String string3 = this.getHostName();
            String string4 = this.getPortNo();
            String string5 = null;
            List<HashMap<String, String>> list = this.getHostList();
            if (list != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < list.size(); ++i) {
                    HashMap<String, String> hashMap = list.get(i);
                    String string6 = hashMap.get("host");
                    String string7 = hashMap.get("port");
                    if (string7 == null) {
                        string7 = DEFAULT_PORT;
                    }
                    stringBuffer.append(string6).append(":").append(string7).append(",");
                }
                string5 = stringBuffer.toString();
                if (string5.endsWith(",")) {
                    string5 = string5.substring(0, string5.lastIndexOf(","));
                }
            }
            if (string2 == null) {
                string2 = "-";
            }
            if (string3 == null) {
                string3 = this.jdbcUrl;
            }
            if (string4 == null) {
                string4 = "-";
            }
            hashtable.put("SERVERTYPE", string);
            hashtable.put("DATABASENAME", string2);
            if (list != null) {
                hashtable.put("SERVERNAME", string5);
            } else {
                hashtable.put("SERVERNAME", string3);
            }
            hashtable.put("PORTNUMBER", string4);
        }
        return hashtable;
    }

    private String getHostName() {
        return this.hostName;
    }

    private String getDataBaseType() {
        if (this.isUrlRAC && this.hostList != null && this.hostList.size() > 1) {
            return "Oracle_cluster_service";
        }
        return this.dbType;
    }

    private String getDataBaseName() {
        return this.databaseName;
    }

    private String getJdbcUrl() {
        return this.jdbcUrl;
    }

    private String getPortNo() {
        return this.portNo;
    }

    private boolean isCluterType() {
        return this.hostList != null && this.hostList.size() > 1;
    }

    private boolean isParsingFailure() {
        return this.isParsingFailure;
    }

    private List<HashMap<String, String>> getHostList() {
        return this.hostList;
    }

    private void parseUrl() {
        if (this.jdbcUrl == null) {
            this.logger.warn("[" + this.dbType + " - parseUrl] jdbcUrl must not be null");
            return;
        }
        String string = this.jdbcUrl.toLowerCase();
        if (!string.startsWith("jdbc:")) {
            string = "jdbc:" + string;
        }
        StringMaker stringMaker = new StringMaker(string);
        if (string.startsWith(URL_PREFIX)) {
            stringMaker.after(URL_PREFIX).after(":");
            String string2 = stringMaker.after('@').value().trim();
            this.logger.debug("[" + this.dbType + " - parseUrl] description :" + string2);
            if (string2.startsWith("(")) {
                this.isUrlRAC = true;
                this.parseNetConnectionUrl();
            } else {
                this.parseSimpleUrl(string2);
            }
        } else if (string.startsWith(DATADIRECT_URL_PREFIX)) {
            stringMaker.after(DATADIRECT_URL_PREFIX);
            this.parseWeblogicConnectionUrl(stringMaker, DEFAULT_PORT);
            if (this.databaseName == null) {
                this.databaseName = "-";
            }
        }
    }

    private void parseSimpleUrl(String string) {
        int n;
        int n2;
        this.logger.debug("[" + this.dbType + " - parseSimpleUrl]- sourceString :" + string);
        if (string.startsWith("[")) {
            this.parseIPv6Url(string);
            return;
        }
        if (string.startsWith("///")) {
            this.hostName = "localhost";
            this.portNo = DEFAULT_PORT;
            this.databaseName = string.substring(3);
            this.logger.debug("[" + this.dbType + " - parseSimpleUrl]-  hostName :" + this.hostName + "  " + this.portNo + "  " + this.databaseName);
            return;
        }
        if (string.startsWith("//")) {
            string = string.substring(2);
        } else {
            n2 = string.indexOf("//");
            n = string.indexOf("=");
            if (n > 0 || n2 > 2) {
                this.isParsingFailure = true;
                this.logger.warn("[" + this.dbType + " - parseSimpleUrl] JDBC Url format is different, so not parsing , " + this.jdbcUrl);
                return;
            }
        }
        n2 = string.lastIndexOf("/");
        if (n2 > 0) {
            this.databaseName = string.substring(n2 + 1);
            string = string.substring(0, n2);
        } else {
            n = string.lastIndexOf(":");
            if (n > 0) {
                this.databaseName = string.substring(n + 1);
                string = string.substring(0, n);
            } else {
                this.isParsingFailure = true;
                this.logger.warn("[" + this.dbType + " - parseSimpleUrl] JDBC Url format is different, so not parsing, " + this.jdbcUrl);
                return;
            }
        }
        n = string.indexOf(":");
        if (n == 0) {
            this.hostName = "localhost";
            this.portNo = string.substring(1);
        } else if (n > 0) {
            this.hostName = string.substring(0, n);
            this.portNo = string.substring(n + 1);
        } else {
            this.portNo = DEFAULT_PORT;
            this.hostName = string;
        }
        this.logger.info("[" + this.dbType + " - parseSimpleUrl]- hostName :" + this.hostName + "  " + this.portNo + "  " + this.databaseName);
    }

    private void parseIPv6Url(String string) {
        int n;
        int n2 = string.indexOf("]");
        if (n2 > 0) {
            this.hostName = string.substring(0, n2 + 1);
            string = string.substring(n2 + 1);
        }
        if (string.startsWith(":")) {
            string = string.substring(1);
        }
        if ((n = string.lastIndexOf(":")) > -1) {
            this.databaseName = string.substring(n + 1);
            string = string.substring(0, n);
        } else {
            int n3 = string.lastIndexOf("/");
            if (n3 > -1) {
                this.databaseName = string.substring(n3 + 1);
                string = string.substring(0, n3);
            }
        }
        this.portNo = string != null && string.length() > 0 ? string : DEFAULT_PORT;
        this.logger.info("[" + this.dbType + " -  IPv6 Block]- hostName :" + this.hostName + "  " + this.portNo + "  " + this.databaseName);
    }

    private void parseList(String string, List<OracleKeyValue> list) {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            OracleKeyValue oracleKeyValue = list.get(i);
            String string2 = oracleKeyValue.getKeyString();
            if (string.equals("address")) {
                object = new HashMap();
                for (int j = 0; j < list.size(); ++j) {
                    OracleKeyValue oracleKeyValue2 = list.get(j);
                    String string3 = oracleKeyValue2.getKeyString();
                    String string4 = oracleKeyValue2.getValueString();
                    if (!string3.equals("host") && !string3.equals("port")) continue;
                    ((HashMap)object).put(string3, string4);
                }
                if (this.hostList == null) {
                    this.hostList = new ArrayList<HashMap<String, String>>();
                }
                this.hostList.add((HashMap<String, String>)object);
                break;
            }
            object = oracleKeyValue.getValueString();
            if (object == null) {
                this.parseList(string2, oracleKeyValue.getKeyValueList());
            }
            if (!string2.equals("service_name") && !string2.equals("sid")) continue;
            this.databaseName = object;
        }
    }

    private void parseNetConnectionUrl() {
        OracleNetConnectionDescriptorParser oracleNetConnectionDescriptorParser = new OracleNetConnectionDescriptorParser(this.jdbcUrl);
        OracleKeyValue oracleKeyValue = oracleNetConnectionDescriptorParser.parse();
        List<OracleKeyValue> list = oracleKeyValue.getKeyValueList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            OracleKeyValue oracleKeyValue2 = list.get(i);
            String string = oracleKeyValue2.getKeyString();
            String string2 = oracleKeyValue2.getValueString();
            if (string2 != null) continue;
            List<OracleKeyValue> list2 = oracleKeyValue2.getKeyValueList();
            this.parseList(string, list2);
        }
        if (this.hostList != null && this.hostList.size() == 1) {
            HashMap<String, String> hashMap = this.hostList.get(0);
            this.hostName = hashMap.get("host");
            this.portNo = hashMap.get("port");
            this.hostList = null;
        }
    }

    public static void main(String[] stringArray) {
        String string = "jdbc:oracle:thin:@(DESCRIPTION = (ADDRESS = (PROTOCOL = TCP)(HOST = oraclehost1)(PORT = 1521))(ADDRESS = (PROTOCOL = TCP)(HOST = oraclehost2)(PORT = 1521)) (LOAD_BALANCE = yes)(CONNECT_DATA = (SERVER = DEDICATED)(SERVICE_NAME = REPORTER)))";
        string = "jdbc:oracle:thin:FCDBB001_PRD/fc3ldb#mmk!@(DESCRIPTION_LIST=(LOAD_BALANCE=off)(FAILOVER=on)(DESCRIPTION=(ADDRESS_LIST=(LOAD_BALANCE=on)(ADDRESS=(PROTOCOL=TCP)(HOST=dc01-scan.kbzbank.com.mm)(PORT=1580)))(CONNECT_DATA=(SERVICE_NAME=fcdboltp.kbzbank.com.mm))))";
        System.out.println("jdbcUrl :" + string);
        OracleDatabaseInfo oracleDatabaseInfo = new OracleDatabaseInfo(string, "Oracle_server", null);
        Hashtable<String, String> hashtable = oracleDatabaseInfo.getDBInfo();
        System.out.println("Result :" + hashtable);
    }
}

