/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.apm.APMLanguage;
import com.eg.apm.APMNodeWorker;
import com.eg.apm.APMQueue;
import com.eg.apm.APMWorker;
import com.eg.apm.AgentStartupLogger;
import java.util.ArrayList;

public abstract class BaseThreadPoolManager {
    private APMQueue<Object> myQueue = null;
    private ArrayList workerList = null;
    private APMLanguage apmLanguage = null;
    private static final int DEFAULT_WORKERS = 5;
    private static final int DEFAULT_CAPACITY = 100000;
    private int maxQueueCapacity = 100000;
    private int maxWorkers = 5;
    private static final String THREAD_NAME = "eG_APM_Worker_";
    private static final String loggerDispStr = "[BaseThreadPoolManager]";

    protected void init(int maxWorkers, int maxQueueCapacity, APMLanguage apmLanguage) {
        this.maxWorkers = maxWorkers;
        this.maxQueueCapacity = maxQueueCapacity;
        this.workerList = new ArrayList();
        this.apmLanguage = apmLanguage;
        this.myQueue = new APMQueue(maxQueueCapacity);
        this.initAllConsumers();
    }

    private void initAllConsumers() {
        int i = 1;
        while (i <= this.maxWorkers) {
            APMWorker apm = null;
            if (this.apmLanguage == APMLanguage.JAVA) {
                apm = new APMWorker(this.myQueue);
            } else if (this.apmLanguage == APMLanguage.NODEJS) {
                apm = new APMNodeWorker(this.myQueue);
            }
            Thread thread = new Thread(apm);
            thread.setDaemon(true);
            thread.setName(THREAD_NAME + (Object)((Object)this.apmLanguage) + " " + i);
            thread.start();
            this.workerList.add(apm);
            ++i;
        }
        AgentStartupLogger.logger.info("{} eG APM - {} Threadpool created with - maxWokers {}, workers {} & queue size {}", new Object[]{loggerDispStr, this.apmLanguage, this.maxWorkers, this.workerList, this.maxQueueCapacity});
    }

    public void submitTask(Object dataObject) {
        this.myQueue.enqueue(dataObject);
    }

    public int getQueueSize() {
        return this.myQueue.getSize();
    }

    public void clearThreadPoolManager() {
        if (this.workerList != null && this.workerList.size() > 0) {
            int len = this.workerList.size();
            AgentStartupLogger.logger.warn("{} Closing all APM worker threads ", (Object)loggerDispStr);
            AgentStartupLogger.logger.info("{} Current APM workerList size : {} & Workers : {}", new Object[]{loggerDispStr, len, this.workerList});
            int i = 0;
            while (i < len) {
                APMWorker apm = (APMWorker)this.workerList.get(i);
                apm.setRunThis(false);
                this.submitTask(new Object());
                ++i;
            }
        }
        this.workerList = new ArrayList();
    }

    public abstract void start(int var1, int var2);
}

