/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm.util;

import com.eg.apm.util.QueryInfo;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum QueryParser {
    DML("^(\\s|\\t|\\n)*(select|delete).+\\s+(from)\\s+([^\\s,(;]*).*"){

        protected QueryInfo createQueryInfo(Matcher m) {
            return new QueryInfo(m.group(), m.group(2), m.group(4));
        }
    }
    ,
    DML_INSERT("^(\\s|\\t|\\n)*(insert)\\s+(into)\\s+([^\\s,(;]*).*"){

        protected QueryInfo createQueryInfo(Matcher m) {
            return new QueryInfo(m.group(), m.group(2), m.group(4));
        }
    }
    ,
    DML_UPDATE("^(\\s|\\t|\\n)*(update)\\s+([^\\s,(;]*).*"){

        protected QueryInfo createQueryInfo(Matcher m) {
            return new QueryInfo(m.group(), m.group(2), m.group(3));
        }
    }
    ,
    DDL_INSERT("^(\\s|\\t|\\n)*(create)\\s+(table)\\s+(\\w+)\\s+(AS)\\s+(select)\\s+(\\*|\\w+,?).*"){

        protected QueryInfo createQueryInfo(Matcher m) {
            return new QueryInfo(m.group(), "CREATE AND INSERT", m.group(3));
        }
    }
    ,
    DDL("^(\\s|\\t|\\n)*(create|drop)\\s+(procedure|database|table).*"){

        protected QueryInfo createQueryInfo(Matcher m) {
            return new QueryInfo(m.group(), m.group(2), m.group(3));
        }
    }
    ,
    ALTER("^(\\s|\\t|\\n)*(alter)\\s+([^\\s]*).*"){

        protected QueryInfo createQueryInfo(Matcher m) {
            return new QueryInfo(m.group(), m.group(2), m.group(3));
        }
    }
    ,
    DML_PROC("^(\\s|\\t|\\n)*(call|execute)\\s+([^\\s(,]*).*"){

        protected QueryInfo createQueryInfo(Matcher m) {
            return new QueryInfo(m.group(), m.group(2), m.group(3));
        }
    };

    private final Pattern p;

    private QueryParser(String pattern) {
        this.p = Pattern.compile(pattern, 34);
    }

    protected abstract QueryInfo createQueryInfo(Matcher var1);

    private Pattern getQueryPattern() {
        return this.p;
    }

    public static QueryInfo getQueryInfo(String sql) {
        if (sql == null) {
            throw new RuntimeException("query is null[QueryParser] : " + sql);
        }
        for (QueryParser qP : EnumSet.allOf(QueryParser.class)) {
            Matcher m = qP.getQueryPattern().matcher(sql);
            if (!m.find()) continue;
            return qP.createQueryInfo(m);
        }
        return new QueryInfo(sql, sql.split(" ")[0], "QUERY");
    }

    public static String standardizeQuery(String query) {
        query = query.replaceAll("(\\t|\\n)+", " ");
        query = query.replaceAll("\\,", ", ");
        query = query.replaceAll("\\s+", " ");
        query = query.replaceAll("/\\*.+\\*/", "");
        return query;
    }

    /* synthetic */ QueryParser(String string, int n, String string2, QueryParser queryParser) {
        this(string2);
    }
}

