/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.JavaProcess;
import com.eg.apm.PatternMatcher;
import com.eg.apm.TAG;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerTypePatternMatcher
extends PatternMatcher {
    private static final String loggerDispStr = "[ServerTypePatternMatcher]";
    private HashMap classNameMapper = null;
    private HashMap<String, String> serverTypeDeciderPriorityMapper = null;
    private HashMap executableNameMapper = null;
    private HashMap systemPropertyNameMapper = null;

    public String getComponentType(String string, JavaProcess javaProcess) {
        if (this.classNameMapper != null) {
            String string2;
            Iterator iterator = this.classNameMapper.keySet().iterator();
            boolean bl = this.isServerTypeDeciderPriorityAvailable();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                ArrayList arrayList3 = (ArrayList)this.classNameMapper.get(string2);
                if (arrayList3 == null || arrayList3.size() <= 0) continue;
                for (int i = 0; i < arrayList3.size(); ++i) {
                    try {
                        String string3 = (String)arrayList3.get(i);
                        boolean bl2 = ServerTypePatternMatcher.patternMatchWithRegex(string, string3);
                        if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                            APMDiscoveryLogger.discoveryLogger.trace("{} Server type discovery - {} : {} , {} IN {}  ", new Object[]{loggerDispStr, TAG.CMDLINE_INCLUDE_PATTERN_FOUND, bl2, string3, string});
                        }
                        if (!bl2) continue;
                        if (bl) {
                            if (!arrayList.contains(string2)) {
                                arrayList.add(string2);
                            }
                            arrayList2.add(string3);
                            continue;
                        }
                        if (string2 == null || string2.length() <= 0) continue;
                        javaProcess.setMsg((Object)((Object)TAG.CMDLINE_INCLUDE_PATTERN_FOUND) + " - " + string3);
                        return string2;
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.info("{} Unable to do class name match for server type : {} IN {}, {} ", new Object[]{loggerDispStr, string, arrayList3, exception});
                    }
                }
            }
            if (!arrayList.isEmpty() && (string2 = this.getHighPriortyComponentName(arrayList)) != null && string2.length() > 0) {
                if (arrayList2.size() > 1) {
                    javaProcess.setMsg("MULTI_" + (Object)((Object)TAG.CMDLINE_INCLUDE_PATTERN_FOUND) + " - " + arrayList2);
                } else {
                    javaProcess.setMsg((Object)((Object)TAG.CMDLINE_INCLUDE_PATTERN_FOUND) + " - " + arrayList2);
                }
                javaProcess.setMsg("MATCHED_COMPONENT_TYPE(S) - " + arrayList);
                return string2;
            }
        }
        return "NONE";
    }

    public String getComponentTypeFromExecutable(String string, JavaProcess javaProcess) {
        if (this.executableNameMapper != null) {
            String string2;
            Iterator iterator = this.executableNameMapper.keySet().iterator();
            boolean bl = this.isServerTypeDeciderPriorityAvailable();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                ArrayList arrayList3 = (ArrayList)this.executableNameMapper.get(string2);
                if (arrayList3 == null || arrayList3.size() <= 0) continue;
                for (int i = 0; i < arrayList3.size(); ++i) {
                    try {
                        String string3 = (String)arrayList3.get(i);
                        boolean bl2 = ServerTypePatternMatcher.patternMatchWithRegex(string, string3);
                        if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                            APMDiscoveryLogger.discoveryLogger.trace("{} Server type discovery - {}: {} , {} IN {}  ", new Object[]{loggerDispStr, TAG.EXECUTABLE_INCLUDE_PATTERN_FOUND, bl2, string3, string});
                        }
                        if (!bl2) continue;
                        if (bl) {
                            if (!arrayList.contains(string2)) {
                                arrayList.add(string2);
                            }
                            arrayList2.add(string3);
                            continue;
                        }
                        if (string2 == null || string2.length() <= 0) continue;
                        javaProcess.setMsg((Object)((Object)TAG.EXECUTABLE_INCLUDE_PATTERN_FOUND) + " - " + string3);
                        return string2;
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.info("{} Unable to do executable name match for server type : {} IN {}, {} ", new Object[]{loggerDispStr, string, arrayList3, exception});
                    }
                }
            }
            if (!arrayList.isEmpty() && (string2 = this.getHighPriortyComponentName(arrayList)) != null && string2.length() > 0) {
                if (arrayList2.size() > 1) {
                    javaProcess.setMsg("MULTI_" + (Object)((Object)TAG.EXECUTABLE_INCLUDE_PATTERN_FOUND) + " - " + arrayList2);
                } else {
                    javaProcess.setMsg((Object)((Object)TAG.EXECUTABLE_INCLUDE_PATTERN_FOUND) + " - " + arrayList2);
                }
                javaProcess.setMsg("MATCHED_COMPONENT_TYPE(S) - " + arrayList);
                return string2;
            }
        }
        return "NONE";
    }

    public String getComponentTypeFromSystemProperty(String string, JavaProcess javaProcess) {
        if (this.systemPropertyNameMapper != null) {
            String string2;
            Iterator iterator = this.systemPropertyNameMapper.keySet().iterator();
            boolean bl = this.isServerTypeDeciderPriorityAvailable();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                ArrayList arrayList3 = (ArrayList)this.systemPropertyNameMapper.get(string2);
                if (arrayList3 == null || arrayList3.size() <= 0) continue;
                for (int i = 0; i < arrayList3.size(); ++i) {
                    try {
                        String string3 = (String)arrayList3.get(i);
                        boolean bl2 = ServerTypePatternMatcher.patternMatchWithRegex(string, string3);
                        if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                            APMDiscoveryLogger.discoveryLogger.trace("{} Server type discovery - {} : {} , {} IN {}  ", new Object[]{loggerDispStr, TAG.SYSTEM_PROPERTY_INCLUDE_PATTERN_FOUND, bl2, string3, string});
                        }
                        if (!bl2) continue;
                        if (bl) {
                            if (!arrayList.contains(string2)) {
                                arrayList.add(string2);
                            }
                            arrayList2.add(string3);
                            continue;
                        }
                        if (string2 == null || string2.length() <= 0) continue;
                        javaProcess.setMsg((Object)((Object)TAG.SYSTEM_PROPERTY_INCLUDE_PATTERN_FOUND) + " - " + string3);
                        return string2;
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.info("{} Unable to do system property match for server type : {} IN {}, {} ", new Object[]{loggerDispStr, string, arrayList3, exception});
                    }
                }
            }
            if (!arrayList.isEmpty() && (string2 = this.getHighPriortyComponentName(arrayList)) != null && string2.length() > 0) {
                if (arrayList2.size() > 1) {
                    javaProcess.setMsg("MULTI_" + (Object)((Object)TAG.SYSTEM_PROPERTY_INCLUDE_PATTERN_FOUND) + " - " + arrayList2);
                } else {
                    javaProcess.setMsg((Object)((Object)TAG.SYSTEM_PROPERTY_INCLUDE_PATTERN_FOUND) + " - " + arrayList2);
                }
                javaProcess.setMsg("MATCHED_COMPONENT_TYPE(S) - " + arrayList);
                return string2;
            }
        }
        return "NONE";
    }

    private String getHighPriortyComponentName(ArrayList<String> arrayList) {
        try {
            if (arrayList != null && !arrayList.isEmpty()) {
                TreeMap<Integer, ArrayList> treeMap = new TreeMap<Integer, ArrayList>();
                if (this.isServerTypeDeciderPriorityAvailable() && !this.serverTypeDeciderPriorityMapper.isEmpty()) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string = arrayList.get(i);
                        String string2 = this.serverTypeDeciderPriorityMapper.get(string);
                        this.addToSortedMap(string2, string, treeMap);
                    }
                    if (treeMap != null && !treeMap.isEmpty()) {
                        return this.getFirstPriorityCompType(treeMap);
                    }
                    return arrayList.get(0);
                }
                return arrayList.get(0);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while getting high priority component type ", (Object)loggerDispStr, (Object)exception);
        }
        return "NONE";
    }

    private String getFirstPriorityCompType(TreeMap<Integer, ArrayList> treeMap) {
        if (treeMap != null) {
            APMDiscoveryLogger.discoveryLogger.trace("{} Server type priority finalized map : {} ", (Object)loggerDispStr, treeMap);
            try {
                for (Map.Entry<Integer, ArrayList> entry : treeMap.entrySet()) {
                    ArrayList arrayList;
                    int n = entry.getKey();
                    if (n <= 0 || (arrayList = entry.getValue()) == null || arrayList.isEmpty()) continue;
                    return (String)arrayList.get(0);
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception while getting high priority component type ", (Object)loggerDispStr, (Object)exception);
            }
        }
        return "NONE";
    }

    private void addToSortedMap(String string, String string2, TreeMap<Integer, ArrayList> treeMap) {
        if (treeMap != null && string != null) {
            try {
                int n = Integer.parseInt(string);
                ArrayList<String> arrayList = treeMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                if (string2 != null && !arrayList.contains(string2)) {
                    arrayList.add(string2);
                }
                if (arrayList != null && !arrayList.isEmpty()) {
                    treeMap.put(n, arrayList);
                }
            }
            catch (NumberFormatException numberFormatException) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception while parsing string to int ", (Object)loggerDispStr, (Object)numberFormatException);
            }
        }
    }

    public void getConfigurations() {
        try {
            ApmConfigManager apmConfigManager = ApmConfigManager.getInstance();
            this.classNameMapper = apmConfigManager.getClassNameMapper();
            this.executableNameMapper = apmConfigManager.getExecutableNameMapper();
            this.systemPropertyNameMapper = apmConfigManager.getSystemPropertyNameMapper();
            this.serverTypeDeciderPriorityMapper = apmConfigManager.getServerTypeDeciderPriorityMap();
            this.addToConfigHash("classNameMapper", this.classNameMapper.toString());
            this.addToConfigHash("executableNameMapper", this.executableNameMapper.toString());
            this.addToConfigHash("systemPropertyNameMapper", this.systemPropertyNameMapper.toString());
            this.addToConfigHash("serverTypeDeciderPriorityMapper", this.serverTypeDeciderPriorityMapper.toString());
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while getting config details", (Object)loggerDispStr, (Object)exception);
        }
    }

    private boolean isServerTypeDeciderPriorityAvailable() {
        return this.serverTypeDeciderPriorityMapper != null && !this.serverTypeDeciderPriorityMapper.isEmpty();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ServerTypePatternMatcher={");
        stringBuilder.append("classNameMapper=").append(this.classNameMapper);
        stringBuilder.append(",executableNameMapper=").append(this.executableNameMapper);
        stringBuilder.append(",systemPropertyNameMapper=").append(this.systemPropertyNameMapper);
        stringBuilder.append(",serverTypeDeciderPriorityMapper=").append(this.serverTypeDeciderPriorityMapper);
        stringBuilder.append(",md5ConfigHash=").append(this.getConfigHash());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

