/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.EgLogbackManager;
import com.eg.apm.JavaProcess;
import com.eg.apm.Process;
import com.eg.apm.ProcessPatternMatcher;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;

public class ProcessInfo {
    static String sep = "^|^";

    public static void getProcessInfo() {
        try {
            ProcessHandle.allProcesses().filter(processHandle -> processHandle.info().command().isPresent()).forEach(processHandle -> {
                ProcessHandle.Info info = processHandle.info();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(info.user().orElse("-")).append(sep);
                stringBuilder.append(processHandle.pid()).append(sep);
                stringBuilder.append(info.command().orElse("-")).append(sep);
                stringBuilder.append(info.commandLine().orElse("-")).append(sep);
                long l = info.startInstant().get().toEpochMilli();
                if (l <= 0L) {
                    l = Instant.now().toEpochMilli();
                }
                stringBuilder.append(l).append(sep);
                System.out.println(stringBuilder);
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void getJavaProcessInfo(ProcessPatternMatcher processPatternMatcher) {
        try {
            ProcessHandle.allProcesses().filter(processHandle -> processHandle.info().command().isPresent()).forEach(processHandle -> {
                ProcessHandle.Info info = processHandle.info();
                if (processPatternMatcher.isMatched(info.command().orElse(""))) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(info.user().orElse("-")).append(sep);
                    stringBuilder.append(processHandle.pid()).append(sep);
                    stringBuilder.append(info.command().orElse("-")).append(sep);
                    stringBuilder.append(info.commandLine().orElse("-")).append(sep);
                    long l = info.startInstant().get().toEpochMilli();
                    if (l <= 0L) {
                        l = Instant.now().toEpochMilli();
                    }
                    stringBuilder.append(l).append(sep);
                    System.out.println(stringBuilder);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static ArrayList<Process> getJavaProcessInfoObjects(ProcessPatternMatcher processPatternMatcher) {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        try {
            ProcessHandle.allProcesses().filter(processHandle -> processHandle.info().command().isPresent()).forEach(processHandle -> {
                ProcessHandle.Info info = processHandle.info();
                if (processPatternMatcher.isMatched(info.command().orElse(""))) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(info.user().orElse("-")).append(sep);
                    stringBuilder.append(processHandle.pid()).append(sep);
                    stringBuilder.append(info.command().orElse("-")).append(sep);
                    stringBuilder.append(info.commandLine().orElse("-")).append(sep);
                    long l = info.startInstant().get().toEpochMilli();
                    if (l <= 0L) {
                        l = Instant.now().toEpochMilli();
                    }
                    stringBuilder.append(l).append(sep);
                    arrayList.add(new JavaProcess(stringBuilder.toString()));
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static ArrayList<Process> getCustomJavaProcessInfoObjects(String string) {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        try {
            ProcessHandle.allProcesses().filter(processHandle -> processHandle.info().command().isPresent()).forEach(processHandle -> {
                ProcessHandle.Info info = processHandle.info();
                if (info.command().orElse("").contains(string)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(info.user().orElse("-")).append(sep);
                    stringBuilder.append(processHandle.pid()).append(sep);
                    stringBuilder.append(info.command().orElse("-")).append(sep);
                    stringBuilder.append(info.commandLine().orElse("-")).append(sep);
                    long l = info.startInstant().get().toEpochMilli();
                    if (l <= 0L) {
                        l = Instant.now().toEpochMilli();
                    }
                    stringBuilder.append(l).append(sep);
                    arrayList.add(new JavaProcess(stringBuilder.toString()));
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private static void disableLogger() {
        try {
            EgLogbackManager.getInstance().getLogger("APMDISCOVERY_LOGGER");
            EgLogbackManager.getInstance().reset();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray != null) {
            if (stringArray.length > 0) {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                if (arrayList.contains("--java-filter")) {
                    ProcessPatternMatcher processPatternMatcher = new ProcessPatternMatcher();
                    if (arrayList.contains("--debug-off")) {
                        ProcessInfo.disableLogger();
                    }
                    processPatternMatcher.getConfigurations();
                    ProcessInfo.getJavaProcessInfo(processPatternMatcher);
                } else {
                    ProcessInfo.getProcessInfo();
                }
            }
        } else {
            ProcessInfo.getProcessInfo();
        }
    }
}

