/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.IPV6Helper;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.ContainerCategory;
import com.eg.apm.ContainerImpl;
import com.eg.apm.EgApmMainAgentInfo;
import com.eg.apm.PodmanContainersThread;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class PodmanContainers
extends ContainerImpl {
    private static PodmanContainers podmanContServer = null;
    public boolean isPodmanServer = false;
    private static Hashtable ht_runningContainerIpMap = new Hashtable();
    private long lastUpdatedTime = 0L;
    private static final String sync = new String("sync");
    private Hashtable ht_containerIdAndPodName = new Hashtable();
    private Hashtable ht_containerIdAndPort = new Hashtable();
    private static final String loggerDispStr = "[PodmanContainers]";
    public static Hashtable ht_NotRunningContainers = new Hashtable();

    private PodmanContainers(ContainerCategory containerCategory) {
        super(containerCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PodmanContainers getPodmanContainerInstance(ContainerCategory containerCategory) {
        if (podmanContServer == null) {
            String string = sync;
            synchronized (string) {
                if (podmanContServer == null) {
                    podmanContServer = new PodmanContainers(containerCategory);
                }
            }
        }
        return podmanContServer;
    }

    public String getPodName(String string) {
        this.updateRepo();
        String string2 = "";
        if (this.ht_containerIdAndPodName != null && this.ht_containerIdAndPodName.containsKey(string)) {
            string2 = (String)this.ht_containerIdAndPodName.get(string);
        } else {
            this.updateRepo(true);
            if (this.ht_containerIdAndPodName != null && this.ht_containerIdAndPodName.containsKey(string)) {
                string2 = (String)this.ht_containerIdAndPodName.get(string);
            }
        }
        APMDiscoveryLogger.discoveryLogger.trace("{} strContainerId : {}, strPodName : {}, ht_containerIdAndPodName : {}", new Object[]{loggerDispStr, string, string2, this.ht_containerIdAndPodName});
        return string2;
    }

    public Hashtable getRunningContainerIpDetails() {
        Object object;
        String string;
        Object object2;
        int n;
        int n2;
        Hashtable hashtable = this.geRunningContainerDetails();
        ArrayList<String> arrayList = new ArrayList<String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (hashtable != null && hashtable.size() > 0) {
            int n3 = hashtable.size();
            int n4 = 10;
            n2 = 1;
            n = 0;
            object2 = hashtable.keys();
            String string2 = "";
            while (object2.hasMoreElements()) {
                String string3;
                string = (String)object2.nextElement();
                ++n;
                if (string == null || (object = (Hashtable)hashtable.get(string)) == null) continue;
                if (((Hashtable)object).containsKey("Command")) {
                    string3 = (String)((Hashtable)object).get("Command");
                    if (string3 != null && (string3 = string3.trim()).startsWith("\"") && string3.endsWith("\"")) {
                        string3.substring(1, string3.length() - 1);
                    }
                    if (string3 != null && string3.trim().equalsIgnoreCase("\"/pause\"")) continue;
                }
                if (n2 <= n4) {
                    string2 = n2 == 1 ? string : string2 + " " + string;
                    ++n2;
                }
                if (n2 == n4) {
                    arrayList.add(string2);
                    string2 = "";
                    n2 = 1;
                }
                if (n == n3 && n2 != n4) {
                    arrayList.add(string2);
                }
                string3 = null;
                if (!((Hashtable)object).containsKey("Names") || (string3 = (String)((Hashtable)object).get("Names")) == null) continue;
                hashtable2.put(string3, string);
                hashtable2.put(string3, string);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<PodmanContainersThread> arrayList3 = new ArrayList<PodmanContainersThread>();
            n2 = arrayList.size();
            n = EgApmMainAgentInfo.getInstance().getMaxDokcerThreads();
            object2 = "podman inspect --format=\"{{.Name}}#@#{{.NetworkSettings.Ports}}#@#{{.Config.Labels}}#@#{{.NetworkSettings.IPAddress}}\" ";
            for (int i = 0; i < n2; ++i) {
                string = (String)arrayList.get(i);
                if (string == null) continue;
                object = (String)object2 + string;
                long l = System.currentTimeMillis();
                long l2 = 360000L;
                long l3 = l - l2;
                while (arrayList3.size() >= n) {
                    for (int j = 0; j < arrayList3.size(); ++j) {
                        PodmanContainersThread podmanContainersThread = (PodmanContainersThread)arrayList3.get(j);
                        if (podmanContainersThread.isDone()) {
                            ArrayList arrayList4 = podmanContainersThread.getOutput();
                            if (arrayList4 != null && arrayList4.size() > 0) {
                                arrayList2.addAll(arrayList4);
                            }
                            arrayList3.remove(j--);
                            continue;
                        }
                        l = System.currentTimeMillis();
                        l3 = l - l2;
                        if (podmanContainersThread.startTime >= l3) continue;
                        try {
                            podmanContainersThread.interrupt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        arrayList3.remove(j);
                        --j;
                    }
                    if (arrayList3.size() < n) break;
                    try {
                        Thread.currentThread();
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {}
                }
                PodmanContainersThread podmanContainersThread = new PodmanContainersThread(this, (String)object);
                arrayList3.add(podmanContainersThread);
            }
            long l = 360000L;
            while (arrayList3.size() > 0) {
                long l4 = System.currentTimeMillis();
                long l5 = l4 - l;
                for (int i = 0; i < arrayList3.size(); ++i) {
                    PodmanContainersThread podmanContainersThread = (PodmanContainersThread)arrayList3.get(i);
                    if (podmanContainersThread.isDone()) {
                        ArrayList arrayList5 = podmanContainersThread.getOutput();
                        if (arrayList5 != null && arrayList5.size() > 0) {
                            arrayList2.addAll(arrayList5);
                        }
                        arrayList3.remove(i);
                        --i;
                        continue;
                    }
                    if (podmanContainersThread.startTime >= l5) continue;
                    try {
                        podmanContainersThread.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList3.remove(i);
                    --i;
                }
                if (arrayList3 == null || arrayList3.size() == 0) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        Hashtable hashtable3 = this.getRunningContainerIp(arrayList2, hashtable2);
        return hashtable3;
    }

    public Hashtable getRunningContainerIp(ArrayList arrayList, Hashtable hashtable) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n = arrayList.size();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            int n2;
            ArrayList arrayList2;
            String string = (String)arrayList.get(i);
            if (string == null || (arrayList2 = this.egTokenizer(string, "#@#")) == null || arrayList2.size() < 4) continue;
            String string2 = (String)arrayList2.get(0);
            string2 = string2.trim();
            if ((string2 = string2.substring(1)).startsWith("/")) {
                string2 = string2.substring(1);
            }
            String string3 = (String)arrayList2.get(1);
            String string4 = (String)arrayList2.get(2);
            String string5 = (String)arrayList2.get(3);
            if (string5 != null) {
                if ((string5 = string5.trim()).equals("\"")) {
                    string5 = "";
                }
                if (string5.startsWith("\"") && string5.length() > 0) {
                    string5 = string5.substring(1);
                }
                if (string5.endsWith("\"") && string5.length() > 0) {
                    string5 = string5.substring(0, string5.length() - 1);
                }
            }
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            if (string3 != null && string3.length() > 0 && string3.trim().startsWith("[{") && (n2 = ((StringTokenizer)(object2 = new StringTokenizer(string3 = string3.substring(2, string3.length() - 1), " "))).countTokens()) > 1) {
                for (int j = 0; j < n2; ++j) {
                    object = ((StringTokenizer)object2).nextToken();
                    try {
                        double d = Double.parseDouble((String)object);
                        arrayList3.add(object);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            object2 = null;
            if (hashtable != null && string2 != null && hashtable.containsKey(string2)) {
                object2 = (String)hashtable.get(string2);
            }
            if (string5 != null && string5.length() > 0 && object2 != null) {
                hashtable2.put((String)object2, string5);
            }
            String string6 = "";
            String string7 = "";
            if (string4 != null && (string4 = string4.trim()).startsWith("map[") && string4.endsWith("]")) {
                string4 = string4.substring(4, string4.length() - 1);
                object = new StringTokenizer(string4);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    int n3;
                    String string8;
                    String string9;
                    String string10 = ((StringTokenizer)object).nextToken();
                    if (string10 == null || string10.indexOf(":") <= 0) continue;
                    int n4 = string10.indexOf(":");
                    String string11 = string10.substring(0, n4);
                    String string12 = string10.substring(n4 + 1);
                    if (string11.equalsIgnoreCase("io.kubernetes.pod.name")) {
                        string6 = string12;
                    }
                    if (!string11.equalsIgnoreCase("annotation.io.kubernetes.container.ports") || (string9 = string12) == null || string9.indexOf("\"containerPort\":") < 0 || (string8 = string9.substring((n3 = string9.indexOf("\"containerPort\":")) + 16)) == null || string8.indexOf(",") <= 0) continue;
                    string7 = string8.substring(0, string8.indexOf(","));
                }
            }
            if (string7 != null && string7.length() > 0 && (arrayList3 == null || arrayList3.size() == 0)) {
                arrayList3 = new ArrayList();
                arrayList3.add(string7);
            }
            if (string6 == null || object2 == null) continue;
            this.ht_containerIdAndPodName.put(object2, string6);
            if (arrayList3 == null || arrayList3.size() <= 0) continue;
            this.ht_containerIdAndPort.put(object2, this.getHighPriorityPort(arrayList3));
        }
        return hashtable2;
    }

    public Hashtable geRunningContainerDetails() {
        try {
            Hashtable hashtable = new Hashtable();
            String string = "podman ps -a -s --pod";
            ArrayList arrayList = this.executeCommand(string);
            if (!(arrayList != null && arrayList.size() != 0 || (arrayList = this.executeCommand(string = "sudo podman ps -a -s --pod")) != null && arrayList.size() != 0)) {
                System.out.println(" [PodmanContainers] " + string + "\toutput is null so return  ");
                return null;
            }
            int n = arrayList.size();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            String string11 = "";
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string12 = (String)arrayList.get(i);
                if (string12 == null) continue;
                if (string12.indexOf("CONTAINER ID") >= 0) {
                    n2 = string12.indexOf("CONTAINER ID");
                    n3 = string12.indexOf("IMAGE");
                    n4 = string12.indexOf("COMMAND");
                    n5 = string12.indexOf("CREATED");
                    n6 = string12.indexOf("STATUS");
                    n7 = string12.indexOf("PORTS");
                    n8 = string12.indexOf("NAMES");
                    n10 = string12.indexOf("POD");
                    n9 = string12.indexOf("SIZE");
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                string2 = string12.substring(n2, n3 - 1).trim();
                string3 = string12.substring(n3, n4 - 1).trim();
                string4 = string12.substring(n4, n5 - 1).trim();
                string5 = string12.substring(n5, n6 - 1).trim();
                string7 = string12.substring(n6, n7 - 1).trim();
                string8 = string12.substring(n7, n8 - 1).trim();
                string9 = string12.substring(n8, n10 - 1).trim();
                string11 = string12.substring(n10, n9 - 1).trim();
                string10 = string12.substring(n9).trim();
                hashtable2.put("Image", string3);
                hashtable2.put("Command", string4);
                hashtable2.put("Created", string5);
                hashtable2.put("Status", string7);
                hashtable2.put("Port", string8);
                hashtable2.put("Names", string9);
                hashtable2.put("Size", string10);
                if (string2 != null && string11 != null) {
                    this.ht_containerIdAndPodName.put(string2, string11);
                }
                if (string7 == null || string7.toLowerCase().indexOf("up") < 0) continue;
                hashtable.put(string2, hashtable2);
            }
            return hashtable;
        }
        catch (Exception exception) {
            System.err.println(" [PodmanContainers] Exception occured while getting containerDetails");
            exception.printStackTrace();
            return null;
        }
    }

    public ArrayList executeCommand(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList arrayList = null;
        ArrayList arrayList2 = new ArrayList();
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            arrayList2 = egUtilities.getExecOutputLines(string);
            if (arrayList2 != null && arrayList2.size() >= 2) {
                arrayList = (ArrayList)arrayList2.get(0);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception  occured in PodmanContainers while calling executeCommand " + string + " \tdata =" + arrayList2);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public String getDockerHostInternalIp() {
        Object object = "127.0.0.1";
        String string = "ip -4 addr show docker0 | grep -Po 'inet \\K[\\d.]+'";
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getCommandOutputLines(string, true, true);
            if (arrayList != null && arrayList.size() > 0) {
                Object object2;
                ArrayList arrayList2 = (ArrayList)arrayList.get(0);
                if (arrayList2 != null && arrayList2.size() > 0 && (object2 = (String)arrayList2.get(0)) != null && ((String)object2).length() > 0 && IPV6Helper.validateIPV4(((String)object2).trim())) {
                    object = object2;
                }
                if (((String)object).equalsIgnoreCase("127.0.0.1")) {
                    object2 = (ArrayList)arrayList.get(1);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception occured while finding Podman Internal IP Address by using the command " + string);
            exception.printStackTrace();
        }
        return object;
    }

    public ArrayList egTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = string2.length();
        int n2 = 0;
        int n3 = string.indexOf(string2);
        while (n3 >= 0) {
            string3 = string.substring(n2, n3);
            arrayList.add(string3);
            n2 = n3 + n;
            n3 = string.indexOf(string2, n2);
        }
        string3 = string.substring(n2);
        arrayList.add(string3);
        return arrayList;
    }

    public Hashtable getContinerPortDetails() {
        return this.ht_containerIdAndPort;
    }

    public int getDockerPort(String string) {
        ArrayList<String> arrayList;
        int n;
        block8: {
            n = 0;
            arrayList = new ArrayList<String>();
            try {
                int n2;
                StringTokenizer stringTokenizer;
                int n3;
                String string2 = "podman inspect --format=\"{{.NetworkSettings.Ports}}\" " + string;
                EgUtilities egUtilities = EgUtilities.createInstance();
                ArrayList arrayList2 = egUtilities.getExecOutputLines(string2);
                ArrayList arrayList3 = null;
                if (arrayList2 != null && arrayList2.size() > 0) {
                    arrayList3 = (ArrayList)arrayList2.get(0);
                }
                if (arrayList3 == null || arrayList3.size() == 0) {
                    return n;
                }
                String string3 = (String)arrayList3.get(0);
                if (string3 != null && string3.length() > 0) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                if (string3 == null || string3.length() <= 0 || !string3.trim().startsWith("[{") || (n3 = (stringTokenizer = new StringTokenizer(string3 = string3.substring(2, string3.length() - 1), " ")).countTokens()) <= 1 || (n2 = 0) >= n3) break block8;
                String string4 = stringTokenizer.nextToken();
                try {
                    double d = Double.parseDouble(string4);
                    arrayList.add(string4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n = Integer.parseInt(string4);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        if (arrayList.size() > 0) {
            n = Integer.parseInt(this.getHighPriorityPort(arrayList));
        }
        return n;
    }

    public int getPodPort(String string) {
        int n = 0;
        try {
            String string2;
            String string3 = "podman inspect --format=\"{{.Config.Labels}}\" " + string;
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getExecOutputLines(string3);
            ArrayList arrayList2 = null;
            if (arrayList != null && arrayList.size() > 0) {
                arrayList2 = (ArrayList)arrayList.get(0);
            }
            if ((string2 = (String)arrayList2.get(0)) != null && string2.length() > 0) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (string2 != null && (string2 = string2.trim()).startsWith("map[") && string2.endsWith("]")) {
                string2 = string2.substring(4, string2.length() - 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    int n2;
                    String string4;
                    String string5;
                    String string6 = stringTokenizer.nextToken();
                    if (string6 == null || string6.indexOf(":") <= 0) continue;
                    int n3 = string6.indexOf(":");
                    String string7 = string6.substring(0, n3);
                    String string8 = string6.substring(n3 + 1);
                    if (string7.equalsIgnoreCase("io.kubernetes.pod.name")) {
                        string5 = string8;
                    }
                    if (!string7.equalsIgnoreCase("annotation.io.kubernetes.container.ports") || (string5 = string8) == null || string5.indexOf("\"containerPort\":") < 0 || (string4 = string5.substring((n2 = string5.indexOf("\"containerPort\":")) + 16)) == null || string4.indexOf(",") <= 0) continue;
                    String string9 = string4.substring(0, string4.indexOf(","));
                    n = Integer.parseInt(string9);
                    return n;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return n;
    }

    private String getHighPriorityPort(ArrayList arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            if (arrayList.contains("443")) {
                return "443";
            }
            if (arrayList.contains("8080")) {
                return "8080";
            }
            return (String)arrayList.get(0);
        }
        return "0000";
    }

    public String getHostInternalIp() {
        return "127.0.0.1";
    }

    public boolean isContainerZ() {
        return this.isDockerContainer() || this.isCrioContainer() || this.isPodmanContainer();
    }

    public static void main(String[] stringArray) {
    }

    public void updateRepo() {
        this.updateRepo(false);
    }

    public void updateRepo(boolean bl) {
        long l = System.currentTimeMillis();
        if (l - this.lastUpdatedTime >= 600000L || bl && l - this.lastUpdatedTime > 10000L) {
            ht_runningContainerIpMap = this.getRunningContainerIpDetails();
            this.lastUpdatedTime = l;
        }
    }
}

