/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.NodeModuleInstaller;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class NodeModuleSetup {
    private static final String NODE_MONITOR_STATUS_LOG_FILE = "node-monitor-status.log";
    private static final String NODE_MONITOR_ZIP = "eg-node-monitor.zip";
    private static final String loggerDispStr = "[NodeModuleSetup]";
    private static final NodeModuleSetup instance = new NodeModuleSetup();

    private NodeModuleSetup() {
    }

    public static NodeModuleSetup getInstance() {
        return instance;
    }

    public void installNodeModules() {
        String string = EgInstallInfo.getInstallDir() + "/lib/apm/NodeJS/" + NODE_MONITOR_ZIP;
        String string2 = EgInstallInfo.getInstallDir() + "/lib/apm/NodeJS/default/";
        AgentStartupLogger.logger.debug("{} ZipFile : {} extracted to {} ", new Object[]{loggerDispStr, string, string2});
        boolean bl = this.getNodeModuleUnzipStatus();
        if (bl) {
            AgentStartupLogger.logger.debug("{} Already {} Unzipped !!!", (Object)loggerDispStr, (Object)string);
        }
        AgentStartupLogger.logger.debug("{} Unzipping of {}  & Executing scripts done by a new Thread.", (Object)loggerDispStr, (Object)string);
        NodeModuleInstaller nodeModuleInstaller = new NodeModuleInstaller(string, string2, bl);
        Thread thread = new Thread(nodeModuleInstaller);
        thread.setDaemon(true);
        thread.setName("NodeModuleInstaller");
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int extractFile(ZipFile zipFile, ZipEntry zipEntry, File file) {
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            int n2;
            bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            fileOutputStream = new FileOutputStream(file);
            filterOutputStream = new BufferedOutputStream(fileOutputStream, 1024);
            while ((n2 = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n2);
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while extracting file: {} - {}", new Object[]{loggerDispStr, file, exception});
            n = 1;
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unZipWithSubFolders(String string, String string2) {
        ZipFile zipFile = null;
        File file = new File(string);
        boolean bl = false;
        int n = 0;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                File file2 = new File(string2, zipEntry.getName());
                file2.getParentFile().mkdirs();
                if (zipEntry.isDirectory()) continue;
                AgentStartupLogger.logger.info("{} Extracting file: {}", (Object)loggerDispStr, (Object)zipEntry.getName());
                int n2 = this.extractFile(zipFile, zipEntry, file2);
                n += n2;
            }
            bl = true;
            this.updateStatus(n);
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception in UnZip operation: {}", (Object)loggerDispStr, (Object)exception);
            bl = false;
            this.updateStatus(-1);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus(int n) {
        Object object;
        String string;
        String string2 = EgInstallInfo.getInstallDir() + "/agent/logs/" + NODE_MONITOR_STATUS_LOG_FILE;
        String string3 = string = n == 0 ? "UNZIP_STATUS=SUCCESS" : "UNZIP_STATUS=FAILED";
        if (n > 0) {
            AgentStartupLogger.logger.warn("{} Node Modules are not unzipped properly as having {} failures ", (Object)loggerDispStr, (Object)n);
        }
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new FileReader(string2));
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)object).startsWith("UNZIP_STATUS=")) {
                    arrayList.add(string);
                    bl = true;
                    continue;
                }
                arrayList.add((String)object);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("[NodeModuleSetup] Unable to read existing status as the file not found " + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        if (arrayList.size() > 0) {
            if (!bl) {
                arrayList.add(string);
            }
        } else {
            arrayList.add(string);
            arrayList.add("INSTALL_STATUS=0");
        }
        object = null;
        try {
            object = new BufferedWriter(new FileWriter(string2));
            for (int i = 0; i < arrayList.size(); ++i) {
                String string4 = (String)arrayList.get(i);
                ((Writer)object).write(string4);
                ((Writer)object).write("\n");
            }
            ((BufferedWriter)object).flush();
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.debug("{} Exception while updating Node Module Unzip status on {} due to {}", new Object[]{loggerDispStr, string2, exception});
        }
        finally {
            try {
                if (object != null) {
                    ((BufferedWriter)object).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean getNodeModuleUnzipStatus() {
        boolean bl = false;
        String string = EgInstallInfo.getInstallDir() + "/agent/logs/" + NODE_MONITOR_STATUS_LOG_FILE;
        try {
            File file = new File(string);
            if (file.exists()) {
                int n;
                String string2 = this.getStatusLine(string, "UNZIP_STATUS");
                if (string2 != null && (n = string2.indexOf("=SUCCESS")) > 0) {
                    bl = true;
                }
            } else {
                AgentStartupLogger.logger.warn("{} {} Not Exists !!!", (Object)loggerDispStr, (Object)string);
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while reading nodejs unzip status from {} ,{}", new Object[]{loggerDispStr, string, exception});
        }
        return bl;
    }

    public int getNodeModuleStatus() {
        int n = 0;
        String string = EgInstallInfo.getInstallDir() + "/agent/logs/" + NODE_MONITOR_STATUS_LOG_FILE;
        try {
            File file = new File(string);
            if (file.exists()) {
                int n2;
                String string2 = this.getStatusLine(string, "STATUS=");
                if (string2 != null && (n2 = string2.indexOf("=")) > 0) {
                    String string3 = string2.substring(n2 + 1);
                    AgentStartupLogger.logger.debug("{} statusCode from {}  is {}", new Object[]{loggerDispStr, string, string3});
                    try {
                        n = Integer.parseInt(string3);
                    }
                    catch (Exception exception) {
                        AgentStartupLogger.logger.warn("{} Invalid statusCode {} {}", new Object[]{loggerDispStr, string3, exception});
                    }
                }
            } else {
                AgentStartupLogger.logger.debug("{} {} Not Exists !!!", (Object)loggerDispStr, (Object)string);
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while reading nodejs status from {} ,{}", new Object[]{loggerDispStr, string, exception});
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStatusLine(String string, String string2) {
        BufferedReader bufferedReader = null;
        String string3 = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while (!((string3 = bufferedReader.readLine()) == null || string3 != null && (string3 = string3.trim()).startsWith(string2))) {
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while reading status line {} ", (Object)loggerDispStr, (Object)exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return string3;
    }
}

