/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.apm.APMUtils;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.NodeModuleSetup;
import java.util.ArrayList;

public class NodeModuleInstaller
implements Runnable {
    private String sourceFile;
    private String destination;
    private boolean unzipDone = false;
    private static final String loggerDispStr = "[NodeModuleInstaller]";

    public NodeModuleInstaller(String string, String string2, boolean bl) {
        this.sourceFile = string;
        this.destination = string2;
        this.unzipDone = bl;
    }

    public void run() {
        Object object;
        boolean bl = false;
        if (!this.unzipDone && (bl = ((NodeModuleSetup)(object = NodeModuleSetup.getInstance())).unZipWithSubFolders(this.sourceFile, this.destination))) {
            AgentStartupLogger.logger.debug("{} ZipFile : {} extracted to {} Successfully !!!", new Object[]{loggerDispStr, this.sourceFile, this.destination});
        }
        if (this.unzipDone || bl) {
            object = this.getScriptFileName();
            AgentStartupLogger.logger.debug("{} Node.js Module Installer script file name {}", (Object)loggerDispStr, object);
            if (object != null) {
                boolean bl2 = false;
                ArrayList arrayList = null;
                try {
                    arrayList = APMUtils.executeCmd((String)object, bl2);
                }
                catch (Exception exception) {
                    AgentStartupLogger.logger.error("{} Exception while installing Node.js Modules  {} ", (Object)loggerDispStr, object);
                }
                AgentStartupLogger.logger.debug("{} Result of Node.js Module Installer {}", (Object)loggerDispStr, (Object)arrayList);
            }
        } else {
            AgentStartupLogger.logger.warn("{} Issue while unzipping the file {} :", (Object)loggerDispStr, (Object)this.sourceFile);
        }
    }

    private String getScriptFileName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EgInstallInfo.getInstallDir());
        if (APMUtils.isWindows()) {
            stringBuffer.append("/lib/").append("setup_nodejs.bat");
        } else {
            stringBuffer.append("/bin/").append("setup_nodejs");
        }
        return stringBuffer.toString();
    }
}

