/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.ExceedSqlDetails;
import com.eg.apm.NodeBTM;
import com.eg.apm.NodeBTMErrors;
import com.eg.apm.NodeBTMLogger;
import com.eg.apm.NodeCache;
import com.eg.apm.NodeCodeError;
import com.eg.apm.NodeDataRepository;
import com.eg.apm.NodeDumpCluster;
import com.eg.apm.NodeDumps;
import com.eg.apm.NodeExternalCallDetails;
import com.eg.apm.NodeGC;
import com.eg.apm.NodeHttp;
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import com.eg.apm.NodeJms;
import com.eg.apm.NodeNoSql;
import com.eg.apm.NodeSql;
import com.eg.apm.NodeTraceSpan;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import com.eg.org.slf4j.Logger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NodeBTMDataParser {
    protected static final Logger log = NodeBTMLogger.nodeLogger;
    public String logPrefix = " [" + this.getClass().getName() + "] ";
    private static final String callTraceDelimiter = "#=#";
    private static final String callTraceLineDelimiter = "%*%";
    private static final String callTraceTimeDelimiter = "~$~";
    private static final String NOT_Available = "N/A";

    public ArrayList computeNodeJsData(JSONArray nodeJsArray) {
        ArrayList finalMethodInfoList = new ArrayList();
        log.info("{} : recevied JSON Array object from queue  : {} Size is {} ", new Object[]{this.logPrefix, nodeJsArray, nodeJsArray.size()});
        int index = 0;
        while (index < nodeJsArray.size()) {
            JSONObject infraOrBtmJsonObject = (JSONObject)nodeJsArray.get(index);
            if (infraOrBtmJsonObject.get((Object)"infra") != null) {
                this.processInfraData(infraOrBtmJsonObject, Mapper.INSTANCE.getObjectMapper());
            } else if (infraOrBtmJsonObject.get((Object)"btm") != null) {
                this.processNodeJsBtmData(infraOrBtmJsonObject, finalMethodInfoList, Mapper.INSTANCE.getObjectMapper());
            } else if (infraOrBtmJsonObject.get((Object)"nodeDump") != null) {
                this.processDumpData(infraOrBtmJsonObject, Mapper.INSTANCE.getObjectMapper());
            }
            ++index;
        }
        return finalMethodInfoList;
    }

    private void processNodeJsBtmData(JSONObject infraOrBtmJsonObject, ArrayList finalMethodInfoList, ObjectMapper objectMapper) {
        try {
            log.info("{} : Process NodeJs BtmData : {} ", (Object)this.logPrefix, (Object)infraOrBtmJsonObject);
            NodeBTM btmObject = null;
            MethodInfo minfo = new MethodInfo();
            ArrayList<String> idMapper = new ArrayList<String>();
            HashMap<String, double[]> slowSQLTimeDetails = new HashMap<String, double[]>();
            minfo.setType("http:inbound");
            JSONObject btmJSON = (JSONObject)infraOrBtmJsonObject.get((Object)"btm");
            String componentId = (String)infraOrBtmJsonObject.get((Object)"componentId");
            boolean is404Request = btmJSON.containsKey((Object)"is404Request");
            if (is404Request) {
                this.process404RequestDetails(is404Request, btmJSON, componentId, minfo, finalMethodInfoList);
                return;
            }
            btmObject = (NodeBTM)objectMapper.readValue(btmJSON.toString(), NodeBTM.class);
            log.info("{} : componentId : {} : btmObject : {} ", new Object[]{this.logPrefix, componentId, btmObject.toString()});
            Properties props = null;
            if (btmObject != null) {
                PropsManager propsManager = APMComponentIDRepository.getRepository().getAPMComponent(componentId).getPropsManager();
                props = this.prepareBtmPropsDetails(btmObject, componentId, propsManager);
                this.prepareMethodInfoObject(props, btmObject, minfo, propsManager);
                this.prepareCallTraceDetails(btmObject, props, idMapper);
                long id = this.prepareExternalCallDetails(btmObject, props, propsManager, minfo, idMapper, slowSQLTimeDetails);
                boolean isErrorTransaction = btmObject.isTransactionError();
                if (btmObject != null && isErrorTransaction && btmObject.getErrors() != null) {
                    this.prepareBusinessErorrDetails(btmObject, props, minfo, id += (long)btmObject.getErrors().length);
                }
                this.prepareExceedCallDetails(btmObject, props, slowSQLTimeDetails);
                if (slowSQLTimeDetails != null && slowSQLTimeDetails.size() > 0) {
                    props.put("SlowSQLTime", slowSQLTimeDetails.get("ALL_SQL"));
                }
                minfo.setProperties(props);
                finalMethodInfoList.add(minfo);
                log.trace("{} final methodInfo Objects :  {}", (Object)this.logPrefix, (Object)finalMethodInfoList);
            } else {
                log.info("{} Data is not from btm or infra , something else", (Object)this.logPrefix);
            }
        }
        catch (Exception e) {
            log.error("{} exception occurred while process NodeJs Btm Data {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private void prepareExceptionTestDetails(NodeCodeError nodeCodeError, Properties props) {
        try {
            if (nodeCodeError != null) {
                String[] exceptionDetailsArray = null;
                ArrayList<String[]> finalExceptionList = new ArrayList<String[]>();
                String rfqcn = nodeCodeError.getRfqcn();
                String rfqcn_msg = nodeCodeError.getRfqcn_msg();
                String bfqcn = nodeCodeError.getBfqcn();
                String bfqcn_msg = nodeCodeError.getBfqcn_msg();
                exceptionDetailsArray = nodeCodeError.getSize() > 4 ? new String[]{rfqcn, rfqcn_msg, bfqcn, bfqcn_msg, nodeCodeError.getRcause_1(), nodeCodeError.getRcause_1_msg(), nodeCodeError.getRcause_2(), nodeCodeError.getRcause_2_msg(), nodeCodeError.getBcause_1(), nodeCodeError.getBcause_1_msg(), nodeCodeError.getBcause_2(), nodeCodeError.getBcause_2_msg()} : new String[]{rfqcn, rfqcn_msg, bfqcn, bfqcn_msg};
                finalExceptionList.add(exceptionDetailsArray);
                props.put("NODEJS_EXCEPTION_FQCN_ROOT", rfqcn);
                props.put("NODEJS_EXCEPTION_FQCN_BOTTOM", bfqcn);
                props.put("NODEJS_EXCEPTION_DETAILS", finalExceptionList);
            }
        }
        catch (Exception e) {
            log.error("{} error while preparing exception test details {} ", (Object)this.logPrefix, (Object)e);
        }
    }

    private void process404RequestDetails(boolean is404Request, JSONObject btmJSON, String componentId, MethodInfo minfo, ArrayList finalMethodInfoList) {
        try {
            Properties props = new Properties();
            HashMap request404 = (HashMap)btmJSON.get((Object)"requestDetails");
            double[] req404count = new double[2];
            long reqCount = (Long)request404.get("requestCount");
            long reqReCount = (Long)request404.get("requestRedirectCount");
            req404count[0] = reqCount;
            req404count[0] = reqReCount;
            props.put("Request404Details", req404count);
            props.put("is404Request", (Object)true);
            props.put("JvmGUID", componentId);
            props.put("isHttpStatusCodeTestEnabled", (Object)true);
            minfo.setProperties(props);
            finalMethodInfoList.add(minfo);
        }
        catch (Exception e) {
            log.error("{} exception occurred while preparing 404 request details NodeJs BTM  {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private void prepareExceedCallDetails(NodeBTM btmObject, Properties props, HashMap<String, double[]> slowSQLTimeDetails) {
        try {
            ExceedSqlDetails[] otherSqlDetails = btmObject.getOtherSqlDetails();
            HashMap<String, double[]> fastSqlDetails = new HashMap<String, double[]>();
            HashMap<String, double[]> errorSqlDetails = new HashMap<String, double[]>();
            HashMap<String, double[]> slowSqlDetails = new HashMap<String, double[]>();
            int index = 0;
            while (index < otherSqlDetails.length) {
                double[] countExeTime;
                String jdbcUrl;
                String hostAddress;
                if (otherSqlDetails[index].getNodeOrder().equals("FASTSQL")) {
                    log.debug("{} preapring FASTQUERY for : {} = {} ", new Object[]{this.logPrefix, btmObject.getEg_guid(), otherSqlDetails[index].getServerType()});
                    hostAddress = this.parseAddress(otherSqlDetails[index].getHost());
                    jdbcUrl = String.valueOf(otherSqlDetails[index].getServerType()) + "://" + hostAddress + ":" + otherSqlDetails[index].getPort() + "/" + otherSqlDetails[index].getDbName();
                    countExeTime = new double[]{otherSqlDetails[index].getQuery(), otherSqlDetails[index].getResTime()};
                    if (jdbcUrl.indexOf("mongodb") <= -1) {
                        this.updateAllSQLDetails(countExeTime, slowSQLTimeDetails);
                    }
                    fastSqlDetails.put(jdbcUrl, countExeTime);
                }
                if (otherSqlDetails[index].getNodeOrder().equals("ErrorExceedSql")) {
                    log.debug("{} preapring Error Exceed Sql for : {} = {} ", new Object[]{this.logPrefix, btmObject.getEg_guid(), otherSqlDetails[index].getServerType()});
                    hostAddress = this.parseAddress(otherSqlDetails[index].getHost());
                    jdbcUrl = String.valueOf(otherSqlDetails[index].getServerType()) + "://" + hostAddress + ":" + otherSqlDetails[index].getPort() + "/" + otherSqlDetails[index].getDbName();
                    countExeTime = new double[]{otherSqlDetails[index].getQuery(), otherSqlDetails[index].getResTime()};
                    if (jdbcUrl.indexOf("mongodb") <= -1) {
                        this.updateAllSQLDetails(countExeTime, slowSQLTimeDetails);
                    }
                    errorSqlDetails.put(jdbcUrl, countExeTime);
                }
                if (otherSqlDetails[index].getNodeOrder().equals("SlowExceedSql")) {
                    log.debug("{} preapring Slow Exceed Sql for : {} = {} ", new Object[]{this.logPrefix, btmObject.getEg_guid(), otherSqlDetails[index].getServerType()});
                    hostAddress = this.parseAddress(otherSqlDetails[index].getHost());
                    jdbcUrl = String.valueOf(otherSqlDetails[index].getServerType()) + "://" + hostAddress + ":" + otherSqlDetails[index].getPort() + "/" + otherSqlDetails[index].getDbName();
                    countExeTime = new double[]{otherSqlDetails[index].getQuery(), otherSqlDetails[index].getResTime()};
                    if (jdbcUrl.indexOf("mongodb") <= -1) {
                        this.updateAllSQLDetails(countExeTime, slowSQLTimeDetails);
                    }
                    slowSqlDetails.put(jdbcUrl, countExeTime);
                }
                ++index;
            }
            if (fastSqlDetails.size() > 0) {
                props.put("Fast_Method_Map", fastSqlDetails);
            }
            if (slowSqlDetails.size() > 0) {
                props.put("Slow_Exceed_Sql_Limit_Map", slowSqlDetails);
            }
            if (errorSqlDetails.size() > 0) {
                props.put("Error_Exceed_Sql_Limit_Map", errorSqlDetails);
            }
        }
        catch (Exception e) {
            log.error("{} exception occurred while processing exceed SQL call details {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private void updateAllSQLDetails(double[] countExeTimes, HashMap<String, double[]> allSqlDetailsMap) {
        try {
            double[] countExeTime = allSqlDetailsMap.get("ALL_SQL");
            countExeTime[0] = countExeTime[0] + countExeTimes[0];
            countExeTime[1] = countExeTime[1] + countExeTimes[1];
        }
        catch (NullPointerException e) {
            allSqlDetailsMap.put("ALL_SQL", new double[]{countExeTimes[0], countExeTimes[1]});
        }
    }

    private String parseAddress(String host) {
        String finalHostAddress = host;
        try {
            if (finalHostAddress != null && (finalHostAddress.indexOf("localhost") > -1 || finalHostAddress.startsWith("127"))) {
                finalHostAddress = "localhost";
            }
        }
        catch (Exception e) {
            log.error("{} exception occurred while parsing hostAddress for SQL call  {}", (Object)this.logPrefix, (Object)e);
        }
        return finalHostAddress;
    }

    private long prepareExternalCallDetails(NodeBTM btmObject, Properties props, PropsManager propsManager, MethodInfo minfo, ArrayList<String> idMapper, HashMap<String, double[]> slowSQLTimeDetails) {
        long id;
        block21: {
            id = 0L;
            try {
                NodeExternalCallDetails externalCallDetails = null;
                NodeHttp[] httpArray = null;
                NodeSql[] sqlArray = null;
                NodeNoSql[] noSqlArray = null;
                NodeCache[] cacheArray = null;
                NodeJms[] nodeJms = null;
                HashMap<Long, MethodInfo> childMapReference = new HashMap<Long, MethodInfo>();
                externalCallDetails = btmObject.getExternalCallDetails();
                log.debug("{} preapring external calls details for {} : {} ", new Object[]{this.logPrefix, btmObject.getEg_guid(), externalCallDetails.toString()});
                if (externalCallDetails == null) break block21;
                int index = 0;
                while (index < idMapper.size()) {
                    String sequenceId = idMapper.get(index);
                    try {
                        httpArray = externalCallDetails.getHttp();
                        if (httpArray != null && httpArray.length > 0) {
                            log.debug("{} preapring http external outbound calls for {} : {} : {} ", new Object[]{this.logPrefix, btmObject.getEg_guid(), id, sequenceId});
                            id = this.prepareHttpExternalCallDetails(httpArray, childMapReference, id, minfo, sequenceId, props);
                        }
                    }
                    catch (Exception e) {
                        log.error("{} exception occurred while preapring outbound http calls : {} ", (Object)this.logPrefix, (Object)e);
                    }
                    try {
                        sqlArray = externalCallDetails.getSql();
                        if (sqlArray != null && sqlArray.length > 0) {
                            log.debug("{} preapring sql external outbound calls for {} : {} : {} ", new Object[]{this.logPrefix, btmObject.getEg_guid(), id, sequenceId});
                            id = this.prepareSqlExternalCallDetails(sqlArray, childMapReference, minfo, id, props, propsManager, sequenceId, slowSQLTimeDetails);
                        }
                    }
                    catch (Exception e) {
                        log.error("{} exception occurred while getting sql calls {} ", (Object)this.logPrefix, (Object)e);
                    }
                    try {
                        noSqlArray = externalCallDetails.getNosql();
                        if (noSqlArray != null && noSqlArray.length > 0) {
                            log.debug("{} preapring non sql external outbound calls for {} : {} : {} ", new Object[]{this.logPrefix, btmObject.getEg_guid(), id, sequenceId});
                            id = this.prepareNonSqlExternalCallDetails(noSqlArray, childMapReference, minfo, props, id, sequenceId);
                        }
                    }
                    catch (Exception e) {
                        log.error("{} exception occurred while getting nosql calls {}", (Object)this.logPrefix, (Object)e);
                    }
                    try {
                        cacheArray = externalCallDetails.getCache();
                        if (cacheArray != null && cacheArray.length > 0) {
                            log.debug("{} preapring cache external outbound calls for {} : {} : {} ", new Object[]{this.logPrefix, btmObject.getEg_guid(), id, cacheArray.toString()});
                            id = this.prepareCacheExternalCallDetails(cacheArray, childMapReference, minfo, props, id);
                        }
                    }
                    catch (Exception e) {
                        log.error("{} exception occurred while getting sql calls {}", (Object)this.logPrefix, (Object)e);
                    }
                    try {
                        nodeJms = externalCallDetails.getJms();
                        if (nodeJms != null && nodeJms.length > 0) {
                            log.debug("{} preapring jms external outbound calls for {} : {} : {} ", new Object[]{this.logPrefix, btmObject.getEg_guid(), id, nodeJms.toString()});
                            id = this.prepareJmsExternalCallDetails(nodeJms, childMapReference, minfo, props, id);
                        }
                    }
                    catch (Exception e) {
                        log.error("{} exception occurred while getting jms calls {}", (Object)this.logPrefix, (Object)e);
                    }
                    ++index;
                }
                if (httpArray == null && sqlArray == null && noSqlArray == null && cacheArray == null && nodeJms == null) {
                    props.put("firstNode", (Object)true);
                } else {
                    props.put("firstNode", (Object)false);
                }
                if (childMapReference.size() > 0) {
                    props.put("CHILD_MAP", childMapReference);
                }
            }
            catch (Exception e) {
                log.error("{} exception occurred while preparing ExternalCallDetails calls {}", (Object)this.logPrefix, (Object)e);
            }
        }
        return id;
    }

    private long prepareJmsExternalCallDetails(NodeJms[] nodeJms, HashMap<Long, MethodInfo> childMapReference, MethodInfo minfo, Properties props, long jmsId) {
        long id = jmsId;
        try {
            int jmsSize;
            if (nodeJms != null && (jmsSize = nodeJms.length) > 0) {
                int jmsCount = 0;
                while (jmsCount < jmsSize) {
                    MethodInfo innerMethodinfo = new MethodInfo();
                    NodeJms jmsNode = nodeJms[jmsCount];
                    innerMethodinfo.setId(++id);
                    int jmsResTime = jmsNode.getResTime();
                    innerMethodinfo.setExecutionTime(Long.parseLong(String.valueOf(jmsResTime)));
                    innerMethodinfo.setType(jmsNode.getPointcut());
                    NodeBTMErrors errStack = jmsNode.getError();
                    String errorStackTrace = "";
                    if (errStack != null && errStack.getStack().length() > 0) {
                        errorStackTrace = errStack.getStack();
                        errorStackTrace = errorStackTrace.replace("\n", "?^?");
                    }
                    Properties propsInner = new Properties();
                    propsInner.put("JMS-PROVIDER", jmsNode.getProvider());
                    propsInner.put("JMS-QUEUE", jmsNode.getQueue());
                    propsInner.put("TYPE", jmsNode.getType());
                    if (jmsNode.getNodeOrder() == null) {
                        propsInner.put("NODE_ORDER", "1.1");
                    } else {
                        propsInner.put("NODE_ORDER", jmsNode.getNodeOrder());
                    }
                    innerMethodinfo.setProperties(propsInner);
                    minfo.addToChildInfo(childMapReference, innerMethodinfo);
                    if (errorStackTrace != null && errorStackTrace.length() > 0) {
                        this.prepareExternalErrorDetails(++id, errStack.getErrorTime(), errorStackTrace, minfo, childMapReference, errStack.getCodeError(), props);
                    }
                    ++jmsCount;
                }
            }
        }
        catch (Exception e) {
            log.error("{} exception occurred while preparing ExternalCallDetails calls for jms {}", (Object)this.logPrefix, (Object)e);
        }
        return id;
    }

    private long prepareCacheExternalCallDetails(NodeCache[] cacheArray, HashMap<Long, MethodInfo> childMapReference, MethodInfo minfo, Properties props, long cacheId) {
        long id = cacheId;
        try {
            int cacheSize;
            if (cacheArray != null && (cacheSize = cacheArray.length) > 0) {
                int cacheCount = 0;
                while (cacheCount < cacheSize) {
                    MethodInfo innerMethodinfo = new MethodInfo();
                    NodeCache cacheNode = cacheArray[cacheCount];
                    innerMethodinfo.setId(++id);
                    int cacheResTime = cacheNode.getResTime();
                    innerMethodinfo.setExecutionTime(Long.parseLong(String.valueOf(cacheResTime)));
                    innerMethodinfo.setType("REDIS");
                    NodeBTMErrors errStack = cacheNode.getError();
                    String errorStackTrace = "";
                    if (errStack != null && errStack.getStack().length() > 0) {
                        errorStackTrace = errStack.getStack();
                        errorStackTrace = errorStackTrace.replace("\n", "?^?");
                    }
                    Properties propsInner = new Properties();
                    propsInner.put("redisIP", cacheNode.getHost());
                    propsInner.put("redisPort", cacheNode.getPort());
                    propsInner.put("redisDetails", cacheNode.getCommand());
                    innerMethodinfo.setProperties(propsInner);
                    minfo.addToChildInfo(childMapReference, innerMethodinfo);
                    if (errorStackTrace != null && errorStackTrace.length() > 0) {
                        this.prepareExternalErrorDetails(++id, errStack.getErrorTime(), errorStackTrace, minfo, childMapReference, errStack.getCodeError(), props);
                    }
                    ++cacheCount;
                }
            }
        }
        catch (Exception e) {
            log.error("{} exception occurred while preparing Cache ExternalCallDetails calls {}", (Object)this.logPrefix, (Object)e);
        }
        return id;
    }

    private long prepareNonSqlExternalCallDetails(NodeNoSql[] noSqlArray, HashMap<Long, MethodInfo> childMapReference, MethodInfo minfo, Properties props, long sqlID, String sequenceCallGraphId) {
        long id = sqlID;
        try {
            int nosqlSize;
            if (noSqlArray != null && (nosqlSize = noSqlArray.length) > 0) {
                int nosqlCount = 0;
                while (nosqlCount < nosqlSize) {
                    MethodInfo innerMethodinfo = new MethodInfo();
                    NodeNoSql nosqlNode = noSqlArray[nosqlCount];
                    if (nosqlNode.getId() != null && nosqlNode.getId().equals(sequenceCallGraphId)) {
                        innerMethodinfo.setId(++id);
                        int sqlResTime = nosqlNode.getResTime();
                        innerMethodinfo.setExecutionTime(Long.parseLong(String.valueOf(sqlResTime)));
                        props.put("isSQLPresent", (Object)true);
                        innerMethodinfo.setExecutionTime(Long.parseLong(String.valueOf(sqlResTime)));
                        innerMethodinfo.setType("MONGODB");
                        NodeBTMErrors errStack = nosqlNode.getError();
                        String errorStackTrace = "";
                        if (errStack != null && errStack.getStack().length() > 0) {
                            errorStackTrace = errStack.getStack();
                            errorStackTrace = errorStackTrace.replace("\n", "?^?");
                        }
                        Properties propsInner = new Properties();
                        String hostAddress = this.parseAddress(nosqlNode.getHost());
                        propsInner.put("mongoServerDetails", "mongodb://" + hostAddress + ":" + nosqlNode.getPort() + "/" + nosqlNode.getDbName());
                        propsInner.put("mongoTableName", nosqlNode.getEntityName());
                        propsInner.put("queryType", nosqlNode.getQueryType());
                        propsInner.put("mongoQuery", nosqlNode.getQuery());
                        propsInner.put("error", errorStackTrace);
                        innerMethodinfo.setProperties(propsInner);
                        minfo.addToChildInfo(childMapReference, innerMethodinfo);
                        if (errorStackTrace != null && errorStackTrace.length() > 0) {
                            this.prepareExternalErrorDetails(++id, errStack.getErrorTime(), errorStackTrace, minfo, childMapReference, errStack.getCodeError(), props);
                        }
                    }
                    ++nosqlCount;
                }
            }
        }
        catch (Exception e) {
            log.error("{} exception occurred while preparing Non SQL ExternalCallDetails calls {}", (Object)this.logPrefix, (Object)e);
        }
        return id;
    }

    private long prepareSqlExternalCallDetails(NodeSql[] sqlArray, HashMap<Long, MethodInfo> childMapReference, MethodInfo minfo, long httpID, Properties props, PropsManager propsManager, String sequenceId, HashMap<String, double[]> slowSQLTimeDetails) {
        long id = httpID;
        try {
            props.put("isSQLPresent", (Object)true);
            int index = 0;
            while (index < sqlArray.length) {
                if (sqlArray[index].getId() != null && sqlArray[index].getId().equals(sequenceId)) {
                    MethodInfo sqlMethodinfo = new MethodInfo();
                    ++id;
                    long sqlResTime = sqlArray[index].getResTime();
                    try {
                        if ((double)sqlResTime >= propsManager.getSQLExecCutOff()) {
                            this.updateAllSQLDetails(new double[]{1.0, sqlResTime}, slowSQLTimeDetails);
                        }
                        sqlMethodinfo.setId(id);
                        sqlMethodinfo.setExecutionTime(sqlResTime);
                        sqlMethodinfo.setType("SQL");
                        Properties propsInner = new Properties();
                        propsInner.put("sqlStmt", sqlArray[index].getQuery());
                        propsInner.put("jdbcUrl", String.valueOf(sqlArray[index].getServerType()) + "://" + sqlArray[index].getHost() + ":" + sqlArray[index].getPort() + "/" + sqlArray[index].getDbName());
                        NodeBTMErrors errStack = sqlArray[index].getError();
                        String errorStackTrace = "";
                        if (errStack != null && errStack.getStack().length() > 0) {
                            errorStackTrace = errStack.getStack();
                            errorStackTrace = errorStackTrace.replace("\n", "?^?");
                        }
                        propsInner.put("sqlError", errorStackTrace);
                        propsInner.put("stackTrace", errorStackTrace);
                        sqlMethodinfo.setProperties(propsInner);
                        minfo.addToChildInfo(childMapReference, sqlMethodinfo);
                        if (errorStackTrace != null && errorStackTrace.length() > 0) {
                            this.prepareExternalErrorDetails(++id, errStack.getErrorTime(), errorStackTrace, minfo, childMapReference, errStack.getCodeError(), props);
                            this.updateAllSQLDetails(new double[]{1.0, sqlResTime}, slowSQLTimeDetails);
                        }
                    }
                    catch (Exception e) {
                        log.error("{} error while getting SQL execution cutoff {} ", (Object)this.logPrefix, (Object)e);
                    }
                }
                ++index;
            }
        }
        catch (Exception e) {
            log.error("{} exception occurred while preparing SQL ExternalCallDetails calls {}", (Object)this.logPrefix, (Object)e);
        }
        return id;
    }

    private long prepareHttpExternalCallDetails(NodeHttp[] httpArray, HashMap<Long, MethodInfo> childMapReference, long initialId, MethodInfo minfo, String sequenceId, Properties props) {
        long id = initialId;
        try {
            int index = 0;
            while (index < httpArray.length) {
                if (httpArray[index].getId() != null && httpArray[index].getId().equals(sequenceId)) {
                    MethodInfo httpMethodinfo = new MethodInfo();
                    NodeHttp httpNode = httpArray[index];
                    httpMethodinfo.setId(++id);
                    httpMethodinfo.setExecutionTime(httpNode.getResTime());
                    httpMethodinfo.setType("HTTP");
                    int httpStatusCode = httpNode.getStatusCode();
                    Properties propsInner = new Properties();
                    propsInner.put("EXTURL", httpNode.getUri());
                    propsInner.put("METHOD", httpNode.getMethod());
                    propsInner.put("NODE_ORDER", httpNode.getNodeOrder());
                    if (httpStatusCode == 0) {
                        propsInner.put("SC", "-");
                    } else {
                        propsInner.put("SC", String.valueOf(httpStatusCode));
                    }
                    propsInner.put("RM", "-");
                    httpMethodinfo.setProperties(propsInner);
                    minfo.addToChildInfo(childMapReference, httpMethodinfo);
                    NodeBTMErrors errStack = httpNode.getError();
                    String errorStackTrace = "";
                    if (errStack != null && errStack.getStack().length() > 0) {
                        errorStackTrace = errStack.getStack();
                        errorStackTrace = errorStackTrace.replace("\n", "?^?");
                    }
                    if (errorStackTrace != null && errorStackTrace.length() > 0) {
                        this.prepareExternalErrorDetails(++id, errStack.getErrorTime(), errorStackTrace, minfo, childMapReference, errStack.getCodeError(), props);
                    }
                }
                ++index;
            }
        }
        catch (Exception e) {
            log.error("{} exception occurred while preparing HTTP ExternalCallDetails calls {}", (Object)this.logPrefix, (Object)e);
        }
        return id;
    }

    private void prepareCallTraceDetails(NodeBTM btmObject, Properties props, ArrayList<String> idMapper) {
        try {
            NodeTraceSpan[] callTraceArr = btmObject.getCallTrace();
            StringBuilder callTraceStrB = new StringBuilder();
            long callTraceStartTime = callTraceArr[0].getStartTime();
            long rootSelfTime = this.calculateSelfTimeForRootMethod(callTraceArr);
            if (callTraceArr != null) {
                int j = 0;
                while (j < callTraceArr.length) {
                    NodeTraceSpan span = callTraceArr[j];
                    if (j == 0) {
                        callTraceStrB.append("0");
                    } else {
                        callTraceStrB.append("0." + (j - 1));
                    }
                    callTraceStrB.append(callTraceDelimiter);
                    if (j == 0) {
                        callTraceStrB.append(btmObject.getResTime());
                    } else {
                        callTraceStrB.append(NOT_Available);
                    }
                    callTraceStrB.append(callTraceDelimiter);
                    long startTime = span.getStartTime();
                    if (j == 0) {
                        callTraceStrB.append(rootSelfTime);
                    } else {
                        callTraceStrB.append(span.getDuration());
                    }
                    callTraceStrB.append(callTraceDelimiter);
                    callTraceStrB.append(span.getName());
                    callTraceStrB.append(callTraceDelimiter);
                    callTraceStrB.append(span.getType());
                    if (span.getId() != null && !idMapper.contains(span.getId())) {
                        idMapper.add(span.getId());
                    }
                    callTraceStrB.append(callTraceTimeDelimiter);
                    callTraceStrB.append(startTime - callTraceStartTime);
                    callTraceStrB.append(callTraceLineDelimiter);
                    ++j;
                }
            }
            props.put("callTrace", callTraceStrB.toString());
        }
        catch (Exception e) {
            log.error("{} exception occurred while preparing call trace Details calls {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private long calculateSelfTimeForRootMethod(NodeTraceSpan[] callTraceArr) {
        long selfTime = 0L;
        try {
            long totalTime = 0L;
            long duration = 0L;
            int j = 0;
            while (j < callTraceArr.length) {
                NodeTraceSpan span = callTraceArr[j];
                if (j == 0) {
                    totalTime = span.getDuration();
                } else {
                    duration += span.getDuration();
                }
                ++j;
            }
            selfTime = totalTime - duration;
            if (selfTime < 0L) {
                selfTime = totalTime;
            }
        }
        catch (Exception e) {
            log.error("{} exception occurred while calculating duration for root method {}", (Object)this.logPrefix, (Object)e);
        }
        return selfTime;
    }

    private void prepareMethodInfoObject(Properties props, NodeBTM btmObject, MethodInfo minfo, PropsManager propsManager) {
        try {
            int resTime = btmObject.getResTime();
            double slowThesh = 4000.0;
            double stalledThesh = 60000.0;
            try {
                String slowStr = btmObject.getSlowUrlThreshold();
                if (slowStr != null) {
                    slowThesh = Double.parseDouble(slowStr);
                }
            }
            catch (Exception slowStr) {
                // empty catch block
            }
            try {
                String stalledStr = btmObject.getStallUrlThreshold();
                if (stalledStr != null) {
                    stalledThesh = Double.parseDouble(stalledStr);
                }
            }
            catch (Exception stalledStr) {
                // empty catch block
            }
            try {
                log.debug("{} btm slowThesh - {}, resTime - {}", new Object[]{this.logPrefix, slowThesh, resTime});
                minfo.setExecutionTime(Long.parseLong(String.valueOf(resTime)));
                if ((double)resTime >= slowThesh && (double)resTime < stalledThesh) {
                    props.put("isSlowURL", (Object)true);
                }
                if ((double)resTime >= stalledThesh) {
                    props.put("isStalled", (Object)true);
                }
                if (btmObject.isTransactionError()) {
                    props.put("isErrorURL", (Object)true);
                }
            }
            catch (Exception e) {
                log.error("{} error while setting slow and stalled threshold {}", (Object)this.logPrefix, (Object)e);
            }
            minfo.setExecutionTime(Long.parseLong(String.valueOf(resTime)));
        }
        catch (Exception e) {
            log.error("{} exception occurred while preparing Method Info Object {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private Properties prepareBtmPropsDetails(NodeBTM btmObject, String componentId, PropsManager propsManager) {
        Properties props = new Properties();
        try {
            props.setProperty("JvmGUID", componentId);
            props.setProperty("PS", btmObject.getUri());
            props.put("keyTransaction", (Object)false);
            props.put("isSQLPresent", (Object)false);
            props.put("isSlowURL", (Object)false);
            props.put("isErrorURL", (Object)false);
            props.put("isStalled", (Object)false);
            props.put("CONTEXT", btmObject.getUri());
            props.put("remoteHost", btmObject.getRemote_host());
            props.put("Thread_GUID", btmObject.getThreadGuid());
            props.put("SlowLimit", btmObject.getSlowUrlThreshold());
            props.put("StalledLimit", btmObject.getStallUrlThreshold());
            props.put("QUERYSTRING", btmObject.getQueryString());
            props.put("SESSIONID", btmObject.getSessid());
            props.put("THREAD", btmObject.getThreadId() == null ? "-" : btmObject.getThreadId());
            props.put("DEVICE", btmObject.getDevice());
            props.put("OS", btmObject.getOs());
            props.put("BROWSER", btmObject.getBrowser());
            props.put("REFERER", btmObject.getReferer());
            props.put("REDIRECTED_ERROR_PAGE", (Object)btmObject.isRedirectedErrorPage());
            props.put("is404Request", (Object)false);
            props.put("isHttpStatusCodeTestEnabled", (Object)true);
            props.put("STATUS_MESSAGE", btmObject.getStatusMessage());
            props.put("User-Agent".toLowerCase(), btmObject.getUserAgent());
            int statusCode = btmObject.getStatusCode();
            if (this.isErrorStatusCode(statusCode)) {
                props.put("STATUS", (Object)statusCode);
                props.put("isErrorURL", (Object)true);
            } else {
                if (statusCode == 0) {
                    props.put("STATUS", "-");
                } else {
                    props.put("STATUS", (Object)statusCode);
                }
                props.put("ExceptionTrace", "");
            }
            String headers = btmObject.getHeaders();
            String cookies = btmObject.getCookies();
            try {
                Hashtable<String, String> headersDetails = new Hashtable<String, String>();
                if (headers != null && !headers.equals("-")) {
                    this.parseCookiesHeadersDeails(headers, headersDetails, true);
                }
                if (cookies != null && !cookies.equals("-")) {
                    headersDetails.put("cookie", cookies);
                }
                if (headersDetails != null) {
                    props.put("HEADERS", headersDetails);
                }
            }
            catch (Exception e) {
                log.error("{} error while parsing HTTP Headers from {} {}", new Object[]{this.logPrefix, headers, e});
            }
            props.put("METHODTYPE", btmObject.getMethod());
            props.put("GUID", String.valueOf(btmObject.getEg_guid()) + "#~#" + btmObject.getNodeOrder());
            String reqTime = btmObject.getReqTime();
            props.put("requestID", String.valueOf(btmObject.getUri()) + " @ " + reqTime);
            props.put("DataBaseHT", "true");
            props.put("TimeZone", btmObject.getTz());
            props.put("requestType", btmObject.getReqType());
            props.put("urlPatternsMatched", btmObject.getUri());
            props.put("UTC", btmObject.getUtc());
            props.put("CustomPC", new Hashtable());
        }
        catch (Exception e) {
            log.error("{} exception occurred while preparing BTM Props Details {}", (Object)this.logPrefix, (Object)e);
        }
        return props;
    }

    private void processNodeJsErrorInfraDetails(NodeInfra infraObject, NodeInfraCluster currentInfraObject, NodeDataRepository nodeRepository, String componentId, boolean isErrorInfra) {
        try {
            String workerID = null;
            workerID = infraObject.getMode().equals("STANDALONE") ? "Standalone" : infraObject.getWorkerId();
            NodeGC[] gcData = infraObject.getGc();
            boolean isMaster = infraObject.isMaster();
            int workerCount = infraObject.getWorkerCount();
            log.info("{} WorkerID : {}  isMaster : {}  workerCount : {} infraObject : {} ", new Object[]{this.logPrefix, workerID, isMaster, workerCount, infraObject.toString()});
            if (gcData != null && gcData.length >= 1000) {
                this.processNodeGcDetails(currentInfraObject, gcData, isMaster, workerID);
                return;
            }
            currentInfraObject.setWorkerCount(workerCount);
            if (isErrorInfra) {
                currentInfraObject.getErrorList().add(infraObject);
                log.info("{} metrics are from nodejs error MASTER", (Object)this.logPrefix);
            } else if (isMaster) {
                currentInfraObject.setMaster(infraObject);
                log.info("{} metrics are from nodejs MASTER", (Object)this.logPrefix);
            } else {
                log.info("{} metrics are from nodejs Worker", (Object)this.logPrefix);
                currentInfraObject.setWorker(workerID, infraObject);
            }
            nodeRepository.setInfraById(componentId, currentInfraObject);
            log.trace("{} added infra objects into existing repository {}", (Object)this.logPrefix, (Object)currentInfraObject);
        }
        catch (Exception e) {
            log.error("{} Error while trying to extract data for Node JS Error Infra Details ", (Object)this.logPrefix, (Object)e);
        }
    }

    private void processNodeGcDetails(NodeInfraCluster currentInfraObject, NodeGC[] gcData, boolean isMaster, String workerID) {
        try {
            HashMap<String, ArrayList<NodeGC[]>> gcMapDetails = currentInfraObject.getNodeGcMap();
            if (gcMapDetails == null) {
                ArrayList<NodeGC[]> nodeGcArray = new ArrayList<NodeGC[]>();
                nodeGcArray.add(gcData);
                if (isMaster) {
                    currentInfraObject.setNodeGcMap("master", nodeGcArray);
                } else {
                    currentInfraObject.setNodeGcMap(workerID, nodeGcArray);
                }
            } else if (isMaster) {
                ArrayList<NodeGC[]> listGc = gcMapDetails.get("master");
                listGc.add(gcData);
            } else {
                ArrayList<NodeGC[]> listGc = gcMapDetails.get(workerID);
                listGc.add(gcData);
            }
        }
        catch (Exception e) {
            log.error("{} Error while trying to merging gc data for Node JS Infra Details ", (Object)this.logPrefix, (Object)e);
        }
    }

    private void prepareExternalErrorDetails(long id, long errorTime, String errorStackTrace, MethodInfo minfo, HashMap<Long, MethodInfo> childMapReference, NodeCodeError nodeCodeError, Properties props) {
        try {
            MethodInfo errorMethodinfo = new MethodInfo();
            errorMethodinfo.setId(id);
            errorMethodinfo.setExecutionTime(errorTime);
            errorMethodinfo.setType("EXCEPTION");
            Properties errorPropsInner = new Properties();
            errorPropsInner.setProperty("EXCEPTION", errorStackTrace);
            errorMethodinfo.setProperties(errorPropsInner);
            minfo.addToChildInfo(childMapReference, errorMethodinfo);
            this.prepareExceptionTestDetails(nodeCodeError, props);
        }
        catch (Exception e) {
            log.error("{} error while preparing exception for external calls {} ", (Object)this.logPrefix, (Object)e);
        }
    }

    private void prepareBusinessErorrDetails(NodeBTM btmObject, Properties props, MethodInfo minfo, long id) {
        try {
            NodeBTMErrors[] nodeBtmErrors = null;
            HashMap<Long, MethodInfo> childMapReference = (HashMap<Long, MethodInfo>)props.get("CHILD_MAP");
            if (childMapReference == null) {
                childMapReference = new HashMap<Long, MethodInfo>();
            }
            if (btmObject != null) {
                nodeBtmErrors = btmObject.getErrors();
                int index = 0;
                while (index < nodeBtmErrors.length) {
                    this.prepareExceptionTestDetails(nodeBtmErrors[index].getCodeError(), props);
                    MethodInfo errorMethodinfo = new MethodInfo();
                    errorMethodinfo.setId(id += (long)index);
                    errorMethodinfo.setExecutionTime(nodeBtmErrors[index].getErrorTime());
                    errorMethodinfo.setType("EXCEPTION");
                    Properties propsInner = new Properties();
                    String errorStack = nodeBtmErrors[index].getStack().replace("\n", "?^?");
                    propsInner.setProperty("EXCEPTION", errorStack);
                    errorMethodinfo.setProperties(propsInner);
                    minfo.addToChildInfo(childMapReference, errorMethodinfo);
                    ++index;
                }
                if (childMapReference.size() > 0) {
                    props.put("CHILD_MAP", childMapReference);
                }
            }
        }
        catch (Exception e) {
            log.error("{} exception occurred while process NodeJs BTM Data for Exception {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private void processInfraData(JSONObject innerJsonObject, ObjectMapper objectMapper) {
        block7: {
            try {
                JSONObject infraJSON = (JSONObject)innerJsonObject.get((Object)"infra");
                NodeInfra infraObject = (NodeInfra)objectMapper.readValue(infraJSON.toJSONString(), NodeInfra.class);
                NodeDataRepository nodeRepository = NodeDataRepository.getRepository();
                String componentId = (String)innerJsonObject.get((Object)"componentId");
                log.info("{} ComponentId : {}  infraObject : {}  ", new Object[]{this.logPrefix, componentId, infraObject});
                try {
                    if (!nodeRepository.isInfraIdExists(componentId)) {
                        log.info("{} adding new component JVMGUID into node infra repository : {}", (Object)this.logPrefix, (Object)componentId);
                        nodeRepository.setInfraById(componentId, new NodeInfraCluster());
                    } else {
                        log.info("{} component JVMGUID is already added into node infra repository : {}", (Object)this.logPrefix, (Object)componentId);
                    }
                    NodeInfraCluster currentInfraObject = nodeRepository.getInfraById(componentId);
                    if (infraObject.getError() != null) {
                        this.processNodeJsErrorInfraDetails(infraObject, currentInfraObject, nodeRepository, componentId, true);
                        break block7;
                    }
                    this.processNodeJsErrorInfraDetails(infraObject, currentInfraObject, nodeRepository, componentId, false);
                }
                catch (Exception e) {
                    log.error("{} Error while storing infra into repo {}", (Object)this.logPrefix, (Object)e);
                }
            }
            catch (Exception e) {
                log.error("{} exception occurred while process NodeJs NormalDetails Infra :  {}", (Object)this.logPrefix, (Object)e);
            }
        }
    }

    private void processDumpData(JSONObject innerJsonObject, ObjectMapper objectMapper) {
        try {
            JSONObject infraJSON = (JSONObject)innerJsonObject.get((Object)"nodeDump");
            NodeDumps nodeDumps = (NodeDumps)objectMapper.readValue(infraJSON.toJSONString(), NodeDumps.class);
            NodeDataRepository nodeRepository = NodeDataRepository.getRepository();
            String componentId = (String)innerJsonObject.get((Object)"componentId");
            log.trace("{} ComponentId : {}  nodeDumps : {}  ", new Object[]{this.logPrefix, componentId, nodeDumps});
            if (!nodeRepository.isDumpIdExists(componentId)) {
                log.info("{} adding new component JVMGUID into node dump repository : {}", (Object)this.logPrefix, (Object)componentId);
                nodeRepository.setDumpById(componentId, new NodeDumpCluster());
            } else {
                log.info("{} component JVMGUID is already added into node dump repository : {}", (Object)this.logPrefix, (Object)componentId);
            }
            NodeDumpCluster currentInfraObject = nodeRepository.getDumpById(componentId);
            this.processNodeJsDumpDetails(nodeDumps, currentInfraObject, nodeRepository, componentId);
        }
        catch (Exception e) {
            log.error("{} exception occurred while process NodeJs dumps data :  {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private void processNodeJsDumpDetails(NodeDumps nodeDumps, NodeDumpCluster currentDumpObject, NodeDataRepository nodeRepository, String componentId) {
        try {
            String workerID = null;
            workerID = nodeDumps.getMode().equals("STANDALONE") ? "Standalone" : nodeDumps.getWorkerId();
            boolean isMaster = nodeDumps.isMaster();
            int workerCount = nodeDumps.getWorkerCount();
            log.info("{} WorkerID : {}  isMaster : {}  workerCount : {} dump Object : {} ", new Object[]{this.logPrefix, workerID, isMaster, workerCount, currentDumpObject});
            currentDumpObject.setWorkerCount(workerCount);
            if (isMaster) {
                currentDumpObject.setMaster(nodeDumps);
                log.info("{} metrics are from Nodejs master", (Object)this.logPrefix);
            } else {
                log.info("{} metrics are from Nodejs worker", (Object)this.logPrefix);
                currentDumpObject.setWorkers(workerID, nodeDumps);
            }
            nodeRepository.setDumpById(componentId, currentDumpObject);
            log.trace("{} added dump objects into existing repository {}", (Object)this.logPrefix, (Object)currentDumpObject);
        }
        catch (Exception e) {
            log.error("{} Error while trying to extract data for Node JS dump Details ", (Object)this.logPrefix, (Object)e);
        }
    }

    private boolean isErrorStatusCode(int statusCode) {
        return statusCode != 0 && (statusCode < 100 || statusCode > 399);
    }

    public String parseCookiesHeadersDeails(String headers, Hashtable headersDetails, boolean isHeaders) {
        JSONParser jsonParser = new JSONParser();
        StringBuilder cookiesBuilder = new StringBuilder();
        JSONObject jsonHeader = null;
        try {
            jsonHeader = (JSONObject)jsonParser.parse(headers);
        }
        catch (ParseException e) {
            log.error("{} error while parsing headers {}", (Object)this.logPrefix, (Object)e);
        }
        if (jsonHeader != null && jsonHeader.size() > 0) {
            Set headerData = jsonHeader.keySet();
            Iterator itr = headerData.iterator();
            while (itr.hasNext()) {
                String headerKey = itr.next().toString();
                String headerValue = (String)jsonHeader.get((Object)headerKey);
                if (isHeaders) {
                    headersDetails.put(headerKey, headerValue);
                    continue;
                }
                cookiesBuilder.append(headerKey).append("=").append(headerValue).append(";");
            }
        }
        return cookiesBuilder.toString();
    }

    public MethodInfo getHttpCallDetails(NodeHttp[] httpArray) {
        int httpSize = 0;
        httpSize = httpArray.length;
        MethodInfo innerMethodinfo = null;
        if (httpSize > 0) {
            int httpCount = 0;
            while (httpCount < httpSize) {
                innerMethodinfo = new MethodInfo();
                NodeHttp httpNode = httpArray[httpCount];
                long id = httpCount + 1;
                innerMethodinfo.setId(id);
                innerMethodinfo.setExecutionTime(Long.parseLong(String.valueOf(httpNode.getResTime())));
                innerMethodinfo.setType("HTTP");
                Properties propsInner = new Properties();
                propsInner.put("EXTURL", httpNode.getUri());
                propsInner.put("METHOD", httpNode.getMethod());
                propsInner.put("NODE_ORDER", String.valueOf(httpNode.getNodeOrder()));
                propsInner.put("SC", String.valueOf(httpNode.getStatusCode()));
                propsInner.put("RM", "-");
                innerMethodinfo.setProperties(propsInner);
                ++httpCount;
            }
        }
        return innerMethodinfo;
    }

    public static enum Mapper {
        INSTANCE;

        private final ObjectMapper mapper = new ObjectMapper();

        private Mapper() {
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }

        public ObjectMapper getObjectMapper() {
            return this.mapper;
        }
    }
}

