/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ContainerInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class K8sSpecHandler {
    private static K8sSpecHandler instance;
    private ArrayList nsToInclude;
    private ArrayList nsToExclude;
    private ArrayList deploymentNameToInclude;
    private ArrayList labelToInclude;
    private ArrayList containerNameToInclude;
    private boolean doWildCardCheck_4_NsToInclude = false;
    private boolean doWildCardCheck_4_NsToExclude = false;
    private boolean doWildCardCheck_4_deploymentName = false;
    private boolean doWildCardCheck_4_labels = false;
    private boolean isAllContainerSelected = false;
    private boolean isFirstContainerSelected = false;
    private boolean isSpecificContainerSeleted = false;
    private boolean doWildCardCheck_4_containerName = false;
    private static final String loggerDispStr = "[K8sSpecHandler]";

    private K8sSpecHandler() {
        this.initSpecHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static K8sSpecHandler getInstance() {
        if (instance != null) return instance;
        Class<K8sSpecHandler> clazz = K8sSpecHandler.class;
        synchronized (K8sSpecHandler.class) {
            if (instance != null) return instance;
            instance = new K8sSpecHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initSpecHandler() {
        this.readNameSpaceSpecDetails();
        this.readDeploymentSpecDetails();
        this.readLabelSpecDetails();
        this.readContainerSpecDetails();
    }

    private String getEnv(String string) {
        return System.getenv(string);
    }

    private boolean isWildCard(String string) {
        if (string != null) {
            return string.contains("*");
        }
        return false;
    }

    private void readNameSpaceSpecDetails() {
        try {
            String string = this.getEnv("NAMESPACES_TO_INCLUDE");
            String string2 = this.getEnv("NAMESPACES_TO_EXCLUDE");
            this.nsToInclude = APMUtils.getStringAsArrayList(string, "|", APMDiscoveryLogger.discoveryLogger);
            this.nsToExclude = APMUtils.getStringAsArrayList(string2, "|", APMDiscoveryLogger.discoveryLogger);
            this.doWildCardCheck_4_NsToInclude = this.isWildCard(string);
            this.doWildCardCheck_4_NsToExclude = this.isWildCard(string2);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void readDeploymentSpecDetails() {
        try {
            String string = this.getEnv("DEPLOYMENT_NAME_MATCH");
            this.deploymentNameToInclude = APMUtils.getStringAsArrayList(string, "|", APMDiscoveryLogger.discoveryLogger);
            this.doWildCardCheck_4_deploymentName = this.isWildCard(string);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void readLabelSpecDetails() {
        try {
            String string = this.getEnv("LABEL_MATCH");
            this.labelToInclude = APMUtils.getStringAsArrayList(string, "|", APMDiscoveryLogger.discoveryLogger);
            this.doWildCardCheck_4_labels = this.isWildCard(string);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void readContainerSpecDetails() {
        try {
            String string = this.getEnv("CONTAINER_SELECTION");
            if (string != null && string.equalsIgnoreCase("select")) {
                String string2 = this.getEnv("CONTAINER_NAME_MATCH");
                this.containerNameToInclude = APMUtils.getStringAsArrayList(string2, "|", APMDiscoveryLogger.discoveryLogger);
                this.doWildCardCheck_4_containerName = this.isWildCard(string2);
                this.isSpecificContainerSeleted = true;
            } else if (string != null && string.equalsIgnoreCase("all")) {
                this.isAllContainerSelected = true;
            } else if (string != null && string.equalsIgnoreCase("first")) {
                this.isFirstContainerSelected = true;
            } else {
                this.isAllContainerSelected = true;
            }
            if (this.isAllContainerSelected || this.isFirstContainerSelected) {
                this.containerNameToInclude = new ArrayList();
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private boolean validate(String string, ArrayList arrayList, boolean bl, boolean bl2) {
        try {
            String string2 = string = string == null ? "" : string;
            if (arrayList.isEmpty()) {
                return bl2;
            }
            if (bl) {
                return this.patternMatch(arrayList, string);
            }
            return arrayList.contains(string);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
            return false;
        }
    }

    public boolean isNameSpaceIncluded(String string) {
        return this.validateForNameSpacesInclude(string, this.nsToInclude, this.doWildCardCheck_4_NsToInclude, false);
    }

    private boolean validateForNameSpacesInclude(String string, ArrayList arrayList, boolean bl, boolean bl2) {
        try {
            String string2 = string = string == null ? "" : string;
            if (arrayList.isEmpty()) {
                return bl2;
            }
            if (arrayList.size() == 1 && arrayList.contains("*")) {
                return true;
            }
            if (bl) {
                return this.patternMatch(arrayList, string);
            }
            return arrayList.contains(string);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
            return false;
        }
    }

    public boolean isNameSpaceExcluded(String string) {
        return this.validate(string, this.nsToExclude, this.doWildCardCheck_4_NsToExclude, false);
    }

    public boolean isDeploymentNameIncluded(String string) {
        return this.validate(string, this.deploymentNameToInclude, this.doWildCardCheck_4_deploymentName, true);
    }

    public boolean isLabelNameIncluded(String string) {
        return this.validate(string, this.labelToInclude, this.doWildCardCheck_4_labels, true);
    }

    public boolean isLabelNameIncluded(ArrayList arrayList) {
        try {
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    if (!this.isLabelNameIncluded(string)) continue;
                    return true;
                }
            } else if (arrayList == null && this.labelToInclude != null && this.labelToInclude.isEmpty()) {
                return true;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
        }
        return false;
    }

    public boolean isContainerNameIncluded(HashMap hashMap, String string) {
        try {
            if (hashMap != null) {
                for (int i = 0; i < hashMap.size(); ++i) {
                    ContainerInfo containerInfo = (ContainerInfo)hashMap.get(string);
                    if (containerInfo == null || !this.isContainerNameIncluded(containerInfo.getName(), containerInfo.getIndex())) continue;
                    return true;
                }
            } else if (hashMap == null && this.containerNameToInclude != null && this.containerNameToInclude.isEmpty()) {
                return true;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
        }
        return false;
    }

    public boolean isContainerNameIncluded(String string, int n) {
        if (this.isSpecificContainerSeleted) {
            return this.validate(string, this.containerNameToInclude, this.doWildCardCheck_4_containerName, true);
        }
        if (this.isAllContainerSelected) {
            return true;
        }
        return this.isFirstContainerSelected && n == 0;
    }

    private boolean patternMatch(ArrayList arrayList, String string) {
        if (arrayList != null && !arrayList.isEmpty()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                boolean bl = APMUtils.wildCardPatternMatch(string, string2);
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    private boolean IsValidContainerSpec(Hashtable hashtable) {
        try {
            String string = (String)hashtable.get("containerId");
            String string2 = (String)hashtable.get("nameSpace");
            String string3 = (String)hashtable.get("podName");
            if (string3 == null || string2 == null || string == null) {
                return false;
            }
            if (this.isNameSpaceExcluded(string2)) {
                APMDiscoveryLogger.discoveryLogger.info("{} filterOutWithSpecInfo() - podName : {}, containerId : {}, namespace : {}  is in exluded namespace list, Skipping... ", new Object[]{loggerDispStr, string3, string, string2});
                return false;
            }
            if (!this.isNameSpaceIncluded(string2)) {
                APMDiscoveryLogger.discoveryLogger.info("{} filterOutWithSpecInfo() - podName : {}, containerId : {}, namespace : {} is not in included namespace list, Skipping... ", new Object[]{loggerDispStr, string3, string, string2});
                return false;
            }
            String string4 = (String)hashtable.get("deploymentName");
            if (!this.isDeploymentNameIncluded(string4)) {
                APMDiscoveryLogger.discoveryLogger.info("{} filterOutWithSpecInfo() - podName : {}, containerId : {}, namespace : {}, deploymentName : {}  is not in included deployment name list, Skipping... ", new Object[]{loggerDispStr, string3, string, string2, string4});
                return false;
            }
            ArrayList arrayList = (ArrayList)hashtable.get("labelsList");
            if (!this.isLabelNameIncluded(arrayList)) {
                APMDiscoveryLogger.discoveryLogger.info("{} filterOutWithSpecInfo() - podName : {}, containerId : {}, namespace : {}, labelsList : {}  is not in included lebel list, Skipping... ", new Object[]{loggerDispStr, string3, string, string2, arrayList});
                return false;
            }
            HashMap hashMap = (HashMap)hashtable.get("containersList");
            if (!this.isContainerNameIncluded(hashMap, string)) {
                APMDiscoveryLogger.discoveryLogger.info("{} filterOutWithSpecInfo() - podName : {}, containerId : {}, namespace : {}, containersList : {}  is not in included container name list, Skipping... ", new Object[]{loggerDispStr, string3, string, string2, hashMap});
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
            return false;
        }
    }

    public void filterOutWithSpecInfo(ConcurrentHashMap concurrentHashMap) {
        if (concurrentHashMap == null) {
            return;
        }
        Iterator iterator = concurrentHashMap.entrySet().iterator();
        APMDiscoveryLogger.discoveryLogger.debug("{} Current k8sSpecHandler config - {}", (Object)loggerDispStr, (Object)this);
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Hashtable hashtable = (Hashtable)entry.getValue();
                String string2 = (String)hashtable.get("nameSpace");
                String string3 = (String)hashtable.get("podName");
                if (string3 == null || string2 == null) continue;
                if (this.isNameSpaceExcluded(string2)) {
                    APMDiscoveryLogger.discoveryLogger.info("{} filterOutWithSpecInfo() - podName : {}, containerId : {}, namespace : {}  is in exluded namespace list, Skipping... ", new Object[]{loggerDispStr, string3, string, string2});
                    concurrentHashMap.remove(string);
                    continue;
                }
                if (!this.isNameSpaceIncluded(string2)) {
                    APMDiscoveryLogger.discoveryLogger.info("{} filterOutWithSpecInfo() - podName : {}, containerId : {}, namespace : {} is not in included namespace list, Skipping... ", new Object[]{loggerDispStr, string3, string, string2});
                    concurrentHashMap.remove(string);
                    continue;
                }
                String string4 = (String)hashtable.get("deploymentName");
                if (!this.isDeploymentNameIncluded(string4)) {
                    APMDiscoveryLogger.discoveryLogger.info("{} filterOutWithSpecInfo() - podName : {}, containerId : {}, namespace : {}, deploymentName : {}  is not in included deployment name list, Skipping... ", new Object[]{loggerDispStr, string3, string, string2, string4});
                    concurrentHashMap.remove(string);
                    continue;
                }
                ArrayList arrayList = (ArrayList)hashtable.get("labelsList");
                if (!this.isLabelNameIncluded(arrayList)) {
                    APMDiscoveryLogger.discoveryLogger.info("{} filterOutWithSpecInfo() - podName : {}, containerId : {}, namespace : {}, labelsList : {}  is not in included lebel list, Skipping... ", new Object[]{loggerDispStr, string3, string, string2, arrayList});
                    concurrentHashMap.remove(string);
                    continue;
                }
                HashMap hashMap = (HashMap)hashtable.get("containersList");
                if (this.isContainerNameIncluded(hashMap, string)) continue;
                APMDiscoveryLogger.discoveryLogger.info("{} filterOutWithSpecInfo() - podName : {}, containerId : {}, namespace : {}, containersList : {}  is not in included container name list, Skipping... ", new Object[]{loggerDispStr, string3, string, string2, hashMap});
                concurrentHashMap.remove(string);
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
            }
        }
        APMDiscoveryLogger.discoveryLogger.trace("{} filterOutWithSpecInfo() - After filter-out - {}", (Object)loggerDispStr, (Object)concurrentHashMap);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("K8sSpecHandler : {nsToInclude=").append(this.nsToInclude).append(", nsToExclude=").append(this.nsToExclude).append(", deploymentNameToInclude=").append(this.deploymentNameToInclude).append(", labelToInclude=").append(this.labelToInclude).append(", containerNameToInclude=").append(this.containerNameToInclude).append(", doWildCardCheck_4_NsToInclude=").append(this.doWildCardCheck_4_NsToInclude).append(", doWildCardCheck_4_NsToExclude=").append(this.doWildCardCheck_4_NsToExclude).append(", doWildCardCheck_4_deploymentName=").append(this.doWildCardCheck_4_deploymentName).append(", doWildCardCheck_4_labels=").append(this.doWildCardCheck_4_labels).append(", doWildCardCheck_4_containerName=").append(this.doWildCardCheck_4_containerName).append(", isAllContainerSelected=").append(this.isAllContainerSelected).append(", isFirstContainerSelected=").append(this.isFirstContainerSelected).append(", isSpecificContainerSeleted=").append(this.isSpecificContainerSeleted).append("}");
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        K8sSpecHandler k8sSpecHandler = K8sSpecHandler.getInstance();
        System.out.println(k8sSpecHandler);
        System.out.println();
        System.out.println("nsToInclude: " + k8sSpecHandler.nsToInclude);
        System.out.println("nsToExclude: " + k8sSpecHandler.nsToExclude);
        System.out.println();
        System.out.println("order Excludeded : " + k8sSpecHandler.isNameSpaceExcluded("order"));
        System.out.println("gateway Excludeded : " + k8sSpecHandler.isNameSpaceExcluded("gateway"));
        System.out.println("mysql Excludeded : " + k8sSpecHandler.isNameSpaceExcluded("mysql"));
        System.out.println("vcv Excludeded : " + k8sSpecHandler.isNameSpaceExcluded("vcv"));
        System.out.println();
        System.out.println("emty contains : " + k8sSpecHandler.nsToInclude.contains(""));
        System.out.println();
        System.out.println("frontend includeded : " + k8sSpecHandler.isNameSpaceIncluded("frontend"));
        System.out.println("customer includeded : " + k8sSpecHandler.isNameSpaceIncluded("customer"));
        System.out.println("eg includeded : " + k8sSpecHandler.isNameSpaceIncluded("eg"));
        System.out.println();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("name=frontend");
        arrayList.add("cluster=prod");
        System.out.println("customer isDeploymentNameIncluded: " + k8sSpecHandler.isDeploymentNameIncluded("customer"));
        System.out.println("isLabelNameIncluded: " + k8sSpecHandler.isLabelNameIncluded(arrayList));
        System.out.println("customer isContainerNameIncluded: " + k8sSpecHandler.isContainerNameIncluded("customer", 0));
    }
}

