/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.apm.EgLogFilter;
import com.eg.apm.EgLogbackConfig;
import com.eg.apm.EgLogbackProperties;
import com.eg.ch.qos.logback.classic.AsyncAppender;
import com.eg.ch.qos.logback.classic.Level;
import com.eg.ch.qos.logback.classic.Logger;
import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import com.eg.ch.qos.logback.contrib.jackson.JacksonJsonFormatter;
import com.eg.ch.qos.logback.contrib.json.JsonFormatter;
import com.eg.ch.qos.logback.contrib.json.classic.JsonLayout;
import com.eg.ch.qos.logback.core.Appender;
import com.eg.ch.qos.logback.core.Context;
import com.eg.ch.qos.logback.core.FileAppender;
import com.eg.ch.qos.logback.core.Layout;
import com.eg.ch.qos.logback.core.encoder.Encoder;
import com.eg.ch.qos.logback.core.filter.Filter;
import com.eg.ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import com.eg.ch.qos.logback.core.rolling.RollingFileAppender;
import com.eg.ch.qos.logback.core.rolling.RollingPolicy;
import com.eg.ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import com.eg.ch.qos.logback.core.rolling.TriggeringPolicy;
import com.eg.ch.qos.logback.core.util.FileSize;
import com.eg.org.slf4j.LoggerFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Properties;

public class EgLog {
    private com.eg.org.slf4j.Logger logger;
    private String loggerName;
    private volatile boolean initialized = false;
    private String prefix;
    private boolean debugSysout = false;
    private final String[] configArray = new String[8];
    private static final String[] LOGGER_SUFFIX = new String[]{".logger.name", ".logger.level", ".logger.max.files", ".logger.file.size", ".logger.file.name", ".logger.filter.match", ".logger.layout", ".logger.pattern"};
    private EgLogbackConfig loggerConfig;
    private AsyncAppender asyncAppender;
    private EgLogFilter logFilter;
    private static final String _LOGGER = "_LOGGER";
    private static final String NONE = "none";
    private static final String DEFAULT_PATTERN = "%date %-5level %class{15} %method %line %msg%n %ex{10} %rEx{5}";
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static HashMap<String, Level> MAPPING = new HashMap();

    public EgLog(String string, boolean bl) {
        this.loggerName = string;
        this.logger = LoggerFactory.getLogger((String)this.loggerName);
        this.loggerConfig = new EgLogbackConfig();
        this.debugSysout = bl;
        if (string != null) {
            int n = string.indexOf(_LOGGER);
            this.prefix = n > 0 ? "agent." + string.substring(0, n).toLowerCase() : "agent." + string.toLowerCase();
            this.initLogger();
        }
    }

    private void initLogger() {
        Properties properties = EgLogbackProperties.getInstance().getProperties();
        if (this.debugSysout) {
            System.out.println("loggerName :" + this.loggerName + " & Properties :" + properties);
        }
        this.initLogProperties(properties);
    }

    public com.eg.org.slf4j.Logger getLogger() {
        return this.logger;
    }

    public void checkForUpdate(Properties properties) {
        String string = properties.getProperty(this.prefix + LOGGER_SUFFIX[1]);
        if (string != null) {
            this.checkLogLevelForUpdate(string);
        }
        boolean bl = false;
        String string2 = properties.getProperty(this.prefix + LOGGER_SUFFIX[2]);
        int n = this.loggerConfig.getLogFileMaxCount();
        if (string2 != null && !string2.equals(this.configArray[2])) {
            bl = true;
            n = this.getFileCount(string2);
        }
        String string3 = properties.getProperty(this.prefix + LOGGER_SUFFIX[3]);
        int n2 = this.loggerConfig.getLogFileLimit();
        if (string3 != null && !string3.equals(this.configArray[3])) {
            bl = true;
            n2 = this.getFileSize(string3);
        }
        String string4 = properties.getProperty(this.prefix + LOGGER_SUFFIX[4]);
        String string5 = this.loggerConfig.getLogFileName();
        if (string4 != null && !string4.equals(this.configArray[4]) && string4.trim().length() > 0) {
            bl = true;
            string5 = string4.trim();
        }
        String string6 = properties.getProperty(this.prefix + LOGGER_SUFFIX[5]);
        String string7 = this.loggerConfig.getMatchString();
        if (string6 != null && string6.length() > 0) {
            if (!string6.equals(string7)) {
                bl = true;
                string7 = string6;
            }
        } else if (string7 == null || !string7.equalsIgnoreCase(NONE)) {
            bl = true;
            string7 = NONE;
        }
        String string8 = properties.getProperty(this.prefix + LOGGER_SUFFIX[6]);
        String string9 = this.loggerConfig.getLayout();
        if (string8 != null && string8.length() > 0 && !string8.equals(string9)) {
            bl = true;
            string9 = string8;
        }
        String string10 = properties.getProperty(this.prefix + LOGGER_SUFFIX[7]);
        String string11 = this.loggerConfig.getPatternString();
        if (string10 != null && string10.length() > 0 && !string10.equals(string11)) {
            bl = true;
            string11 = string10.trim();
        }
        if (bl) {
            System.out.println("Found changes on the logger configuration file for the logger -" + this.loggerName);
            this.initialized = false;
            this.initLogProperties(n, n2, string5, string7, string11, string9);
        }
    }

    private void checkLogLevelForUpdate(String string) {
        if (!string.equals(this.configArray[1])) {
            Level level = MAPPING.get(string.toLowerCase());
            if (level != null) {
                this.updateNewLogbackLevel(level);
            } else {
                this.updateNewLogbackLevel(Level.WARN);
            }
        }
    }

    private boolean isLoggerExistsOnFile(Properties properties) {
        String string = this.prefix + LOGGER_SUFFIX[0];
        String string2 = properties.getProperty(string);
        if (string2 != null && string2.equals(this.loggerName)) {
            this.configArray[0] = string2;
            for (int i = 0; i < LOGGER_SUFFIX.length; ++i) {
                this.configArray[i] = properties.getProperty(this.prefix + LOGGER_SUFFIX[i]);
            }
            return true;
        }
        return false;
    }

    private void initLogProperties(int n, int n2, String string, String string2, String string3, String string4) {
        this.loggerConfig.setLogFileName(string);
        this.loggerConfig.setLogFileMaxCount(n);
        this.loggerConfig.setLogFileLimit(n2);
        this.loggerConfig.setMatchString(string2);
        this.loggerConfig.setPatternString(string3);
        this.loggerConfig.setLayout(string4);
        this.start();
    }

    private void initLogProperties(Properties properties) {
        try {
            if (this.isLoggerExistsOnFile(properties)) {
                String string = properties.getProperty(this.prefix + LOGGER_SUFFIX[1]);
                String string2 = properties.getProperty(this.prefix + LOGGER_SUFFIX[2]);
                String string3 = properties.getProperty(this.prefix + LOGGER_SUFFIX[3]);
                String string4 = properties.getProperty(this.prefix + LOGGER_SUFFIX[4]);
                String string5 = properties.getProperty(this.prefix + LOGGER_SUFFIX[5]);
                String string6 = properties.getProperty(this.prefix + LOGGER_SUFFIX[6]);
                String string7 = properties.getProperty(this.prefix + LOGGER_SUFFIX[7]);
                Level level = MAPPING.get(string.toLowerCase());
                this.loggerConfig.setLogLevel(level);
                if (string4 != null && string4.trim().length() > 0) {
                    this.loggerConfig.setLogFileName(string4);
                } else {
                    this.loggerConfig.setLogFileName(this.prefix + ".log");
                }
                int n = this.getFileCount(string2);
                this.loggerConfig.setLogFileMaxCount(n);
                int n2 = this.getFileSize(string3);
                this.loggerConfig.setLogFileLimit(n2);
                if (string5 != null && string5.length() > 0) {
                    this.loggerConfig.setMatchString(string5);
                } else {
                    this.loggerConfig.setMatchString(NONE);
                }
                if (string7 != null && string7.length() > 0) {
                    this.loggerConfig.setPatternString(string7);
                } else {
                    this.loggerConfig.setPatternString(DEFAULT_PATTERN);
                }
                if (string6 != null && string6.length() > 0) {
                    if ((string6 = string6.trim().toLowerCase()).equals("json")) {
                        this.loggerConfig.setLayout("json");
                    } else {
                        this.loggerConfig.setLayout("text");
                    }
                } else {
                    this.loggerConfig.setLayout("text");
                }
            } else {
                System.out.println("[EgLog:initLogProperties] - Logger -" + this.loggerName + "- proceeds with default logging properties ");
                this.setDefaultLogging();
            }
        }
        catch (Exception exception) {
            System.out.println("[EgLog:initLogProperties] - Logger -" + this.loggerName + "- proceeds with default logging properties ");
            exception.printStackTrace();
            this.setDefaultLogging();
        }
        this.start();
    }

    public void setDefaultLogging() {
        this.loggerConfig.setLogLevel(Level.WARN);
        this.loggerConfig.setLogFileLimit(3);
        this.loggerConfig.setLogFileMaxCount(3);
        this.loggerConfig.setLogFileName(this.prefix + ".log");
        this.loggerConfig.setMatchString(NONE);
        this.loggerConfig.setPatternString(DEFAULT_PATTERN);
        this.loggerConfig.setLayout("text");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEGLogger() {
        if (!this.initialized) {
            String string = this.loggerName;
            synchronized (string) {
                if (!this.initialized) {
                    this.init();
                }
            }
        }
    }

    private void init() {
        JacksonJsonFormatter jacksonJsonFormatter;
        String string = EgInstallInfo.getInstallDir();
        if (this.debugSysout) {
            System.out.println("[EgLog] - eG Home Folder :" + string + " this.loggerName :" + this.loggerName);
        }
        if (string == null || string.trim().length() == 0) {
            return;
        }
        String string2 = string + File.separator + "agent" + File.separator + "logs";
        String string3 = string2 + File.separator + this.loggerConfig.getLogFileName();
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        RollingFileAppender rollingFileAppender = new RollingFileAppender();
        rollingFileAppender.setContext((Context)loggerContext);
        rollingFileAppender.setFile(string3);
        rollingFileAppender.setName(this.prefix);
        String string4 = this.loggerConfig.getMatchString();
        if (string4 != null && !string4.equalsIgnoreCase(NONE)) {
            this.logFilter = new EgLogFilter(string4, this.loggerName);
            rollingFileAppender.addFilter((Filter)this.logFilter);
            this.logFilter.start();
        }
        FixedWindowRollingPolicy fixedWindowRollingPolicy = new FixedWindowRollingPolicy();
        fixedWindowRollingPolicy.setContext((Context)loggerContext);
        fixedWindowRollingPolicy.setFileNamePattern(string2 + File.separator + this.loggerConfig.getLogFileName() + "-%i.log");
        fixedWindowRollingPolicy.setMinIndex(1);
        fixedWindowRollingPolicy.setMaxIndex(this.loggerConfig.getLogFileMaxCount());
        fixedWindowRollingPolicy.setParent((FileAppender)rollingFileAppender);
        fixedWindowRollingPolicy.start();
        SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = new SizeBasedTriggeringPolicy();
        FileSize fileSize = FileSize.valueOf((String)(this.loggerConfig.getLogFileLimit() + "MB"));
        sizeBasedTriggeringPolicy.setMaxFileSize(fileSize);
        sizeBasedTriggeringPolicy.start();
        String string5 = this.loggerConfig.getLayout();
        if (string5.equals("json")) {
            jacksonJsonFormatter = new JacksonJsonFormatter();
            jacksonJsonFormatter.setPrettyPrint(true);
            JsonLayout jsonLayout = new JsonLayout();
            jsonLayout.setContext((Context)loggerContext);
            jsonLayout.setJsonFormatter((JsonFormatter)jacksonJsonFormatter);
            jsonLayout.setIncludeFormattedMessage(true);
            jsonLayout.setAppendLineSeparator(true);
            jsonLayout.setTimestampFormat(ISO_8601_FORMAT);
            jsonLayout.start();
            rollingFileAppender.setLayout((Layout)jsonLayout);
        } else {
            jacksonJsonFormatter = new PatternLayoutEncoder();
            jacksonJsonFormatter.setContext((Context)loggerContext);
            jacksonJsonFormatter.setPattern(this.loggerConfig.getPatternString());
            jacksonJsonFormatter.start();
            rollingFileAppender.setEncoder((Encoder)jacksonJsonFormatter);
        }
        rollingFileAppender.setRollingPolicy((RollingPolicy)fixedWindowRollingPolicy);
        rollingFileAppender.setTriggeringPolicy((TriggeringPolicy)sizeBasedTriggeringPolicy);
        rollingFileAppender.setLazy(true);
        rollingFileAppender.start();
        this.asyncAppender = new AsyncAppender();
        this.asyncAppender.setContext((Context)loggerContext);
        this.asyncAppender.setName(this.prefix);
        this.asyncAppender.addAppender((Appender)rollingFileAppender);
        this.asyncAppender.setDiscardingThreshold(this.loggerConfig.getDiscardThresholdLimit());
        this.asyncAppender.setQueueSize(this.loggerConfig.getAsyncQueueSize());
        this.asyncAppender.setIncludeCallerData(true);
        this.asyncAppender.start();
        jacksonJsonFormatter = loggerContext.getLogger(this.loggerName);
        jacksonJsonFormatter.addAppender((Appender)this.asyncAppender);
        jacksonJsonFormatter.setLevel(this.loggerConfig.getLogLevel());
        jacksonJsonFormatter.setAdditive(true);
        this.initialized = true;
    }

    private void start() {
        this.stop();
        this.initEGLogger();
    }

    private void stop() {
        if (this.asyncAppender != null && this.asyncAppender.isStarted()) {
            this.asyncAppender.stop();
        }
        if (this.logFilter != null && this.logFilter.isStarted()) {
            this.logFilter.stop();
        }
    }

    private void updateNewLogbackLevel(Level level) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = loggerContext.getLogger(this.loggerName);
        this.loggerConfig.setLogLevel(level);
        logger.setLevel(this.loggerConfig.getLogLevel());
        this.logger.debug("{} Log Level is  : {} ", (Object)this.loggerName, (Object)level.toString());
    }

    private int getFileCount(String string) {
        int n = 3;
        if (string != null && string.trim().length() > 0) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 > 0) {
                    n = n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private int getFileSize(String string) {
        int n = 3;
        if (string != null && string.trim().length() > 0) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 > 0) {
                    n = n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    static {
        MAPPING.put("all", Level.ALL);
        MAPPING.put("off", Level.OFF);
        MAPPING.put("info", Level.INFO);
        MAPPING.put("warn", Level.WARN);
        MAPPING.put("debug", Level.DEBUG);
        MAPPING.put("trace", Level.TRACE);
        MAPPING.put("error", Level.ERROR);
    }
}

