/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.ContainerRunTimeProcess;
import com.eg.apm.ContainerUtils;
import com.eg.apm.ContainersService;
import com.eg.apm.CrioRunTimeProcess;
import com.eg.apm.DockerContainerRunTimeProcess;
import com.eg.apm.JavaProcess;

public final class ContainerProcessUtils {
    public static ContainerRunTimeProcess getContainerRtProcess(JavaProcess javaProcess) {
        ContainerRunTimeProcess containerRunTimeProcess = ContainerProcessUtils.getDockerRtProcess(javaProcess);
        if (containerRunTimeProcess != null) {
            return containerRunTimeProcess;
        }
        containerRunTimeProcess = ContainerProcessUtils.getCrioRtProcess(javaProcess);
        if (containerRunTimeProcess != null) {
            return containerRunTimeProcess;
        }
        return null;
    }

    private static ContainerRunTimeProcess getCrioRtProcess(JavaProcess javaProcess) {
        if (!ContainersService.getInstance().isCrio()) {
            return null;
        }
        String string = ContainerUtils.getDockerContainerId(javaProcess.getPid());
        if (string == null) {
            return null;
        }
        String string2 = ContainerUtils.getDockerFileSystemPath(javaProcess.getPid());
        if (string2 == null) {
            return null;
        }
        return new CrioRunTimeProcess(javaProcess.getUser(), javaProcess.getPid(), javaProcess.getExecutable(), javaProcess.getCommand(), javaProcess.getUptimeAsDate(), javaProcess.getSystemPropertiesAsString(), javaProcess.getUptime(), string, string2);
    }

    private static DockerContainerRunTimeProcess getDockerRtProcess(JavaProcess javaProcess) {
        if (!ContainersService.getInstance().isDocker()) {
            return null;
        }
        String string = ContainerUtils.getDockerContainerId(javaProcess.getPid());
        if (string == null) {
            return null;
        }
        String string2 = ContainerUtils.getDockerFileSystemPath(javaProcess.getPid());
        if (string2 == null) {
            return null;
        }
        return new DockerContainerRunTimeProcess(javaProcess.getUser(), javaProcess.getPid(), javaProcess.getExecutable(), javaProcess.getCommand(), javaProcess.getUptimeAsDate(), javaProcess.getSystemPropertiesAsString(), javaProcess.getUptime(), string, string2);
    }
}

