/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMUtils;
import com.eg.apm.ContainerDetails;
import com.eg.apm.ContainerType;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerEnvironment {
    private static ContainerEnvironment instance = null;
    private static final String DOCKER = "docker";
    private static final String CRIO = "crio";
    private static final String AWS_ECS = "ecs";
    private static final String POD = "kubepods.slice";
    private static final String KUBE_PODS = "kubepods";
    private static final String AWS_DOCKER_POD = "kubepods";
    private static final String CGROUPFILENAME = "/proc/self/cgroup";
    private boolean checked = false;
    private boolean linuxOS = false;
    private boolean linuxContainer = false;
    private final ContainerDetails containerDetails = new ContainerDetails();

    private ContainerEnvironment() {
        this.linuxOS = APMUtils.isLinux();
        this.getProcessDetails();
        if (this.linuxOS) {
            ArrayList<String> arrayList = this.getLinesFromCGroup();
            this.containerDetails.setCGroupContent(arrayList);
            this.checked = this.findContainerType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContainerEnvironment getInstance() {
        if (instance != null) return instance;
        Class<ContainerEnvironment> clazz = ContainerEnvironment.class;
        synchronized (ContainerEnvironment.class) {
            if (instance != null) return instance;
            instance = new ContainerEnvironment();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isLinuxContainer() {
        return this.linuxContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArrayList<String> getLinesFromCGroup() {
        ArrayList<String> arrayList;
        block15: {
            String string;
            arrayList = new ArrayList<String>();
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(CGROUPFILENAME));
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            Object var5_6 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block15;
            }
            catch (Exception exception) {}
            break block15;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    ContainerEnvironment.printOutLog("INFO", "/proc/self/cgroup file not found !!!");
                    this.linuxContainer = false;
                    Object var5_7 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block15;
                    }
                    catch (Exception exception) {}
                    break block15;
                }
                catch (Exception exception) {
                    ContainerEnvironment.printOutLog("INFO", "Unable to read the file /proc/self/cgroup due to " + exception.getMessage());
                    this.linuxContainer = false;
                    Object var5_8 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block15;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return arrayList;
    }

    boolean checkContainerType() {
        if (!this.linuxContainer) {
            this.findContainerType();
        }
        return false;
    }

    boolean isLinux() {
        return this.linuxOS;
    }

    private boolean findContainerType() {
        boolean bl = false;
        if (this.containerDetails.isCGroupContentExists()) {
            ArrayList<String> arrayList = this.containerDetails.getCGroupContent();
            if (arrayList != null && arrayList.size() > 0) {
                ContainerType containerType = null;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = arrayList.get(i);
                    if (string == null || (containerType = ContainerEnvironment.decideType(string)) == null) continue;
                    bl = true;
                    this.containerDetails.setContainerType(containerType);
                    this.linuxContainer = true;
                    ContainerEnvironment.printOutLog("INFO", "Found type of container :" + (Object)((Object)containerType));
                    break;
                }
            }
        } else {
            ContainerEnvironment.printOutLog("INFO", "Either file /proc/self/cgroup not found (or) No content from that file");
        }
        return bl;
    }

    private static ContainerType decideType(String string) {
        ContainerType containerType = null;
        if (string.indexOf(DOCKER) > -1) {
            containerType = ContainerType.DOCKER;
            if (string.indexOf(POD) > 1 || string.indexOf("kubepods") > 1) {
                containerType = ContainerType.DOCKER_K8;
            } else {
                try {
                    String string2 = System.getenv("ECS_ENABLE_TASK_CPU_MEM_LIMIT");
                    if (string2 != null && string2.equalsIgnoreCase("false")) {
                        containerType = ContainerType.AWS_ECS;
                    }
                }
                catch (Exception exception) {}
            }
        } else if (string.indexOf(CRIO) > -1) {
            containerType = ContainerType.CRIO;
            if (string.indexOf(POD) > 1 || string.indexOf("kubepods") > 1) {
                containerType = ContainerType.CRIO_K8;
            }
        } else if (string.indexOf("kubepods") > -1) {
            containerType = ContainerType.AWS_K8;
        } else if (string.indexOf(AWS_ECS) > -1) {
            containerType = ContainerType.AWS_ECS;
        }
        return containerType;
    }

    private static void printOutLog(String string, String string2) {
        if (string == null || string.length() == 0) {
            string = "INFO";
        }
        if (string2 != null) {
            System.out.println(new Date() + " " + string + "  [eG BTM] - " + string2);
        }
    }

    private void getProcessDetails() {
        try {
            String string = ManagementFactory.getRuntimeMXBean().getName();
            ContainerEnvironment.printOutLog("INFO", "Java Process Name - " + string);
            if (string != null && string.length() > 0) {
                int n = string.indexOf("@");
                if (n > 0) {
                    String string2 = string.substring(n + 1);
                    String string3 = string.substring(0, n);
                    this.containerDetails.setHostName(string2);
                    this.containerDetails.setProcessID(string3);
                } else {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    String string4 = inetAddress.getHostName();
                    String string5 = string;
                    this.containerDetails.setHostName(string4);
                    this.containerDetails.setProcessID(string5);
                }
            }
        }
        catch (Exception exception) {
            ContainerEnvironment.printOutLog("WARN", "Exception while getting processDetails - " + exception.getMessage());
        }
    }

    public String getHostName() {
        return this.containerDetails.getHostName();
    }

    String getProcessID() {
        return this.containerDetails.getProcessID();
    }

    ContainerType getContainerType() {
        return this.containerDetails.getContainerType();
    }

    ArrayList<String> getCGroupContent() {
        return this.containerDetails.getCGroupContent();
    }

    void setContainerName(String string) {
        this.containerDetails.setContainerName(string);
    }

    String getContainerName() {
        return this.containerDetails.getContainerName();
    }

    void setContainerTypeByManualOption(ContainerType containerType) {
        this.containerDetails.setContainerType(containerType);
    }
}

