/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgAgentInfo;
import com.eg.EgInstallInfo;
import com.eg.apm.APMCleanUpUtils;
import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMConfigUtils;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMLanguage;
import com.eg.apm.APMWorkerHelper;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.ApmDemoInfo;
import com.eg.apm.Component;
import com.eg.apm.JavaBTMLogger;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.Status;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.PropsManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComponentWatcher
extends TimerTask {
    private static final String loggerDispStr = "[ComponentWatcher]";
    private static final HashMap<String, HashMap> previousTable = new HashMap();
    private long lastModifiedTime = -1L;
    String egApmIniFile = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.agentConfigPath + "eg_apm.ini";
    EgAgentInfo egApmIniInfo = new EgAgentInfo("agent", this.egApmIniFile);
    private boolean isFirstTime = true;
    private boolean prepareCpcData = true;
    private boolean doReadForDeletedComponent = false;
    boolean isEgApmIniModified = false;
    private long lastHeartBeatTimeCheck = -1L;
    private static final HashMap<APMLanguage, ArrayList<String>> apmOffloadTests = new HashMap();
    private static final HashMap<String, APMLanguage> languageMap = new HashMap();

    static {
        languageMap.put("JAVA", APMLanguage.JAVA);
        languageMap.put("NODEJS", APMLanguage.NODEJS);
        languageMap.put("true", APMLanguage.JAVA);
    }

    @Override
    public void run() {
        try {
            if (ApmDemoInfo.isDemoMode() && ApmDemoInfo.checkForUpdate()) {
                ApmConfigManager.getInstance().updateDemoConfigs();
            }
            ApmConfigManager.getInstance().checkForUpdate();
            if (!ApmConfigManager.getInstance().isAPMMonitoringEnabled()) {
                return;
            }
            this.isEgApmIniModified = this.egApmIniInfo.checkForUpdate();
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} isEgApmIniModified : {}", (Object)loggerDispStr, (Object)this.isEgApmIniModified);
            APMComponentIDRepository componentIDRepository = APMComponentIDRepository.getRepository();
            try {
                this.componentWatcher(componentIDRepository);
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to do component watcher tracker : {} ", (Object)loggerDispStr, (Object)e);
            }
            try {
                this.getCPCData();
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to get Custom BTM configuration from eg_apm.ini : {}", (Object)loggerDispStr, (Object)e);
            }
            try {
                boolean isCleanUpEnabled = ApmConfigManager.getInstance().isCleanUpEnabled();
                if (isCleanUpEnabled) {
                    APMCleanUpUtils apmCleanUpUtils = new APMCleanUpUtils();
                    apmCleanUpUtils.initCleanUpProcess(this.isEgApmIniModified);
                }
            }
            catch (Exception e) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do ini clean up process {}", (Object)loggerDispStr, (Object)e);
            }
            this.isFirstTime = false;
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to do component watcher tracker : {}", (Object)loggerDispStr, (Object)e);
        }
    }

    private HashMap computeCpcdata(String sub, HashMap fullCPCData, boolean isBT) {
        String[] compNames = this.egApmIniInfo.getVariables(sub);
        if (compNames != null && compNames.length > 0) {
            List<String> btmCpcCompList = Arrays.asList(compNames);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Offload CPC components from eg_apm.ini :  {} ", (Object)loggerDispStr, btmCpcCompList);
            int i = 0;
            while (i < btmCpcCompList.size()) {
                String compName = btmCpcCompList.get(i);
                compName = compName != null ? compName : "";
                String[] strArray = compName.split(":");
                if (strArray != null && strArray.length == 3) {
                    String uuid = strArray[0];
                    String guid = strArray[1];
                    String cpc = strArray[2];
                    String jvmID = String.valueOf(uuid) + ":" + guid;
                    if (APMComponentIDRepository.getRepository().isSiteIdAvailable(jvmID)) {
                        HashMap data;
                        String cpcData = this.egApmIniInfo.getValue(sub, compName);
                        String string = cpcData = cpcData != null ? cpcData : "";
                        if (isBT) {
                            cpcData = String.valueOf(cpc) + "#B=" + cpcData;
                        } else {
                            int count = 1;
                            if (fullCPCData.containsKey(jvmID)) {
                                data = (HashMap)fullCPCData.get(jvmID);
                                count = data.size();
                            }
                            cpcData = "CPC" + count + "#KB=" + cpcData;
                        }
                        HashMap cpcMap = this.parseCpcData(cpcData);
                        if (fullCPCData.containsKey(jvmID)) {
                            data = (HashMap)fullCPCData.get(jvmID);
                            data.putAll(cpcMap);
                            fullCPCData.put(jvmID, data);
                        } else {
                            fullCPCData.put(jvmID, cpcMap);
                        }
                    }
                }
                ++i;
            }
        }
        return fullCPCData;
    }

    private void getCPCData() {
        try {
            if (this.isEgApmIniModified || this.isFirstTime || this.prepareCpcData) {
                HashMap fullCPCData = new HashMap();
                String sub = "CUSTOM_PATTERN_CONFIGURATION_BT";
                fullCPCData = this.computeCpcdata(sub, fullCPCData, true);
                sub = "CUSTOM_PATTERN_CONFIGURATION_KBT";
                fullCPCData = this.computeCpcdata(sub, fullCPCData, false);
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{}  fullCPCData : {}", (Object)loggerDispStr, (Object)fullCPCData);
                if (fullCPCData.size() > 0) {
                    this.setCpcTable(fullCPCData);
                }
                this.checkForDeletedComponents();
                this.prepareCpcData = false;
            }
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to get Custom BTM configuration from eg_apm.ini : {} ", (Object)loggerDispStr, (Object)e);
        }
    }

    private void heartBeatCheck(EgAgentInfo egAgentIniInfo) {
        try {
            boolean doCheck = false;
            long currentTime = System.currentTimeMillis();
            if (this.lastHeartBeatTimeCheck > 0L) {
                long diff = currentTime - this.lastHeartBeatTimeCheck;
                if (diff > 300000L) {
                    doCheck = true;
                    this.lastHeartBeatTimeCheck = currentTime;
                }
            } else {
                this.lastHeartBeatTimeCheck = currentTime;
                doCheck = true;
            }
            if (doCheck) {
                ConcurrentHashMap<String, APMComponent> ComponentIDTable = APMComponentIDRepository.getRepository().getComponentRepository();
                for (Map.Entry<String, APMComponent> entry : ComponentIDTable.entrySet()) {
                    String jvmGUID = entry.getKey();
                    if (jvmGUID != null && jvmGUID.startsWith("DISCOVER_ME_")) continue;
                    JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Doing heartbeat check for : {}", (Object)loggerDispStr, (Object)jvmGUID);
                    APMComponent component = APMComponentIDRepository.getRepository().getAPMComponent(jvmGUID);
                    if (component == null) continue;
                    this.checkAutoUnmanage(component);
                    this.prepareConfigs(component, egAgentIniInfo);
                }
            }
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to do heartbeat time check BTM : {}", (Object)loggerDispStr, (Object)e);
        }
    }

    private void prepareConfigs(APMComponent component, EgAgentInfo egAgentIniInfo) {
        if (component.isPrepareJvmTestConfigs()) {
            JavaBTMLogger.btmLogger.info("{} [eGTest_Config_Request] Preparing jvm test configs for {} - {}", new Object[]{loggerDispStr, component.getID(), component.getNickWithPort()});
            this.getEnabledTestsAndConfigsFromIni(component, egAgentIniInfo, true, false);
            component.setPrepareJvmTestConfigs(false);
        }
        if (component.isPrepareCpcConfigs()) {
            JavaBTMLogger.btmLogger.info("{} [eGTest_Config_Request] Preparing cpc configs for {} - {}", new Object[]{loggerDispStr, component.getID(), component.getNickWithPort()});
            this.prepareCpcData = true;
            component.setPrepareCpcConfigs(false);
        }
    }

    private void setCpcTable(HashMap table) {
        for (Map.Entry entry : table.entrySet()) {
            String jvmID = (String)entry.getKey();
            HashMap cpcData = (HashMap)entry.getValue();
            APMComponent component = APMComponentIDRepository.getRepository().getAPMComponent(jvmID);
            if (component == null) continue;
            component.setCPCPatternMap(cpcData);
        }
    }

    private void checkForDeletedComponents() {
        ConcurrentHashMap<String, APMComponent> componentIDTable = APMComponentIDRepository.getRepository().getComponentRepository();
        for (Map.Entry<String, APMComponent> entry : componentIDTable.entrySet()) {
            String jvmID = entry.getKey();
            APMComponent component = APMComponentIDRepository.getRepository().getAPMComponent(jvmID);
            HashMap cpcData = component.getCPCPatternMap(Component.DEFAULT_WORKER_ID, Component.DEFAULT_WORKER_ID);
            if (cpcData != null) continue;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("cpcInfo", "cpcInfo");
            component.setCPCPatternMap(cpcData);
        }
    }

    private HashMap parseCpcData(String cpcData) {
        String[] array;
        HashMap cpcMap = new HashMap();
        if (cpcData != null && cpcData.length() > 0 && cpcData != null && cpcData.length() > 0 && (array = cpcData.split(",")) != null && array.length > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            int i = 0;
            while (i < array.length) {
                String temp = array[i];
                if (temp != null && temp.length() > 0) {
                    String cpc = temp.substring(0, temp.indexOf("=")).trim();
                    String value = temp.substring(temp.indexOf("=") + 1).trim();
                    if (cpc != null && cpc.length() > 0 && value != null && value.length() > 0) {
                        map.put(cpc, value);
                    }
                }
                ++i;
            }
            if (map != null && map.size() > 0) {
                cpcMap.putAll(map);
                cpcMap.put("cpcInfo", "cpcInfo");
            }
        }
        return cpcMap;
    }

    private void updateOffLoadTestDetails(APMLanguage lang, String testName) {
        if (apmOffloadTests.containsKey((Object)lang)) {
            ArrayList<String> testList = apmOffloadTests.get((Object)lang);
            testList.add(testName);
        } else {
            ArrayList<String> testList = new ArrayList<String>();
            testList.add(testName);
            apmOffloadTests.put(lang, testList);
        }
    }

    private void getOffloadTestsByLanguage(String[] allLines) {
        ArrayList<String> allTests = new ArrayList<String>();
        apmOffloadTests.clear();
        int i = 0;
        while (i < allLines.length) {
            block7: {
                boolean added;
                String testName;
                block9: {
                    String langString;
                    block8: {
                        String line = allLines[i];
                        int indx = line.indexOf("=");
                        if (indx <= 0) break block7;
                        testName = line.substring(0, indx);
                        langString = line.substring(indx + 1);
                        added = false;
                        int commaIndx = langString.indexOf(",");
                        if (commaIndx <= 0) break block8;
                        StringTokenizer tokenizer = new StringTokenizer(langString, ",");
                        int count = tokenizer.countTokens();
                        int c = 0;
                        while (c < count) {
                            String langName = tokenizer.nextToken();
                            APMLanguage lang = languageMap.get(langName);
                            if (lang != null) {
                                this.updateOffLoadTestDetails(lang, testName);
                                added = true;
                            }
                            ++c;
                        }
                        break block9;
                    }
                    APMLanguage lang = languageMap.get(langString);
                    if (lang == null) break block7;
                    this.updateOffLoadTestDetails(lang, testName);
                    added = true;
                }
                if (added) {
                    allTests.add(testName);
                }
            }
            ++i;
        }
    }

    private void getOffloadTestNamesFromIni() {
        try {
            String[] allLines;
            if ((this.isEgApmIniModified || this.isFirstTime) && (allLines = this.egApmIniInfo.getLinesUnderSubject("OFFLOAD_SUPPORTING_TEST_NAMES")) != null && allLines.length > 0) {
                this.getOffloadTestsByLanguage(allLines);
            }
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} unable to get offloadtestnames from eg_apm.Ini {}", (Object)loggerDispStr, (Object)e);
        }
    }

    private void componentWatcher(APMComponentIDRepository componentIDRepository) {
        int apmcomponents = componentIDRepository.getComponentRepository().size();
        if (apmcomponents == 0) {
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} APM Component repository is empty.", (Object)loggerDispStr);
            return;
        }
        boolean isHeartBeatCheckDone = false;
        boolean iniUpdated = false;
        EgAgentInfo egAgentIniInfo = new EgAgentInfo("agent");
        long lastModified = egAgentIniInfo.lastModified();
        if (this.lastModifiedTime > -1L) {
            if (lastModified != this.lastModifiedTime) {
                iniUpdated = true;
                this.lastModifiedTime = lastModified;
            }
        } else {
            this.lastModifiedTime = lastModified;
            iniUpdated = true;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} isAgentsIniModified : {}", (Object)loggerDispStr, (Object)iniUpdated);
        if (iniUpdated || this.isFirstTime) {
            this.getOffloadTestNamesFromIni();
            if (JavaBTMOffloadLogger.btmOffLoadLogger.isTraceEnabled()) {
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} eg_agents.ini is modified {} ", (Object)loggerDispStr, (Object)lastModified);
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} isFirstTime : {}", (Object)loggerDispStr, (Object)this.isFirstTime);
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} offloadTestNames : {}", (Object)loggerDispStr, apmOffloadTests);
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} ComponentIDTable : {}", (Object)loggerDispStr, componentIDRepository.getComponentRepository());
            }
            if (apmOffloadTests == null || apmOffloadTests.isEmpty()) {
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} offloadTestNames is null or empty, trying to read offloadTestNames from eg_apm.ini", (Object)loggerDispStr);
                this.isEgApmIniModified = true;
                this.getOffloadTestNamesFromIni();
            }
            if (apmOffloadTests == null || apmOffloadTests.isEmpty()) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} offloadTestNames is null or empty, Skipping further processes of ComponentWatcher Tracker ", (Object)loggerDispStr);
                return;
            }
            ConcurrentHashMap<String, APMComponent> ComponentIDTable = componentIDRepository.getComponentRepository();
            for (Map.Entry<String, APMComponent> entry : ComponentIDTable.entrySet()) {
                String componentGUID = entry.getKey();
                if (componentGUID != null && componentGUID.startsWith("DISCOVER_ME_")) continue;
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Doing Component tracker task for : {}", (Object)loggerDispStr, (Object)componentGUID);
                APMComponent component = componentIDRepository.getAPMComponent(componentGUID);
                if (component == null) continue;
                this.checkAutoUnmanage(component);
                isHeartBeatCheckDone = true;
                this.getEnabledTestsAndConfigsFromIni(component, egAgentIniInfo, iniUpdated, true);
            }
            this.doReadForDeletedComponent = false;
        }
        if (!isHeartBeatCheckDone) {
            this.heartBeatCheck(egAgentIniInfo);
        }
    }

    private String[] getOffLoadTestsByLanguage(APMLanguage language) {
        String[] resultArr = null;
        ArrayList<String> testList = apmOffloadTests.get((Object)language);
        if (testList != null) {
            resultArr = testList.toArray(new String[testList.size()]);
        }
        return resultArr;
    }

    private void getEnabledTestsAndConfigsFromIni(APMComponent component, EgAgentInfo egAgentIniInfo, boolean isAgentsIniModified, boolean compareWithPreviousData) {
        boolean doReadForNewComponent = false;
        if (component.isComponentOrEntityStatus()) {
            doReadForNewComponent = true;
        }
        String nickName = component.getNickName();
        String port = component.getHostPort();
        APMLanguage language = component.getAPMLanguage();
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} doReadForDeletedCommonent : {}", (Object)loggerDispStr, (Object)this.doReadForDeletedComponent);
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} doReadForNewComponent : {}", (Object)loggerDispStr, (Object)doReadForNewComponent);
        if (isAgentsIniModified || doReadForNewComponent || this.doReadForDeletedComponent) {
            String[] testsWithConfigs = egAgentIniInfo.getTestsForTarget(nickName, "offload");
            if (testsWithConfigs == null) {
                String[] offloadTests = this.getOffLoadTestsByLanguage(language);
                String subjectName4Component = egAgentIniInfo.getSubjectForThisCompoent(nickName, port, offloadTests);
                if (subjectName4Component == null) {
                    String componentGUID = component.getID();
                    JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} SECTION not found in eg_agents.ini {} - {}", new Object[]{loggerDispStr, nickName, subjectName4Component});
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} SECTION not found in eg_agents.ini for {}. Marking as unmanaged component and removed from respository ", (Object)loggerDispStr, (Object)componentGUID);
                    APMConfigUtils.getInstance().processApmConfigIni(componentGUID, true, "delete_all", language, "agent");
                    APMComponentIDRepository.getRepository().unRegisterComponent(componentGUID, false, false);
                    this.doReadForDeletedComponent = true;
                    return;
                }
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} SECTION found in eg_agents.ini for {} - {}", new Object[]{loggerDispStr, nickName, subjectName4Component});
                testsWithConfigs = egAgentIniInfo.getTestsForTarget(subjectName4Component, "offload");
            }
            String[] testNamesWithPort = egAgentIniInfo.getTests(testsWithConfigs, "offload");
            this.updateTestConfigs(component, testsWithConfigs, testNamesWithPort, false, compareWithPreviousData);
            APMWorkerHelper.getInstance().clearRepository(component);
            if (doReadForNewComponent) {
                component.changeComponentOrEntityStatus();
            }
        }
    }

    private void updateInfraTestConfig(String componentID, String test, HashMap<String, String> testConfigParams, HashMap currentConfig, boolean isAgentLess) {
        if (test.startsWith("Jvm")) {
            boolean isJarMode = false;
            try {
                String jmxOptions = testConfigParams.get("metric_collection_type");
                if (jmxOptions != null && jmxOptions.equalsIgnoreCase("false")) {
                    isJarMode = true;
                }
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("Exception while finding metric_collection_mode for the {} and entity {} - {}", new Object[]{componentID, test, e.getMessage()});
            }
            if (isJarMode) {
                if (test.equalsIgnoreCase("JvmMemoryDetailsTest")) {
                    String heapAnlysis = testConfigParams.get("Heap_Analysis");
                    String javaHome = testConfigParams.get("Java_Home");
                    if (heapAnlysis != null) {
                        currentConfig.put("Heap_Analysis", heapAnlysis);
                    }
                    if (javaHome != null) {
                        currentConfig.put("Heap_Analysis", heapAnlysis);
                    }
                } else if (test.equalsIgnoreCase("JvmThreadTest")) {
                    String dump_thread_limit = "-1";
                    currentConfig.put("Thread_Dump_Limit", dump_thread_limit);
                    String dumpThreadLimit = testConfigParams.get("Thread_Dump_Limit");
                    try {
                        int limit = Integer.parseInt(dumpThreadLimit);
                        currentConfig.put("Thread_Dump_Limit", dumpThreadLimit);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                currentConfig.put("JVM_METRIC_COLLECTION", "true");
            } else {
                currentConfig.put("JVM_METRIC_COLLECTION", "false");
            }
            String agentLessCheck = testConfigParams.get("agentless");
            if (agentLessCheck != null && agentLessCheck.length() > 0 && agentLessCheck.equalsIgnoreCase("y")) {
                isAgentLess = true;
                currentConfig.put("isAgentLess", "true");
            } else {
                currentConfig.put("isAgentLess", "false");
            }
        }
    }

    private void updateTestConfigs(APMComponent component, String[] testsWithConfigs, String[] testNameWithPort, boolean isAgentLess, boolean compareWithPreviousData) {
        ArrayList<String> offloadTestList = apmOffloadTests.get((Object)component.getAPMLanguage());
        if (offloadTestList == null || offloadTestList.isEmpty()) {
            return;
        }
        String portNo = component.getHostPort();
        List<String> agentTestsWithPortList = Arrays.asList(testNameWithPort);
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Enabled agents tests with port:  {}", (Object)loggerDispStr, agentTestsWithPortList);
        HashMap<String, String> currentConfig = new HashMap<String, String>();
        String componentID = component.getID();
        APMLanguage apmLanguage = component.getAPMLanguage();
        int i = 0;
        while (i < offloadTestList.size()) {
            String test = offloadTestList.get(i);
            String testWithPort = String.valueOf(test) + "_" + portNo;
            int testIndex = agentTestsWithPortList.indexOf(testWithPort);
            if (testIndex < 0) {
                component.removeEntity(test);
                currentConfig.put(test, "false");
            } else {
                String configLine = testsWithConfigs[testIndex];
                HashMap testConfigParams = this.getFullConfigs(configLine, test);
                String testFrequency = (String)testConfigParams.get("egMeasPeriod");
                if (testFrequency != null) {
                    currentConfig.put(test, "true");
                    currentConfig.put(String.valueOf(test) + "Frequency", testFrequency);
                }
                if (apmLanguage == APMLanguage.JAVA) {
                    this.updateInfraTestConfig(componentID, test, testConfigParams, currentConfig, isAgentLess);
                } else if (apmLanguage == APMLanguage.NODEJS) {
                    this.updateInfraTestConfig(componentID, test, testConfigParams, currentConfig, isAgentLess);
                }
                APMComponentIDRepository.getRepository().registerComponent(componentID, test, apmLanguage);
            }
            ++i;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Offload test config:- compareWithPreviousData - {} ", (Object)loggerDispStr, (Object)compareWithPreviousData);
        if (currentConfig.size() > 0) {
            HashMap tmp = new HashMap(currentConfig);
            previousTable.put(componentID, tmp);
            currentConfig.put("JVMTestsInfo", "JVMTestsInfo");
            component.setInfraTestConfig(currentConfig);
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Current JVM Configuration for ({}) : {}", new Object[]{loggerDispStr, componentID, component.getInfraTestConfig()});
    }

    private HashMap getFullConfigs(String configLine, String test) {
        HashMap<String, String> configTable = new HashMap<String, String>();
        String config = configLine.substring(configLine.indexOf("-host") + 1, configLine.lastIndexOf(","));
        config = config.replace("   ", " ");
        config = config.replace("  ", " ");
        String[] datas = config.split(" -");
        int i = 0;
        while (i < datas.length) {
            String[] params = datas[i].split(" ");
            configTable.put(params[0], params[1]);
            ++i;
        }
        return configTable;
    }

    private void checkAutoUnmanage(APMComponent component) {
        long currenTime = System.currentTimeMillis();
        boolean heartBeating = component.getHeartbeatStatus() == Status.HEART_BEATING;
        long lastHeartBeatTime = component.getHeartBeatTime();
        long diffs = System.currentTimeMillis() - lastHeartBeatTime;
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} lastHeartBeatTime :{} , currenTime :{} ,diffs :{}", new Object[]{loggerDispStr, lastHeartBeatTime, currenTime, diffs});
        if (lastHeartBeatTime < 0L) {
            return;
        }
        PropsManager propsManager = component.getPropsManager();
        if (propsManager == null) {
            return;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Measure period for {} :{}", new Object[]{loggerDispStr, component.getID(), propsManager.getEgMeasPeriod()});
        if (diffs >= 6L * propsManager.getEgMeasPeriod() && heartBeating) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Doing  BTM repository reset due to no heart beat for a few couple of measure peroid : {} ", (Object)loggerDispStr, (Object)component.getID());
            component.setHeartBeatStatus(Status.NO_HEART_BEATING);
            component.reset();
        }
    }

    protected static HashMap getModifiedConfig(HashMap currentTable, HashMap previousTable) {
        HashMap<String, String> resultTable = new HashMap<String, String>();
        if (currentTable != null && currentTable.size() > 0) {
            Set currentKeySet = currentTable.keySet();
            for (String currentKey : currentKeySet) {
                String currentValue = (String)currentTable.get(currentKey);
                if (previousTable.containsKey(currentKey)) {
                    String previousValue = (String)previousTable.get(currentKey);
                    if (currentValue.equals(previousValue)) continue;
                    resultTable.put(currentKey, currentValue);
                    continue;
                }
                resultTable.put(currentKey, currentValue);
            }
        }
        return resultTable;
    }
}

